/*
 * @(#)AutoDocITSetUTest.java
 *
 * Copyright (C) 2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.autodoc.v1.defimpl;

import net.sourceforge.groboutils.autodoc.v1.spi.AutoDocLogFactory;
import net.sourceforge.groboutils.autodoc.v1.*;
import net.sourceforge.groboutils.autodoc.v1.spi.*;

import org.easymock.EasyMock;
import org.easymock.MockControl;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import java.util.*;


/**
 * Tests the DefaultAutoDocFactory class.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/05/30 00:06:04 $
 * @since     March 27, 2002
 */
public class AutoDocITSetUTest extends TestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = AutoDocITSetUTest.class;
    
    public AutoDocITSetUTest( String name )
    {
        super( name );
    }

    
    //-------------------------------------------------------------------------
    // setup
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    private static class MyAutoDocIT implements AutoDocIT
    {
        public Vector methodNames = new Vector();
        public Vector longIssueID = new Vector();
        public Vector strIssueID = new Vector();
        
        public void testsIssue( String methodName, long issueID )
        {
            this.methodNames.addElement( methodName );
            this.longIssueID.addElement( new Long( issueID ) );
        }
    
    
        public void testsIssue( String methodName, String issueID )
        {
            this.methodNames.addElement( methodName );
            this.strIssueID.addElement( issueID );
        }
        
        
        public void testsIssue( long issueID )
        {
            this.longIssueID.addElement( new Long( issueID ) );
        }
        
        
        public void testsIssue( String issueID )
        {
            this.strIssueID.addElement( issueID );
        }
    }
    
    
    public void testTestsIssue1()
    {
        MyAutoDocIT mad = new MyAutoDocIT();
        AutoDocITSet set = new AutoDocITSet();
        set.addIT( mad );
        
        set.testsIssue( "name", 1L );
        
        assertEquals(
            "Did not add only 1 method name.",
            mad.methodNames.size(),
            1 );
        assertEquals(
            "Did not add only 1 long id.",
            mad.longIssueID.size(),
            1 );
        assertEquals(
            "Added a string id.",
            mad.strIssueID.size(),
            0 );
    }
    
    
    public void testTestsIssue2()
    {
        MyAutoDocIT mad = new MyAutoDocIT();
        AutoDocITSet set = new AutoDocITSet();
        set.addIT( mad );
        
        set.testsIssue( "name", "1" );
        
        assertEquals(
            "Did not add only 1 method name.",
            mad.methodNames.size(),
            1 );
        assertEquals(
            "Did not add only 1 string id.",
            mad.strIssueID.size(),
            1 );
        assertEquals(
            "Added a long id.",
            mad.longIssueID.size(),
            0 );
    }
    
    
    public void testTestsIssue3()
    {
        MyAutoDocIT mad = new MyAutoDocIT();
        AutoDocITSet set = new AutoDocITSet();
        set.addIT( mad );
        
        set.testsIssue( 1L );
        
        assertEquals(
            "Added a method name.",
            mad.methodNames.size(),
            0 );
        assertEquals(
            "Did not add only 1 long id.",
            mad.longIssueID.size(),
            1 );
        assertEquals(
            "Added a string id.",
            mad.strIssueID.size(),
            0 );
    }
    
    
    public void testTestsIssue4()
    {
        MyAutoDocIT mad = new MyAutoDocIT();
        AutoDocITSet set = new AutoDocITSet();
        set.addIT( mad );
        
        set.testsIssue( "l" );
        
        assertEquals(
            "Added a method name.",
            mad.methodNames.size(),
            0 );
        assertEquals(
            "Did not add only 1 string id.",
            mad.strIssueID.size(),
            1 );
        assertEquals(
            "Added a long id.",
            mad.longIssueID.size(),
            0 );
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static Test suite()
    {
        TestSuite suite = new TestSuite( THIS_CLASS );
        InterfaceTestSuite its = AutoDocITUTestI.suite();
        its.addInterfaceTestSuite( IAutoDocSetUTestI.suite() );
        its.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return new AutoDocITSet();
            }
        } );
        suite.addTest( its );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }
}

