/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.iterator;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.janino.util.Producer;
import org.codehaus.janino.util.iterator.MultiDimensionalIterator;
import org.codehaus.janino.util.iterator.ProducerIterator;

public class DirectoryIterator
extends ProducerIterator {
    public DirectoryIterator(File file, final FilenameFilter filenameFilter, final FilenameFilter filenameFilter2) {
        super(new Producer(file){
            private final List stateStack;
            {
                this.stateStack = DirectoryIterator.newArrayList(new State(filenameFilter3, filenameFilter22, this, file));
            }

            public Object produce() {
                while (!this.stateStack.isEmpty()) {
                    State state = (State)this.stateStack.get(this.stateStack.size() - 1);
                    if (state.directories.hasNext()) {
                        this.stateStack.add(new State(filenameFilter, filenameFilter2, this, (File)state.directories.next()));
                        continue;
                    }
                    if (state.files.hasNext()) {
                        return (File)state.files.next();
                    }
                    this.stateStack.remove(this.stateStack.size() - 1);
                }
                return null;
            }

            class State {
                private final /* synthetic */ 1 this$1;
                final Iterator directories;
                final Iterator files;

                State(FilenameFilter filenameFilter, FilenameFilter filenameFilter2, 1 var3_3, File file) {
                    this.this$1 = var3_3;
                    File[] fileArray = file.listFiles();
                    if (fileArray == null) {
                        throw new RuntimeException("Directory \"" + file + "\" could not be read");
                    }
                    ArrayList<File> arrayList = new ArrayList<File>();
                    ArrayList<File> arrayList2 = new ArrayList<File>();
                    int n = 0;
                    while (n < fileArray.length) {
                        File file2 = fileArray[n];
                        if (file2.isDirectory()) {
                            if (filenameFilter.accept(file, file2.getName())) {
                                arrayList.add(file2);
                            }
                        } else if (file2.isFile() && filenameFilter2.accept(file, file2.getName())) {
                            arrayList2.add(file2);
                        }
                        ++n;
                    }
                    this.directories = arrayList.iterator();
                    this.files = arrayList2.iterator();
                }
            }
        });
    }

    private static ArrayList newArrayList(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        return arrayList;
    }

    public static Iterator traverseDirectories(File[] fileArray, FilenameFilter filenameFilter, FilenameFilter filenameFilter2) {
        ArrayList<DirectoryIterator> arrayList = new ArrayList<DirectoryIterator>();
        int n = 0;
        while (n < fileArray.length) {
            arrayList.add(new DirectoryIterator(fileArray[n], filenameFilter, filenameFilter2));
            ++n;
        }
        return new MultiDimensionalIterator(arrayList.iterator(), 2);
    }
}

