; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=i686-unknown-linux-gnu -mattr=-bmi,-tbm,-bmi2 < %s | FileCheck %s --check-prefixes=X86,X86-NOBMI2,X86-BASELINE
; RUN: llc -mtriple=i686-unknown-linux-gnu -mattr=+cmov,+bmi,-tbm,-bmi2 < %s | FileCheck %s --check-prefixes=X86,X86-NOBMI2,X86-BMI1
; RUN: llc -mtriple=i686-unknown-linux-gnu -mattr=+cmov,+bmi,+tbm,-bmi2 < %s | FileCheck %s --check-prefixes=X86,X86-NOBMI2,X86-BMI1
; RUN: llc -mtriple=i686-unknown-linux-gnu -mattr=+cmov,+bmi,+tbm,+bmi2 < %s | FileCheck %s --check-prefixes=X86,X86-BMI2
; RUN: llc -mtriple=i686-unknown-linux-gnu -mattr=+cmov,+bmi,-tbm,+bmi2 < %s | FileCheck %s --check-prefixes=X86,X86-BMI2
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -mattr=-bmi,-tbm,-bmi2 < %s | FileCheck %s --check-prefixes=X64,X64-NOBMI2
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -mattr=+bmi,-tbm,-bmi2 < %s | FileCheck %s --check-prefixes=X64,X64-NOBMI2
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -mattr=+bmi,+tbm,-bmi2 < %s | FileCheck %s --check-prefixes=X64,X64-NOBMI2
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -mattr=+bmi,+tbm,+bmi2 < %s | FileCheck %s --check-prefixes=X64,X64-BMI2
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -mattr=+bmi,-tbm,+bmi2 < %s | FileCheck %s --check-prefixes=X64,X64-BMI2

; Patterns:
;    c) x &  (-1 >> y)
;    d) x << y >> y
; are equivalent, but we prefer the second variant if we have BMI2.

; We do not test the variant where y = (32 - z), because that is BMI2's BZHI.

; ---------------------------------------------------------------------------- ;
; 8-bit
; ---------------------------------------------------------------------------- ;

define i8 @clear_highbits8_c0(i8 %val, i8 %numhighbits) nounwind {
; X86-LABEL: clear_highbits8_c0:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    shlb %cl, %al
; X86-NEXT:    shrb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: clear_highbits8_c0:
; X64:       # %bb.0:
; X64-NEXT:    movl %esi, %ecx
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shlb %cl, %al
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    shrb %cl, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %mask = lshr i8 -1, %numhighbits
  %masked = and i8 %mask, %val
  ret i8 %masked
}

define i8 @clear_highbits8_c2_load(i8* %w, i8 %numhighbits) nounwind {
; X86-LABEL: clear_highbits8_c2_load:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movb (%eax), %al
; X86-NEXT:    shlb %cl, %al
; X86-NEXT:    shrb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: clear_highbits8_c2_load:
; X64:       # %bb.0:
; X64-NEXT:    movl %esi, %ecx
; X64-NEXT:    movb (%rdi), %al
; X64-NEXT:    shlb %cl, %al
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    shrb %cl, %al
; X64-NEXT:    retq
  %val = load i8, i8* %w
  %mask = lshr i8 -1, %numhighbits
  %masked = and i8 %mask, %val
  ret i8 %masked
}

define i8 @clear_highbits8_c4_commutative(i8 %val, i8 %numhighbits) nounwind {
; X86-LABEL: clear_highbits8_c4_commutative:
; X86:       # %bb.0:
; X86-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-NEXT:    shlb %cl, %al
; X86-NEXT:    shrb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: clear_highbits8_c4_commutative:
; X64:       # %bb.0:
; X64-NEXT:    movl %esi, %ecx
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    shlb %cl, %al
; X64-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NEXT:    shrb %cl, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %mask = lshr i8 -1, %numhighbits
  %masked = and i8 %val, %mask ; swapped order
  ret i8 %masked
}

; ---------------------------------------------------------------------------- ;
; 16-bit
; ---------------------------------------------------------------------------- ;

define i16 @clear_highbits16_c0(i16 %val, i16 %numhighbits) nounwind {
; X86-NOBMI2-LABEL: clear_highbits16_c0:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    shll %cl, %eax
; X86-NOBMI2-NEXT:    movzwl %ax, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits16_c0:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI2-NEXT:    shlxl %eax, {{[0-9]+}}(%esp), %ecx
; X86-BMI2-NEXT:    movzwl %cx, %ecx
; X86-BMI2-NEXT:    shrxl %eax, %ecx, %eax
; X86-BMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits16_c0:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %esi, %ecx
; X64-NOBMI2-NEXT:    shll %cl, %edi
; X64-NOBMI2-NEXT:    movzwl %di, %eax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits16_c0:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    shlxl %esi, %edi, %eax
; X64-BMI2-NEXT:    movzwl %ax, %eax
; X64-BMI2-NEXT:    shrxl %esi, %eax, %eax
; X64-BMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-BMI2-NEXT:    retq
  %mask = lshr i16 -1, %numhighbits
  %masked = and i16 %mask, %val
  ret i16 %masked
}

define i16 @clear_highbits16_c1_indexzext(i16 %val, i8 %numhighbits) nounwind {
; X86-NOBMI2-LABEL: clear_highbits16_c1_indexzext:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    shll %cl, %eax
; X86-NOBMI2-NEXT:    movzwl %ax, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits16_c1_indexzext:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI2-NEXT:    shlxl %eax, {{[0-9]+}}(%esp), %ecx
; X86-BMI2-NEXT:    movzwl %cx, %ecx
; X86-BMI2-NEXT:    shrxl %eax, %ecx, %eax
; X86-BMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits16_c1_indexzext:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %esi, %ecx
; X64-NOBMI2-NEXT:    shll %cl, %edi
; X64-NOBMI2-NEXT:    movzwl %di, %eax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits16_c1_indexzext:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    shlxl %esi, %edi, %eax
; X64-BMI2-NEXT:    movzwl %ax, %eax
; X64-BMI2-NEXT:    shrxl %esi, %eax, %eax
; X64-BMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-BMI2-NEXT:    retq
  %sh_prom = zext i8 %numhighbits to i16
  %mask = lshr i16 -1, %sh_prom
  %masked = and i16 %mask, %val
  ret i16 %masked
}

define i16 @clear_highbits16_c2_load(i16* %w, i16 %numhighbits) nounwind {
; X86-NOBMI2-LABEL: clear_highbits16_c2_load:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    movzwl (%eax), %eax
; X86-NOBMI2-NEXT:    shll %cl, %eax
; X86-NOBMI2-NEXT:    movzwl %ax, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits16_c2_load:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI2-NEXT:    movzwl (%ecx), %ecx
; X86-BMI2-NEXT:    shlxl %eax, %ecx, %ecx
; X86-BMI2-NEXT:    movzwl %cx, %ecx
; X86-BMI2-NEXT:    shrxl %eax, %ecx, %eax
; X86-BMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits16_c2_load:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %esi, %ecx
; X64-NOBMI2-NEXT:    movzwl (%rdi), %eax
; X64-NOBMI2-NEXT:    shll %cl, %eax
; X64-NOBMI2-NEXT:    movzwl %ax, %eax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits16_c2_load:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movzwl (%rdi), %eax
; X64-BMI2-NEXT:    shlxl %esi, %eax, %eax
; X64-BMI2-NEXT:    movzwl %ax, %eax
; X64-BMI2-NEXT:    shrxl %esi, %eax, %eax
; X64-BMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-BMI2-NEXT:    retq
  %val = load i16, i16* %w
  %mask = lshr i16 -1, %numhighbits
  %masked = and i16 %mask, %val
  ret i16 %masked
}

define i16 @clear_highbits16_c3_load_indexzext(i16* %w, i8 %numhighbits) nounwind {
; X86-NOBMI2-LABEL: clear_highbits16_c3_load_indexzext:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    movzwl (%eax), %eax
; X86-NOBMI2-NEXT:    shll %cl, %eax
; X86-NOBMI2-NEXT:    movzwl %ax, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits16_c3_load_indexzext:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI2-NEXT:    movzwl (%ecx), %ecx
; X86-BMI2-NEXT:    shlxl %eax, %ecx, %ecx
; X86-BMI2-NEXT:    movzwl %cx, %ecx
; X86-BMI2-NEXT:    shrxl %eax, %ecx, %eax
; X86-BMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits16_c3_load_indexzext:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %esi, %ecx
; X64-NOBMI2-NEXT:    movzwl (%rdi), %eax
; X64-NOBMI2-NEXT:    shll %cl, %eax
; X64-NOBMI2-NEXT:    movzwl %ax, %eax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits16_c3_load_indexzext:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movzwl (%rdi), %eax
; X64-BMI2-NEXT:    shlxl %esi, %eax, %eax
; X64-BMI2-NEXT:    movzwl %ax, %eax
; X64-BMI2-NEXT:    shrxl %esi, %eax, %eax
; X64-BMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-BMI2-NEXT:    retq
  %val = load i16, i16* %w
  %sh_prom = zext i8 %numhighbits to i16
  %mask = lshr i16 -1, %sh_prom
  %masked = and i16 %mask, %val
  ret i16 %masked
}

define i16 @clear_highbits16_c4_commutative(i16 %val, i16 %numhighbits) nounwind {
; X86-NOBMI2-LABEL: clear_highbits16_c4_commutative:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    shll %cl, %eax
; X86-NOBMI2-NEXT:    movzwl %ax, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits16_c4_commutative:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI2-NEXT:    shlxl %eax, {{[0-9]+}}(%esp), %ecx
; X86-BMI2-NEXT:    movzwl %cx, %ecx
; X86-BMI2-NEXT:    shrxl %eax, %ecx, %eax
; X86-BMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits16_c4_commutative:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %esi, %ecx
; X64-NOBMI2-NEXT:    shll %cl, %edi
; X64-NOBMI2-NEXT:    movzwl %di, %eax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits16_c4_commutative:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    shlxl %esi, %edi, %eax
; X64-BMI2-NEXT:    movzwl %ax, %eax
; X64-BMI2-NEXT:    shrxl %esi, %eax, %eax
; X64-BMI2-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-BMI2-NEXT:    retq
  %mask = lshr i16 -1, %numhighbits
  %masked = and i16 %val, %mask ; swapped order
  ret i16 %masked
}

; ---------------------------------------------------------------------------- ;
; 32-bit
; ---------------------------------------------------------------------------- ;

define i32 @clear_highbits32_c0(i32 %val, i32 %numhighbits) nounwind {
; X86-NOBMI2-LABEL: clear_highbits32_c0:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    shll %cl, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits32_c0:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI2-NEXT:    movl $32, %ecx
; X86-BMI2-NEXT:    subl %eax, %ecx
; X86-BMI2-NEXT:    bzhil %ecx, {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits32_c0:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %esi, %ecx
; X64-NOBMI2-NEXT:    movl %edi, %eax
; X64-NOBMI2-NEXT:    shll %cl, %eax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits32_c0:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movl $32, %eax
; X64-BMI2-NEXT:    subl %esi, %eax
; X64-BMI2-NEXT:    bzhil %eax, %edi, %eax
; X64-BMI2-NEXT:    retq
  %mask = lshr i32 -1, %numhighbits
  %masked = and i32 %mask, %val
  ret i32 %masked
}

define i32 @clear_highbits32_c1_indexzext(i32 %val, i8 %numhighbits) nounwind {
; X86-NOBMI2-LABEL: clear_highbits32_c1_indexzext:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    shll %cl, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits32_c1_indexzext:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI2-NEXT:    movl $32, %ecx
; X86-BMI2-NEXT:    subl %eax, %ecx
; X86-BMI2-NEXT:    bzhil %ecx, {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits32_c1_indexzext:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %esi, %ecx
; X64-NOBMI2-NEXT:    movl %edi, %eax
; X64-NOBMI2-NEXT:    shll %cl, %eax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits32_c1_indexzext:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movl $32, %eax
; X64-BMI2-NEXT:    subl %esi, %eax
; X64-BMI2-NEXT:    bzhil %eax, %edi, %eax
; X64-BMI2-NEXT:    retq
  %sh_prom = zext i8 %numhighbits to i32
  %mask = lshr i32 -1, %sh_prom
  %masked = and i32 %mask, %val
  ret i32 %masked
}

define i32 @clear_highbits32_c2_load(i32* %w, i32 %numhighbits) nounwind {
; X86-NOBMI2-LABEL: clear_highbits32_c2_load:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    movl (%eax), %eax
; X86-NOBMI2-NEXT:    shll %cl, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits32_c2_load:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI2-NEXT:    movl $32, %edx
; X86-BMI2-NEXT:    subl %ecx, %edx
; X86-BMI2-NEXT:    bzhil %edx, (%eax), %eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits32_c2_load:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %esi, %ecx
; X64-NOBMI2-NEXT:    movl (%rdi), %eax
; X64-NOBMI2-NEXT:    shll %cl, %eax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits32_c2_load:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movl $32, %eax
; X64-BMI2-NEXT:    subl %esi, %eax
; X64-BMI2-NEXT:    bzhil %eax, (%rdi), %eax
; X64-BMI2-NEXT:    retq
  %val = load i32, i32* %w
  %mask = lshr i32 -1, %numhighbits
  %masked = and i32 %mask, %val
  ret i32 %masked
}

define i32 @clear_highbits32_c3_load_indexzext(i32* %w, i8 %numhighbits) nounwind {
; X86-NOBMI2-LABEL: clear_highbits32_c3_load_indexzext:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    movl (%eax), %eax
; X86-NOBMI2-NEXT:    shll %cl, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits32_c3_load_indexzext:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI2-NEXT:    movl $32, %edx
; X86-BMI2-NEXT:    subl %ecx, %edx
; X86-BMI2-NEXT:    bzhil %edx, (%eax), %eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits32_c3_load_indexzext:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %esi, %ecx
; X64-NOBMI2-NEXT:    movl (%rdi), %eax
; X64-NOBMI2-NEXT:    shll %cl, %eax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits32_c3_load_indexzext:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movl $32, %eax
; X64-BMI2-NEXT:    subl %esi, %eax
; X64-BMI2-NEXT:    bzhil %eax, (%rdi), %eax
; X64-BMI2-NEXT:    retq
  %val = load i32, i32* %w
  %sh_prom = zext i8 %numhighbits to i32
  %mask = lshr i32 -1, %sh_prom
  %masked = and i32 %mask, %val
  ret i32 %masked
}

define i32 @clear_highbits32_c4_commutative(i32 %val, i32 %numhighbits) nounwind {
; X86-NOBMI2-LABEL: clear_highbits32_c4_commutative:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    shll %cl, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits32_c4_commutative:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI2-NEXT:    movl $32, %ecx
; X86-BMI2-NEXT:    subl %eax, %ecx
; X86-BMI2-NEXT:    bzhil %ecx, {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits32_c4_commutative:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %esi, %ecx
; X64-NOBMI2-NEXT:    movl %edi, %eax
; X64-NOBMI2-NEXT:    shll %cl, %eax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits32_c4_commutative:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movl $32, %eax
; X64-BMI2-NEXT:    subl %esi, %eax
; X64-BMI2-NEXT:    bzhil %eax, %edi, %eax
; X64-BMI2-NEXT:    retq
  %mask = lshr i32 -1, %numhighbits
  %masked = and i32 %val, %mask ; swapped order
  ret i32 %masked
}

; ---------------------------------------------------------------------------- ;
; 64-bit
; ---------------------------------------------------------------------------- ;

define i64 @clear_highbits64_c0(i64 %val, i64 %numhighbits) nounwind {
; X86-BASELINE-LABEL: clear_highbits64_c0:
; X86-BASELINE:       # %bb.0:
; X86-BASELINE-NEXT:    pushl %esi
; X86-BASELINE-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BASELINE-NEXT:    movl $-1, %eax
; X86-BASELINE-NEXT:    movl $-1, %esi
; X86-BASELINE-NEXT:    shrl %cl, %esi
; X86-BASELINE-NEXT:    xorl %edx, %edx
; X86-BASELINE-NEXT:    testb $32, %cl
; X86-BASELINE-NEXT:    jne .LBB13_1
; X86-BASELINE-NEXT:  # %bb.2:
; X86-BASELINE-NEXT:    movl %esi, %edx
; X86-BASELINE-NEXT:    jmp .LBB13_3
; X86-BASELINE-NEXT:  .LBB13_1:
; X86-BASELINE-NEXT:    movl %esi, %eax
; X86-BASELINE-NEXT:  .LBB13_3:
; X86-BASELINE-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BASELINE-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X86-BASELINE-NEXT:    popl %esi
; X86-BASELINE-NEXT:    retl
;
; X86-BMI1-LABEL: clear_highbits64_c0:
; X86-BMI1:       # %bb.0:
; X86-BMI1-NEXT:    pushl %esi
; X86-BMI1-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1-NEXT:    movl $-1, %esi
; X86-BMI1-NEXT:    movl $-1, %eax
; X86-BMI1-NEXT:    shrl %cl, %eax
; X86-BMI1-NEXT:    xorl %edx, %edx
; X86-BMI1-NEXT:    testb $32, %cl
; X86-BMI1-NEXT:    cmovel %eax, %edx
; X86-BMI1-NEXT:    cmovel %esi, %eax
; X86-BMI1-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BMI1-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X86-BMI1-NEXT:    popl %esi
; X86-BMI1-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits64_c0:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    pushl %esi
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI2-NEXT:    movl $-1, %eax
; X86-BMI2-NEXT:    shrxl %ecx, %eax, %esi
; X86-BMI2-NEXT:    xorl %edx, %edx
; X86-BMI2-NEXT:    testb $32, %cl
; X86-BMI2-NEXT:    cmovel %esi, %edx
; X86-BMI2-NEXT:    cmovnel %esi, %eax
; X86-BMI2-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X86-BMI2-NEXT:    popl %esi
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits64_c0:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movq %rsi, %rcx
; X64-NOBMI2-NEXT:    movq %rdi, %rax
; X64-NOBMI2-NEXT:    shlq %cl, %rax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI2-NEXT:    shrq %cl, %rax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits64_c0:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movl $64, %eax
; X64-BMI2-NEXT:    subl %esi, %eax
; X64-BMI2-NEXT:    bzhiq %rax, %rdi, %rax
; X64-BMI2-NEXT:    retq
  %mask = lshr i64 -1, %numhighbits
  %masked = and i64 %mask, %val
  ret i64 %masked
}

define i64 @clear_highbits64_c1_indexzext(i64 %val, i8 %numhighbits) nounwind {
; X86-BASELINE-LABEL: clear_highbits64_c1_indexzext:
; X86-BASELINE:       # %bb.0:
; X86-BASELINE-NEXT:    pushl %esi
; X86-BASELINE-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BASELINE-NEXT:    movl $-1, %eax
; X86-BASELINE-NEXT:    movl $-1, %esi
; X86-BASELINE-NEXT:    shrl %cl, %esi
; X86-BASELINE-NEXT:    xorl %edx, %edx
; X86-BASELINE-NEXT:    testb $32, %cl
; X86-BASELINE-NEXT:    jne .LBB14_1
; X86-BASELINE-NEXT:  # %bb.2:
; X86-BASELINE-NEXT:    movl %esi, %edx
; X86-BASELINE-NEXT:    jmp .LBB14_3
; X86-BASELINE-NEXT:  .LBB14_1:
; X86-BASELINE-NEXT:    movl %esi, %eax
; X86-BASELINE-NEXT:  .LBB14_3:
; X86-BASELINE-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BASELINE-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X86-BASELINE-NEXT:    popl %esi
; X86-BASELINE-NEXT:    retl
;
; X86-BMI1-LABEL: clear_highbits64_c1_indexzext:
; X86-BMI1:       # %bb.0:
; X86-BMI1-NEXT:    pushl %esi
; X86-BMI1-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1-NEXT:    movl $-1, %esi
; X86-BMI1-NEXT:    movl $-1, %eax
; X86-BMI1-NEXT:    shrl %cl, %eax
; X86-BMI1-NEXT:    xorl %edx, %edx
; X86-BMI1-NEXT:    testb $32, %cl
; X86-BMI1-NEXT:    cmovel %eax, %edx
; X86-BMI1-NEXT:    cmovel %esi, %eax
; X86-BMI1-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BMI1-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X86-BMI1-NEXT:    popl %esi
; X86-BMI1-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits64_c1_indexzext:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    pushl %esi
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI2-NEXT:    movl $-1, %eax
; X86-BMI2-NEXT:    shrxl %ecx, %eax, %esi
; X86-BMI2-NEXT:    xorl %edx, %edx
; X86-BMI2-NEXT:    testb $32, %cl
; X86-BMI2-NEXT:    cmovel %esi, %edx
; X86-BMI2-NEXT:    cmovnel %esi, %eax
; X86-BMI2-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X86-BMI2-NEXT:    popl %esi
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits64_c1_indexzext:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %esi, %ecx
; X64-NOBMI2-NEXT:    movq %rdi, %rax
; X64-NOBMI2-NEXT:    shlq %cl, %rax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI2-NEXT:    shrq %cl, %rax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits64_c1_indexzext:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movl $64, %eax
; X64-BMI2-NEXT:    subl %esi, %eax
; X64-BMI2-NEXT:    bzhiq %rax, %rdi, %rax
; X64-BMI2-NEXT:    retq
  %sh_prom = zext i8 %numhighbits to i64
  %mask = lshr i64 -1, %sh_prom
  %masked = and i64 %mask, %val
  ret i64 %masked
}

define i64 @clear_highbits64_c2_load(i64* %w, i64 %numhighbits) nounwind {
; X86-BASELINE-LABEL: clear_highbits64_c2_load:
; X86-BASELINE:       # %bb.0:
; X86-BASELINE-NEXT:    pushl %edi
; X86-BASELINE-NEXT:    pushl %esi
; X86-BASELINE-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BASELINE-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BASELINE-NEXT:    movl $-1, %eax
; X86-BASELINE-NEXT:    movl $-1, %edi
; X86-BASELINE-NEXT:    shrl %cl, %edi
; X86-BASELINE-NEXT:    xorl %edx, %edx
; X86-BASELINE-NEXT:    testb $32, %cl
; X86-BASELINE-NEXT:    jne .LBB15_1
; X86-BASELINE-NEXT:  # %bb.2:
; X86-BASELINE-NEXT:    movl %edi, %edx
; X86-BASELINE-NEXT:    jmp .LBB15_3
; X86-BASELINE-NEXT:  .LBB15_1:
; X86-BASELINE-NEXT:    movl %edi, %eax
; X86-BASELINE-NEXT:  .LBB15_3:
; X86-BASELINE-NEXT:    andl (%esi), %eax
; X86-BASELINE-NEXT:    andl 4(%esi), %edx
; X86-BASELINE-NEXT:    popl %esi
; X86-BASELINE-NEXT:    popl %edi
; X86-BASELINE-NEXT:    retl
;
; X86-BMI1-LABEL: clear_highbits64_c2_load:
; X86-BMI1:       # %bb.0:
; X86-BMI1-NEXT:    pushl %edi
; X86-BMI1-NEXT:    pushl %esi
; X86-BMI1-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1-NEXT:    movl $-1, %edi
; X86-BMI1-NEXT:    movl $-1, %eax
; X86-BMI1-NEXT:    shrl %cl, %eax
; X86-BMI1-NEXT:    xorl %edx, %edx
; X86-BMI1-NEXT:    testb $32, %cl
; X86-BMI1-NEXT:    cmovel %eax, %edx
; X86-BMI1-NEXT:    cmovel %edi, %eax
; X86-BMI1-NEXT:    andl (%esi), %eax
; X86-BMI1-NEXT:    andl 4(%esi), %edx
; X86-BMI1-NEXT:    popl %esi
; X86-BMI1-NEXT:    popl %edi
; X86-BMI1-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits64_c2_load:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    pushl %ebx
; X86-BMI2-NEXT:    pushl %esi
; X86-BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %bl
; X86-BMI2-NEXT:    movl $-1, %eax
; X86-BMI2-NEXT:    shrxl %ebx, %eax, %esi
; X86-BMI2-NEXT:    xorl %edx, %edx
; X86-BMI2-NEXT:    testb $32, %bl
; X86-BMI2-NEXT:    cmovel %esi, %edx
; X86-BMI2-NEXT:    cmovnel %esi, %eax
; X86-BMI2-NEXT:    andl (%ecx), %eax
; X86-BMI2-NEXT:    andl 4(%ecx), %edx
; X86-BMI2-NEXT:    popl %esi
; X86-BMI2-NEXT:    popl %ebx
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits64_c2_load:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movq %rsi, %rcx
; X64-NOBMI2-NEXT:    movq (%rdi), %rax
; X64-NOBMI2-NEXT:    shlq %cl, %rax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI2-NEXT:    shrq %cl, %rax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits64_c2_load:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movl $64, %eax
; X64-BMI2-NEXT:    subl %esi, %eax
; X64-BMI2-NEXT:    bzhiq %rax, (%rdi), %rax
; X64-BMI2-NEXT:    retq
  %val = load i64, i64* %w
  %mask = lshr i64 -1, %numhighbits
  %masked = and i64 %mask, %val
  ret i64 %masked
}

define i64 @clear_highbits64_c3_load_indexzext(i64* %w, i8 %numhighbits) nounwind {
; X86-BASELINE-LABEL: clear_highbits64_c3_load_indexzext:
; X86-BASELINE:       # %bb.0:
; X86-BASELINE-NEXT:    pushl %edi
; X86-BASELINE-NEXT:    pushl %esi
; X86-BASELINE-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BASELINE-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BASELINE-NEXT:    movl $-1, %eax
; X86-BASELINE-NEXT:    movl $-1, %edi
; X86-BASELINE-NEXT:    shrl %cl, %edi
; X86-BASELINE-NEXT:    xorl %edx, %edx
; X86-BASELINE-NEXT:    testb $32, %cl
; X86-BASELINE-NEXT:    jne .LBB16_1
; X86-BASELINE-NEXT:  # %bb.2:
; X86-BASELINE-NEXT:    movl %edi, %edx
; X86-BASELINE-NEXT:    jmp .LBB16_3
; X86-BASELINE-NEXT:  .LBB16_1:
; X86-BASELINE-NEXT:    movl %edi, %eax
; X86-BASELINE-NEXT:  .LBB16_3:
; X86-BASELINE-NEXT:    andl (%esi), %eax
; X86-BASELINE-NEXT:    andl 4(%esi), %edx
; X86-BASELINE-NEXT:    popl %esi
; X86-BASELINE-NEXT:    popl %edi
; X86-BASELINE-NEXT:    retl
;
; X86-BMI1-LABEL: clear_highbits64_c3_load_indexzext:
; X86-BMI1:       # %bb.0:
; X86-BMI1-NEXT:    pushl %edi
; X86-BMI1-NEXT:    pushl %esi
; X86-BMI1-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1-NEXT:    movl $-1, %edi
; X86-BMI1-NEXT:    movl $-1, %eax
; X86-BMI1-NEXT:    shrl %cl, %eax
; X86-BMI1-NEXT:    xorl %edx, %edx
; X86-BMI1-NEXT:    testb $32, %cl
; X86-BMI1-NEXT:    cmovel %eax, %edx
; X86-BMI1-NEXT:    cmovel %edi, %eax
; X86-BMI1-NEXT:    andl (%esi), %eax
; X86-BMI1-NEXT:    andl 4(%esi), %edx
; X86-BMI1-NEXT:    popl %esi
; X86-BMI1-NEXT:    popl %edi
; X86-BMI1-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits64_c3_load_indexzext:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    pushl %ebx
; X86-BMI2-NEXT:    pushl %esi
; X86-BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %bl
; X86-BMI2-NEXT:    movl $-1, %eax
; X86-BMI2-NEXT:    shrxl %ebx, %eax, %esi
; X86-BMI2-NEXT:    xorl %edx, %edx
; X86-BMI2-NEXT:    testb $32, %bl
; X86-BMI2-NEXT:    cmovel %esi, %edx
; X86-BMI2-NEXT:    cmovnel %esi, %eax
; X86-BMI2-NEXT:    andl (%ecx), %eax
; X86-BMI2-NEXT:    andl 4(%ecx), %edx
; X86-BMI2-NEXT:    popl %esi
; X86-BMI2-NEXT:    popl %ebx
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits64_c3_load_indexzext:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %esi, %ecx
; X64-NOBMI2-NEXT:    movq (%rdi), %rax
; X64-NOBMI2-NEXT:    shlq %cl, %rax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI2-NEXT:    shrq %cl, %rax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits64_c3_load_indexzext:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movl $64, %eax
; X64-BMI2-NEXT:    subl %esi, %eax
; X64-BMI2-NEXT:    bzhiq %rax, (%rdi), %rax
; X64-BMI2-NEXT:    retq
  %val = load i64, i64* %w
  %sh_prom = zext i8 %numhighbits to i64
  %mask = lshr i64 -1, %sh_prom
  %masked = and i64 %mask, %val
  ret i64 %masked
}

define i64 @clear_highbits64_c4_commutative(i64 %val, i64 %numhighbits) nounwind {
; X86-BASELINE-LABEL: clear_highbits64_c4_commutative:
; X86-BASELINE:       # %bb.0:
; X86-BASELINE-NEXT:    pushl %esi
; X86-BASELINE-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BASELINE-NEXT:    movl $-1, %eax
; X86-BASELINE-NEXT:    movl $-1, %esi
; X86-BASELINE-NEXT:    shrl %cl, %esi
; X86-BASELINE-NEXT:    xorl %edx, %edx
; X86-BASELINE-NEXT:    testb $32, %cl
; X86-BASELINE-NEXT:    jne .LBB17_1
; X86-BASELINE-NEXT:  # %bb.2:
; X86-BASELINE-NEXT:    movl %esi, %edx
; X86-BASELINE-NEXT:    jmp .LBB17_3
; X86-BASELINE-NEXT:  .LBB17_1:
; X86-BASELINE-NEXT:    movl %esi, %eax
; X86-BASELINE-NEXT:  .LBB17_3:
; X86-BASELINE-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BASELINE-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X86-BASELINE-NEXT:    popl %esi
; X86-BASELINE-NEXT:    retl
;
; X86-BMI1-LABEL: clear_highbits64_c4_commutative:
; X86-BMI1:       # %bb.0:
; X86-BMI1-NEXT:    pushl %esi
; X86-BMI1-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1-NEXT:    movl $-1, %esi
; X86-BMI1-NEXT:    movl $-1, %eax
; X86-BMI1-NEXT:    shrl %cl, %eax
; X86-BMI1-NEXT:    xorl %edx, %edx
; X86-BMI1-NEXT:    testb $32, %cl
; X86-BMI1-NEXT:    cmovel %eax, %edx
; X86-BMI1-NEXT:    cmovel %esi, %eax
; X86-BMI1-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BMI1-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X86-BMI1-NEXT:    popl %esi
; X86-BMI1-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits64_c4_commutative:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    pushl %esi
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI2-NEXT:    movl $-1, %eax
; X86-BMI2-NEXT:    shrxl %ecx, %eax, %esi
; X86-BMI2-NEXT:    xorl %edx, %edx
; X86-BMI2-NEXT:    testb $32, %cl
; X86-BMI2-NEXT:    cmovel %esi, %edx
; X86-BMI2-NEXT:    cmovnel %esi, %eax
; X86-BMI2-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X86-BMI2-NEXT:    popl %esi
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits64_c4_commutative:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movq %rsi, %rcx
; X64-NOBMI2-NEXT:    movq %rdi, %rax
; X64-NOBMI2-NEXT:    shlq %cl, %rax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI2-NEXT:    shrq %cl, %rax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits64_c4_commutative:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movl $64, %eax
; X64-BMI2-NEXT:    subl %esi, %eax
; X64-BMI2-NEXT:    bzhiq %rax, %rdi, %rax
; X64-BMI2-NEXT:    retq
  %mask = lshr i64 -1, %numhighbits
  %masked = and i64 %val, %mask ; swapped order
  ret i64 %masked
}

; ---------------------------------------------------------------------------- ;
; Multi-use tests
; ---------------------------------------------------------------------------- ;

define i32 @oneuse32_c(i32 %val, i32 %numhighbits, i32* %escape) nounwind {
; X86-NOBMI2-LABEL: oneuse32_c:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOBMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    movl $-1, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    movl %eax, (%edx)
; X86-NOBMI2-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: oneuse32_c:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %al
; X86-BMI2-NEXT:    movl $-1, %edx
; X86-BMI2-NEXT:    shrxl %eax, %edx, %eax
; X86-BMI2-NEXT:    movl %eax, (%ecx)
; X86-BMI2-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: oneuse32_c:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %esi, %ecx
; X64-NOBMI2-NEXT:    movl $-1, %eax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    movl %eax, (%rdx)
; X64-NOBMI2-NEXT:    andl %edi, %eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: oneuse32_c:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movl $-1, %eax
; X64-BMI2-NEXT:    shrxl %esi, %eax, %eax
; X64-BMI2-NEXT:    movl %eax, (%rdx)
; X64-BMI2-NEXT:    andl %edi, %eax
; X64-BMI2-NEXT:    retq
  %mask = lshr i32 -1, %numhighbits
  store i32 %mask, i32* %escape
  %masked = and i32 %mask, %val
  ret i32 %masked
}

define i64 @oneuse64_c(i64 %val, i64 %numhighbits, i64* %escape) nounwind {
; X86-BASELINE-LABEL: oneuse64_c:
; X86-BASELINE:       # %bb.0:
; X86-BASELINE-NEXT:    pushl %esi
; X86-BASELINE-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BASELINE-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BASELINE-NEXT:    movl $-1, %eax
; X86-BASELINE-NEXT:    movl $-1, %edx
; X86-BASELINE-NEXT:    shrl %cl, %edx
; X86-BASELINE-NEXT:    testb $32, %cl
; X86-BASELINE-NEXT:    je .LBB19_2
; X86-BASELINE-NEXT:  # %bb.1:
; X86-BASELINE-NEXT:    movl %edx, %eax
; X86-BASELINE-NEXT:    xorl %edx, %edx
; X86-BASELINE-NEXT:  .LBB19_2:
; X86-BASELINE-NEXT:    movl %edx, 4(%esi)
; X86-BASELINE-NEXT:    movl %eax, (%esi)
; X86-BASELINE-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BASELINE-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X86-BASELINE-NEXT:    popl %esi
; X86-BASELINE-NEXT:    retl
;
; X86-BMI1-LABEL: oneuse64_c:
; X86-BMI1:       # %bb.0:
; X86-BMI1-NEXT:    pushl %edi
; X86-BMI1-NEXT:    pushl %esi
; X86-BMI1-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1-NEXT:    movl $-1, %eax
; X86-BMI1-NEXT:    movl $-1, %edi
; X86-BMI1-NEXT:    shrl %cl, %edi
; X86-BMI1-NEXT:    xorl %edx, %edx
; X86-BMI1-NEXT:    testb $32, %cl
; X86-BMI1-NEXT:    cmovnel %edi, %eax
; X86-BMI1-NEXT:    cmovel %edi, %edx
; X86-BMI1-NEXT:    movl %edx, 4(%esi)
; X86-BMI1-NEXT:    movl %eax, (%esi)
; X86-BMI1-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BMI1-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X86-BMI1-NEXT:    popl %esi
; X86-BMI1-NEXT:    popl %edi
; X86-BMI1-NEXT:    retl
;
; X86-BMI2-LABEL: oneuse64_c:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    pushl %ebx
; X86-BMI2-NEXT:    pushl %esi
; X86-BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %bl
; X86-BMI2-NEXT:    movl $-1, %eax
; X86-BMI2-NEXT:    shrxl %ebx, %eax, %esi
; X86-BMI2-NEXT:    xorl %edx, %edx
; X86-BMI2-NEXT:    testb $32, %bl
; X86-BMI2-NEXT:    cmovnel %esi, %eax
; X86-BMI2-NEXT:    cmovel %esi, %edx
; X86-BMI2-NEXT:    movl %edx, 4(%ecx)
; X86-BMI2-NEXT:    movl %eax, (%ecx)
; X86-BMI2-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    andl {{[0-9]+}}(%esp), %edx
; X86-BMI2-NEXT:    popl %esi
; X86-BMI2-NEXT:    popl %ebx
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: oneuse64_c:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movq %rsi, %rcx
; X64-NOBMI2-NEXT:    movq $-1, %rax
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI2-NEXT:    shrq %cl, %rax
; X64-NOBMI2-NEXT:    movq %rax, (%rdx)
; X64-NOBMI2-NEXT:    andq %rdi, %rax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: oneuse64_c:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movq $-1, %rax
; X64-BMI2-NEXT:    shrxq %rsi, %rax, %rax
; X64-BMI2-NEXT:    movq %rax, (%rdx)
; X64-BMI2-NEXT:    andq %rdi, %rax
; X64-BMI2-NEXT:    retq
  %mask = lshr i64 -1, %numhighbits
  store i64 %mask, i64* %escape
  %masked = and i64 %mask, %val
  ret i64 %masked
}

define i32 @oneuse32_d(i32 %val, i32 %numhighbits, i32* %escape) nounwind {
; X86-NOBMI2-LABEL: oneuse32_d:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOBMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    shll %cl, %eax
; X86-NOBMI2-NEXT:    movl %eax, (%edx)
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: oneuse32_d:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI2-NEXT:    shlxl %ecx, {{[0-9]+}}(%esp), %edx
; X86-BMI2-NEXT:    movl %edx, (%eax)
; X86-BMI2-NEXT:    shrxl %ecx, %edx, %eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: oneuse32_d:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %esi, %ecx
; X64-NOBMI2-NEXT:    movl %edi, %eax
; X64-NOBMI2-NEXT:    shll %cl, %eax
; X64-NOBMI2-NEXT:    movl %eax, (%rdx)
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $ecx
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: oneuse32_d:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    shlxl %esi, %edi, %eax
; X64-BMI2-NEXT:    movl %eax, (%rdx)
; X64-BMI2-NEXT:    shrxl %esi, %eax, %eax
; X64-BMI2-NEXT:    retq
  %sh1 = shl i32 %val, %numhighbits
  store i32 %sh1, i32* %escape
  %masked = lshr i32 %sh1, %numhighbits
  ret i32 %masked
}

define i64 @oneusei64_d(i64 %val, i64 %numhighbits, i64* %escape) nounwind {
; X86-BASELINE-LABEL: oneusei64_d:
; X86-BASELINE:       # %bb.0:
; X86-BASELINE-NEXT:    pushl %ebx
; X86-BASELINE-NEXT:    pushl %edi
; X86-BASELINE-NEXT:    pushl %esi
; X86-BASELINE-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BASELINE-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BASELINE-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BASELINE-NEXT:    movl %edx, %edi
; X86-BASELINE-NEXT:    shll %cl, %edi
; X86-BASELINE-NEXT:    shldl %cl, %edx, %eax
; X86-BASELINE-NEXT:    testb $32, %cl
; X86-BASELINE-NEXT:    movl %edi, %esi
; X86-BASELINE-NEXT:    jne .LBB21_2
; X86-BASELINE-NEXT:  # %bb.1:
; X86-BASELINE-NEXT:    movl %eax, %esi
; X86-BASELINE-NEXT:  .LBB21_2:
; X86-BASELINE-NEXT:    movl %esi, %eax
; X86-BASELINE-NEXT:    shrl %cl, %eax
; X86-BASELINE-NEXT:    xorl %ebx, %ebx
; X86-BASELINE-NEXT:    testb $32, %cl
; X86-BASELINE-NEXT:    movl $0, %edx
; X86-BASELINE-NEXT:    jne .LBB21_4
; X86-BASELINE-NEXT:  # %bb.3:
; X86-BASELINE-NEXT:    movl %edi, %ebx
; X86-BASELINE-NEXT:    movl %eax, %edx
; X86-BASELINE-NEXT:  .LBB21_4:
; X86-BASELINE-NEXT:    movl %ebx, %edi
; X86-BASELINE-NEXT:    shrdl %cl, %esi, %edi
; X86-BASELINE-NEXT:    testb $32, %cl
; X86-BASELINE-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BASELINE-NEXT:    movl %ebx, (%ecx)
; X86-BASELINE-NEXT:    movl %esi, 4(%ecx)
; X86-BASELINE-NEXT:    jne .LBB21_6
; X86-BASELINE-NEXT:  # %bb.5:
; X86-BASELINE-NEXT:    movl %edi, %eax
; X86-BASELINE-NEXT:  .LBB21_6:
; X86-BASELINE-NEXT:    popl %esi
; X86-BASELINE-NEXT:    popl %edi
; X86-BASELINE-NEXT:    popl %ebx
; X86-BASELINE-NEXT:    retl
;
; X86-BMI1-LABEL: oneusei64_d:
; X86-BMI1:       # %bb.0:
; X86-BMI1-NEXT:    pushl %ebx
; X86-BMI1-NEXT:    pushl %edi
; X86-BMI1-NEXT:    pushl %esi
; X86-BMI1-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI1-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-BMI1-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI1-NEXT:    movl %edx, %eax
; X86-BMI1-NEXT:    shll %cl, %eax
; X86-BMI1-NEXT:    shldl %cl, %edx, %esi
; X86-BMI1-NEXT:    testb $32, %cl
; X86-BMI1-NEXT:    cmovnel %eax, %esi
; X86-BMI1-NEXT:    movl %esi, %edi
; X86-BMI1-NEXT:    shrl %cl, %edi
; X86-BMI1-NEXT:    xorl %edx, %edx
; X86-BMI1-NEXT:    testb $32, %cl
; X86-BMI1-NEXT:    cmovnel %edx, %eax
; X86-BMI1-NEXT:    cmovel %edi, %edx
; X86-BMI1-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-BMI1-NEXT:    movl %eax, (%ebx)
; X86-BMI1-NEXT:    shrdl %cl, %esi, %eax
; X86-BMI1-NEXT:    testb $32, %cl
; X86-BMI1-NEXT:    movl %esi, 4(%ebx)
; X86-BMI1-NEXT:    cmovnel %edi, %eax
; X86-BMI1-NEXT:    popl %esi
; X86-BMI1-NEXT:    popl %edi
; X86-BMI1-NEXT:    popl %ebx
; X86-BMI1-NEXT:    retl
;
; X86-BMI2-LABEL: oneusei64_d:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    pushl %ebx
; X86-BMI2-NEXT:    pushl %edi
; X86-BMI2-NEXT:    pushl %esi
; X86-BMI2-NEXT:    movb {{[0-9]+}}(%esp), %cl
; X86-BMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-BMI2-NEXT:    shldl %cl, %eax, %esi
; X86-BMI2-NEXT:    shlxl %ecx, %eax, %eax
; X86-BMI2-NEXT:    xorl %edx, %edx
; X86-BMI2-NEXT:    testb $32, %cl
; X86-BMI2-NEXT:    cmovnel %eax, %esi
; X86-BMI2-NEXT:    cmovnel %edx, %eax
; X86-BMI2-NEXT:    shrxl %ecx, %esi, %edi
; X86-BMI2-NEXT:    cmovel %edi, %edx
; X86-BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-BMI2-NEXT:    movl %eax, (%ebx)
; X86-BMI2-NEXT:    shrdl %cl, %esi, %eax
; X86-BMI2-NEXT:    testb $32, %cl
; X86-BMI2-NEXT:    movl %esi, 4(%ebx)
; X86-BMI2-NEXT:    cmovnel %edi, %eax
; X86-BMI2-NEXT:    popl %esi
; X86-BMI2-NEXT:    popl %edi
; X86-BMI2-NEXT:    popl %ebx
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: oneusei64_d:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movq %rsi, %rcx
; X64-NOBMI2-NEXT:    movq %rdi, %rax
; X64-NOBMI2-NEXT:    shlq %cl, %rax
; X64-NOBMI2-NEXT:    movq %rax, (%rdx)
; X64-NOBMI2-NEXT:    # kill: def $cl killed $cl killed $rcx
; X64-NOBMI2-NEXT:    shrq %cl, %rax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: oneusei64_d:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    shlxq %rsi, %rdi, %rax
; X64-BMI2-NEXT:    movq %rax, (%rdx)
; X64-BMI2-NEXT:    shrxq %rsi, %rax, %rax
; X64-BMI2-NEXT:    retq
  %sh1 = shl i64 %val, %numhighbits
  store i64 %sh1, i64* %escape
  %masked = lshr i64 %sh1, %numhighbits
  ret i64 %masked
}

; ---------------------------------------------------------------------------- ;
; Misc.
;
; Variation of pattern
;   c) x &  (-1 >> (C - y))
; but with C != bitwidth(x)
; ---------------------------------------------------------------------------- ;

define i32 @clear_highbits32_16(i32 %val, i32 %numlowbits) nounwind {
; X86-NOBMI2-LABEL: clear_highbits32_16:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    movb $16, %cl
; X86-NOBMI2-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    shll %cl, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits32_16:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movb $16, %al
; X86-BMI2-NEXT:    subb {{[0-9]+}}(%esp), %al
; X86-BMI2-NEXT:    movl $32, %ecx
; X86-BMI2-NEXT:    subl %eax, %ecx
; X86-BMI2-NEXT:    bzhil %ecx, {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits32_16:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %edi, %eax
; X64-NOBMI2-NEXT:    movb $16, %cl
; X64-NOBMI2-NEXT:    subb %sil, %cl
; X64-NOBMI2-NEXT:    shll %cl, %eax
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits32_16:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movb $16, %al
; X64-BMI2-NEXT:    subb %sil, %al
; X64-BMI2-NEXT:    movl $32, %ecx
; X64-BMI2-NEXT:    subl %eax, %ecx
; X64-BMI2-NEXT:    bzhil %ecx, %edi, %eax
; X64-BMI2-NEXT:    retq
  %numhighbits = sub i32 16, %numlowbits
  %mask = lshr i32 -1, %numhighbits
  %masked = and i32 %mask, %val
  ret i32 %masked
}
define i32 @clear_highbits32_48(i32 %val, i32 %numlowbits) nounwind {
; X86-NOBMI2-LABEL: clear_highbits32_48:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    movb $48, %cl
; X86-NOBMI2-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    shll %cl, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits32_48:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movb $48, %al
; X86-BMI2-NEXT:    subb {{[0-9]+}}(%esp), %al
; X86-BMI2-NEXT:    movl $32, %ecx
; X86-BMI2-NEXT:    subl %eax, %ecx
; X86-BMI2-NEXT:    bzhil %ecx, {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits32_48:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movl %edi, %eax
; X64-NOBMI2-NEXT:    movb $48, %cl
; X64-NOBMI2-NEXT:    subb %sil, %cl
; X64-NOBMI2-NEXT:    shll %cl, %eax
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits32_48:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movb $48, %al
; X64-BMI2-NEXT:    subb %sil, %al
; X64-BMI2-NEXT:    movl $32, %ecx
; X64-BMI2-NEXT:    subl %eax, %ecx
; X64-BMI2-NEXT:    bzhil %ecx, %edi, %eax
; X64-BMI2-NEXT:    retq
  %numhighbits = sub i32 48, %numlowbits
  %mask = lshr i32 -1, %numhighbits
  %masked = and i32 %mask, %val
  ret i32 %masked
}

define i32 @clear_highbits32_16_extrause(i32 %val, i32 %numlowbits, i32* %escape) nounwind {
; X86-NOBMI2-LABEL: clear_highbits32_16_extrause:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOBMI2-NEXT:    movb $16, %cl
; X86-NOBMI2-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    movl $-1, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    movl %eax, (%edx)
; X86-NOBMI2-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits32_16_extrause:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI2-NEXT:    movb $16, %al
; X86-BMI2-NEXT:    subb {{[0-9]+}}(%esp), %al
; X86-BMI2-NEXT:    movl $-1, %edx
; X86-BMI2-NEXT:    shrxl %eax, %edx, %eax
; X86-BMI2-NEXT:    movl %eax, (%ecx)
; X86-BMI2-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits32_16_extrause:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movb $16, %cl
; X64-NOBMI2-NEXT:    subb %sil, %cl
; X64-NOBMI2-NEXT:    movl $-1, %eax
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    movl %eax, (%rdx)
; X64-NOBMI2-NEXT:    andl %edi, %eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits32_16_extrause:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movb $16, %al
; X64-BMI2-NEXT:    subb %sil, %al
; X64-BMI2-NEXT:    movl $-1, %ecx
; X64-BMI2-NEXT:    shrxl %eax, %ecx, %eax
; X64-BMI2-NEXT:    movl %eax, (%rdx)
; X64-BMI2-NEXT:    andl %edi, %eax
; X64-BMI2-NEXT:    retq
  %numhighbits = sub i32 16, %numlowbits
  %mask = lshr i32 -1, %numhighbits
  store i32 %mask, i32* %escape
  %masked = and i32 %mask, %val
  ret i32 %masked
}
define i32 @clear_highbits32_48_extrause(i32 %val, i32 %numlowbits, i32* %escape) nounwind {
; X86-NOBMI2-LABEL: clear_highbits32_48_extrause:
; X86-NOBMI2:       # %bb.0:
; X86-NOBMI2-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NOBMI2-NEXT:    movb $48, %cl
; X86-NOBMI2-NEXT:    subb {{[0-9]+}}(%esp), %cl
; X86-NOBMI2-NEXT:    movl $-1, %eax
; X86-NOBMI2-NEXT:    shrl %cl, %eax
; X86-NOBMI2-NEXT:    movl %eax, (%edx)
; X86-NOBMI2-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-NOBMI2-NEXT:    retl
;
; X86-BMI2-LABEL: clear_highbits32_48_extrause:
; X86-BMI2:       # %bb.0:
; X86-BMI2-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-BMI2-NEXT:    movb $48, %al
; X86-BMI2-NEXT:    subb {{[0-9]+}}(%esp), %al
; X86-BMI2-NEXT:    movl $-1, %edx
; X86-BMI2-NEXT:    shrxl %eax, %edx, %eax
; X86-BMI2-NEXT:    movl %eax, (%ecx)
; X86-BMI2-NEXT:    andl {{[0-9]+}}(%esp), %eax
; X86-BMI2-NEXT:    retl
;
; X64-NOBMI2-LABEL: clear_highbits32_48_extrause:
; X64-NOBMI2:       # %bb.0:
; X64-NOBMI2-NEXT:    movb $48, %cl
; X64-NOBMI2-NEXT:    subb %sil, %cl
; X64-NOBMI2-NEXT:    movl $-1, %eax
; X64-NOBMI2-NEXT:    shrl %cl, %eax
; X64-NOBMI2-NEXT:    movl %eax, (%rdx)
; X64-NOBMI2-NEXT:    andl %edi, %eax
; X64-NOBMI2-NEXT:    retq
;
; X64-BMI2-LABEL: clear_highbits32_48_extrause:
; X64-BMI2:       # %bb.0:
; X64-BMI2-NEXT:    movb $48, %al
; X64-BMI2-NEXT:    subb %sil, %al
; X64-BMI2-NEXT:    movl $-1, %ecx
; X64-BMI2-NEXT:    shrxl %eax, %ecx, %eax
; X64-BMI2-NEXT:    movl %eax, (%rdx)
; X64-BMI2-NEXT:    andl %edi, %eax
; X64-BMI2-NEXT:    retq
  %numhighbits = sub i32 48, %numlowbits
  %mask = lshr i32 -1, %numhighbits
  store i32 %mask, i32* %escape
  %masked = and i32 %mask, %val
  ret i32 %masked
}
