/*
 * Copyright 2010-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license
 * that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.codegen;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.JUnit3RunnerWithInners;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.runner.RunWith;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.generators.tests.TestsPackage}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/tests-spec/testData/codegen/box")
@TestDataPath("$PROJECT_ROOT")
@RunWith(JUnit3RunnerWithInners.class)
public class BlackBoxCodegenTestSpecGenerated extends AbstractBlackBoxCodegenTestSpec {
    private void runTest(String testDataFilePath) throws Exception {
        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
    }

    public void testAllFilesPresentInBox() throws Exception {
        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true, "helpers", "templates");
    }

    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class Linked extends AbstractBlackBoxCodegenTestSpec {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInLinked() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Constant_literals extends AbstractBlackBoxCodegenTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInConstant_literals() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Boolean_literals extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInBoolean_literals() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.1.kt");
                        }

                        @TestMetadata("2.10.kt")
                        public void test2_10() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.10.kt");
                        }

                        @TestMetadata("2.11.kt")
                        public void test2_11() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.11.kt");
                        }

                        @TestMetadata("2.12.kt")
                        public void test2_12() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.12.kt");
                        }

                        @TestMetadata("2.13.kt")
                        public void test2_13() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.13.kt");
                        }

                        @TestMetadata("2.14.kt")
                        public void test2_14() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.14.kt");
                        }

                        @TestMetadata("2.15.kt")
                        public void test2_15() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.15.kt");
                        }

                        @TestMetadata("2.16.kt")
                        public void test2_16() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.16.kt");
                        }

                        @TestMetadata("2.17.kt")
                        public void test2_17() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.17.kt");
                        }

                        @TestMetadata("2.18.kt")
                        public void test2_18() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.18.kt");
                        }

                        @TestMetadata("2.19.kt")
                        public void test2_19() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.19.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.2.kt");
                        }

                        @TestMetadata("2.20.kt")
                        public void test2_20() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.20.kt");
                        }

                        @TestMetadata("2.21.kt")
                        public void test2_21() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.21.kt");
                        }

                        @TestMetadata("2.22.kt")
                        public void test2_22() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.22.kt");
                        }

                        @TestMetadata("2.23.kt")
                        public void test2_23() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.23.kt");
                        }

                        @TestMetadata("2.24.kt")
                        public void test2_24() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.24.kt");
                        }

                        @TestMetadata("2.25.kt")
                        public void test2_25() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.25.kt");
                        }

                        @TestMetadata("2.26.kt")
                        public void test2_26() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.26.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.3.kt");
                        }

                        @TestMetadata("2.4.kt")
                        public void test2_4() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.4.kt");
                        }

                        @TestMetadata("2.5.kt")
                        public void test2_5() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.5.kt");
                        }

                        @TestMetadata("2.6.kt")
                        public void test2_6() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.6.kt");
                        }

                        @TestMetadata("2.7.kt")
                        public void test2_7() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.7.kt");
                        }

                        @TestMetadata("2.8.kt")
                        public void test2_8() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.8.kt");
                        }

                        @TestMetadata("2.9.kt")
                        public void test2_9() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos/2.9.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/boolean-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Integer_literals extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInteger_literals() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/binary-integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Binary_integer_literals extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInBinary_integer_literals() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/binary-integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/binary-integer-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/binary-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/binary-integer-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/binary-integer-literals/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/binary-integer-literals/p-1/pos/2.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/binary-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/decimal-integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Decimal_integer_literals extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInDecimal_integer_literals() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/decimal-integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/decimal-integer-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/decimal-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/pos/2.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/decimal-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/hexadecimal-integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Hexadecimal_integer_literals extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInHexadecimal_integer_literals() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/hexadecimal-integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("2.1.kt")
                            public void test2_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos/2.1.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/hexadecimal-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/long-integer-literals")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Long_integer_literals extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInLong_integer_literals() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/long-integer-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/long-integer-literals/p-1")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        public void testAllFilesPresentInP_1() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/long-integer-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }

                        @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos")
                        @TestDataPath("$PROJECT_ROOT")
                        @RunWith(JUnit3RunnerWithInners.class)
                        public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                            private void runTest(String testDataFilePath) throws Exception {
                                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                            }

                            @TestMetadata("1.1.kt")
                            public void test1_1() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/1.1.kt");
                            }

                            @TestMetadata("1.2.kt")
                            public void test1_2() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/1.2.kt");
                            }

                            @TestMetadata("1.3.kt")
                            public void test1_3() throws Exception {
                                runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos/1.3.kt");
                            }

                            public void testAllFilesPresentInPos() throws Exception {
                                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/integer-literals/long-integer-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                            }
                        }
                    }
                }
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Real_literals extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInReal_literals() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-1")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_1 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_1() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-1"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-1/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-1/pos/1.1.kt");
                        }

                        @TestMetadata("3.1.kt")
                        public void test3_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-1/pos/3.1.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-1/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-2")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_2 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_2() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-2"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-2/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-2/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-2/pos/1.2.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-2/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-3")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_3 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_3() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-3"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-3/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-3/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-3/pos/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-3/pos/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-3/pos/1.4.kt");
                        }

                        @TestMetadata("2.1.kt")
                        public void test2_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-3/pos/2.1.kt");
                        }

                        @TestMetadata("2.2.kt")
                        public void test2_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-3/pos/2.2.kt");
                        }

                        @TestMetadata("2.3.kt")
                        public void test2_3() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-3/pos/2.3.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-3/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-4")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class P_4 extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    public void testAllFilesPresentInP_4() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-4"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }

                    @TestMetadata("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-4/pos")
                    @TestDataPath("$PROJECT_ROOT")
                    @RunWith(JUnit3RunnerWithInners.class)
                    public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                        private void runTest(String testDataFilePath) throws Exception {
                            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                        }

                        @TestMetadata("1.1.kt")
                        public void test1_1() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-4/pos/1.1.kt");
                        }

                        @TestMetadata("1.2.kt")
                        public void test1_2() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-4/pos/1.2.kt");
                        }

                        @TestMetadata("1.3.kt")
                        public void test1_3() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-4/pos/1.3.kt");
                        }

                        @TestMetadata("1.4.kt")
                        public void test1_4() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-4/pos/1.4.kt");
                        }

                        @TestMetadata("1.5.kt")
                        public void test1_5() throws Exception {
                            runTest("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-4/pos/1.5.kt");
                        }

                        public void testAllFilesPresentInPos() throws Exception {
                            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/linked/constant-literals/real-literals/p-4/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                        }
                    }
                }
            }
        }
    }

    @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked")
    @TestDataPath("$PROJECT_ROOT")
    @RunWith(JUnit3RunnerWithInners.class)
    public static class NotLinked extends AbstractBlackBoxCodegenTestSpec {
        private void runTest(String testDataFilePath) throws Exception {
            KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
        }

        public void testAllFilesPresentInNotLinked() throws Exception {
            KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
        }

        @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked/annotations")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Annotations extends AbstractBlackBoxCodegenTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInAnnotations() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked/annotations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Type_annotations extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInType_annotations() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.kt")
                    public void test1() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations/neg/1.kt");
                    }

                    @TestMetadata("10.kt")
                    public void test10() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations/neg/10.kt");
                    }

                    @TestMetadata("11.kt")
                    public void test11() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations/neg/11.kt");
                    }

                    @TestMetadata("2.kt")
                    public void test2() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations/neg/2.kt");
                    }

                    @TestMetadata("3.kt")
                    public void test3() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations/neg/3.kt");
                    }

                    @TestMetadata("4.kt")
                    public void test4() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations/neg/4.kt");
                    }

                    @TestMetadata("5.kt")
                    public void test5() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations/neg/5.kt");
                    }

                    @TestMetadata("6.kt")
                    public void test6() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations/neg/6.kt");
                    }

                    @TestMetadata("7.kt")
                    public void test7() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations/neg/7.kt");
                    }

                    @TestMetadata("8.kt")
                    public void test8() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations/neg/8.kt");
                    }

                    @TestMetadata("9.kt")
                    public void test9() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations/neg/9.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked/annotations/type-annotations/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }
        }

        @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked/objects")
        @TestDataPath("$PROJECT_ROOT")
        @RunWith(JUnit3RunnerWithInners.class)
        public static class Objects extends AbstractBlackBoxCodegenTestSpec {
            private void runTest(String testDataFilePath) throws Exception {
                KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
            }

            public void testAllFilesPresentInObjects() throws Exception {
                KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked/objects"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
            }

            @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance")
            @TestDataPath("$PROJECT_ROOT")
            @RunWith(JUnit3RunnerWithInners.class)
            public static class Inheritance extends AbstractBlackBoxCodegenTestSpec {
                private void runTest(String testDataFilePath) throws Exception {
                    KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                }

                public void testAllFilesPresentInInheritance() throws Exception {
                    KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Neg extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.kt")
                    public void test1() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/1.kt");
                    }

                    @TestMetadata("10.kt")
                    public void test10() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/10.kt");
                    }

                    @TestMetadata("11.kt")
                    public void test11() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/11.kt");
                    }

                    @TestMetadata("12.kt")
                    public void test12() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/12.kt");
                    }

                    @TestMetadata("13.kt")
                    public void test13() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/13.kt");
                    }

                    @TestMetadata("14.kt")
                    public void test14() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/14.kt");
                    }

                    @TestMetadata("15.kt")
                    public void test15() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/15.kt");
                    }

                    @TestMetadata("16.kt")
                    public void test16() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/16.kt");
                    }

                    @TestMetadata("17.kt")
                    public void test17() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/17.kt");
                    }

                    @TestMetadata("18.kt")
                    public void test18() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/18.kt");
                    }

                    @TestMetadata("19.kt")
                    public void test19() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/19.kt");
                    }

                    @TestMetadata("2.kt")
                    public void test2() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/2.kt");
                    }

                    @TestMetadata("3.kt")
                    public void test3() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/3.kt");
                    }

                    @TestMetadata("4.kt")
                    public void test4() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/4.kt");
                    }

                    @TestMetadata("5.kt")
                    public void test5() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/5.kt");
                    }

                    @TestMetadata("6.kt")
                    public void test6() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/6.kt");
                    }

                    @TestMetadata("7.kt")
                    public void test7() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/7.kt");
                    }

                    @TestMetadata("8.kt")
                    public void test8() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/8.kt");
                    }

                    @TestMetadata("9.kt")
                    public void test9() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg/9.kt");
                    }

                    public void testAllFilesPresentInNeg() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/neg"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }

                @TestMetadata("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/pos")
                @TestDataPath("$PROJECT_ROOT")
                @RunWith(JUnit3RunnerWithInners.class)
                public static class Pos extends AbstractBlackBoxCodegenTestSpec {
                    private void runTest(String testDataFilePath) throws Exception {
                        KotlinTestUtils.runTest(this::doTest, TargetBackend.ANY, testDataFilePath);
                    }

                    @TestMetadata("1.kt")
                    public void test1() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/pos/1.kt");
                    }

                    @TestMetadata("2.kt")
                    public void test2() throws Exception {
                        runTest("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/pos/2.kt");
                    }

                    public void testAllFilesPresentInPos() throws Exception {
                        KotlinTestUtils.assertAllTestsPresentByMetadata(this.getClass(), new File("compiler/tests-spec/testData/codegen/box/notLinked/objects/inheritance/pos"), Pattern.compile("^(.+)\\.kt$"), TargetBackend.ANY, true);
                    }
                }
            }
        }
    }
}
