
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2019 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCameraControl.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QCameraControl>
#include <QChildEvent>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include "gsiDeclQtMultimediaTypeTraits.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCameraControl

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCameraControl::staticMetaObject);
}


// bool QCameraControl::canChangeProperty(QCameraControl::PropertyChangeType changeType, QCamera::Status status)


static void _init_f_canChangeProperty_c5578 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("changeType");
  decl->add_arg<const qt_gsi::Converter<QCameraControl::PropertyChangeType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("status");
  decl->add_arg<const qt_gsi::Converter<QCamera::Status>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_canChangeProperty_c5578 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraControl::PropertyChangeType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCameraControl::PropertyChangeType>::target_type & >() (args, heap);
  const qt_gsi::Converter<QCamera::Status>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QCamera::Status>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QCameraControl *)cls)->canChangeProperty (qt_gsi::QtToCppAdaptor<QCameraControl::PropertyChangeType>(arg1).cref(), qt_gsi::QtToCppAdaptor<QCamera::Status>(arg2).cref()));
}


// QFlags<QCamera::CaptureMode> QCameraControl::captureMode()


static void _init_f_captureMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QCamera::CaptureMode> > ();
}

static void _call_f_captureMode_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QCamera::CaptureMode> > ((QFlags<QCamera::CaptureMode>)((QCameraControl *)cls)->captureMode ());
}


// bool QCameraControl::isCaptureModeSupported(QFlags<QCamera::CaptureMode> mode)


static void _init_f_isCaptureModeSupported_c3027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<QFlags<QCamera::CaptureMode> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isCaptureModeSupported_c3027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCamera::CaptureMode> arg1 = gsi::arg_reader<QFlags<QCamera::CaptureMode> >() (args, heap);
  ret.write<bool > ((bool)((QCameraControl *)cls)->isCaptureModeSupported (arg1));
}


// void QCameraControl::setCaptureMode(QFlags<QCamera::CaptureMode>)


static void _init_f_setCaptureMode_3027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFlags<QCamera::CaptureMode> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCaptureMode_3027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCamera::CaptureMode> arg1 = gsi::arg_reader<QFlags<QCamera::CaptureMode> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraControl *)cls)->setCaptureMode (arg1);
}


// void QCameraControl::setState(QCamera::State state)


static void _init_f_setState_1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<QCamera::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setState_1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::State>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraControl *)cls)->setState (qt_gsi::QtToCppAdaptor<QCamera::State>(arg1).cref());
}


// QCamera::State QCameraControl::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCamera::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCamera::State>::target_type > ((qt_gsi::Converter<QCamera::State>::target_type)qt_gsi::CppToQtAdaptor<QCamera::State>(((QCameraControl *)cls)->state ()));
}


// QCamera::Status QCameraControl::status()


static void _init_f_status_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCamera::Status>::target_type > ();
}

static void _call_f_status_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCamera::Status>::target_type > ((qt_gsi::Converter<QCamera::Status>::target_type)qt_gsi::CppToQtAdaptor<QCamera::Status>(((QCameraControl *)cls)->status ()));
}


// static QString QCameraControl::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraControl::tr (arg1, arg2, arg3));
}


// static QString QCameraControl::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "__null");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (__null, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QCameraControl::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QCameraControl () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("canChangeProperty", "@brief Method bool QCameraControl::canChangeProperty(QCameraControl::PropertyChangeType changeType, QCamera::Status status)\n", true, &_init_f_canChangeProperty_c5578, &_call_f_canChangeProperty_c5578);
  methods += new qt_gsi::GenericMethod (":captureMode", "@brief Method QFlags<QCamera::CaptureMode> QCameraControl::captureMode()\n", true, &_init_f_captureMode_c0, &_call_f_captureMode_c0);
  methods += new qt_gsi::GenericMethod ("isCaptureModeSupported?", "@brief Method bool QCameraControl::isCaptureModeSupported(QFlags<QCamera::CaptureMode> mode)\n", true, &_init_f_isCaptureModeSupported_c3027, &_call_f_isCaptureModeSupported_c3027);
  methods += new qt_gsi::GenericMethod ("setCaptureMode|captureMode=", "@brief Method void QCameraControl::setCaptureMode(QFlags<QCamera::CaptureMode>)\n", false, &_init_f_setCaptureMode_3027, &_call_f_setCaptureMode_3027);
  methods += new qt_gsi::GenericMethod ("setState|state=", "@brief Method void QCameraControl::setState(QCamera::State state)\n", false, &_init_f_setState_1731, &_call_f_setState_1731);
  methods += new qt_gsi::GenericMethod (":state", "@brief Method QCamera::State QCameraControl::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("status", "@brief Method QCamera::Status QCameraControl::status()\n", true, &_init_f_status_c0, &_call_f_status_c0);
  methods += gsi::qt_signal<QFlags<QCamera::CaptureMode> > ("captureModeChanged(QFlags<QCamera::CaptureMode>)", "captureModeChanged", gsi::arg("arg1"), "@brief Signal declaration for QCameraControl::captureModeChanged(QFlags<QCamera::CaptureMode>)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QCameraControl::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<int, const QString & > ("error(int, const QString &)", "error", gsi::arg("error"), gsi::arg("errorString"), "@brief Signal declaration for QCameraControl::error(int error, const QString &errorString)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QCamera::State>::target_type & > ("stateChanged(QCamera::State)", "stateChanged", gsi::arg("arg1"), "@brief Signal declaration for QCameraControl::stateChanged(QCamera::State)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QCamera::Status>::target_type & > ("statusChanged(QCamera::Status)", "statusChanged", gsi::arg("arg1"), "@brief Signal declaration for QCameraControl::statusChanged(QCamera::Status)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCameraControl::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCameraControl::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QMediaControl> &qtdecl_QMediaControl ();

qt_gsi::QtNativeClass<QCameraControl> decl_QCameraControl (qtdecl_QMediaControl (), "QtMultimedia", "QCameraControl_Native",
  methods_QCameraControl (),
  "@hide\n@alias QCameraControl");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QCameraControl> &qtdecl_QCameraControl () { return decl_QCameraControl; }

}


class QCameraControl_Adaptor : public QCameraControl, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCameraControl_Adaptor();

  //  [adaptor ctor] QCameraControl::QCameraControl()
  QCameraControl_Adaptor() : QCameraControl()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QCameraControl::isSignalConnected(const QMetaMethod &signal)
  bool fp_QCameraControl_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QCameraControl::isSignalConnected(signal);
  }

  //  [expose] int QCameraControl::receivers(const char *signal)
  int fp_QCameraControl_receivers_c1731 (const char *signal) const {
    return QCameraControl::receivers(signal);
  }

  //  [expose] QObject *QCameraControl::sender()
  QObject * fp_QCameraControl_sender_c0 () const {
    return QCameraControl::sender();
  }

  //  [expose] int QCameraControl::senderSignalIndex()
  int fp_QCameraControl_senderSignalIndex_c0 () const {
    return QCameraControl::senderSignalIndex();
  }

  //  [adaptor impl] bool QCameraControl::canChangeProperty(QCameraControl::PropertyChangeType changeType, QCamera::Status status)
  bool cbs_canChangeProperty_c5578_0(const qt_gsi::Converter<QCameraControl::PropertyChangeType>::target_type & changeType, const qt_gsi::Converter<QCamera::Status>::target_type & status) const
  {
    __SUPPRESS_UNUSED_WARNING (changeType);
    __SUPPRESS_UNUSED_WARNING (status);
    throw qt_gsi::AbstractMethodCalledException("canChangeProperty");
  }

  virtual bool canChangeProperty(QCameraControl::PropertyChangeType changeType, QCamera::Status status) const
  {
    if (cb_canChangeProperty_c5578_0.can_issue()) {
      return cb_canChangeProperty_c5578_0.issue<QCameraControl_Adaptor, bool, const qt_gsi::Converter<QCameraControl::PropertyChangeType>::target_type &, const qt_gsi::Converter<QCamera::Status>::target_type &>(&QCameraControl_Adaptor::cbs_canChangeProperty_c5578_0, qt_gsi::CppToQtAdaptor<QCameraControl::PropertyChangeType>(changeType), qt_gsi::CppToQtAdaptor<QCamera::Status>(status));
    } else {
      throw qt_gsi::AbstractMethodCalledException("canChangeProperty");
    }
  }

  //  [adaptor impl] QFlags<QCamera::CaptureMode> QCameraControl::captureMode()
  QFlags<QCamera::CaptureMode> cbs_captureMode_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("captureMode");
  }

  virtual QFlags<QCamera::CaptureMode> captureMode() const
  {
    if (cb_captureMode_c0_0.can_issue()) {
      return cb_captureMode_c0_0.issue<QCameraControl_Adaptor, QFlags<QCamera::CaptureMode> >(&QCameraControl_Adaptor::cbs_captureMode_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("captureMode");
    }
  }

  //  [emitter impl] void QCameraControl::captureModeChanged(QFlags<QCamera::CaptureMode>)
  void emitter_QCameraControl_captureModeChanged_3027(QFlags<QCamera::CaptureMode> arg1)
  {
    emit QCameraControl::captureModeChanged(arg1);
  }

  //  [emitter impl] void QCameraControl::destroyed(QObject *)
  void emitter_QCameraControl_destroyed_1302(QObject *arg1)
  {
    emit QCameraControl::destroyed(arg1);
  }

  //  [emitter impl] void QCameraControl::error(int error, const QString &errorString)
  void emitter_QCameraControl_error_2684(int _error, const QString &errorString)
  {
    emit QCameraControl::error(_error, errorString);
  }

  //  [adaptor impl] bool QCameraControl::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QCameraControl::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCameraControl_Adaptor, bool, QEvent *>(&QCameraControl_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QCameraControl::event(arg1);
    }
  }

  //  [adaptor impl] bool QCameraControl::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QCameraControl::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCameraControl_Adaptor, bool, QObject *, QEvent *>(&QCameraControl_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QCameraControl::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QCameraControl::isCaptureModeSupported(QFlags<QCamera::CaptureMode> mode)
  bool cbs_isCaptureModeSupported_c3027_0(QFlags<QCamera::CaptureMode> mode) const
  {
    __SUPPRESS_UNUSED_WARNING (mode);
    throw qt_gsi::AbstractMethodCalledException("isCaptureModeSupported");
  }

  virtual bool isCaptureModeSupported(QFlags<QCamera::CaptureMode> mode) const
  {
    if (cb_isCaptureModeSupported_c3027_0.can_issue()) {
      return cb_isCaptureModeSupported_c3027_0.issue<QCameraControl_Adaptor, bool, QFlags<QCamera::CaptureMode> >(&QCameraControl_Adaptor::cbs_isCaptureModeSupported_c3027_0, mode);
    } else {
      throw qt_gsi::AbstractMethodCalledException("isCaptureModeSupported");
    }
  }

  //  [adaptor impl] void QCameraControl::setCaptureMode(QFlags<QCamera::CaptureMode>)
  void cbs_setCaptureMode_3027_0(QFlags<QCamera::CaptureMode> arg1)
  {
    __SUPPRESS_UNUSED_WARNING (arg1);
    throw qt_gsi::AbstractMethodCalledException("setCaptureMode");
  }

  virtual void setCaptureMode(QFlags<QCamera::CaptureMode> arg1)
  {
    if (cb_setCaptureMode_3027_0.can_issue()) {
      cb_setCaptureMode_3027_0.issue<QCameraControl_Adaptor, QFlags<QCamera::CaptureMode> >(&QCameraControl_Adaptor::cbs_setCaptureMode_3027_0, arg1);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setCaptureMode");
    }
  }

  //  [adaptor impl] void QCameraControl::setState(QCamera::State state)
  void cbs_setState_1731_0(const qt_gsi::Converter<QCamera::State>::target_type & state)
  {
    __SUPPRESS_UNUSED_WARNING (state);
    throw qt_gsi::AbstractMethodCalledException("setState");
  }

  virtual void setState(QCamera::State state)
  {
    if (cb_setState_1731_0.can_issue()) {
      cb_setState_1731_0.issue<QCameraControl_Adaptor, const qt_gsi::Converter<QCamera::State>::target_type &>(&QCameraControl_Adaptor::cbs_setState_1731_0, qt_gsi::CppToQtAdaptor<QCamera::State>(state));
    } else {
      throw qt_gsi::AbstractMethodCalledException("setState");
    }
  }

  //  [adaptor impl] QCamera::State QCameraControl::state()
  qt_gsi::Converter<QCamera::State>::target_type cbs_state_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("state");
  }

  virtual QCamera::State state() const
  {
    if (cb_state_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QCamera::State>(cb_state_c0_0.issue<QCameraControl_Adaptor, qt_gsi::Converter<QCamera::State>::target_type>(&QCameraControl_Adaptor::cbs_state_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("state");
    }
  }

  //  [emitter impl] void QCameraControl::stateChanged(QCamera::State)
  void emitter_QCameraControl_stateChanged_1731(QCamera::State arg1)
  {
    emit QCameraControl::stateChanged(arg1);
  }

  //  [adaptor impl] QCamera::Status QCameraControl::status()
  qt_gsi::Converter<QCamera::Status>::target_type cbs_status_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("status");
  }

  virtual QCamera::Status status() const
  {
    if (cb_status_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QCamera::Status>(cb_status_c0_0.issue<QCameraControl_Adaptor, qt_gsi::Converter<QCamera::Status>::target_type>(&QCameraControl_Adaptor::cbs_status_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("status");
    }
  }

  //  [emitter impl] void QCameraControl::statusChanged(QCamera::Status)
  void emitter_QCameraControl_statusChanged_1862(QCamera::Status arg1)
  {
    emit QCameraControl::statusChanged(arg1);
  }

  //  [adaptor impl] void QCameraControl::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCameraControl::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCameraControl_Adaptor, QChildEvent *>(&QCameraControl_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCameraControl::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCameraControl::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCameraControl::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCameraControl_Adaptor, QEvent *>(&QCameraControl_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCameraControl::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QCameraControl::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QCameraControl::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QCameraControl_Adaptor, const QMetaMethod &>(&QCameraControl_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QCameraControl::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCameraControl::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QCameraControl::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCameraControl_Adaptor, QTimerEvent *>(&QCameraControl_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QCameraControl::timerEvent(arg1);
    }
  }

  gsi::Callback cb_canChangeProperty_c5578_0;
  gsi::Callback cb_captureMode_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_isCaptureModeSupported_c3027_0;
  gsi::Callback cb_setCaptureMode_3027_0;
  gsi::Callback cb_setState_1731_0;
  gsi::Callback cb_state_c0_0;
  gsi::Callback cb_status_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QCameraControl_Adaptor::~QCameraControl_Adaptor() { }

//  Constructor QCameraControl::QCameraControl() (adaptor class)

static void _init_ctor_QCameraControl_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QCameraControl_Adaptor> ();
}

static void _call_ctor_QCameraControl_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QCameraControl_Adaptor *> (new QCameraControl_Adaptor ());
}


// bool QCameraControl::canChangeProperty(QCameraControl::PropertyChangeType changeType, QCamera::Status status)

static void _init_cbs_canChangeProperty_c5578_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("changeType");
  decl->add_arg<const qt_gsi::Converter<QCameraControl::PropertyChangeType>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("status");
  decl->add_arg<const qt_gsi::Converter<QCamera::Status>::target_type & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_canChangeProperty_c5578_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCameraControl::PropertyChangeType>::target_type & arg1 = args.read<const qt_gsi::Converter<QCameraControl::PropertyChangeType>::target_type & > (heap);
  const qt_gsi::Converter<QCamera::Status>::target_type & arg2 = args.read<const qt_gsi::Converter<QCamera::Status>::target_type & > (heap);
  ret.write<bool > ((bool)((QCameraControl_Adaptor *)cls)->cbs_canChangeProperty_c5578_0 (arg1, arg2));
}

static void _set_callback_cbs_canChangeProperty_c5578_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraControl_Adaptor *)cls)->cb_canChangeProperty_c5578_0 = cb;
}


// QFlags<QCamera::CaptureMode> QCameraControl::captureMode()

static void _init_cbs_captureMode_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QCamera::CaptureMode> > ();
}

static void _call_cbs_captureMode_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QCamera::CaptureMode> > ((QFlags<QCamera::CaptureMode>)((QCameraControl_Adaptor *)cls)->cbs_captureMode_c0_0 ());
}

static void _set_callback_cbs_captureMode_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraControl_Adaptor *)cls)->cb_captureMode_c0_0 = cb;
}


// emitter void QCameraControl::captureModeChanged(QFlags<QCamera::CaptureMode>)

static void _init_emitter_captureModeChanged_3027 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFlags<QCamera::CaptureMode> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_captureModeChanged_3027 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCamera::CaptureMode> arg1 = gsi::arg_reader<QFlags<QCamera::CaptureMode> >() (args, heap);
  ((QCameraControl_Adaptor *)cls)->emitter_QCameraControl_captureModeChanged_3027 (arg1);
}


// void QCameraControl::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraControl_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraControl_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QCameraControl::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraControl_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraControl_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QCameraControl::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QCameraControl_Adaptor *)cls)->emitter_QCameraControl_destroyed_1302 (arg1);
}


// void QCameraControl::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraControl_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraControl_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// emitter void QCameraControl::error(int error, const QString &errorString)

static void _init_emitter_error_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("error");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("errorString");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_error_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  ((QCameraControl_Adaptor *)cls)->emitter_QCameraControl_error_2684 (arg1, arg2);
}


// bool QCameraControl::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraControl_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraControl_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QCameraControl::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QCameraControl_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraControl_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QCameraControl::isCaptureModeSupported(QFlags<QCamera::CaptureMode> mode)

static void _init_cbs_isCaptureModeSupported_c3027_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<QFlags<QCamera::CaptureMode> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_isCaptureModeSupported_c3027_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCamera::CaptureMode> arg1 = args.read<QFlags<QCamera::CaptureMode> > (heap);
  ret.write<bool > ((bool)((QCameraControl_Adaptor *)cls)->cbs_isCaptureModeSupported_c3027_0 (arg1));
}

static void _set_callback_cbs_isCaptureModeSupported_c3027_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraControl_Adaptor *)cls)->cb_isCaptureModeSupported_c3027_0 = cb;
}


// exposed bool QCameraControl::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QCameraControl_Adaptor *)cls)->fp_QCameraControl_isSignalConnected_c2394 (arg1));
}


// exposed int QCameraControl::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QCameraControl_Adaptor *)cls)->fp_QCameraControl_receivers_c1731 (arg1));
}


// exposed QObject *QCameraControl::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QCameraControl_Adaptor *)cls)->fp_QCameraControl_sender_c0 ());
}


// exposed int QCameraControl::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QCameraControl_Adaptor *)cls)->fp_QCameraControl_senderSignalIndex_c0 ());
}


// void QCameraControl::setCaptureMode(QFlags<QCamera::CaptureMode>)

static void _init_cbs_setCaptureMode_3027_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFlags<QCamera::CaptureMode> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setCaptureMode_3027_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QCamera::CaptureMode> arg1 = args.read<QFlags<QCamera::CaptureMode> > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraControl_Adaptor *)cls)->cbs_setCaptureMode_3027_0 (arg1);
}

static void _set_callback_cbs_setCaptureMode_3027_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraControl_Adaptor *)cls)->cb_setCaptureMode_3027_0 = cb;
}


// void QCameraControl::setState(QCamera::State state)

static void _init_cbs_setState_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("state");
  decl->add_arg<const qt_gsi::Converter<QCamera::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setState_1731_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::State>::target_type & arg1 = args.read<const qt_gsi::Converter<QCamera::State>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraControl_Adaptor *)cls)->cbs_setState_1731_0 (arg1);
}

static void _set_callback_cbs_setState_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraControl_Adaptor *)cls)->cb_setState_1731_0 = cb;
}


// QCamera::State QCameraControl::state()

static void _init_cbs_state_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCamera::State>::target_type > ();
}

static void _call_cbs_state_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCamera::State>::target_type > ((qt_gsi::Converter<QCamera::State>::target_type)((QCameraControl_Adaptor *)cls)->cbs_state_c0_0 ());
}

static void _set_callback_cbs_state_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraControl_Adaptor *)cls)->cb_state_c0_0 = cb;
}


// emitter void QCameraControl::stateChanged(QCamera::State)

static void _init_emitter_stateChanged_1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCamera::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_stateChanged_1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::State>::target_type & >() (args, heap);
  ((QCameraControl_Adaptor *)cls)->emitter_QCameraControl_stateChanged_1731 (arg1);
}


// QCamera::Status QCameraControl::status()

static void _init_cbs_status_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCamera::Status>::target_type > ();
}

static void _call_cbs_status_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QCamera::Status>::target_type > ((qt_gsi::Converter<QCamera::Status>::target_type)((QCameraControl_Adaptor *)cls)->cbs_status_c0_0 ());
}

static void _set_callback_cbs_status_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraControl_Adaptor *)cls)->cb_status_c0_0 = cb;
}


// emitter void QCameraControl::statusChanged(QCamera::Status)

static void _init_emitter_statusChanged_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QCamera::Status>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_statusChanged_1862 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QCamera::Status>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QCamera::Status>::target_type & >() (args, heap);
  ((QCameraControl_Adaptor *)cls)->emitter_QCameraControl_statusChanged_1862 (arg1);
}


// void QCameraControl::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QCameraControl_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCameraControl_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QCameraControl> &qtdecl_QCameraControl ();

static gsi::Methods methods_QCameraControl_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCameraControl::QCameraControl()\nThis method creates an object of class QCameraControl.", &_init_ctor_QCameraControl_Adaptor_0, &_call_ctor_QCameraControl_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("canChangeProperty", "@hide", true, &_init_cbs_canChangeProperty_c5578_0, &_call_cbs_canChangeProperty_c5578_0);
  methods += new qt_gsi::GenericMethod ("canChangeProperty", "@brief Virtual method bool QCameraControl::canChangeProperty(QCameraControl::PropertyChangeType changeType, QCamera::Status status)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canChangeProperty_c5578_0, &_call_cbs_canChangeProperty_c5578_0, &_set_callback_cbs_canChangeProperty_c5578_0);
  methods += new qt_gsi::GenericMethod ("captureMode", "@hide", true, &_init_cbs_captureMode_c0_0, &_call_cbs_captureMode_c0_0);
  methods += new qt_gsi::GenericMethod ("captureMode", "@brief Virtual method QFlags<QCamera::CaptureMode> QCameraControl::captureMode()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_captureMode_c0_0, &_call_cbs_captureMode_c0_0, &_set_callback_cbs_captureMode_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_captureModeChanged", "@brief Emitter for signal void QCameraControl::captureModeChanged(QFlags<QCamera::CaptureMode>)\nCall this method to emit this signal.", false, &_init_emitter_captureModeChanged_3027, &_call_emitter_captureModeChanged_3027);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCameraControl::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCameraControl::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QCameraControl::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCameraControl::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("emit_error", "@brief Emitter for signal void QCameraControl::error(int error, const QString &errorString)\nCall this method to emit this signal.", false, &_init_emitter_error_2684, &_call_emitter_error_2684);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QCameraControl::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QCameraControl::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("isCaptureModeSupported", "@hide", true, &_init_cbs_isCaptureModeSupported_c3027_0, &_call_cbs_isCaptureModeSupported_c3027_0);
  methods += new qt_gsi::GenericMethod ("isCaptureModeSupported", "@brief Virtual method bool QCameraControl::isCaptureModeSupported(QFlags<QCamera::CaptureMode> mode)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isCaptureModeSupported_c3027_0, &_call_cbs_isCaptureModeSupported_c3027_0, &_set_callback_cbs_isCaptureModeSupported_c3027_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QCameraControl::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QCameraControl::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QCameraControl::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QCameraControl::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setCaptureMode", "@hide", false, &_init_cbs_setCaptureMode_3027_0, &_call_cbs_setCaptureMode_3027_0);
  methods += new qt_gsi::GenericMethod ("setCaptureMode", "@brief Virtual method void QCameraControl::setCaptureMode(QFlags<QCamera::CaptureMode>)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setCaptureMode_3027_0, &_call_cbs_setCaptureMode_3027_0, &_set_callback_cbs_setCaptureMode_3027_0);
  methods += new qt_gsi::GenericMethod ("setState", "@hide", false, &_init_cbs_setState_1731_0, &_call_cbs_setState_1731_0);
  methods += new qt_gsi::GenericMethod ("setState", "@brief Virtual method void QCameraControl::setState(QCamera::State state)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setState_1731_0, &_call_cbs_setState_1731_0, &_set_callback_cbs_setState_1731_0);
  methods += new qt_gsi::GenericMethod ("state", "@hide", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Virtual method QCamera::State QCameraControl::state()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0, &_set_callback_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_stateChanged", "@brief Emitter for signal void QCameraControl::stateChanged(QCamera::State)\nCall this method to emit this signal.", false, &_init_emitter_stateChanged_1731, &_call_emitter_stateChanged_1731);
  methods += new qt_gsi::GenericMethod ("status", "@hide", true, &_init_cbs_status_c0_0, &_call_cbs_status_c0_0);
  methods += new qt_gsi::GenericMethod ("status", "@brief Virtual method QCamera::Status QCameraControl::status()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_status_c0_0, &_call_cbs_status_c0_0, &_set_callback_cbs_status_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_statusChanged", "@brief Emitter for signal void QCameraControl::statusChanged(QCamera::Status)\nCall this method to emit this signal.", false, &_init_emitter_statusChanged_1862, &_call_emitter_statusChanged_1862);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCameraControl::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QCameraControl_Adaptor> decl_QCameraControl_Adaptor (qtdecl_QCameraControl (), "QtMultimedia", "QCameraControl",
  methods_QCameraControl_Adaptor (),
  "@qt\n@brief Binding of QCameraControl");

}


//  Implementation of the enum wrapper class for QCameraControl::PropertyChangeType
namespace qt_gsi
{

static gsi::Enum<QCameraControl::PropertyChangeType> decl_QCameraControl_PropertyChangeType_Enum ("QtMultimedia", "QCameraControl_PropertyChangeType",
    gsi::enum_const ("CaptureMode", QCameraControl::CaptureMode, "@brief Enum constant QCameraControl::CaptureMode") +
    gsi::enum_const ("ImageEncodingSettings", QCameraControl::ImageEncodingSettings, "@brief Enum constant QCameraControl::ImageEncodingSettings") +
    gsi::enum_const ("VideoEncodingSettings", QCameraControl::VideoEncodingSettings, "@brief Enum constant QCameraControl::VideoEncodingSettings") +
    gsi::enum_const ("Viewfinder", QCameraControl::Viewfinder, "@brief Enum constant QCameraControl::Viewfinder") +
    gsi::enum_const ("ViewfinderSettings", QCameraControl::ViewfinderSettings, "@brief Enum constant QCameraControl::ViewfinderSettings"),
  "@qt\n@brief This class represents the QCameraControl::PropertyChangeType enum");

static gsi::QFlagsClass<QCameraControl::PropertyChangeType > decl_QCameraControl_PropertyChangeType_Enums ("QtMultimedia", "QCameraControl_QFlags_PropertyChangeType",
  "@qt\n@brief This class represents the QFlags<QCameraControl::PropertyChangeType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QCameraControl> inject_QCameraControl_PropertyChangeType_Enum_in_parent (decl_QCameraControl_PropertyChangeType_Enum.defs ());
static gsi::ClassExt<QCameraControl> decl_QCameraControl_PropertyChangeType_Enum_as_child (decl_QCameraControl_PropertyChangeType_Enum, "PropertyChangeType");
static gsi::ClassExt<QCameraControl> decl_QCameraControl_PropertyChangeType_Enums_as_child (decl_QCameraControl_PropertyChangeType_Enums, "QFlags_PropertyChangeType");

}

