//---------------------------------------------------------------------------
//
// KOSUI -- Kawari cOnSole Use Interpritor --
//  -- 󥽡ǲ󥿡ץ꥿ --
//
//      Programed by NAKAUE.T (Meister)
//
//  2001.05.30  Phase 5.1     󥽡륤󥿡ץ꥿
//  2001.08.06  Phase 6.2     KawariDebugger˹碌ƥǥեȤecho-mode
//  2001.08.12  Phase 6.2.1   KawariDebugger
//  2002.01.08  ֳ          NothingIsDone
//  2002.03.12  Phase 7.9.0   AttachϤνΤޤХ
//  2002.04.12  Phase 8.0.0   󥿡եڤľ
//  2008.01.23  Phase 8.2.5   quiet⡼ɲ
//
//---------------------------------------------------------------------------
#include "config.h"
//---------------------------------------------------------------------------
#ifdef __BORLANDC__
#	define _POSIX_
#	include <limits.h>
#endif
//---------------------------------------------------------------------------
#include <string>
#include <iostream>
#include <cstdlib>
using namespace std;
//---------------------------------------------------------------------------
#include "tool/kosui_base.h"
#include "tool/kawari_kosui.h"
#include "misc/l10n.h"
#ifdef USEKDB
#	include "tool/kdb.h"
#	include "tool/kosui_dsstp.h"
#endif
#if defined(KAWARI_POSIX)
#	include <unistd.h>
#	include <limits.h>
#else
#	include <direct.h>
#endif
#ifdef _MSC_VER
#define PATH_MAX _MAX_PATH
#endif
//---------------------------------------------------------------------------
// ³르Ȥ
TKawariInterface_base* AttachTarget(const string& datapath,const string& inifile,const string& event)
{
	cout << "[" << 0 << "] : " << " Interpreter mode." << endl;

	#ifdef USEKDB
		// ǥХåȤ߹
		map<HWND,string> ghostname;
		GetGhostList(ghostname);

		if(ghostname.size()>0) {
			vector<HWND> ghostlist;
			map<HWND,string>::iterator it;
			for(it=ghostname.begin();it!=ghostname.end();it++) {
				ghostlist.push_back(it->first);
				cout << "[" << ghostlist.size() << "] : " << it->second << endl;
			}

			unsigned int no;
			while(true) {
				cout << "Attach : ";
				string buff;
				getline(cin,buff);
				no=atoi(buff.c_str());
				if(no<=ghostlist.size()) break;
			}

			if(no>0) return(new TKosuiDSSTPInterface(ghostlist[no-1],event));
		}
	#endif

	return(new TKawariKosuiAdapter(datapath,inifile));
}
//---------------------------------------------------------------------------
int main(int argc,char *argv[])
{
	string datapath;
	char cwd[PATH_MAX+1];
	if(NULL==getcwd(cwd, PATH_MAX+1)){
		datapath=CanonicalPath("./");
	}else{
		datapath=cwd;
		if(datapath.length()&&(datapath[datapath.length()-1]!=FILE_SEPARATOR))
			datapath+=FILE_SEPARATOR;
	}
	string inifile="kawarirc.kis";
	string event="ShioriEcho";
	bool quietmode=false;

	if(argc>1) {
		for (int i=1; i<argc; i++){
			string param=argv[i];
			if ((param=="--event")||(param=="-e")){
				if (++i<argc){
					param=argv[i];
					if (param.size())
						event=param;
				}
			}else if (param=="--norc"){
				inifile="";
			}else if (param=="--quiet"){
				quietmode=true;
			}else{
				inifile=param;
				wstring wini=ctow(inifile);
				unsigned int pos=wini.rfind((wchar_t)'/');
				if(pos==string::npos) pos=wini.rfind((wchar_t)'\\');
				if(pos!=string::npos)
					datapath=CanonicalPath(wtoc(wini.substr(0,pos+1)));
			}
		}
		if(quietmode){
			// quiet⡼(inifile¹Ԥ餹˽λ)
			TKawariInterface_base *Kawari=new TKawariKosuiAdapter(datapath,inifile);
			delete Kawari;
			return(0);
		}
	}

	cout << "K O S U I -- Kawari cOnSole Use Interpritor --" << endl;
	cout << "2001 Programed by NAKAUE.T (Meister)" << endl << endl;

	TKawariInterface_base *Kawari=AttachTarget(datapath,inifile,event);

	cout << endl;
	cout << Kawari->GetInformation() << endl << endl;

	cout << "'.' is mode change command." << endl;

	bool commode=false;
	while(true) {
		if(commode) cout << "command-mode > " << flush;
		 else cout << "echo-mode > " << flush;

		string buff;
		getline(cin,buff);
//		buff=buff.c_str();

		if(buff.size()==0) continue;

		if(buff=="exit") break;
		if(buff==".") {
			commode=!commode;
			continue;
		}

		if(commode) cout << Kawari->Parse(string("$(")+buff+")") << endl;
		 else cout << Kawari->Parse(buff) << endl;
	}

	delete Kawari;

	return(0);
}
//---------------------------------------------------------------------------

