/*=========================================================================

  Program:   Image Guided Surgery Software Toolkit
  Module:    $RCSfile: TrackingVolumeViewerQuadrantViews.h,v $
  Language:  C++
  Date:      $Date: 2009-01-30 20:48:05 $
  Version:   $Revision: 1.1 $

  Copyright (c) ISC  Insight Software Consortium.  All rights reserved.
  See IGSTKCopyright.txt or http://www.igstk.org/copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notices for more information.

=========================================================================*/

// generated by Fast Light User Interface Designer (fluid) version 1.0107

#ifndef __TrackingVolumeViewerQuadrantViews_h
#define __TrackingVolumeViewerQuadrantViews_h

#include <FL/Fl.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Tabs.H>

#include "igstkFLTKWidget.h"
#include "igstkView2D.h"
#include "igstkView3D.h"
#include "igstkEvents.h"
#include "igstkCTImageSpatialObject.h"

namespace igstk {

/** \class QuadrantViews
* 
* \brief Composite FLTK class defines the standard four viewer windows.
*
* This class provides a convenient way to define the commonly used quadrant 
* views. It has three 2D views and one 3D view. From left to right and top to 
* bottom they are: Axial, Sagittal, Coronal, and 3D.
*
*/

class TrackingVolumeViewerQuadrantViews : public Fl_Group {
public:

  TrackingVolumeViewerQuadrantViews(int X, int Y, int W, int H, const char *L = 0);

  virtual ~TrackingVolumeViewerQuadrantViews(void);

  typedef igstk::View          ViewType;
  typedef igstk::View2D        ViewType2D;
  typedef igstk::View3D        ViewType3D;

  // Declare View objects
  ViewType2D::Pointer          m_AxialView;
  ViewType2D::Pointer          m_SagittalView;
  ViewType2D::Pointer          m_CoronalView;
  ViewType3D::Pointer          m_3DView;

  // Declare FLTKWidgetNew objects
  igstk::FLTKWidget * m_AxialWidget;
  igstk::FLTKWidget * m_SagittalWidget;
  igstk::FLTKWidget * m_CoronalWidget;
  igstk::FLTKWidget * m_3DWidget;

  unsigned long AddObserver( 
    const ::itk::EventObject & event, ::itk::Command * observer );

  void RemoveObserver( unsigned long tag );
  void RemoveAllObservers();

protected:


private:

  // Call backs

  ::itk::Object::Pointer    m_Reporter;

private:

  int m_Width;
  int m_Height;
  int m_X;
  int m_Y;
  int m_WW;
  int m_HH;

};



} // end namespace igstk

#endif
