/*
 * Decompiled with CFR 0.152.
 */
package jarinstaller.gui;

import jarinstaller.gui.StepPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class RadioPanel
extends StepPanel
implements ActionListener {
    public static final int ELEMENTS_COUNT = 5;
    Hashtable gp;
    Vector radioButtonList;
    ButtonGroup buttonGroup;
    Vector lines;
    JLabel info_lab = new JLabel("");
    String info = "";

    public RadioPanel(Hashtable params) {
        this.gp = params;
        try {
            this.createElements();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createElements() throws Exception {
        this.setLayout(null);
        this.radioButtonList = new Vector();
        this.add(this.info_lab);
        this.info_lab.setBounds(23, 0, 200, 24);
        this.buttonGroup = new ButtonGroup();
        for (int i = 0; i < 5; ++i) {
            this.radioButtonList.add(this.createRadioButton(i));
        }
        this.guiRefresh();
    }

    private JRadioButton createRadioButton(int skip) {
        JRadioButton jcb = new JRadioButton("");
        this.add(jcb);
        jcb.setBounds(23, 50 + skip * 24, 250, 24);
        jcb.setSelected(true);
        jcb.setVisible(false);
        jcb.addActionListener(this);
        jcb.setActionCommand(String.valueOf(skip));
        this.buttonGroup.add(jcb);
        return jcb;
    }

    public void guiRefresh() throws Exception {
        this.setOpaque(false);
        this.setMaximumSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.setPreferredSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.setMinimumSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.setBackground((Color)this.gp.get("gui.color.bgrnd"));
        this.info_lab.setFont((Font)this.gp.get("gui.font.msg"));
        this.info_lab.setForeground((Color)this.gp.get("gui.color.title"));
        this.info_lab.setBackground((Color)this.gp.get("gui.color.bgrnd"));
        this.info_lab.setText(this.info);
        for (int i = 0; i < this.radioButtonList.size(); ++i) {
            JRadioButton btn = (JRadioButton)this.radioButtonList.elementAt(i);
            btn.setOpaque(false);
            btn.setFont((Font)this.gp.get("gui.font.msg"));
            btn.setForeground((Color)this.gp.get("gui.color.title"));
            btn.setBackground((Color)this.gp.get("gui.color.bgrnd"));
        }
        this.validate();
    }

    public boolean isActivate() {
        return true;
    }

    public void setParams(Hashtable params) {
        this.info = (String)params.get("info");
        this.info_lab.setText(this.info);
        this.lines = (Vector)params.get("parameters");
        for (int i = 0; i < this.lines.size(); ++i) {
            Hashtable ht = (Hashtable)this.lines.elementAt(i);
            JRadioButton radio = (JRadioButton)this.radioButtonList.get(i);
            if (this.gp.containsKey(ht.get("enablekey"))) {
                radio.setEnabled(true);
            } else {
                radio.setEnabled(false);
            }
            radio.setText((String)ht.get("title"));
            radio.setVisible(true);
        }
    }

    public boolean start(Hashtable start_params) {
        return true;
    }

    public boolean isFinisdhed(boolean stop) {
        return true;
    }

    public Hashtable end() {
        Hashtable answer = new Hashtable();
        for (int i = 0; i < this.radioButtonList.size(); ++i) {
            JRadioButton btn = (JRadioButton)this.radioButtonList.elementAt(i);
            if (!btn.isVisible()) continue;
            Hashtable p = (Hashtable)this.lines.get(i);
            answer.put(p.get("result"), btn.isSelected());
        }
        return answer;
    }

    public void actionPerformed(ActionEvent event) {
    }
}

