/*  Copyright (c) 2015, Dan Newman <dan(dot)newman(at)mtbaldy(dot)us>
 *  All rights reserved.
 * 
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice, this
 *     list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 * 
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef S3G_COMMANDS_H_

#define S3G_COMMANDS_H_

#ifdef __cplusplus
extern "C" {
#endif

#define HOST_CMD_VERSION			0
#define HOST_CMD_INIT				1
#define HOST_CMD_GET_BUFFER_SIZE		2
#define HOST_CMD_CLEAR_BUFFER			3
#define HOST_CMD_GET_POSITION			4
#define HOST_CMD_ABORT				7
#define HOST_CMD_PAUSE				8
#define HOST_CMD_PROBE				9
#define HOST_CMD_TOOL_QUERY			10
#define HOST_CMD_IS_FINISHED			11
#define HOST_CMD_READ_EEPROM			12
#define HOST_CMD_WRITE_EEPROM			13
#define HOST_CMD_CAPTURE_TO_FILE	       	14
#define HOST_CMD_END_CAPTURE			15
#define HOST_CMD_PLAYBACK_CAPTURE		16
#define HOST_CMD_RESET				17
#define HOST_CMD_NEXT_FILENAME			18
#define HOST_CMD_GET_DBG_REG			19
#define HOST_CMD_GET_BUILD_NAME			20
#define HOST_CMD_GET_POSITION_EXT      		21
#define HOST_CMD_EXTENDED_STOP			22
#define HOST_CMD_BOARD_STATUS			23
#define HOST_CMD_GET_BUILD_STATS		24
#define HOST_CMD_ADVANCED_VERSION		27
#define HOST_CMD_DEBUG_ECHO			112
#define HOST_CMD_FIND_AXES_MINIMUM		131
#define HOST_CMD_FIND_AXES_MAXIMUM		132
#define HOST_CMD_DELAY				133
#define HOST_CMD_CHANGE_TOOL			134
#define HOST_CMD_WAIT_FOR_TOOL			135
#define HOST_CMD_TOOL_COMMAND			136
#define HOST_CMD_ENABLE_AXES			137
#define HOST_CMD_QUEUE_POINT_EXT		139
#define HOST_CMD_SET_POSITION_EXT		140
#define HOST_CMD_WAIT_FOR_PLATFORM		141
#define HOST_CMD_QUEUE_POINT_NEW		142
#define HOST_CMD_STORE_HOME_POSITION		143
#define HOST_CMD_RECALL_HOME_POSITION		144
#define HOST_CMD_SET_POT_VALUE			145
#define HOST_CMD_SET_RGB_LED			146
#define HOST_CMD_SET_BEEP			147
#define HOST_CMD_PAUSE_FOR_BUTTON		148
#define HOST_CMD_DISPLAY_MESSAGE		149
#define HOST_CMD_SET_BUILD_PERCENT		150
#define HOST_CMD_QUEUE_SONG			151
#define HOST_CMD_RESET_TO_FACTORY		152
#define HOST_CMD_BUILD_START_NOTIFICATION      	153
#define HOST_CMD_BUILD_END_NOTIFICATION		154
#define HOST_CMD_QUEUE_POINT_NEW_EXT		155
#define HOST_CMD_SET_ACCELERATION_TOGGLE       	156
#define HOST_CMD_STREAM_VERSION			157
#define HOST_CMD_PAUSE_AT_ZPOS			158

#define TOOL_CMD_VERSION			0
#define TOOL_CMD_INIT				1
#define TOOL_CMD_GET_TEMP			2
#define TOOL_CMD_SET_TEMP			3
#define TOOL_CMD_SET_MOTOR_1_PWM		4
#define TOOL_CMD_SET_MOTOR_2_PWM		5
#define TOOL_CMD_SET_MOTOR_1_RPM		6
#define TOOL_CMD_SET_MOTOR_2_RPM		7
#define TOOL_CMD_SET_MOTOR_1_DIR		8
#define TOOL_CMD_SET_MOTOR_2_DIR		9
#define TOOL_CMD_TOGGLE_MOTOR_1			10
#define TOOL_CMD_TOGGLE_MOTOR_2			11
#define TOOL_CMD_TOGGLE_FAN			12
#define TOOL_CMD_TOGGLE_VALVE			13
#define TOOL_CMD_SET_SERVO_1_POS		14
#define TOOL_CMD_SET_SERVO_2_POS		15
#define TOOL_CMD_FILAMENT_STATUS		16
#define TOOL_CMD_GET_MOTOR_1_RPM		17
#define TOOL_CMD_GET_MOTOR_2_RPM		18
#define TOOL_CMD_GET_MOTOR_1_PWM		19
#define TOOL_CMD_GET_MOTOR_2_PWM		20
#define TOOL_CMD_SELECT_TOOL			21
#define TOOL_CMD_IS_TOOL_READY			22
#define TOOL_CMD_PAUSE_UNPAUSE			23
#define TOOL_CMD_ABORT				24
#define TOOL_CMD_READ_FROM_EEPROM		25
#define TOOL_CMD_WRITE_TO_EEPROM		26
#define TOOL_CMD_GET_PLATFORM_TEMP		30
#define TOOL_CMD_SET_PLATFORM_TEMP		31
#define TOOL_CMD_GET_SP				32
#define TOOL_CMD_GET_PLATFORM_SP		33
#define TOOL_CMD_GET_BUILD_NAME			34
#define TOOL_CMD_IS_PLATFORM_READY		35
#define TOOL_CMD_GET_TOOL_STATUS		36
#define TOOL_CMD_GET_PID_STATE			37
#define TOOL_CMD_LIGHT_INDICATOR_LED		40

#ifdef __cplusplus
}
#endif

#endif
