/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <glib/gi18n.h>
#include "gsfile-pspec.h"
#include "gsfile-filenames-widget.h"

/* FILENAMES */
GS_DEFINE_PARAM (gsfile, GSFile, filenames, Filenames, G_TYPE_POINTER);

/**
 * gsfile_param_spec_filenames:
 * @name: spec name
 * @nick: spec nick
 * @blurb: spec blurb
 * @group: The quark of the group the param belong to
 * @formats: The list of #GdkPixbufFormats
 * @flags: Param flags.
 * 
 * Create a new #GSParamSpecFilenames .
 * 
 * Returns: the new #GSParamSpecFilenames
 **/
GParamSpec*
gsfile_param_spec_filenames (const gchar *name,
						 const gchar *nick,
						 const gchar *blurb,
						 GQuark group,
						 GSList *formats,
						 GParamFlags flags)
{
	GParamSpec *spec = g_param_spec_internal (GSFILE_TYPE_PARAM_FILENAMES,
												  name, nick, blurb, flags);
	g_param_spec_set_qdata (spec, GS_PARAM_GROUP_QUARK, (gpointer) group);
	g_param_spec_set_qdata (spec, GS_PARAM_FORMATS_QUARK, (gpointer) formats);
	gs_param_spec_set_widget_type (spec, GSFILE_TYPE_FILENAMES_WIDGET);
	
	return G_PARAM_SPEC (spec);
}

static void
gsfile_param_filenames_value_set_default (GParamSpec *pspec, GValue *value)
{
	g_value_set_pointer (value, NULL);
}

static gint
gsfile_param_filenames_values_cmp (GParamSpec *pspec, const GValue *a, const GValue *b)
{
	return a - b; /* completely fool */
}

/**
 * gsfile_param_spec_filenames_get_formats:
 * @pspec: a #GSParamSpecFilename
 * 
 * Retrieve the list of supported formats.
 * 
 * Returns: a #GSList of #GdkPixbufFormats structs.
 **/
GSList*
gsfile_param_spec_filenames_get_formats (GParamSpec *pspec)
{
	return (GSList *) g_param_spec_get_qdata (pspec, GS_PARAM_FORMATS_QUARK);
}
