import QtQuick 2.0
import Ubuntu.Components 0.1
import Friends 0.2

Item {
    id: threadView

    height: threadListView.height

    width: parent.width

    anchors {
        left: parent.left
        right: parent.right
        bottomMargin: units.gu(2)
    }

    StreamModel {
        id: streamModel
        stream: "reply_to/"+messageId
    }

    FriendsUtils {
        id: friendsUtils
    }

    Column {
        id: threadListView
        anchors {
            left: parent.left
            right: parent.right
        }

        width: parent.width
        height: childrenRect.height

        Repeater {
            id: repeater
            width: parent.width
            model: streamModel
            delegate: Item {
                id: threadItem

                anchors {
                    right: parent.right
                    left: parent.left

                    leftMargin: units.gu(4)
                    bottomMargin: units.gu(2)
                }

                height: childrenRect.height

                AvatarImage {
                    id: avatarImage

                    anchors {
                        left: parent.left
                        top: parent. top

                        margins: units.gu(1)
                    }
                }

                StatusUpdateContent {
                    anchors {
                        leftMargin: units.gu(1)

                        left: avatarImage.right
                        right: parent.right
                        top: parent.top
                    }
                }
           }
        }
    }
}
