/*
 * warnings - a set of gcc pragmas to disable warnings in Vala-generated C code
 *
 * Copyright © 2013 Collabora Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301  USA
 *
 * Authors:
 *      Philip Withnall <philip.withnall@collabora.co.uk>
 */

#ifndef FOLKS_WARNINGS_H
#define FOLKS_WARNINGS_H

/* The following pragmas disable various GCC warnings which frequently arise
 * from C code generated by Vala. Fixing the code generator to eliminate these
 * warnings (especially the first few) is very low on the Vala developers'
 * priority list, so for now we have to live with them disabled.
 *
 * The warnings nearer the end of the list are a little more specific and
 * important, and bugs have been filed (and referenced below) to try and get
 * the code generator fixed so we can remove the pragmas.
 *
 * This file should be included using
 *     *_CPPFLAGS += -include $(top_srcdir)/folks/warnings.h
 * in every build target which compiles only Vala source files. Targets which
 * compile both Vala and (non-generated) C should *not* include this file, so
 * that genuine warnings in the C code are caught. */

/* Vala likes to duplicate function declarations at the top of every C file.
 * They're all identical, so not a problem, but GCC should shut up about
 * them. */
#pragma GCC diagnostic ignored "-Wredundant-decls"

/* Vala continually sets variabeles which it never later uses. */
#pragma GCC diagnostic ignored "-Wunused-but-set-variable"

/* Vala continually generates unused temporary variables. */
#pragma GCC diagnostic ignored "-Wunused-variable"

/* Vala sometimes generates unused utility functions. */
#pragma GCC diagnostic ignored "-Wunused-function"

/* Vala sometimes generates labels it doesn't use when doing async state
 * machines and error handling. */
#pragma GCC diagnostic ignored "-Wunused-label"

/* Vala misses off the braces in nested static struct initialisations */
#pragma GCC diagnostic ignored "-Wmissing-braces"

/* Vala warns us about using deprecated functions from other namespaces, but
 * handily doesn't warn about using deprecated functions internally. */
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"

/* Vala likes putting format literals through temporary variables. */
#pragma GCC diagnostic ignored "-Wformat-nonliteral"

/* Vala often doesn't cast to the right parent class or interface for method
 * calls. Disabling -Wcast-qual doesn't seem to achieve anything, but we might
 * as well try.
 *
 * See: https://bugzilla.gnome.org/show_bug.cgi?id=652553
 * and: https://bugzilla.gnome.org/show_bug.cgi?id=710863
 * and: https://bugzilla.gnome.org/show_bug.cgi?id=710865 */
#pragma GCC diagnostic ignored "-Wcast-qual"

/* Vala can't emit the G_GNUC_PRINTF function attribute.
 *
 * See: https://bugzilla.gnome.org/show_bug.cgi?id=710862 */
#pragma GCC diagnostic ignored "-Wsuggest-attribute=format"

#endif
