/*	Copyright  2001 The Regents of the University of California.
*	All Rights Reserved.
*	Permission to use, copy, modify, and distribute this software and its
*	documentation for educational, research and non-profit purposes, without
*	fee, and without a written agreement is hereby granted, provided that the
*	above copyright notice, this paragraph and the following three paragraphs
*	appear in all copies.
*	Permission to incorporate this software into commercial products may
*	be obtained by contacting the University of California: 
*	Bill Hoskins
*	Office of Technology Licensing
*	2150 Shattuck Avenue #150
* 	Berkeley, CA 94720-1620
*	(510) 643-7201
*	bhoskins@uclink2.berkeley.edu
*	
*
*	This software program and documentation are copyrighted by The Regents
*	of the University of California. The software program and documentation
*	are supplied "as is", without any accompanying services from
*	The Regents. The Regents does not warrant that the operation of the program
*	will be uninterrupted or error-free. The end-user understands that the
*	program was developed for research purposes and is advised not to rely
*	exclusively on the program for any reason.
*	IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
*	FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING
*	LOST PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION,
*	EVEN IF THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY
*	OF SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
*	WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
*	AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
*	ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO
*	OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
*	This software is based on Mark Fullmer's flow-tools 
*	http://www.splintered.net/sw/flow-tools/
*	$Id: acl-filter.h,v 1.2 2001/10/17 23:32:24 robert Exp $
*/


#if HAVE_CONFIG_H
 #include <config.h>
#endif

#include <sys/time.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#if HAVE_STRINGS_H
 #include <strings.h>
#endif
#if HAVE_STRING_H
  #include <string.h>
#endif
#include <time.h>
#include <fcntl.h>
#include <errno.h>

#include "ftlib.h"
#include "support.h"
#include "acl2.h"
#include "aclyacc.h"
#include "fmt.h"
#include "route_lookup.h"



struct acl_info {
  int main_index;
  int sub_index;
  char* name;
  struct ftio* bucket;
  u_int64 num_written;
};


enum {
  SRC_STD = 0,
  DST_STD,
  SRC_AS,
  DST_AS,
  SRC_COMM,
  DST_COMM,
  LAST_ACL
};



void init_acl_bucket(struct ftio *out, struct ftset* ftset, struct ftver* ftv, int fd);

void  pass_flow(struct acl_info* acl, void* rec);

void write_flow(struct ftio*,void*);

void write_header(struct ftio*);

void close_acl_buckets(struct ftio* buckets, int num_buckets); 

int  check_dup(int len, struct acl_info* acls, char* name);

void init_flow_input(struct ftio* in, struct ftver* version);

void init_acls(char** acl_names, struct acl_info** acls, int* list_sizes, struct ftio* ftstdout);

struct ftio* init_output(struct ftset* ftset, struct ftver* ftversion, int fd);

void init_split_output(struct ftset* ftset, struct ftver* ftver,
		       struct acl_info** acls, int* sizes);

void run_filters(struct ftio* ftin, struct ftio* ftstdout, struct acl_info** acls, 
		int* sizes, int debug);

int filter_std(struct acl_info* acl, int len, u_int32 ip);

int filter_as(struct acl_info* acl, int len, u_int32 prefix,u_int8 mask_bitlen, int debug);

int filter_community(struct acl_info* acl, int len, u_int32 prefix,
		     u_int8 mask_bitlen, int debug);

void close_buckets(struct acl_info **acls, int* sizes);

void check_acls(struct acl_info **acls, int* sizes);

void usage();
