/* $Id: listtest.c,v 1.4 2003/06/15 10:05:56 sjoerd Exp $ */
#include <stdio.h>

#include <global.h>
#include <list.h>

int
print_item(void *data, void *user_data) {
  char *p = (char *) data;

  printf("%c ", *p);

  return TRUE;
}

void
print_list(List * list) {
  list_foreach(list, print_item, NULL);
  printf("\n");
}

int
compare(void *data0,void *data1, void *user_data) {
  char *a = (char *)data0;
  char *b = (char *)data1;

  return *a - *b;
}

int
main(int argc, char **argv) {
  List *list;
  List_ptr *ptr;
  char alphabet[] = "abcdefghijkl";
  char *p;

  list = new_list();
  ptr = new_list_ptr(list);

  printf("Getting first of an empty list: %d\n", list_ptr_first(ptr));
  printf("Getting last  of an empty list: %d\n", list_ptr_first(ptr));

  printf("appending the alphabet\n");
  for (p = alphabet; *p != '\0'; p++)
    list_append(list, p);
  print_list(list);

  printf("prepending the alphabet\n");
  for (p = alphabet; *p != '\0'; p++)
  list_prepend(list, p);
  print_list(list);

  printf("deleting one a\n");
  list_del(list, alphabet);
  printf("printing\n");
  print_list(list);

  printf("deleting second a\n");
  list_del(list, alphabet);
  print_list(list);

  printf("deleting random items\n");
  list_ptr_first(ptr);
  do {
    if (((unsigned long) list_ptr_get_data(ptr)) % 2) {
      list_ptr_del_current(ptr);
      print_list(list);
    }
  } while (list_ptr_next(ptr));
 del_list_ptr(ptr);

 printf("Sorting\n");
 list_sort(list,compare,NULL);
 print_list(list);
 del_list(list);
 return 0;
}
