/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file address-add.c
 * \brief Add address dialog
 */

#include <ffgtk.h>
#include <vcard.h>

/** Common widgets */
static GtkWidget *psFirstNameEntry, *psLastNameEntry, *psCompanyEntry;

/**
 * \brief Add address dialog
 * \param psPerson pointer to person struct
 * \param pnNumber new number
 * \param nState state informing about button action
 * \return error code
 */
gint AddAddressDialog( struct sPerson *psPerson, const gchar *pnNumber, gint nState ) {
	GtkBuilder *psBuilder = NULL;
	GError *psError = NULL;
	GtkWidget *psDialog = NULL;
	gchar *pnUiFile;
	gint nResponse = 0;
	gint nResult = -1;

	psBuilder = gtk_builder_new();
	pnUiFile = getUiFile( "addaddress.ui" );
	if ( gtk_builder_add_from_file( psBuilder, pnUiFile, &psError ) == 0 ) {
	    Debug( KERN_WARNING, "Error: %s\n", psError -> message );
	    g_error_free( psError );
		g_free( pnUiFile );
	    return nResult;
	}
	g_free( pnUiFile );

	psDialog = GTK_WIDGET( gtk_builder_get_object( psBuilder, "psAddAddressDialog" ) );

	psFirstNameEntry = GTK_WIDGET( gtk_builder_get_object( psBuilder, "psFirstNameEntry" ) );
	if ( psPerson != NULL && psPerson -> pnFirstName != NULL ) {
		gtk_entry_set_text( GTK_ENTRY( psFirstNameEntry ), psPerson -> pnFirstName );
	}

	psLastNameEntry = GTK_WIDGET( gtk_builder_get_object( psBuilder, "psLastNameEntry" ) );
	if ( psPerson != NULL && psPerson -> pnLastName != NULL ) {
		gtk_entry_set_text( GTK_ENTRY( psLastNameEntry ), psPerson -> pnLastName );
	}

	psCompanyEntry = GTK_WIDGET( gtk_builder_get_object( psBuilder, "psCompanyEntry" ) );
	if ( psPerson != NULL && psPerson -> pnCompany != NULL ) {
		gtk_entry_set_text( GTK_ENTRY( psCompanyEntry ), psPerson -> pnCompany );
	}

	gtk_builder_connect_signals( psBuilder, NULL );

	g_object_unref( G_OBJECT( psBuilder ) );

	nResponse = gtk_dialog_run( GTK_DIALOG( psDialog ) );
	if ( nResponse == 2 ) {
		GHashTable *psTable = g_hash_table_new( NULL, NULL );
		const gchar *pnFirstName = gtk_entry_get_text( GTK_ENTRY( psFirstNameEntry ) );
		const gchar *pnLastName = gtk_entry_get_text( GTK_ENTRY( psLastNameEntry ) );
		const gchar *pnCompany = gtk_entry_get_text( GTK_ENTRY( psCompanyEntry ) );
		GString *psDisplayName = g_string_new( "" );

		GString *psId = createUid();

		AddInfo( psTable, PERSON_ID, psId -> str );

		if ( pnFirstName != NULL && strlen( pnFirstName ) > 0 ) {
			AddInfo( psTable, PERSON_FIRST_NAME, pnFirstName );
			psDisplayName = g_string_append( psDisplayName, pnFirstName );
		}
		if ( pnLastName != NULL && strlen( pnLastName ) > 0 ) {
			if ( psDisplayName -> len > 0 ) {
				psDisplayName = g_string_append( psDisplayName, " " );
			}
			psDisplayName = g_string_append( psDisplayName, pnLastName );
			AddInfo( psTable, PERSON_LAST_NAME, pnLastName );
		}
		if ( pnCompany != NULL && strlen( pnCompany ) > 0 ) {
			if ( psDisplayName -> len == 0 ) {
				psDisplayName = g_string_append( psDisplayName, pnCompany );
			}
			AddInfo( psTable, PERSON_COMPANY, pnCompany );
		}
		if ( pnNumber != NULL && strlen( pnNumber ) > 0 ) {
			AddInfo( psTable, PERSON_PRIVATE_PHONE, pnNumber );
		}

		if ( psDisplayName -> len != 0 ) {
			AddInfo( psTable, PERSON_DISPLAY_NAME, psDisplayName -> str );

			psPerson = AddPerson( psTable, TRUE );
			if ( psPerson != NULL ) {
				nResult = 0;
			}
			updateCallerList( pnNumber, psDisplayName -> str );
			//SaveBook();
			g_string_free( psDisplayName, TRUE );
		}

		g_hash_table_destroy( psTable );
		g_string_free( psId, TRUE );
	}

	gtk_widget_destroy( psDialog );

	return nResult;
}
