/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.McIDASUtil;

public final class LAMBnav
extends AREAnav {
    private boolean isEastPositive = true;
    int iwest;
    int ihem;
    double xrow;
    double xcol;
    double xlat1;
    double xlat2;
    double xspace;
    double xqlon;
    double xblat;
    double xfac;
    double xpole;

    public LAMBnav(int[] iparms) throws IllegalArgumentException {
        if (iparms[0] != 1279348034) {
            throw new IllegalArgumentException("Invalid navigation type" + iparms[0]);
        }
        this.xrow = iparms[1];
        this.xcol = iparms[2];
        int ipole = iparms[11];
        if (ipole == 0) {
            ipole = 900000;
        }
        this.ihem = 1;
        if (ipole < 0) {
            this.ihem = -1;
        }
        this.xpole = McIDASUtil.integerLatLonToDouble(ipole);
        this.xlat1 = McIDASUtil.integerLatLonToDouble(iparms[3]);
        this.xlat2 = McIDASUtil.integerLatLonToDouble(iparms[4]);
        this.xlat1 = (90.0 - (double)this.ihem * this.xlat1) * (Math.PI / 180);
        this.xlat2 = (90.0 - (double)this.ihem * this.xlat2) * (Math.PI / 180);
        this.xspace = (double)iparms[5] / 1000.0;
        this.xqlon = McIDASUtil.integerLatLonToDouble(iparms[6]);
        double r = (double)iparms[7] / 1000.0;
        this.iwest = iparms[10];
        if (this.iwest >= 0) {
            this.iwest = 1;
        }
        this.xfac = (Math.log(Math.sin(this.xlat1)) - Math.log(Math.sin(this.xlat2))) / (Math.log(Math.tan(0.5 * this.xlat1)) - Math.log(Math.tan(0.5 * this.xlat2)));
        this.xblat = r * Math.sin(this.xlat1) / (this.xspace * this.xfac * Math.pow(Math.tan(this.xlat1 * 0.5), this.xfac));
    }

    public double[][] toLatLon(double[][] linele) {
        int number = linele[0].length;
        double[][] latlon = new double[2][number];
        double[][] imglinele = this.areaCoordToImageCoord(linele);
        for (int point = 0; point < number; ++point) {
            double xldif = (double)this.ihem * (imglinele[1][point] - this.xrow) / this.xblat;
            double xedif = (double)(-this.ihem) * (imglinele[0][point] - this.xcol) / this.xblat;
            double xrlon = 0.0;
            if (xldif != 0.0 || xedif != 0.0) {
                xrlon = Math.atan2(xedif, xldif);
            }
            double xlon = (double)this.ihem * xrlon / this.xfac / (Math.PI / 180) + this.xqlon;
            xlon = (xlon + 900.0) % 360.0 - 180.0;
            double radius = Math.sqrt(xldif * xldif + xedif * xedif);
            double xlat = Math.abs(radius) < 1.0E-10 ? (double)(this.ihem * 90) : (double)this.ihem * (90.0 - 2.0 * Math.atan(Math.exp(Math.log(radius) / this.xfac)) / (Math.PI / 180));
            latlon[0][point] = xlat;
            latlon[1][point] = this.iwest == 1 ? -xlon : xlon;
        }
        return latlon;
    }

    public double[][] toLinEle(double[][] latlon) {
        int number = latlon[0].length;
        double[][] linele = new double[2][number];
        for (int point = 0; point < number; ++point) {
            double xlat = latlon[0][point];
            double xlon = this.iwest == 1 ? -latlon[1][point] : latlon[1][point];
            double xrlon = (double)this.ihem * (xlon - this.xqlon);
            xrlon = (xrlon + 900.0) % 360.0 - 180.0;
            xrlon = xrlon * this.xfac * (Math.PI / 180);
            double xclat = (90.0 - (double)this.ihem * xlat) * (Math.PI / 180) * 0.5;
            double xrlat = xclat == 0.0 ? 0.0 : this.xblat * Math.pow(Math.tan(Math.abs(xclat)), this.xfac);
            linele[1][point] = this.xrow + (double)this.ihem * (xrlat * Math.cos(xrlon));
            linele[0][point] = this.xcol - (double)this.ihem * (xrlat * Math.sin(xrlon));
        }
        return this.imageCoordToAreaCoord(linele, linele);
    }
}

