// Servidor(maestro)/cliente usando funciones UDP por Titonus (net.dll realizada por MaQ)

// Este programa consiste en el envio y recepcion de la coordenadas, angulo, grafico y disparos
// en pantalla del avion, nick/alias del servidor y de varios clientes (a determinar en la constante jugadores) y
// mensajes entre ellos; si un disparo colisiona con un avin entonces "muere" y al instante reaparece.

// Teclas para el movimiento del avion: A,D,W,S y ESPACIO para disparar
// Tecla Y para enviar mensajes

// Funciona adecuadamente tanto en red  local como en internet, y se puede probar en el mismo pc 
// ejecutando el servidor (Opcion 1) y luego un cliente (Opcion 3) poniendo como IP (localhost o 127.0.0.1) y habiendo 
// asignado previamente la constante jugadores a 2.

// Si usamos las opciones de servidor maestro, es preciso que antes de crear un servidor
// con esta opcin, que haya sido creado anteriormente un servidor maestro para que se pueda validar,
// al igual que es necesario que haya sido iniciado un servidor maestro y al menos un servidor (validado)
// para que un cliente pueda unirse a alguna partida.

// En routers y/o proxies, para que funcione correctamente por internet es preciso abrir los puertos UDP siguientes: 
// - Si no se usa el servidor maestro basta con los siguientes: 
// 16660 (servidor), 16662+clientes (clientes = desde 0 hasta nmero de clientes) 
// - Si se usa el servidor maestro son necesarios los anteriores mas los siguientes:
// 19000, 19001 y 20000 en la mquina del servidor maestro, 19000 en el servidor y, 19001 y 20000 en el cliente.

// * NOTA: Es posible que se produzcan salidas y/o errores inesperados *

program avionudp;

// Tipos a usar para los paquetes UDP
type _IPaddress
    int host;
    word port;
end;

type _UDPpacket
    int channel;       
    byte pointer data;
    int len;
    int maxlen;
    int status;
    _IPaddress address;
end;

import "net.dll"

const 
jugadores=2; // Clientes ms el servidor (Jugadores-Servidor) (por ejemplo 2 jugadores son un cliente y el servidor)
servidores_validos=7; // Servidores posibles a autentificar el servidor maestro (7 significa que son 8 posibles)

global
// Punteros para los paquetes UDP
_UDPpacket pointer p; 
_UDPpacket pointer q;
_UDPpacket pointer r;

plane; // Para la carga del grfico del avion
disparo; // Para la carga del grfico del disparo
explosion; // Para la carga del fpg de los grficos de la explosin
// Variables para el input de la direccion ip o del nick/alias
String 	prompt = "_" ;
String	entry ;
String 	nick;
String	maestro;
int	Nombre[7];
int    Nombre_Servidor[7];
inputText ;
//..
disparando; // Para indicar si est disparando
explosionando[jugadores-1]; // Para indicar si el avin ha hecho explosin

// Para el envio/recepcion de datos (coordenadas ,angulo, grafico, si esta disparando, nick/alias, mensaje)
struct playerdata;
int x,int y,int angle,int graph,int shoot,int asciinick[7], int asciimessage[12];
end;

// Para almacenar nombre y direccion ip de los servidores (Servidor Maestro y clientes que lo soliciten)
struct info_server[servidores_validos]; // hasta 'servidores_validos' a autentificar
int name[7],int hostip;
end;

// Variables mini-chat (sistema de mensajes)
chat; // Si vale 1 es que estamos mandando un mensaje y no dejamos mover o disparar nuestro avion
posicion_textoy_chat=180; // Variable que indica la coordenada 'y' del texto del chat - posicion por defecto 180, restando 10 a cada mensaje que llegue hasta 140 como mucho
String 	prompt1 = "_" ;
String	entry1 ;
String	textomensaje;
// Dos variables mensaje, una local para enviar y otra temporal a usar cuando se reciban mensajes
int Mensaje[12]; // Hasta 12 caracteres por linea (debido al solo envio de 100 bytes de los paquetes)
inputChat;
textoMensajes[4]; // Numero de mensajes visualizados a la vez (5)
lineasMensajes; // Lleva el n de mensajes visualizados
//..

opcion; // Para llamar al servidor o al cliente
vivo; // Si vale 0 no te ha dado ningun disparo, cuando estas muerto tardas un tiempo en reaparecer

private
i; // bucle for i
begin
	// cerramos sockets por si en una ejecucion anterior no se cerro el programa adecuadamente
	// y asi evitar petadas de sdl_net
	for  (i=0;i<=jugadores;i++);
	net_udp_close(i);
	end;
	// modo ventana 16 bits, carga de graficos y esperamos a que se seleccione opcion
	full_screen=false;
 	graph_mode=mode_16bits;
	plane=load_png("avion.png");
	disparo=load_png("disparo.png");
	explosion=load_fpg("explosion.fpg");
	write(0,5,5,0,"Selecciona una opcion:");
	write(0,5,25,0,"1. Servidor sin auntentificarse");
	write(0,5,35,0,"2. Servidor auntentificandose");
	write(0,5,45,0,"3. Cliente especificando direccion IP o HOST");
	write(0,5,55,0,"4. Cliente usando servidor maestro");
	write(0,5,65,0,"5. Servidor maestro");
		while (Opcion==0 and Jugadores>1)
			if (key(_1)) opcion=1;delete_text(0);input (0,5,25,300,"",1);end
			if (key(_2)) opcion=2;delete_text(0);input (0,5,25,300,"",0);end
			if (key(_3)) opcion=3;delete_text(0);input (0,5,25,300,"",1);end
			if (key(_4)) opcion=4;delete_text(0);input (0,5,25,300,"",0);end
			if (key(_5)) opcion=5;delete_text(0);servidor_maestro();end
			if (key(_esc)) opcion=9;end
			frame;
		end;
end;

// Proceso del servidor maestro
PROCESS servidor_maestro()
private
i, j;
texto[servidores_validos];
string nombreservidor;
begin
	write(0,10,10,3,"Servidor Maestro - Servidores autentificados: ");
	write_int(0,300,10,3,offset i);
	net_init(); // inicializamos funciones de red
	
	net_udp_open(99,19000); // abrimos el socket 99 para escucha (servidores) en el puerto 19000
	net_udp_bind(99,1,"127.0.0.1",19000); // "bindeamos" el socket 99 con el canal 1 en el puerto de escucha
	net_udp_open(100,19001); // abrimos el socket 100 para escucha (clientes) en el puerto 19001
	net_udp_bind(100,1,"127.0.0.1",19001); // "bindeamos" el socket 100 con el canal 1 en el puerto de escucha
	net_udp_allocpacket(100,100); // paquete 100 para enviar/recibir servidores que se autentifican (puede ser necesario reajustar el tamao de 100 dependiendo de la informacion)
	p=net_udp_getpacket(100);
	repeat
		// Autentificacion de un servidor
		if (net_udp_recv(99,100)>0 and i<8)
		memcopy(&info_server[i].name,p.data,100); // con ello conseguimos el nombre del servidor
		info_server[i].hostip=p.address.host; // con ello conseguimos el host
		nombreservidor="";
		for (j=0;j<=7;j++);
			if (info_server[i].name[j]<>0) nombreservidor+=chr(info_server[i].name[j]);end;
		end
		texto[i]=write(0,10,30+(i*10),3,"- "+ i +". "+nombreservidor);
		i++;
		end;
		//..
		
		// Cliente que pide datos de los servidores
		if (net_udp_recv(100,100)>0)
		p.len=100;// longitud 100 del paquete de datos a enviar al cliente
		net_udp_open(101,0); // abrimos el socket 101 para envio en el puerto 20000
		net_udp_bind2(101,1,p.address.host,20000); // "bindeamos" el socket 101 con el canal 1 en el puerto de envio
		memcopy(p.data,&info_server,100);
		net_udp_send(101,1,100);// enviamos info de los servidores autentificados al cliente que lo solicita
		net_udp_close(101);
		end;
		//..
		
	frame;
	until (key(_Esc))
	net_udp_freepacket(0); // vaciamos paquetes y cerramos sockets y funciones
	net_udp_close(99);// cerramos socket 99 (escucha)
	net_udp_close(100); // cerramos socket 100 (envio)
	net_quit();
	let_me_alone();
end;

// Proceso del servidor
PROCESS servidor()
private
i, j, conectados, texto[3]; // bucles for i,j
oservidor;
begin
	oservidor=opcion;// para evitar variaciones imprevistas de opcion
	// Inicio del servidor
	write(0,10,10,3,"Servidor");
	texto[0]=write(0,10,25,3,"Jugadores conectados:");
	texto[1]=write_int(0,160,25,3,offset conectados);
	texto[2]=write(0,10,40,3,"Esperando conexin de "+ (jugadores-1) +" jugadores...");
	
	net_init(); // inicializamos funciones de red
	
	// Si opcion=-1 es que hemos de autentificarnos en un servidor maestro
	if (oservidor<1)
	net_udp_allocpacket(100,100);
	net_udp_open(99,0); // abrimos el socket 99 para conectar al servidor maestro y enviarle nuestra info
	net_udp_bind(99,1,maestro,19000); // "bindeamos" el socket 99 con el canal 1 en el puerto del servidor maestro 19000
	r=net_udp_getpacket(100);
	r.len=100;// longitud 100 del paquete de datos a enviar el servidor maestro
	memcopy(r.data,&nombre_servidor,100);
	// enviamos nuestro nombre del servidor
	if (net_udp_send(99,1,100)<=0) texto[3]=write(0,10,50,3,"Autentificacion fallida");end
	net_udp_close(99);
	net_udp_freepacket(100);
	end;
		
	for (i=0;i<=jugadores;i++)
	net_udp_allocpacket(i,100); // iniciamos los paquetes para envio y recibo de datos
	end;
	net_udp_open(0,16660); // abrimos el socket 0 para escucha en el puerto 16660
	net_udp_bind(0,1,"127.0.0.1",16660); // "bindeamos" el socket 0 con el canal 1 en el puerto de escucha
	
	// Esperamos a que se conecten jugadores
	p=net_udp_getpacket(0);
	while (conectados<jugadores-1)
		if (net_udp_recv(0,0)>0)
		q=p; // con ello conseguimos el host y port del cliente seleccionado
		net_udp_open(conectados+1,0); // abrimos el socket i+1 en el puerto 0 para enviar datos a dicho cliente
		net_udp_bind2(conectados+1,1,q.address.host,16662+conectados); // "bindeamos" el socket i con el canal 1 al puerto 16662+i-1 y direccion del cliente
		conectados=conectados+1; // incrementamos numero de conectados
		end;
		frame;
	end;
	
	if (oservidor<1 and texto[3]>0) delete_Text(texto[3]);end
	delete_text(texto[0]);delete_text(texto[1]);delete_text(texto[2]);
	write(0,10,25,3,"N de jugador: 0");// El servidor siempre es el jugador 0
	
	// Una vez conectados les enviamos su nmero de jugador
	for (i=1;i<=jugadores-1;i++)
	memcopy(p.data,&i,100);
	net_udp_send(i,1,0);
	frame;
	end;
	
	// Grafico del avion y posicion aleatoria
	graph=plane;
	x=rand(10,310);
	y=rand(10,190);
	
	repeat
	// para mandar mensajes (chat)
	if (key(_y) and chat==0) chat=1;inputChat (0,5,190,100,"");end;
	//..
	
	// movimiento del avion y disparo
	
	// restriccion del moviemiento en pantalla
	if (x<0) x=1;end
	if (x>320) x=319;end
	if (y<0) y=1;end
	if (y>200) y=199;end
	
	// si estamos vivos podemos movernos
	if (vivo==0 and chat==0)
		if (key(_a)) angle=angle+5000;end
		if (key(_d)) angle=angle-5000;end
		if (key(_w)) advance(3);end
		if (key(_s)) advance(-3);end
		if (key(_space)) if (disparando==0) pdisparo(x,y,angle);disparando=1;end;
		else
		disparando=0;
		end
	end;
	//..
	
	// si nos da un disparo, desaparecemos un instante y a los 150ms reaparecemos en unas coordenadas aleatorias
	if (collision (type pdisparo))
	graph=0;
	texto[0]=write (0,5,40,3,"Te han dado!, espera un instante para reaparecer");
	timer[0]=0;
	vivo=1;
	pexplosion(x,y,angle);
	end
	
	if (vivo==1 and timer[0]>=150)
	delete_text(texto[0]);
	vivo=0;graph=plane;
	x=rand(10,310);
	y=rand(10,190);
	end;
	//..
	
	// Bloque de envio y recepcion de datos
	for (i=1;i<=jugadores-1;i++);
	// envio de los datos del servidor al cliente i
	playerdata.x=x;
	playerdata.y=y;
	playerdata.angle=angle/1000; // Lo dividimos con el fin de enviar menos bytes, angulos se miden en milesimas de grados
	if (key(_esc)) graph=-1;end;
	playerdata.graph=graph;
	playerdata.shoot=disparando;
	// el siguiente bucle "for" almacena en la estructura playerdata el nick/alias del servidor mediante el cdigo ascii de los caracteres
	for (j=0;j<=7;j++);
	playerdata.asciinick[j]=nombre[j];
	end
	
	// la siguiente condicion y bucle "for" almacena en la estructura playerdata el mensaje del servidor mediante el cdigo ascii de los caracteres
	if (chat==0)
		for (j=0;j<=12;j++);
		playerdata.asciimessage[j]=mensaje[j];
		end
		// Limpiamos la variable mensaje
		for (j=0;j<=12;j++)
		Mensaje[j]=0;
		end;
		//...
	end;
	
	p=net_udp_getpacket(0);
	p.len=100;// longitud 100 del paquete de datos a enviar el servidor
	memcopy(p.data,&playerdata,100);
	net_udp_send(i,1,0);
	if (playerdata.shoot==1) disparando=2;end // Para evitar que salgan constantemente disparos en el receptor
	// si recibimos coordenadas del dato i, mostramos su avion (disparo, explosion, etc) y dicha info la enviamos a los demas clientes
	p=net_udp_getpacket(i);
		if (net_udp_recv(0,i)>0)
		memcopy(&playerdata,p.data,100);
			// el siguiente bucle "for" forma en la variable 'string nick' el nick/alias del cliente i mediante el cdigo ascii de los caracteres
			nick="";
			for (j=0;j<=7;j++);
			if (playerdata.asciinick[j]<>0) nick+=chr(playerdata.asciinick[j]);end;
			end
			// la siguiente condicin y bucle "for" forman el mensaje recibido del jugador correspondiente
			textomensaje="";
			if (playerdata.asciimessage[0]>0)
				for (j=0;j<=12;j++);
				if (playerdata.asciimessage[j]<>0) textomensaje+=chr(playerdata.asciimessage[j]);end;
				end
						if (posicion_textoy_chat<140) posicion_textoy_chat=180;lineasmensajes=0;
								for (j=0;j<=4;j++)
								delete_text(textomensajes[j]);
								end
						end;
			textomensajes[lineasmensajes]=write(0,5,posicion_textoy_chat,0,nick+ ": "+ textomensaje);
			posicion_textoy_chat=posicion_textoy_chat-10;lineasmensajes++;
			end;
			// Si recibimos que graph=-1 es que el jugador correspondiente ha desconectado
			if (playerdata.graph==-1) write(0,5,25+(i*10),0,"El jugador "+i+" ("+nick+") ha desconectado");end
		nave(playerdata.x,playerdata.y,playerdata.graph,playerdata.angle,playerdata.shoot,explosionando[0],nick);
		p.len=100;// longitud 100 del paquete de datos a enviar el servidor
		memcopy(p.data,&playerdata,100);
			for (j=1;j<=jugadores-1;j++)
				if (j!=i) // condicion para no enviar las coordenadas a un cliente que nos ha enviado estas coordenadas
				net_udp_send(j,1,i);
				end;
			end;
		end;
	end;

	frame;
 	until (graph==-1) // Si graph=-1 es que hemos pulsado escape y hemos finalizado el programa
 	for  (i=0;i<=jugadores;i++);
	net_udp_freepacket(i); // vaciamos paquetes y cerramos sockets y funciones
	net_udp_close(i);
	end;
	net_quit();
	let_me_alone();
end

// Proceso del cliente
PROCESS cliente()
private 
i,j,texto,jugador;// bucle for i,j, variable jugador para identificarnos
no_se_que_jugador_soy; // para saber cuando hemos recibido numero de jugador
string nombreservidor;
int entry2; // en el caso de que la ip est dada en un entero en vez de string
ocliente;
begin
	ocliente=opcion;// para evitar variaciones imprevistas de opcion
	net_init();// inicializamos funciones de red
	// Si opcion=7 es que hemos seleccionado elegir un servidor de los que estan autentificados en un servidor maestro
	if (ocliente==7)
	net_udp_allocpacket(100,100);
	r=net_udp_getpacket(100);  // puntero al paquete 100
	net_udp_open(100,0); // abrimos el socket 100 para conectar al servidor maestro y enviarle nuestra info
	net_udp_bind(100,1,maestro,19001); // "bindeamos" el socket 100 con el canal 1 en el puerto del servidor maestro 19001
	r.len=100;// longitud 100 del paquete de datos a enviar el servidor maestro
	memcopy(r.data,&i,100);
	net_udp_send(100,1,100);// enviamos seal para que el servidor maestro nos envie los servidores disponibles
	net_udp_close(100);
	net_udp_open(101,20000); // abrimos el socket 101 para conectar al servidor maestro y recibir info
	net_udp_bind(101,1,"127.0.0.1",20000); // "bindeamos" el socket 101 con el canal 1 con el puerto 20000
	end;
		while (ocliente==7)
			if (net_udp_recv(101,100)>0)
			delete_Text(0);
			ocliente=9;
			write(0,10,15,3,"Servidores autentificados (Selecciona uno):");
			memcopy(&info_Server,r.data,100);
				for (i=0;i<=Servidores_Validos;i++)
				nombreservidor="";	
					for (j=0;j<=7;j++);
					if (info_server[i].name[j]<>0) nombreservidor+=chr(info_server[i].name[j]);end;
					end
				if (nombreservidor<>"");write(0,10,30+(i*10),3,"- "+i+". "+nombreservidor);end;
				end;
			net_udp_freepacket(100);
			end
		end;
	
	// Para seleccionar partida
	while (ocliente==9) // El nmero 0 es en ascii 48, a partir de ahi podemos seleccionar partida, siempre que se cumplan las condiciones del IF
		if (ascii>47 and ascii-48<=servidores_validos and info_server[ascii-48].name[0]<>0) entry2=info_server[ascii-48].hostip;ocliente=8;end
		frame;
	end;
	//..
	for (i=0;i<=jugadores;i++)
	net_udp_allocpacket(i,100); // iniciamos los paquetes para envio y recibo de datos
	end;
	p=net_udp_getpacket(0);  // puntero al paquete 0
	// Inicio del cliente
	net_udp_open(0,0); // abrimos el socket 0 en puerto el 0
 	if (ocliente<>8)
	net_udp_bind(0,1,entry,16660); // "bindeamos" el socket 0 con el canal 1 a la direccion del server en el puerto 16660
	else
	net_udp_close(101);
	delete_Text(0);
	net_udp_bind2(0,1,entry2,16660); // "bindeamos" el socket 0 con el canal 1 a la direccion del server en el puerto 16660
	end;
	p.len=100; // longitud 100 del paquete de datos a enviar el servidor
	write(0,10,10,3,"Cliente");
	texto=write(0,10,25,3,"Conectado! Esperando a los otros jugadores...");
	memcopy(p.data,&i,100); // enviamos i (da igual su valor) para indicar que hemos conectado con el servidor
	net_udp_send(0,1,0);
	
	// Como no sabemos a que puerto y socket el servidor va a enviar todavia la info, abrimos todos los puertos y sockets posibles
	for (i=1;i=<jugadores-1;i++)
	net_udp_open(i,16662+i-1);
 	net_udp_bind(i,1,"127.0.0.1",16662+i-1); 
	end;
	
	// Con lo siguiente esperamos a recibir el dato para saber que jugador somos y que socket y puerto hemos de abrir
	i=1;
	while (no_se_que_jugador_soy==0)
                if (net_udp_recv(i,0)>0)
		memcopy(&jugador,p.data,100);
		delete_text(texto);
		no_se_que_jugador_soy=1;
		texto=write(0,10,25,3,"N de jugador: "+ jugador);
			// el siguiente bucle "for" almacena en la estructura playerdata el nick/alias del cliente mediante el cdigo ascii de los caracteres
			for  (i=1;i<=jugadores;i++)
			net_udp_close(i);// cerramos sockets anteriores
			end;
		net_udp_open(jugador,16662+jugador-1); // abrimos socket jugador en puerto 16662+jugador-1
		net_udp_bind(jugador,1,"127.0.0.1",16662+jugador-1); // "bindeamos" el socket jugador con el canal 1 para escucha en el puerto 16662+jugador-1
		end;
		if (i<jugadores-1) i=i+1;else i=1;end
	frame;
	end;
	
	// Grafico del avion y posicion aleatoria
	x=rand(10,310);
	y=rand(10,190);
	graph=plane;
	repeat
	// para mandar mensajes (chat)
	if (key(_y) and chat==0) chat=1;inputChat (0,5,190,100,"");end;
	//..
	
	// movimiento del avion y disparo
	
	// restriccion del moviemiento en pantalla
	if (x<0) x=1;end
	if (x>320) x=319;end
	if (y<0) y=1;end
	if (y>200) y=199;end
	
	// si estamos vivos podemos movernos
	if (vivo==0 and chat==0)
		if (key(_a)) angle=angle+5000;end
		if (key(_d)) angle=angle-5000;end
		if (key(_w)) advance(3);end
		if (key(_s)) advance(-3);end
		if (key(_space)) if (disparando==0) pdisparo(x,y,angle);disparando=1;end;
		else
		disparando=0;
		end
	end;
	//..
	
	// si nos da un disparo, desaparecemos un instante y a los 150ms reaparecemos en unas coordenadas aleatorias
	if (collision (type pdisparo))
	graph=0;
	texto=write (0,5,40,3,"Te han dado!, espera un instante para reaparecer");
	timer[0]=0;
	vivo=1;
	pexplosion(x,y,angle);
	end
	
	if (vivo==1 and timer[0]>=150)
	delete_text(texto);
	vivo=0;graph=plane;
	x=rand(10,310);
	y=rand(10,190);
	end;
	//..
	
	// Bloque de envio y recepcion de datos
	// enviamos nuestros datos al servidor
	// la siguiente condicion y bucle "for" almacena en la estructura playerdata el mensaje del servidor mediante el cdigo ascii de los caracteres, siempre que haya un mensaje a enviar
	playerdata.x=x;
	playerdata.y=y;
	playerdata.angle=angle/1000;// Lo dividimos con el fin de enviar menos bytes, angulos se miden en milesimas de grados
	if (key(_esc)) graph=-1;end; 
	playerdata.graph=graph;
	playerdata.shoot=disparando;
	// el siguiente bucle "for" almacena en la estructura playerdata el nick/alias del cliente mediante el cdigo ascii de los caracteres
	for (i=0;i<=7;i++);
	playerdata.asciinick[i]=nombre[i];
	end
	
	// la siguiente condicion y bucle "for" almacena en la estructura playerdata el mensaje del cliente mediante el cdigo ascii de los caracteres		
	if (chat==0)
		for (i=0;i<=12;i++);
		playerdata.asciimessage[i]=mensaje[i];
		end
		// Limpiamos la variable mensaje
		for (i=0;i<=12;i++)
		Mensaje[i]=0;
		end;
		//...
	end;		
		
	p=net_udp_getpacket(jugador);  // puntero al paquete jugador
	p.len=100; // longitud 100 del paquete de datos a enviar el servidor
	memcopy(p.data,&playerdata,100);
	net_udp_send(0,1,jugador);
	if (playerdata.shoot==1) disparando=2;end
	// recibimos coordenadas del servidor y mostramos su avion (disparos, explosiones, etc)
	p=net_udp_getpacket(0);
	net_udp_recv(jugador,0);
	memcopy(&playerdata,p.data,100);
	// el siguiente bucle "for" forma en la variable 'string nick' el nick/alias del servidor mediante el cdigo ascii de los caracteres
	nick="";
	for (i=0;i<=7;i++);
	if (playerdata.asciinick[i]<>0) nick+=chr(playerdata.asciinick[i]);end;
	end
			// la siguiente condicin y bucle "for" forman el mensaje recibido del servidor
			textomensaje="";
			if (playerdata.asciimessage[0]>0)
				for (j=0;j<=12;j++);
				if (playerdata.asciimessage[j]<>0) textomensaje+=chr(playerdata.asciimessage[j]);end;
				end
						if (posicion_textoy_chat<140) posicion_textoy_chat=180;lineasmensajes=0;
								for (j=0;j<=4;j++)
								delete_text(textomensajes[j]);
								end
						end;
			textomensajes[lineasmensajes]=write(0,5,posicion_textoy_chat,0,nick+ ": "+ textomensaje);
			posicion_textoy_chat=posicion_textoy_chat-10;lineasmensajes++;
			end;
	// Si recibimos que graph=-1 es que el servidor ha desconectado
	if (playerdata.graph==-1) write(0,5,35,0,"El servidor ("+nick+") ha desconectado");end

	nave(playerdata.x,playerdata.y,playerdata.graph,playerdata.angle,playerdata.shoot,explosionando[0],nick);
	// recibimos del servidor la informacion de los aviones de los clientes y los mostramos
		for (i=1;i<=jugadores-1;i++)
			if (i!=jugador)
			p=net_udp_getpacket(i);  // puntero al paquete i
			net_udp_recv(jugador,i);
			memcopy(&playerdata,p.data,100);nick="";
			// el siguiente bucle "for" forma en la variable 'string nick' el nick/alias del cliente i mediante el cdigo ascii de los caracteres
			nick="";
			for (j=0;i<=7;j++);
			if (playerdata.asciinick[j]<>0) nick+=chr(playerdata.asciinick[j]);end;
			end
			// la siguiente condicin y bucle "for" forman el mensaje recibido del jugador correspondiente
			textomensaje="";
			if (playerdata.asciimessage[0]>0)
				for (j=0;j<=12;j++);
				if (playerdata.asciimessage[j]<>0) textomensaje+=chr(playerdata.asciimessage[j]);end;
				end
						if (posicion_textoy_chat<140) posicion_textoy_chat=180;lineasmensajes=0;
								for (j=0;j<=4;j++)
								delete_text(textomensajes[j]);
								end
						end;
			textomensajes[lineasmensajes]=write(0,5,posicion_textoy_chat,0,nick+ ": "+ textomensaje);
			posicion_textoy_chat=posicion_textoy_chat-10;lineasmensajes++;
			end;
			// Si recibimos que graph=-1 es que el jugador correspondiente ha desconectado
			if (playerdata.graph==-1) write(0,5,25+(i*10),0,"El jugador "+i+" ("+nick+") ha desconectado");end
			nave(playerdata.x,playerdata.y,playerdata.graph,playerdata.angle,playerdata.shoot,explosionando[i],nick);
			end;
		end;
	frame;
	until (graph==-1) // Si graph=-1 es que hemos pulsado escape y hemos finalizado el programa
 	for  (i=0;i<=jugadores;i++);
	net_udp_freepacket(i); // vaciamos paquetes y cerramos sockets y funciones
	net_udp_close(i);
	end;
	net_quit();
	let_me_alone();
end

// input para la direccion ip y nick/alias
PROCESS Input (Int font, Int x, Int y, Int max_width, String default_text, Int IpONick)
private
i;
begin
	scan_code = 0 ;entry=default_text;
	max_width -= text_width(font, prompt) ;
	if (IpONick==0) 
			switch (opcion)
			case 2:
			write (0,5,5,0,"Introduce IP o HOST del servidor maestro");
			opcion=6;
			end;
			case 3:
			write (0,5,5,0,"Introduce IP o HOST del servidor a conectar");
			end;
			case 4:
			write (0,5,5,0,"Introduce IP o HOST del servidor maestro");
			opcion=7;
			end;
			end;
	else
	if (opcion<>6) write (0,5,5,0,"Introduce Nick o Alias - 8 caracteres mximo");else
	write (0,5,5,0,"Pon nombre del servidor - 8 caracteres mximo");end;
	
	end;
	
loop
	if scan_code == _ESC:       exit (0,"Fin");end
	if scan_code == _BACKSPACE: 
			If (IpONick==0) entry = substr (entry, 0, -2);
			else
			if (i>0 and Opcion<6) Nombre[i]=0;i--;end;
			if (i>0 and Opcion>5) Nombre_Servidor[i]=0;i--;end
			entry = substr (entry, 0, -2);end
	end;
	if scan_code == _ENTER:	   
		if (IpONick==0)
		if (entry=="") exit(0,"IP o HOST vaca");else 
					switch (opcion)
					case 3: // Cliente sin usar servidor maestro
					delete_text(0);cliente();return;
					end;
					case 6: // Servidor usando servidor maestro
					delete_text(0);maestro=entry;input (0,5,25,300,"",1);return;
					end;
					case 7: // Cliente usando servidor maestro
					delete_text(0);maestro=entry;input (0,5,25,300,"",1);
					return;
					end;
					end;
		end;
		else
		if (entry=="") exit (0,"Nombre, Nick o Alias vaco");else 
					switch (opcion)
					case -1: // Servidor autentificandose
					delete_text(0);servidor();return;
					end;
					case 1: // Servidor sin auntentificarse
					delete_text(0);servidor();return;
					end;
					case 3: // Cliente sin usar servidor maestro
					delete_text(0);input (0,5,25,300,"",0);return;
					end
					case 6: // Servidor autentificandose
					delete_text(0);opcion=-1;input (0,5,25,300,"",1);return;
					end
					case 7: // Cliente usando servidor maestro
					delete_text(0);cliente();return;
					end
					end
		end;
		end;
	end;
			
	scan_code = 0 ;

	If (IpONick==0)
		if ascii >= 32 AND text_width(font, entry) < max_width:
				entry += chr(ascii) ;
		ascii=0;
		end
	else
		if ascii >= 32 AND text_width(font, entry) < max_width and i<8:
				entry += chr(ascii);
				If (Opcion<>6) Nombre[i]=ascii;else Nombre_Servidor[i]=ascii;end;i++;
		ascii=0;
		end
	end;

	inputText = write (font, x, y, 0, entry + prompt);

	frame;

	delete_text (inputText);
end
end 

// input para el chat
PROCESS InputChat (Int font, Int x, Int y, Int max_width, String default_text)
private
i;
begin
	scan_code = 0 ; entry1=default_text;entry1 = substr (entry1, 0, -2);
	max_width -= text_width(font, prompt1) ;
loop
	if scan_code == _BACKSPACE: 
			Mensaje[i]=0;i--;entry1 = substr (entry1, 0, -2);
	end;
	if scan_code == _ENTER:
		chat=0;break;
	end;
			
	scan_code = 0 ;
	
		if ascii >= 32 AND text_width(font, entry) < max_width:
				entry1 += chr(ascii) ;Mensaje[i]=ascii;i++;
		ascii=0;
		end

	inputChat = write (font, x, y, 0, "(Mensaje): "+ entry1 + prompt1);

	frame;

	delete_text (inputChat);
end
end 

// procedimientos para mostrar el avion del servidor/cliente, sus disparos y explosiones
process nave (x,y,graph,angle,shoot,explos,string alias)
private
text;
begin
angle=angle*1000;
// Si el jugador est realizando disparos, llamamos a dicho proceso
if (shoot==1) pdisparo(x,y,angle);end
// Las dos siguientes condiciones sirven para determinar si llamamos al proceso explosin en el caso de que la
// nave haya sido dada
if (graph==0) if (explosionando[explos]==0) pexplosion(x,y,angle);explosionando[explos]=1;end;
else explosionando[explos]=0;text=write(0,0,0,4,alias);move_text(text,x,y);end
frame;
if (text>0) delete_text(text);end
end;

process pexplosion(x,y,angle)
begin
graph=1;
loop
graph++;
if (graph>5) return;end;
frame;
end;
end;

process pdisparo (x,y,angle)
begin
graph=disparo;
advance(10); // para evitar colision con el propio avion que lanza el disparo
repeat
advance(6);
frame;
until (x<0 or x>320 or y<0 or y>200 or collision (type nave) or collision(type servidor) or collision(type cliente))
end;