#!/bin/false

# marker
functions_found=yes

# see how to invoke FeenoX
feenox=""
for i in  ../feenox ../src/feenox ./feenox ./src/feenox ../../../bin/feenox /usr/local/bin/feenox; do
  if [ -z "${feenox}" ]; then
    if [ -f ${i} ]; then
      feenox=${i}
    fi
  fi 
done
if [ -z "${feenox}" ]; then
  echo "error: could not find feenox executable"
  exit 1
fi

# see where the inputs are
for i in  . tests; do
  if [ -f ${i}/functions.sh ]; then
    dir=${i}
  fi  
done


#######

exitifwrong() {
  if [ $1 != 0 ]; then
    exit $1
  fi  
}  

# checks if feenox is compiled with ida and skips the test if necessary
checkida() {
 if [ $(${feenox} --versions | grep 'SUNDIAL' | grep -v 'N/A'| wc -l) = 0 ]; then
  echo "FeenoX was not compiled with SUNDIALS, skipping test"
  exit 77
 fi
}

# checks if feenox is compiled with petsc and skips the test if necessary
checkpetsc() {
 if [ $(${feenox} --versions | grep 'PETSc' | grep -v 'N/A'| wc -l) = 0 ]; then
  echo "FeenoX was not compiled with PETSc, skipping test"
  exit 77
 fi
}


# checks if feenox is compiled with slepc and skips the test if necessary
checkslepc() {
 if [ $(${feenox} --versions | grep 'SLEPc' | grep -v 'N/A'| wc -l) = 0 ]; then
  echo "FeenoX was not compiled with SLEPc, skipping test"
  exit 77
 fi
}

checkpde() {
 checkpetsc
 if [ $(${feenox} --pdes | grep $1 | wc -l) = 0 ]; then
  echo "FeenoX was not compiled with $1, skipping test"
  exit 77
 fi
}

# checks if feenox is compiled with mumps and skips the test if necessary
checkmumps() {
 if [ $(${feenox} --versions | grep 'mumps' | grep -v 'N/A'| wc -l) = 0 ]; then
  echo "FeenoX was not compiled with MUMPS, skipping test"
  exit 77
 fi
}

# checks if feenox is compiled with mumps and skips the test if necessary
checkhypre() {
 if [ $(${feenox} --versions | grep 'hypre' | grep -v 'N/A'| wc -l) = 0 ]; then
  echo "FeenoX was not compiled with HYPRE, skipping test"
  exit 77
 fi
}


# checks if gmsh executable is available in the path
checkgmsh() {
 if [ -z "$(which gmsh)" ]; then
  echo "gmsh not found, skipping test"
  exit 77
 fi
}

# checks if mpirun is available
checkmpirun() {
 if [ -z "$(which mpirun)" ]; then
  echo "mpirun not found, skipping test"
  exit 77
 fi
 if [ "x$(id -u)" = "x0" ]; then
  echo "attempting to run MPI as root, skipping test"
  exit 77
 fi
}

answer() {
  echo -n "${1} ... "
  answer=$(${feenox} ${dir}/${1})
  error=$?
  
  if [ ${error} != 0 ]; then
    echo "failed"
    return 2
  fi
  
  if [ "${answer}" = "${2}" ]; then
    echo "ok"
    level=0
  else
    echo "wrong, expected '${2}' and got '${answer}'"
    level=1
  fi

  return ${level}
}

answermpi() {
  echo -n "${2} (${1} ranks) ... "
  answer=$(mpirun -n ${1} --map-by :OVERSUBSCRIBE ${feenox} ${dir}/${2})
  error=$?
  
  if [ ${error} != 0 ]; then
    echo "failed"
    return 2
  fi
  
  if [ "${answer}" = "${3}" ]; then
    echo "ok"
    level=0
  else
    echo "wrong, expected '${3}' and got '${answer}'"
    level=1
  fi

  return ${level}
}



answerdiff() {
  echo -n "${1} ... "
  base=$(basename ${1} .fee)
  ${feenox} ${dir}/${1} ${2} | sed 's/-0.0000/0.0000/g' > ${dir}/${base}.last
  error=$?
  
  if [ ${error} != 0 ]; then
    echo "failed"
    return 2
  fi
  
  
  difference=$(diff -w ${dir}/${base}.ref ${dir}/${base}.last)
  if [ -z "${difference}" ]; then
    echo "ok"
    level=0
  else
    echo "wrong, see ${base}.ref and ${base}.last"
    level=1
  fi
  
  return ${level}
}

answer1diff() {
  echo -n "${1} ... "
  base=$(basename ${1} .fee)
  ${feenox} ${dir}/${1} ${2} > ${dir}/${base}.last
  error=$?
  
  if [ ${error} != 0 ]; then
    echo "failed"
    return 2
  fi
  
  difference=$(diff -w ${dir}/${base}.ref ${dir}/${base}.last)
  if [ -z "${difference}" ]; then
    echo "ok"
    level=0
  else
    echo "wrong, see ${base}.ref and ${base}.last"
    level=1
  fi
  
  return ${level}
}


answerfloat() {
  echo -n "${1} ... "
  answer=$(${feenox} ${dir}/${1})
  error=$?
  
  if [ ${error} != 0 ]; then
    echo "failed"
    return 2
  fi

  if [ "$(${feenox} ${dir}/cmp-float.fee "(${answer})" "${2}" "${3}")" = "1" ]; then
    echo "ok"
    level=0
  else
    echo "wrong, expected '${2}' and got '${answer}'"
    level=1
  fi

  return ${level}
}

answerzero() {
  echo -n "${1} ... "
  answer=$(${feenox} ${dir}/${1})
  error=$?
  
  if [ ${error} != 0 ]; then
    return 2
  fi

  if [ -z "${2}" ]; then
    result=$(${feenox} ${dir}/cmp-zero.fee "(${answer})")
  else  
    result=$(${feenox} ${dir}/cmp-zero.fee "(${answer})" "${2}")
  fi  
  if [ "${result}" = "1" ]; then
    echo "ok"
    level=0
  else
    echo "wrong, expected zero and got '${answer}'"
    level=1
  fi

  return ${level}
}


answerzerompi() {
  echo -n "${2} (${1} ranks) ... "
  answer=$(mpirun -n ${1} --map-by :OVERSUBSCRIBE ${feenox} ${dir}/${2})
  error=$?
  
  if [ ${error} != 0 ]; then
    return 2
  fi

  if [ -z "${3}" ]; then
    result=$(${feenox} ${dir}/cmp-zero.fee "(${answer})")
  else  
    result=$(${feenox} ${dir}/cmp-zero.fee "(${answer})" "${3}")
  fi  
  if [ "${result}" = "1" ]; then
    echo "ok"
    level=0
  else
    echo "wrong, expected zero and got '${answer}'"
    level=1
  fi

  return ${level}
}


answerzero1() {
  echo -n "${1} ${2}... "
  answer=$(${feenox} ${dir}/${1} ${2})
  error=$?
  
  if [ ${error} != 0 ]; then
    return 2
  fi

  if [ -z "${3}" ]; then
    result=$(${feenox} ${dir}/cmp-zero.fee "(${answer})")
  else  
    result=$(${feenox} ${dir}/cmp-zero.fee "(${answer})" "${3}")
  fi  
  if [ "${result}" = "1" ]; then
    echo "ok"
    level=0
  else
    echo "wrong, expected zero and got '${answer}'"
    level=1
  fi

  return ${level}
}


answerzero2() {
  echo -n "${1} ${2} ${3}... "
  answer=$(${feenox} ${dir}/${1} ${2} ${3})
  error=$?
  
  if [ ${error} != 0 ]; then
    return 2
  fi

  if [ -z "${4}" ]; then
    result=$(${feenox} ${dir}/cmp-zero.fee "(${answer})")
  else  
    result=$(${feenox} ${dir}/cmp-zero.fee "(${answer})" "${4}")
  fi  
  if [ "${result}" = "1" ]; then
    echo "ok"
    level=0
  else
    echo "wrong, expected zero and got '${answer}'"
    level=1
  fi

  return ${level}
}

answer1() {
  echo -n "${1} ${2} ... "
  answer=$(${feenox} ${dir}/${1} ${2})
  error=$?
  
  if [ ${error} != 0 ]; then
    return 2
  fi
  
  if [ "${answer}" = "${3}" ]; then
    echo "ok"
    level=0
  else
    echo "wrong, expected '${3}' and got '${answer}'"
    level=1
  fi

  return ${level}
}

answer2() {
  echo -n "${1} ${2} ${3}... "
  answer=$(${feenox} ${dir}/${1} ${2} ${3})
  error=$?
  
  if [ ${error} != 0 ]; then
    return 2
  fi
  
  if [ "${answer}" = "${4}" ]; then
    echo "ok"
    level=0
  else
    echo "wrong, expected '${4}' and got '${answer}'"
    level=1
  fi

  return ${level}
}

answerfloat() {
  echo -n "${1} ... "
  answer=$(${feenox} ${dir}/${1})
  error=$?
  
  if [ ${error} != 0 ]; then
    echo "failed"
    return 2
  fi

  if [ "$(${feenox} ${dir}/cmp-float.fee "(${answer})" "${2}" "${3}")" = "1" ]; then
    echo "ok"
    level=0
  else
    echo "wrong, expected '${2}' and got '${answer}'"
    level=1
  fi

  return ${level}
}


answer1float() {
  echo -n "${1} ${2} ... "
  answer=$(${feenox} ${dir}/${1} ${2})
  error=$?
  
  if [ ${error} != 0 ]; then
    echo "failed"
    return 2
  fi
  
  if [ -z "${4}" ]; then
    result=$(${feenox} ${dir}/cmp-float.fee "(${answer})" "${3}")
  else  
    result=$(${feenox} ${dir}/cmp-float.fee "(${answer})" "${3}" "${4}")
  fi  
  
  if [ "${result}" = "1" ]; then
    echo "ok"
    level=0
  else
    echo "wrong, expected '${3}' and got '${answer}'"
    level=1
  fi

  return ${level}
}

answer1zero() {
  echo -n "${1} ${2} ... "
  answer=$(${feenox} ${dir}/${1} ${2})
  error=$?
  
  if [ ${error} != 0 ]; then
    echo "failed"
    return 2
  fi

  if [ -z "${3}" ]; then
    result=$(${feenox} ${dir}/cmp-zero.fee "(${answer})")
  else  
    result=$(${feenox} ${dir}/cmp-zero.fee "(${answer})" "${3}")
  fi  
  if [ "${result}" = "1" ]; then
    echo "ok"
    level=0
  else
    echo "wrong, expected zero and got '${answer}'"
    level=1
  fi

  return ${level}
}


answer2sorthead1() {
  answer=$(${feenox} ${dir}/$1 $2 $3 | sort -rg | head -n1)
  error=$?
  
  if [ ${error} != 0 ]; then
    echo "failed"
    return 2
  fi
  
  if [ "${answer}" = "$4" ]; then
    echo "ok"
    level=0
  else
    echo "wrong"
    level=1
  fi

  return ${level}
}
