/* $Id: DuplicateName.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/reporting/DuplicateName.hpp"

namespace ast {

DuplicateName::DuplicateName(
	const AstNode& dupNode, 
	const AstNode& referring,
	std::string dName
	) : 	CompileError(dupNode, ""),
		firstLoc(referring.location),
		name(dName)
{
}

void
DuplicateName::put(std::ostream& stream) const
{
	stream << this->location << ": "
	       << "Symbol <" << this->name << "> redefined. " 
	       << "First defined here: " << this->firstLoc;
}

}; /* namespace ast */
