#define _REENTRANT

#include <cuda.h>
#include <cupti.h>
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

#include <eztrace-lib/eztrace.h>
#include <eztrace-core/eztrace_config.h>

/* This file intercepts calls to the CUDA runtime API.
 * Since nvcc statically links the application against cuda by default, we cannot use the usual LD_PRELOAD method.
 * Instead, we use cupti callback API.
 */

struct cuda_runtime_api_info {
  enum CUpti_runtime_api_trace_cbid_enum id;
  char *function_name;
  OTF2_RegionRef region;
};

static struct cuda_runtime_api_info cuda_runtime_api_info[] = {
  {.id=CUPTI_RUNTIME_TRACE_CBID_INVALID, .function_name="cuda::runtime::INVALID", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDriverGetVersion_v3020, .function_name="cuda::runtime::cudaDriverGetVersion", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaRuntimeGetVersion_v3020, .function_name="cuda::runtime::cudaRuntimeGetVersion", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetDeviceCount_v3020, .function_name="cuda::runtime::cudaGetDeviceCount", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetDeviceProperties_v3020, .function_name="cuda::runtime::cudaGetDeviceProperties", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaChooseDevice_v3020, .function_name="cuda::runtime::cudaChooseDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetChannelDesc_v3020, .function_name="cuda::runtime::cudaGetChannelDesc", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaCreateChannelDesc_v3020, .function_name="cuda::runtime::cudaCreateChannelDesc", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaConfigureCall_v3020, .function_name="cuda::runtime::cudaConfigureCall", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaSetupArgument_v3020, .function_name="cuda::runtime::cudaSetupArgument", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetLastError_v3020, .function_name="cuda::runtime::cudaGetLastError", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaPeekAtLastError_v3020, .function_name="cuda::runtime::cudaPeekAtLastError", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetErrorString_v3020, .function_name="cuda::runtime::cudaGetErrorString", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaLaunch_v3020, .function_name="cuda::runtime::cudaLaunch", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaFuncSetCacheConfig_v3020, .function_name="cuda::runtime::cudaFuncSetCacheConfig", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaFuncGetAttributes_v3020, .function_name="cuda::runtime::cudaFuncGetAttributes", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaSetDevice_v3020, .function_name="cuda::runtime::cudaSetDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetDevice_v3020, .function_name="cuda::runtime::cudaGetDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaSetValidDevices_v3020, .function_name="cuda::runtime::cudaSetValidDevices", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaSetDeviceFlags_v3020, .function_name="cuda::runtime::cudaSetDeviceFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMalloc_v3020, .function_name="cuda::runtime::cudaMalloc", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMallocPitch_v3020, .function_name="cuda::runtime::cudaMallocPitch", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaFree_v3020, .function_name="cuda::runtime::cudaFree", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMallocArray_v3020, .function_name="cuda::runtime::cudaMallocArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaFreeArray_v3020, .function_name="cuda::runtime::cudaFreeArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMallocHost_v3020, .function_name="cuda::runtime::cudaMallocHost", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaFreeHost_v3020, .function_name="cuda::runtime::cudaFreeHost", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaHostAlloc_v3020, .function_name="cuda::runtime::cudaHostAlloc", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaHostGetDevicePointer_v3020, .function_name="cuda::runtime::cudaHostGetDevicePointer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaHostGetFlags_v3020, .function_name="cuda::runtime::cudaHostGetFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemGetInfo_v3020, .function_name="cuda::runtime::cudaMemGetInfo", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy_v3020, .function_name="cuda::runtime::cudaMemcpy", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2D_v3020, .function_name="cuda::runtime::cudaMemcpy2D", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToArray_v3020, .function_name="cuda::runtime::cudaMemcpyToArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DToArray_v3020, .function_name="cuda::runtime::cudaMemcpy2DToArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromArray_v3020, .function_name="cuda::runtime::cudaMemcpyFromArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DFromArray_v3020, .function_name="cuda::runtime::cudaMemcpy2DFromArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyArrayToArray_v3020, .function_name="cuda::runtime::cudaMemcpyArrayToArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DArrayToArray_v3020, .function_name="cuda::runtime::cudaMemcpy2DArrayToArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToSymbol_v3020, .function_name="cuda::runtime::cudaMemcpyToSymbol", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromSymbol_v3020, .function_name="cuda::runtime::cudaMemcpyFromSymbol", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyAsync_v3020, .function_name="cuda::runtime::cudaMemcpyAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToArrayAsync_v3020, .function_name="cuda::runtime::cudaMemcpyToArrayAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromArrayAsync_v3020, .function_name="cuda::runtime::cudaMemcpyFromArrayAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DAsync_v3020, .function_name="cuda::runtime::cudaMemcpy2DAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DToArrayAsync_v3020, .function_name="cuda::runtime::cudaMemcpy2DToArrayAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DFromArrayAsync_v3020, .function_name="cuda::runtime::cudaMemcpy2DFromArrayAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToSymbolAsync_v3020, .function_name="cuda::runtime::cudaMemcpyToSymbolAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromSymbolAsync_v3020, .function_name="cuda::runtime::cudaMemcpyFromSymbolAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemset_v3020, .function_name="cuda::runtime::cudaMemset", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemset2D_v3020, .function_name="cuda::runtime::cudaMemset2D", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemsetAsync_v3020, .function_name="cuda::runtime::cudaMemsetAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemset2DAsync_v3020, .function_name="cuda::runtime::cudaMemset2DAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetSymbolAddress_v3020, .function_name="cuda::runtime::cudaGetSymbolAddress", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetSymbolSize_v3020, .function_name="cuda::runtime::cudaGetSymbolSize", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaBindTexture_v3020, .function_name="cuda::runtime::cudaBindTexture", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaBindTexture2D_v3020, .function_name="cuda::runtime::cudaBindTexture2D", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaBindTextureToArray_v3020, .function_name="cuda::runtime::cudaBindTextureToArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaUnbindTexture_v3020, .function_name="cuda::runtime::cudaUnbindTexture", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetTextureAlignmentOffset_v3020, .function_name="cuda::runtime::cudaGetTextureAlignmentOffset", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetTextureReference_v3020, .function_name="cuda::runtime::cudaGetTextureReference", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaBindSurfaceToArray_v3020, .function_name="cuda::runtime::cudaBindSurfaceToArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetSurfaceReference_v3020, .function_name="cuda::runtime::cudaGetSurfaceReference", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGLSetGLDevice_v3020, .function_name="cuda::runtime::cudaGLSetGLDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGLRegisterBufferObject_v3020, .function_name="cuda::runtime::cudaGLRegisterBufferObject", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGLMapBufferObject_v3020, .function_name="cuda::runtime::cudaGLMapBufferObject", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGLUnmapBufferObject_v3020, .function_name="cuda::runtime::cudaGLUnmapBufferObject", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGLUnregisterBufferObject_v3020, .function_name="cuda::runtime::cudaGLUnregisterBufferObject", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGLSetBufferObjectMapFlags_v3020, .function_name="cuda::runtime::cudaGLSetBufferObjectMapFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGLMapBufferObjectAsync_v3020, .function_name="cuda::runtime::cudaGLMapBufferObjectAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGLUnmapBufferObjectAsync_v3020, .function_name="cuda::runtime::cudaGLUnmapBufferObjectAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaWGLGetDevice_v3020, .function_name="cuda::runtime::cudaWGLGetDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsGLRegisterImage_v3020, .function_name="cuda::runtime::cudaGraphicsGLRegisterImage", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsGLRegisterBuffer_v3020, .function_name="cuda::runtime::cudaGraphicsGLRegisterBuffer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsUnregisterResource_v3020, .function_name="cuda::runtime::cudaGraphicsUnregisterResource", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsResourceSetMapFlags_v3020, .function_name="cuda::runtime::cudaGraphicsResourceSetMapFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsMapResources_v3020, .function_name="cuda::runtime::cudaGraphicsMapResources", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsUnmapResources_v3020, .function_name="cuda::runtime::cudaGraphicsUnmapResources", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsResourceGetMappedPointer_v3020, .function_name="cuda::runtime::cudaGraphicsResourceGetMappedPointer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsSubResourceGetMappedArray_v3020, .function_name="cuda::runtime::cudaGraphicsSubResourceGetMappedArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaVDPAUGetDevice_v3020, .function_name="cuda::runtime::cudaVDPAUGetDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaVDPAUSetVDPAUDevice_v3020, .function_name="cuda::runtime::cudaVDPAUSetVDPAUDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsVDPAURegisterVideoSurface_v3020, .function_name="cuda::runtime::cudaGraphicsVDPAURegisterVideoSurface", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsVDPAURegisterOutputSurface_v3020, .function_name="cuda::runtime::cudaGraphicsVDPAURegisterOutputSurface", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D11GetDevice_v3020, .function_name="cuda::runtime::cudaD3D11GetDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D11GetDevices_v3020, .function_name="cuda::runtime::cudaD3D11GetDevices", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D11SetDirect3DDevice_v3020, .function_name="cuda::runtime::cudaD3D11SetDirect3DDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsD3D11RegisterResource_v3020, .function_name="cuda::runtime::cudaGraphicsD3D11RegisterResource", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D10GetDevice_v3020, .function_name="cuda::runtime::cudaD3D10GetDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D10GetDevices_v3020, .function_name="cuda::runtime::cudaD3D10GetDevices", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D10SetDirect3DDevice_v3020, .function_name="cuda::runtime::cudaD3D10SetDirect3DDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsD3D10RegisterResource_v3020, .function_name="cuda::runtime::cudaGraphicsD3D10RegisterResource", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D10RegisterResource_v3020, .function_name="cuda::runtime::cudaD3D10RegisterResource", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D10UnregisterResource_v3020, .function_name="cuda::runtime::cudaD3D10UnregisterResource", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D10MapResources_v3020, .function_name="cuda::runtime::cudaD3D10MapResources", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D10UnmapResources_v3020, .function_name="cuda::runtime::cudaD3D10UnmapResources", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D10ResourceSetMapFlags_v3020, .function_name="cuda::runtime::cudaD3D10ResourceSetMapFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D10ResourceGetSurfaceDimensions_v3020, .function_name="cuda::runtime::cudaD3D10ResourceGetSurfaceDimensions", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D10ResourceGetMappedArray_v3020, .function_name="cuda::runtime::cudaD3D10ResourceGetMappedArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D10ResourceGetMappedPointer_v3020, .function_name="cuda::runtime::cudaD3D10ResourceGetMappedPointer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D10ResourceGetMappedSize_v3020, .function_name="cuda::runtime::cudaD3D10ResourceGetMappedSize", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D10ResourceGetMappedPitch_v3020, .function_name="cuda::runtime::cudaD3D10ResourceGetMappedPitch", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9GetDevice_v3020, .function_name="cuda::runtime::cudaD3D9GetDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9GetDevices_v3020, .function_name="cuda::runtime::cudaD3D9GetDevices", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9SetDirect3DDevice_v3020, .function_name="cuda::runtime::cudaD3D9SetDirect3DDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9GetDirect3DDevice_v3020, .function_name="cuda::runtime::cudaD3D9GetDirect3DDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsD3D9RegisterResource_v3020, .function_name="cuda::runtime::cudaGraphicsD3D9RegisterResource", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9RegisterResource_v3020, .function_name="cuda::runtime::cudaD3D9RegisterResource", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9UnregisterResource_v3020, .function_name="cuda::runtime::cudaD3D9UnregisterResource", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9MapResources_v3020, .function_name="cuda::runtime::cudaD3D9MapResources", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9UnmapResources_v3020, .function_name="cuda::runtime::cudaD3D9UnmapResources", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9ResourceSetMapFlags_v3020, .function_name="cuda::runtime::cudaD3D9ResourceSetMapFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9ResourceGetSurfaceDimensions_v3020, .function_name="cuda::runtime::cudaD3D9ResourceGetSurfaceDimensions", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9ResourceGetMappedArray_v3020, .function_name="cuda::runtime::cudaD3D9ResourceGetMappedArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9ResourceGetMappedPointer_v3020, .function_name="cuda::runtime::cudaD3D9ResourceGetMappedPointer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9ResourceGetMappedSize_v3020, .function_name="cuda::runtime::cudaD3D9ResourceGetMappedSize", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9ResourceGetMappedPitch_v3020, .function_name="cuda::runtime::cudaD3D9ResourceGetMappedPitch", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9Begin_v3020, .function_name="cuda::runtime::cudaD3D9Begin", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9End_v3020, .function_name="cuda::runtime::cudaD3D9End", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9RegisterVertexBuffer_v3020, .function_name="cuda::runtime::cudaD3D9RegisterVertexBuffer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9UnregisterVertexBuffer_v3020, .function_name="cuda::runtime::cudaD3D9UnregisterVertexBuffer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9MapVertexBuffer_v3020, .function_name="cuda::runtime::cudaD3D9MapVertexBuffer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D9UnmapVertexBuffer_v3020, .function_name="cuda::runtime::cudaD3D9UnmapVertexBuffer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaThreadExit_v3020, .function_name="cuda::runtime::cudaThreadExit", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaSetDoubleForDevice_v3020, .function_name="cuda::runtime::cudaSetDoubleForDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaSetDoubleForHost_v3020, .function_name="cuda::runtime::cudaSetDoubleForHost", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaThreadSynchronize_v3020, .function_name="cuda::runtime::cudaThreadSynchronize", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaThreadGetLimit_v3020, .function_name="cuda::runtime::cudaThreadGetLimit", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaThreadSetLimit_v3020, .function_name="cuda::runtime::cudaThreadSetLimit", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamCreate_v3020, .function_name="cuda::runtime::cudaStreamCreate", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamDestroy_v3020, .function_name="cuda::runtime::cudaStreamDestroy", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamSynchronize_v3020, .function_name="cuda::runtime::cudaStreamSynchronize", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamQuery_v3020, .function_name="cuda::runtime::cudaStreamQuery", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEventCreate_v3020, .function_name="cuda::runtime::cudaEventCreate", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEventCreateWithFlags_v3020, .function_name="cuda::runtime::cudaEventCreateWithFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEventRecord_v3020, .function_name="cuda::runtime::cudaEventRecord", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEventDestroy_v3020, .function_name="cuda::runtime::cudaEventDestroy", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEventSynchronize_v3020, .function_name="cuda::runtime::cudaEventSynchronize", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEventQuery_v3020, .function_name="cuda::runtime::cudaEventQuery", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEventElapsedTime_v3020, .function_name="cuda::runtime::cudaEventElapsedTime", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMalloc3D_v3020, .function_name="cuda::runtime::cudaMalloc3D", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMalloc3DArray_v3020, .function_name="cuda::runtime::cudaMalloc3DArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemset3D_v3020, .function_name="cuda::runtime::cudaMemset3D", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemset3DAsync_v3020, .function_name="cuda::runtime::cudaMemset3DAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3D_v3020, .function_name="cuda::runtime::cudaMemcpy3D", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3DAsync_v3020, .function_name="cuda::runtime::cudaMemcpy3DAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaThreadSetCacheConfig_v3020, .function_name="cuda::runtime::cudaThreadSetCacheConfig", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamWaitEvent_v3020, .function_name="cuda::runtime::cudaStreamWaitEvent", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D11GetDirect3DDevice_v3020, .function_name="cuda::runtime::cudaD3D11GetDirect3DDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaD3D10GetDirect3DDevice_v3020, .function_name="cuda::runtime::cudaD3D10GetDirect3DDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaThreadGetCacheConfig_v3020, .function_name="cuda::runtime::cudaThreadGetCacheConfig", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaPointerGetAttributes_v4000, .function_name="cuda::runtime::cudaPointerGetAttributes", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaHostRegister_v4000, .function_name="cuda::runtime::cudaHostRegister", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaHostUnregister_v4000, .function_name="cuda::runtime::cudaHostUnregister", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceCanAccessPeer_v4000, .function_name="cuda::runtime::cudaDeviceCanAccessPeer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceEnablePeerAccess_v4000, .function_name="cuda::runtime::cudaDeviceEnablePeerAccess", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceDisablePeerAccess_v4000, .function_name="cuda::runtime::cudaDeviceDisablePeerAccess", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaPeerRegister_v4000, .function_name="cuda::runtime::cudaPeerRegister", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaPeerUnregister_v4000, .function_name="cuda::runtime::cudaPeerUnregister", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaPeerGetDevicePointer_v4000, .function_name="cuda::runtime::cudaPeerGetDevicePointer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyPeer_v4000, .function_name="cuda::runtime::cudaMemcpyPeer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyPeerAsync_v4000, .function_name="cuda::runtime::cudaMemcpyPeerAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3DPeer_v4000, .function_name="cuda::runtime::cudaMemcpy3DPeer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3DPeerAsync_v4000, .function_name="cuda::runtime::cudaMemcpy3DPeerAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceReset_v3020, .function_name="cuda::runtime::cudaDeviceReset", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceSynchronize_v3020, .function_name="cuda::runtime::cudaDeviceSynchronize", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetLimit_v3020, .function_name="cuda::runtime::cudaDeviceGetLimit", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceSetLimit_v3020, .function_name="cuda::runtime::cudaDeviceSetLimit", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetCacheConfig_v3020, .function_name="cuda::runtime::cudaDeviceGetCacheConfig", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceSetCacheConfig_v3020, .function_name="cuda::runtime::cudaDeviceSetCacheConfig", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaProfilerInitialize_v4000, .function_name="cuda::runtime::cudaProfilerInitialize", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaProfilerStart_v4000, .function_name="cuda::runtime::cudaProfilerStart", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaProfilerStop_v4000, .function_name="cuda::runtime::cudaProfilerStop", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetByPCIBusId_v4010, .function_name="cuda::runtime::cudaDeviceGetByPCIBusId", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetPCIBusId_v4010, .function_name="cuda::runtime::cudaDeviceGetPCIBusId", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGLGetDevices_v4010, .function_name="cuda::runtime::cudaGLGetDevices", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaIpcGetEventHandle_v4010, .function_name="cuda::runtime::cudaIpcGetEventHandle", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaIpcOpenEventHandle_v4010, .function_name="cuda::runtime::cudaIpcOpenEventHandle", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaIpcGetMemHandle_v4010, .function_name="cuda::runtime::cudaIpcGetMemHandle", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaIpcOpenMemHandle_v4010, .function_name="cuda::runtime::cudaIpcOpenMemHandle", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaIpcCloseMemHandle_v4010, .function_name="cuda::runtime::cudaIpcCloseMemHandle", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaArrayGetInfo_v4010, .function_name="cuda::runtime::cudaArrayGetInfo", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaFuncSetSharedMemConfig_v4020, .function_name="cuda::runtime::cudaFuncSetSharedMemConfig", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetSharedMemConfig_v4020, .function_name="cuda::runtime::cudaDeviceGetSharedMemConfig", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceSetSharedMemConfig_v4020, .function_name="cuda::runtime::cudaDeviceSetSharedMemConfig", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaCreateTextureObject_v5000, .function_name="cuda::runtime::cudaCreateTextureObject", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDestroyTextureObject_v5000, .function_name="cuda::runtime::cudaDestroyTextureObject", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetTextureObjectResourceDesc_v5000, .function_name="cuda::runtime::cudaGetTextureObjectResourceDesc", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetTextureObjectTextureDesc_v5000, .function_name="cuda::runtime::cudaGetTextureObjectTextureDesc", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaCreateSurfaceObject_v5000, .function_name="cuda::runtime::cudaCreateSurfaceObject", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDestroySurfaceObject_v5000, .function_name="cuda::runtime::cudaDestroySurfaceObject", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetSurfaceObjectResourceDesc_v5000, .function_name="cuda::runtime::cudaGetSurfaceObjectResourceDesc", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMallocMipmappedArray_v5000, .function_name="cuda::runtime::cudaMallocMipmappedArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetMipmappedArrayLevel_v5000, .function_name="cuda::runtime::cudaGetMipmappedArrayLevel", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaFreeMipmappedArray_v5000, .function_name="cuda::runtime::cudaFreeMipmappedArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaBindTextureToMipmappedArray_v5000, .function_name="cuda::runtime::cudaBindTextureToMipmappedArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsResourceGetMappedMipmappedArray_v5000, .function_name="cuda::runtime::cudaGraphicsResourceGetMappedMipmappedArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamAddCallback_v5000, .function_name="cuda::runtime::cudaStreamAddCallback", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamCreateWithFlags_v5000, .function_name="cuda::runtime::cudaStreamCreateWithFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetTextureObjectResourceViewDesc_v5000, .function_name="cuda::runtime::cudaGetTextureObjectResourceViewDesc", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetAttribute_v5000, .function_name="cuda::runtime::cudaDeviceGetAttribute", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamDestroy_v5050, .function_name="cuda::runtime::cudaStreamDestroy", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamCreateWithPriority_v5050, .function_name="cuda::runtime::cudaStreamCreateWithPriority", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetPriority_v5050, .function_name="cuda::runtime::cudaStreamGetPriority", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetFlags_v5050, .function_name="cuda::runtime::cudaStreamGetFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetStreamPriorityRange_v5050, .function_name="cuda::runtime::cudaDeviceGetStreamPriorityRange", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMallocManaged_v6000, .function_name="cuda::runtime::cudaMallocManaged", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaOccupancyMaxActiveBlocksPerMultiprocessor_v6000, .function_name="cuda::runtime::cudaOccupancyMaxActiveBlocksPerMultiprocessor", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamAttachMemAsync_v6000, .function_name="cuda::runtime::cudaStreamAttachMemAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetErrorName_v6050, .function_name="cuda::runtime::cudaGetErrorName", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaOccupancyMaxActiveBlocksPerMultiprocessor_v6050, .function_name="cuda::runtime::cudaOccupancyMaxActiveBlocksPerMultiprocessor", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaLaunchKernel_v7000, .function_name="cuda::runtime::cudaLaunchKernel", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetDeviceFlags_v7000, .function_name="cuda::runtime::cudaGetDeviceFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaLaunch_ptsz_v7000, .function_name="cuda::runtime::cudaLaunch_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaLaunchKernel_ptsz_v7000, .function_name="cuda::runtime::cudaLaunchKernel_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy_ptds_v7000, .function_name="cuda::runtime::cudaMemcpy_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2D_ptds_v7000, .function_name="cuda::runtime::cudaMemcpy2D_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToArray_ptds_v7000, .function_name="cuda::runtime::cudaMemcpyToArray_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DToArray_ptds_v7000, .function_name="cuda::runtime::cudaMemcpy2DToArray_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromArray_ptds_v7000, .function_name="cuda::runtime::cudaMemcpyFromArray_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DFromArray_ptds_v7000, .function_name="cuda::runtime::cudaMemcpy2DFromArray_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyArrayToArray_ptds_v7000, .function_name="cuda::runtime::cudaMemcpyArrayToArray_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DArrayToArray_ptds_v7000, .function_name="cuda::runtime::cudaMemcpy2DArrayToArray_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToSymbol_ptds_v7000, .function_name="cuda::runtime::cudaMemcpyToSymbol_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromSymbol_ptds_v7000, .function_name="cuda::runtime::cudaMemcpyFromSymbol_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyAsync_ptsz_v7000, .function_name="cuda::runtime::cudaMemcpyAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToArrayAsync_ptsz_v7000, .function_name="cuda::runtime::cudaMemcpyToArrayAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromArrayAsync_ptsz_v7000, .function_name="cuda::runtime::cudaMemcpyFromArrayAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DAsync_ptsz_v7000, .function_name="cuda::runtime::cudaMemcpy2DAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DToArrayAsync_ptsz_v7000, .function_name="cuda::runtime::cudaMemcpy2DToArrayAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy2DFromArrayAsync_ptsz_v7000, .function_name="cuda::runtime::cudaMemcpy2DFromArrayAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyToSymbolAsync_ptsz_v7000, .function_name="cuda::runtime::cudaMemcpyToSymbolAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpyFromSymbolAsync_ptsz_v7000, .function_name="cuda::runtime::cudaMemcpyFromSymbolAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemset_ptds_v7000, .function_name="cuda::runtime::cudaMemset_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemset2D_ptds_v7000, .function_name="cuda::runtime::cudaMemset2D_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemsetAsync_ptsz_v7000, .function_name="cuda::runtime::cudaMemsetAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemset2DAsync_ptsz_v7000, .function_name="cuda::runtime::cudaMemset2DAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetPriority_ptsz_v7000, .function_name="cuda::runtime::cudaStreamGetPriority_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetFlags_ptsz_v7000, .function_name="cuda::runtime::cudaStreamGetFlags_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamSynchronize_ptsz_v7000, .function_name="cuda::runtime::cudaStreamSynchronize_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamQuery_ptsz_v7000, .function_name="cuda::runtime::cudaStreamQuery_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamAttachMemAsync_ptsz_v7000, .function_name="cuda::runtime::cudaStreamAttachMemAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEventRecord_ptsz_v7000, .function_name="cuda::runtime::cudaEventRecord_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemset3D_ptds_v7000, .function_name="cuda::runtime::cudaMemset3D_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemset3DAsync_ptsz_v7000, .function_name="cuda::runtime::cudaMemset3DAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3D_ptds_v7000, .function_name="cuda::runtime::cudaMemcpy3D_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3DAsync_ptsz_v7000, .function_name="cuda::runtime::cudaMemcpy3DAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamWaitEvent_ptsz_v7000, .function_name="cuda::runtime::cudaStreamWaitEvent_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamAddCallback_ptsz_v7000, .function_name="cuda::runtime::cudaStreamAddCallback_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3DPeer_ptds_v7000, .function_name="cuda::runtime::cudaMemcpy3DPeer_ptds", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemcpy3DPeerAsync_ptsz_v7000, .function_name="cuda::runtime::cudaMemcpy3DPeerAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags_v7000, .function_name="cuda::runtime::cudaOccupancyMaxActiveBlocksPerMultiprocessorWithFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemPrefetchAsync_v8000, .function_name="cuda::runtime::cudaMemPrefetchAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemPrefetchAsync_ptsz_v8000, .function_name="cuda::runtime::cudaMemPrefetchAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemAdvise_v8000, .function_name="cuda::runtime::cudaMemAdvise", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetP2PAttribute_v8000, .function_name="cuda::runtime::cudaDeviceGetP2PAttribute", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsEGLRegisterImage_v7000, .function_name="cuda::runtime::cudaGraphicsEGLRegisterImage", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamConsumerConnect_v7000, .function_name="cuda::runtime::cudaEGLStreamConsumerConnect", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamConsumerDisconnect_v7000, .function_name="cuda::runtime::cudaEGLStreamConsumerDisconnect", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamConsumerAcquireFrame_v7000, .function_name="cuda::runtime::cudaEGLStreamConsumerAcquireFrame", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamConsumerReleaseFrame_v7000, .function_name="cuda::runtime::cudaEGLStreamConsumerReleaseFrame", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamProducerConnect_v7000, .function_name="cuda::runtime::cudaEGLStreamProducerConnect", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamProducerDisconnect_v7000, .function_name="cuda::runtime::cudaEGLStreamProducerDisconnect", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamProducerPresentFrame_v7000, .function_name="cuda::runtime::cudaEGLStreamProducerPresentFrame", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamProducerReturnFrame_v7000, .function_name="cuda::runtime::cudaEGLStreamProducerReturnFrame", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphicsResourceGetMappedEglFrame_v7000, .function_name="cuda::runtime::cudaGraphicsResourceGetMappedEglFrame", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemRangeGetAttribute_v8000, .function_name="cuda::runtime::cudaMemRangeGetAttribute", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemRangeGetAttributes_v8000, .function_name="cuda::runtime::cudaMemRangeGetAttributes", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEGLStreamConsumerConnectWithFlags_v7000, .function_name="cuda::runtime::cudaEGLStreamConsumerConnectWithFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaLaunchCooperativeKernel_v9000, .function_name="cuda::runtime::cudaLaunchCooperativeKernel", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaLaunchCooperativeKernel_ptsz_v9000, .function_name="cuda::runtime::cudaLaunchCooperativeKernel_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEventCreateFromEGLSync_v9000, .function_name="cuda::runtime::cudaEventCreateFromEGLSync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaLaunchCooperativeKernelMultiDevice_v9000, .function_name="cuda::runtime::cudaLaunchCooperativeKernelMultiDevice", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaFuncSetAttribute_v9000, .function_name="cuda::runtime::cudaFuncSetAttribute", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaImportExternalMemory_v10000, .function_name="cuda::runtime::cudaImportExternalMemory", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaExternalMemoryGetMappedBuffer_v10000, .function_name="cuda::runtime::cudaExternalMemoryGetMappedBuffer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaExternalMemoryGetMappedMipmappedArray_v10000, .function_name="cuda::runtime::cudaExternalMemoryGetMappedMipmappedArray", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDestroyExternalMemory_v10000, .function_name="cuda::runtime::cudaDestroyExternalMemory", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaImportExternalSemaphore_v10000, .function_name="cuda::runtime::cudaImportExternalSemaphore", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaSignalExternalSemaphoresAsync_v10000, .function_name="cuda::runtime::cudaSignalExternalSemaphoresAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaSignalExternalSemaphoresAsync_ptsz_v10000, .function_name="cuda::runtime::cudaSignalExternalSemaphoresAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaWaitExternalSemaphoresAsync_v10000, .function_name="cuda::runtime::cudaWaitExternalSemaphoresAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaWaitExternalSemaphoresAsync_ptsz_v10000, .function_name="cuda::runtime::cudaWaitExternalSemaphoresAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDestroyExternalSemaphore_v10000, .function_name="cuda::runtime::cudaDestroyExternalSemaphore", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaLaunchHostFunc_v10000, .function_name="cuda::runtime::cudaLaunchHostFunc", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaLaunchHostFunc_ptsz_v10000, .function_name="cuda::runtime::cudaLaunchHostFunc_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphCreate_v10000, .function_name="cuda::runtime::cudaGraphCreate", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphKernelNodeGetParams_v10000, .function_name="cuda::runtime::cudaGraphKernelNodeGetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphKernelNodeSetParams_v10000, .function_name="cuda::runtime::cudaGraphKernelNodeSetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddKernelNode_v10000, .function_name="cuda::runtime::cudaGraphAddKernelNode", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddMemcpyNode_v10000, .function_name="cuda::runtime::cudaGraphAddMemcpyNode", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemcpyNodeGetParams_v10000, .function_name="cuda::runtime::cudaGraphMemcpyNodeGetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemcpyNodeSetParams_v10000, .function_name="cuda::runtime::cudaGraphMemcpyNodeSetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddMemsetNode_v10000, .function_name="cuda::runtime::cudaGraphAddMemsetNode", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemsetNodeGetParams_v10000, .function_name="cuda::runtime::cudaGraphMemsetNodeGetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemsetNodeSetParams_v10000, .function_name="cuda::runtime::cudaGraphMemsetNodeSetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddHostNode_v10000, .function_name="cuda::runtime::cudaGraphAddHostNode", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphHostNodeGetParams_v10000, .function_name="cuda::runtime::cudaGraphHostNodeGetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddChildGraphNode_v10000, .function_name="cuda::runtime::cudaGraphAddChildGraphNode", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphChildGraphNodeGetGraph_v10000, .function_name="cuda::runtime::cudaGraphChildGraphNodeGetGraph", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddEmptyNode_v10000, .function_name="cuda::runtime::cudaGraphAddEmptyNode", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphClone_v10000, .function_name="cuda::runtime::cudaGraphClone", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeFindInClone_v10000, .function_name="cuda::runtime::cudaGraphNodeFindInClone", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeGetType_v10000, .function_name="cuda::runtime::cudaGraphNodeGetType", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphGetRootNodes_v10000, .function_name="cuda::runtime::cudaGraphGetRootNodes", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeGetDependencies_v10000, .function_name="cuda::runtime::cudaGraphNodeGetDependencies", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeGetDependentNodes_v10000, .function_name="cuda::runtime::cudaGraphNodeGetDependentNodes", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddDependencies_v10000, .function_name="cuda::runtime::cudaGraphAddDependencies", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphRemoveDependencies_v10000, .function_name="cuda::runtime::cudaGraphRemoveDependencies", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphDestroyNode_v10000, .function_name="cuda::runtime::cudaGraphDestroyNode", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphInstantiate_v10000, .function_name="cuda::runtime::cudaGraphInstantiate", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphLaunch_v10000, .function_name="cuda::runtime::cudaGraphLaunch", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphLaunch_ptsz_v10000, .function_name="cuda::runtime::cudaGraphLaunch_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecDestroy_v10000, .function_name="cuda::runtime::cudaGraphExecDestroy", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphDestroy_v10000, .function_name="cuda::runtime::cudaGraphDestroy", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamBeginCapture_v10000, .function_name="cuda::runtime::cudaStreamBeginCapture", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamBeginCapture_ptsz_v10000, .function_name="cuda::runtime::cudaStreamBeginCapture_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamIsCapturing_v10000, .function_name="cuda::runtime::cudaStreamIsCapturing", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamIsCapturing_ptsz_v10000, .function_name="cuda::runtime::cudaStreamIsCapturing_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamEndCapture_v10000, .function_name="cuda::runtime::cudaStreamEndCapture", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamEndCapture_ptsz_v10000, .function_name="cuda::runtime::cudaStreamEndCapture_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphHostNodeSetParams_v10000, .function_name="cuda::runtime::cudaGraphHostNodeSetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphGetNodes_v10000, .function_name="cuda::runtime::cudaGraphGetNodes", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphGetEdges_v10000, .function_name="cuda::runtime::cudaGraphGetEdges", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetCaptureInfo_v10010, .function_name="cuda::runtime::cudaStreamGetCaptureInfo", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetCaptureInfo_ptsz_v10010, .function_name="cuda::runtime::cudaStreamGetCaptureInfo_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecKernelNodeSetParams_v10010, .function_name="cuda::runtime::cudaGraphExecKernelNodeSetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaThreadExchangeStreamCaptureMode_v10010, .function_name="cuda::runtime::cudaThreadExchangeStreamCaptureMode", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetNvSciSyncAttributes_v10020, .function_name="cuda::runtime::cudaDeviceGetNvSciSyncAttributes", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaOccupancyAvailableDynamicSMemPerBlock_v10200, .function_name="cuda::runtime::cudaOccupancyAvailableDynamicSMemPerBlock", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamSetFlags_v10200, .function_name="cuda::runtime::cudaStreamSetFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamSetFlags_ptsz_v10200, .function_name="cuda::runtime::cudaStreamSetFlags_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecMemcpyNodeSetParams_v10020, .function_name="cuda::runtime::cudaGraphExecMemcpyNodeSetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecMemsetNodeSetParams_v10020, .function_name="cuda::runtime::cudaGraphExecMemsetNodeSetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecHostNodeSetParams_v10020, .function_name="cuda::runtime::cudaGraphExecHostNodeSetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecUpdate_v10020, .function_name="cuda::runtime::cudaGraphExecUpdate", .region=OTF2_UNDEFINED_REGION},

#if  CUPTI_API_VERSION >= 13
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetFuncBySymbol_v11000, .function_name="cuda::runtime::cudaGetFuncBySymbol", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaCtxResetPersistingL2Cache_v11000, .function_name="cuda::runtime::cudaCtxResetPersistingL2Cache", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphKernelNodeCopyAttributes_v11000, .function_name="cuda::runtime::cudaGraphKernelNodeCopyAttributes", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphKernelNodeGetAttribute_v11000, .function_name="cuda::runtime::cudaGraphKernelNodeGetAttribute", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphKernelNodeSetAttribute_v11000, .function_name="cuda::runtime::cudaGraphKernelNodeSetAttribute", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamCopyAttributes_v11000, .function_name="cuda::runtime::cudaStreamCopyAttributes", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamCopyAttributes_ptsz_v11000, .function_name="cuda::runtime::cudaStreamCopyAttributes_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetAttribute_v11000, .function_name="cuda::runtime::cudaStreamGetAttribute", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetAttribute_ptsz_v11000, .function_name="cuda::runtime::cudaStreamGetAttribute_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamSetAttribute_v11000, .function_name="cuda::runtime::cudaStreamSetAttribute", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamSetAttribute_ptsz_v11000, .function_name="cuda::runtime::cudaStreamSetAttribute_ptsz", .region=OTF2_UNDEFINED_REGION},
#endif

#if  CUPTI_API_VERSION >= 14
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetTexture1DLinearMaxWidth_v11010, .function_name="cuda::runtime::cudaDeviceGetTexture1DLinearMaxWidth", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphUpload_v10000, .function_name="cuda::runtime::cudaGraphUpload", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphUpload_ptsz_v10000, .function_name="cuda::runtime::cudaGraphUpload_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddMemcpyNodeToSymbol_v11010, .function_name="cuda::runtime::cudaGraphAddMemcpyNodeToSymbol", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddMemcpyNodeFromSymbol_v11010, .function_name="cuda::runtime::cudaGraphAddMemcpyNodeFromSymbol", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddMemcpyNode1D_v11010, .function_name="cuda::runtime::cudaGraphAddMemcpyNode1D", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemcpyNodeSetParamsToSymbol_v11010, .function_name="cuda::runtime::cudaGraphMemcpyNodeSetParamsToSymbol", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemcpyNodeSetParamsFromSymbol_v11010, .function_name="cuda::runtime::cudaGraphMemcpyNodeSetParamsFromSymbol", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemcpyNodeSetParams1D_v11010, .function_name="cuda::runtime::cudaGraphMemcpyNodeSetParams1D", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecMemcpyNodeSetParamsToSymbol_v11010, .function_name="cuda::runtime::cudaGraphExecMemcpyNodeSetParamsToSymbol", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecMemcpyNodeSetParamsFromSymbol_v11010, .function_name="cuda::runtime::cudaGraphExecMemcpyNodeSetParamsFromSymbol", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecMemcpyNodeSetParams1D_v11010, .function_name="cuda::runtime::cudaGraphExecMemcpyNodeSetParams1D", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaArrayGetSparseProperties_v11010, .function_name="cuda::runtime::cudaArrayGetSparseProperties", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMipmappedArrayGetSparseProperties_v11010, .function_name="cuda::runtime::cudaMipmappedArrayGetSparseProperties", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecChildGraphNodeSetParams_v11010, .function_name="cuda::runtime::cudaGraphExecChildGraphNodeSetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddEventRecordNode_v11010, .function_name="cuda::runtime::cudaGraphAddEventRecordNode", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphEventRecordNodeGetEvent_v11010, .function_name="cuda::runtime::cudaGraphEventRecordNodeGetEvent", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphEventRecordNodeSetEvent_v11010, .function_name="cuda::runtime::cudaGraphEventRecordNodeSetEvent", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddEventWaitNode_v11010, .function_name="cuda::runtime::cudaGraphAddEventWaitNode", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphEventWaitNodeGetEvent_v11010, .function_name="cuda::runtime::cudaGraphEventWaitNodeGetEvent", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphEventWaitNodeSetEvent_v11010, .function_name="cuda::runtime::cudaGraphEventWaitNodeSetEvent", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecEventRecordNodeSetEvent_v11010, .function_name="cuda::runtime::cudaGraphExecEventRecordNodeSetEvent", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecEventWaitNodeSetEvent_v11010, .function_name="cuda::runtime::cudaGraphExecEventWaitNodeSetEvent", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEventRecordWithFlags_v11010, .function_name="cuda::runtime::cudaEventRecordWithFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaEventRecordWithFlags_ptsz_v11010, .function_name="cuda::runtime::cudaEventRecordWithFlags_ptsz", .region=OTF2_UNDEFINED_REGION},
#endif

#if  CUPTI_API_VERSION >= 14
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetDefaultMemPool_v11020, .function_name="cuda::runtime::cudaDeviceGetDefaultMemPool", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMallocAsync_v11020, .function_name="cuda::runtime::cudaMallocAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMallocAsync_ptsz_v11020, .function_name="cuda::runtime::cudaMallocAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaFreeAsync_v11020, .function_name="cuda::runtime::cudaFreeAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaFreeAsync_ptsz_v11020, .function_name="cuda::runtime::cudaFreeAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolTrimTo_v11020, .function_name="cuda::runtime::cudaMemPoolTrimTo", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolSetAttribute_v11020, .function_name="cuda::runtime::cudaMemPoolSetAttribute", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolGetAttribute_v11020, .function_name="cuda::runtime::cudaMemPoolGetAttribute", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolSetAccess_v11020, .function_name="cuda::runtime::cudaMemPoolSetAccess", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaArrayGetPlane_v11020, .function_name="cuda::runtime::cudaArrayGetPlane", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolGetAccess_v11020, .function_name="cuda::runtime::cudaMemPoolGetAccess", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolCreate_v11020, .function_name="cuda::runtime::cudaMemPoolCreate", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolDestroy_v11020, .function_name="cuda::runtime::cudaMemPoolDestroy", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceSetMemPool_v11020, .function_name="cuda::runtime::cudaDeviceSetMemPool", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetMemPool_v11020, .function_name="cuda::runtime::cudaDeviceGetMemPool", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolExportToShareableHandle_v11020, .function_name="cuda::runtime::cudaMemPoolExportToShareableHandle", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolImportFromShareableHandle_v11020, .function_name="cuda::runtime::cudaMemPoolImportFromShareableHandle", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolExportPointer_v11020, .function_name="cuda::runtime::cudaMemPoolExportPointer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMemPoolImportPointer_v11020, .function_name="cuda::runtime::cudaMemPoolImportPointer", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMallocFromPoolAsync_v11020, .function_name="cuda::runtime::cudaMallocFromPoolAsync", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMallocFromPoolAsync_ptsz_v11020, .function_name="cuda::runtime::cudaMallocFromPoolAsync_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaSignalExternalSemaphoresAsync_v2_v11020, .function_name="cuda::runtime::cudaSignalExternalSemaphoresAsync_v2", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaSignalExternalSemaphoresAsync_v2_ptsz_v11020, .function_name="cuda::runtime::cudaSignalExternalSemaphoresAsync_v2_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaWaitExternalSemaphoresAsync_v2_v11020, .function_name="cuda::runtime::cudaWaitExternalSemaphoresAsync_v2", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaWaitExternalSemaphoresAsync_v2_ptsz_v11020, .function_name="cuda::runtime::cudaWaitExternalSemaphoresAsync_v2_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddExternalSemaphoresSignalNode_v11020, .function_name="cuda::runtime::cudaGraphAddExternalSemaphoresSignalNode", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExternalSemaphoresSignalNodeGetParams_v11020, .function_name="cuda::runtime::cudaGraphExternalSemaphoresSignalNodeGetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExternalSemaphoresSignalNodeSetParams_v11020, .function_name="cuda::runtime::cudaGraphExternalSemaphoresSignalNodeSetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddExternalSemaphoresWaitNode_v11020, .function_name="cuda::runtime::cudaGraphAddExternalSemaphoresWaitNode", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExternalSemaphoresWaitNodeGetParams_v11020, .function_name="cuda::runtime::cudaGraphExternalSemaphoresWaitNodeGetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExternalSemaphoresWaitNodeSetParams_v11020, .function_name="cuda::runtime::cudaGraphExternalSemaphoresWaitNodeSetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecExternalSemaphoresSignalNodeSetParams_v11020, .function_name="cuda::runtime::cudaGraphExecExternalSemaphoresSignalNodeSetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecExternalSemaphoresWaitNodeSetParams_v11020, .function_name="cuda::runtime::cudaGraphExecExternalSemaphoresWaitNodeSetParams", .region=OTF2_UNDEFINED_REGION},
#endif

#if  CUPTI_API_VERSION >= 13
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceFlushGPUDirectRDMAWrites_v11030, .function_name="cuda::runtime::cudaDeviceFlushGPUDirectRDMAWrites", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetDriverEntryPoint_v11030, .function_name="cuda::runtime::cudaGetDriverEntryPoint", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetDriverEntryPoint_ptsz_v11030, .function_name="cuda::runtime::cudaGetDriverEntryPoint_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphDebugDotPrint_v11030, .function_name="cuda::runtime::cudaGraphDebugDotPrint", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetCaptureInfo_v2_v11030, .function_name="cuda::runtime::cudaStreamGetCaptureInfo_v2", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetCaptureInfo_v2_ptsz_v11030, .function_name="cuda::runtime::cudaStreamGetCaptureInfo_v2_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamUpdateCaptureDependencies_v11030, .function_name="cuda::runtime::cudaStreamUpdateCaptureDependencies", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamUpdateCaptureDependencies_ptsz_v11030, .function_name="cuda::runtime::cudaStreamUpdateCaptureDependencies_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaUserObjectCreate_v11030, .function_name="cuda::runtime::cudaUserObjectCreate", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaUserObjectRetain_v11030, .function_name="cuda::runtime::cudaUserObjectRetain", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaUserObjectRelease_v11030, .function_name="cuda::runtime::cudaUserObjectRelease", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphRetainUserObject_v11030, .function_name="cuda::runtime::cudaGraphRetainUserObject", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphReleaseUserObject_v11030, .function_name="cuda::runtime::cudaGraphReleaseUserObject", .region=OTF2_UNDEFINED_REGION},
#endif

#if  CUPTI_API_VERSION >= 14
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphInstantiateWithFlags_v11040, .function_name="cuda::runtime::cudaGraphInstantiateWithFlags", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddMemAllocNode_v11040, .function_name="cuda::runtime::cudaGraphAddMemAllocNode", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemAllocNodeGetParams_v11040, .function_name="cuda::runtime::cudaGraphMemAllocNodeGetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphAddMemFreeNode_v11040, .function_name="cuda::runtime::cudaGraphAddMemFreeNode", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphMemFreeNodeGetParams_v11040, .function_name="cuda::runtime::cudaGraphMemFreeNodeGetParams", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGraphMemTrim_v11040, .function_name="cuda::runtime::cudaDeviceGraphMemTrim", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceGetGraphMemAttribute_v11040, .function_name="cuda::runtime::cudaDeviceGetGraphMemAttribute", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaDeviceSetGraphMemAttribute_v11040, .function_name="cuda::runtime::cudaDeviceSetGraphMemAttribute", .region=OTF2_UNDEFINED_REGION},
#endif

#if  CUPTI_API_VERSION >= 16
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeSetEnabled_v11060, .function_name="cuda::runtime::cudaGraphNodeSetEnabled", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphNodeGetEnabled_v11060, .function_name="cuda::runtime::cudaGraphNodeGetEnabled", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaArrayGetMemoryRequirements_v11060, .function_name="cuda::runtime::cudaArrayGetMemoryRequirements", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaMipmappedArrayGetMemoryRequirements_v11060, .function_name="cuda::runtime::cudaMipmappedArrayGetMemoryRequirements", .region=OTF2_UNDEFINED_REGION},
#endif

#if  CUPTI_API_VERSION >= 18
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaLaunchKernelExC_v11060, .function_name="cuda::runtime::cudaLaunchKernelExC", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaLaunchKernelExC_ptsz_v11060, .function_name="cuda::runtime::cudaLaunchKernelExC_ptsz", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaOccupancyMaxPotentialClusterSize_v11070, .function_name="cuda::runtime::cudaOccupancyMaxPotentialClusterSize", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaOccupancyMaxActiveClusters_v11070, .function_name="cuda::runtime::cudaOccupancyMaxActiveClusters", .region=OTF2_UNDEFINED_REGION},
#endif

#if  CUPTI_API_VERSION >= 19
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaCreateTextureObject_v2_v11080, .function_name="cuda::runtime::cudaCreateTextureObject_v2_v11080", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetTextureObjectTextureDesc_v2_v11080, .function_name="cuda::runtime::cudaGetTextureObjectTextureDesc_v2_v11080", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphInstantiateWithParams_v12000, .function_name="cuda::runtime::cudaGraphInstantiateWithParams_v12000", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphInstantiateWithParams_ptsz_v12000, .function_name="cuda::runtime::cudaGraphInstantiateWithParams_ptsz_v12000", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphExecGetFlags_v12000, .function_name="cuda::runtime::cudaGraphExecGetFlags_v12000", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cuda439_v12000, .function_name="cuda::runtime::cuda439_v12000", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGetDeviceProperties_v2_v12000, .function_name="cuda::runtime::cudaGetDeviceProperties_v2_v12000", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetId_v12000, .function_name="cuda::runtime::cudaStreamGetId_v12000", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaStreamGetId_ptsz_v12000, .function_name="cuda::runtime::cudaStreamGetId_ptsz_v12000", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cudaGraphInstantiate_v12000, .function_name="cuda::runtime::cudaGraphInstantiate_v12000", .region=OTF2_UNDEFINED_REGION},
  {.id=CUPTI_RUNTIME_TRACE_CBID_cuda444_v12000, .function_name="cuda::runtime::cuda444_v12000", .region=OTF2_UNDEFINED_REGION},
#endif
};

void CUPTIAPI eztrace_cuda_runtime_callback(void *userdata, CUpti_CallbackDomain domain,
					    CUpti_CallbackId cbid, const void *cbdata) {
  if(domain != CUPTI_CB_DOMAIN_RUNTIME_API)
    return;
  if(!EZTRACE_SAFE)
    return;

  const CUpti_CallbackData *cbInfo = (CUpti_CallbackData *)cbdata;
      
  const char* enter_leave = cbInfo->callbackSite == CUPTI_API_ENTER? "Enter":"Leave";

  if(cuda_runtime_api_info[cbid].region == OTF2_UNDEFINED_REGION) {
    cuda_runtime_api_info[cbid].region = ezt_otf2_register_function(cuda_runtime_api_info[cbid].function_name);
  }

  if(cbInfo->callbackSite == CUPTI_API_ENTER) {
    EZT_OTF2_EvtWriter_Enter( evt_writer,
			      NULL,
			      ezt_get_timestamp(),
			      cuda_runtime_api_info[cbid].region);
  } else  {
    EZT_OTF2_EvtWriter_Leave( evt_writer,
			      NULL,
			      ezt_get_timestamp(),
			      cuda_runtime_api_info[cbid].region);
  }
}
