/*=========================================================================
 *
 *  Copyright UMC Utrecht and contributors
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *=========================================================================*/

#ifndef elxInstallAllComponents_h
#define elxInstallAllComponents_h

#include "elxComponentDatabase.h"

// The CMake generated "elxInstallComponentFunction*.h" files contain calls to the following macros:

/**
 * elxInstallComponentFunctionDeclarationMacro
 *
 * Usage example:
 *   elxInstallComponentFunctionDeclarationMacro( BSplineTransform );
 *
 * This macro declares the function implemented by
 * the elxInstallMacro. This macro is used by the
 * CMake generated file
 * elxInstallComponentFunctionDeclarations.h
 * only.
 *
 * Details: the declaration of InstallComponent function defined
 * by elxInstallMacro is simply repeated.
 */
#define elxInstallComponentFunctionDeclarationMacro(_classname)                                                        \
  extern "C" int _classname##InstallComponent(::elastix::ComponentDatabase * _cdb)

/**
 * elxInstallComponentFunctionCallMacro
 *
 * Usage example:
 *   elxInstallComponentFunctionCallMacro( BSplineTransform );
 *
 * This macro calls the function implemented by
 * the elxInstallMacro. This macro is used by the
 * CMake generated file
 * elxInstallComponentFunctionCalls.h
 * only.
 *
 * Details: the InstallComponent function defined
 * by elxInstallMacro is called.
 */
#define elxInstallComponentFunctionCallMacro(_classname) ret |= _classname##InstallComponent(_cdb)


/** The following file, generated by CMake, declares all
 * the InstallComponent functions implemented by the components. */
#include "elxInstallComponentFunctionDeclarations.h"

int
InstallAllComponents(elx::ComponentDatabase * _cdb)
{
  int ret = 0;

  /** The following file, generated by CMake, calls the
   * InstallComponent functions of the components. */

#include "elxInstallComponentFunctionCalls.h"

  /** ret!=0 when something failed. */
  return ret;

} // end InstallAllComponents


#endif // #ifndef elxInstallAllComponents_h
