/*
 * Decompiled with CFR 0.152.
 */
package dumphd.core;

import dumphd.util.ByteArray;
import dumphd.util.ByteSource;
import dumphd.util.FileSource;
import dumphd.util.PESPack;
import dumphd.util.PESParserException;
import dumphd.util.PackSource;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;

public final class MultiplexedArf {
    public static final int START_PACKET = 16;
    public static final int INTERMEDIATE_PACKET = 0;
    public static final int END_PACKET = 32;
    private File arfFile = null;
    private ByteSource bs = null;
    private boolean demux = false;
    private LinkedList<PackSource.PackRecord> packRecords = new LinkedList();
    private long currentDataOffset = 0L;
    private boolean complete = false;
    private ByteSource reader = null;
    private ByteSource writer = null;

    public MultiplexedArf(String arfName, ByteSource bs, boolean demux) {
        this.arfFile = new File(bs.getFile().getParentFile(), arfName);
        this.bs = bs;
        this.demux = demux;
    }

    public void addData(long packOffset, int payloadOffset, int payloadSize) {
        if (!this.complete) {
            this.packRecords.add(new PackSource.PackRecord(this.currentDataOffset, packOffset, payloadOffset, payloadSize));
            this.currentDataOffset += (long)payloadSize;
        } else {
            throw new IllegalStateException("Cannot add additional data, MultiplexedArf already completed");
        }
    }

    public void markComplete() {
        if (!this.complete) {
            this.complete = true;
            if (this.packRecords.size() == 0) {
                this.packRecords.add(new PackSource.PackRecord());
            }
        }
    }

    public ByteSource getReader() throws IOException {
        if (this.complete) {
            if (this.reader == null) {
                this.reader = new PackSource(this.bs, 0, this.arfFile, this.packRecords);
            }
            return this.reader;
        }
        throw new IllegalStateException("Cannot create reader, MultiplexedArf not completed");
    }

    public ByteSource getWriter() throws IOException {
        if (this.complete) {
            if (this.writer == null) {
                this.writer = this.demux ? new FileSource(this.arfFile, 2) : new PackSource(this.bs, 1, this.arfFile, this.packRecords);
            }
            return this.writer;
        }
        throw new IllegalStateException("Canot create writer, MultiplexedArf not completed");
    }

    /*
     * Unable to fully structure code
     */
    public void close() throws IOException {
        block23: {
            block24: {
                exceptionMessage = new StringBuffer(128);
                if (this.writer == null) break block23;
                if (this.demux) break block24;
                try {
                    block25: {
                        pack = new PESPack();
                        packet = null;
                        it = this.packRecords.iterator();
                        packRecord = (PackSource.PackRecord)it.next();
                        packBuffer = new byte[2048];
                        maxWritten = ((PackSource)this.writer).maxWrittenPosition();
                        if (maxWritten > (long)packRecord.payloadSize) ** GOTO lbl41
                        System.out.println(String.format("0x%1$010X Warning! Multiplexed ARF is only one packet big!", new Object[]{packRecord.packetOffset}));
                        this.bs.setPosition(packRecord.packetOffset);
                        this.bs.read(packBuffer, 0, packBuffer.length);
                        try {
                            pack.parse(packBuffer, 0, false);
                            packet = pack.getPacket(0);
                            ByteArray.setByte(packBuffer, packet.payloadOffset(), 16);
                            packet.setPayloadLength((int)maxWritten + 258);
                            pack.pad(0);
                            this.bs.setPosition(packRecord.packetOffset);
                            this.bs.write(packBuffer, 0, packBuffer.length);
                        }
                        catch (PESParserException e) {
                            if (exceptionMessage.length() > 0) {
                                exceptionMessage.append(", ");
                            }
                            exceptionMessage.append(String.format("0x%1$010X Error padding stream, PES Parser Exception: ", new Object[]{packRecord.packetOffset}));
                            exceptionMessage.append(e.getMessage());
                        }
                        break block25;
lbl-1000:
                        // 1 sources

                        {
                            if (it.hasNext()) {
                                packRecord = (PackSource.PackRecord)it.next();
                                continue;
                            }
                            throw new IOException("Unexpected EOF");
lbl41:
                            // 2 sources

                            ** while (maxWritten > packRecord.dataOffset + (long)packRecord.payloadSize)
                        }
lbl42:
                        // 1 sources

                        this.bs.setPosition(packRecord.packetOffset);
                        this.bs.read(packBuffer, 0, packBuffer.length);
                        try {
                            pack.parse(packBuffer, 0, false);
                            packet = pack.getPacket(0);
                            ByteArray.setByte(packBuffer, packet.payloadOffset(), 32);
                            packet.setPayloadLength(3 + (int)(maxWritten - packRecord.dataOffset));
                            pack.pad(0);
                            this.bs.setPosition(packRecord.packetOffset);
                            this.bs.write(packBuffer, 0, packBuffer.length);
                        }
                        catch (PESParserException e) {
                            if (exceptionMessage.length() > 0) {
                                exceptionMessage.append(", ");
                            }
                            exceptionMessage.append(String.format("0x%1$010X Error padding stream, PES Parser Exception: ", new Object[]{packRecord.packetOffset}));
                            exceptionMessage.append(e.getMessage());
                        }
                    }
                    while (it.hasNext()) {
                        packRecord = (PackSource.PackRecord)it.next();
                        this.bs.setPosition(packRecord.packetOffset);
                        this.bs.read(packBuffer, 0, packBuffer.length);
                        try {
                            pack.parse(packBuffer, 0, false);
                            pack.pad(-1);
                            this.bs.setPosition(packRecord.packetOffset);
                            this.bs.write(packBuffer, 0, packBuffer.length);
                        }
                        catch (PESParserException e) {
                            if (exceptionMessage.length() > 0) {
                                exceptionMessage.append(", ");
                            }
                            exceptionMessage.append(String.format("0x%1$010X Error padding stream, PES Parser Exception: ", new Object[]{packRecord.packetOffset}));
                            exceptionMessage.append(e.getMessage());
                        }
                    }
                }
                catch (IOException e) {
                    if (exceptionMessage.length() > 0) {
                        exceptionMessage.append(", ");
                    }
                    exceptionMessage.append("Error padding stream: ");
                    exceptionMessage.append(e.getMessage());
                }
            }
            try {
                this.writer.close();
            }
            catch (IOException e) {
                if (exceptionMessage.length() > 0) {
                    exceptionMessage.append(", ");
                }
                exceptionMessage.append("Error closing writer: ");
                exceptionMessage.append(e.getMessage());
            }
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                if (exceptionMessage.length() > 0) {
                    exceptionMessage.append(", ");
                }
                exceptionMessage.append("Error closing reader: ");
                exceptionMessage.append(e.getMessage());
            }
        }
        this.reader = null;
        this.writer = null;
        this.packRecords = null;
        this.bs = null;
        this.arfFile = null;
        if (exceptionMessage.length() > 0) {
            throw new IOException(exceptionMessage.toString());
        }
    }
}

