/*
 * dsyslog - a dumb syslog (e.g. syslog for people who have a clue)
 * Copyright (c) 2008 William Pitcock <nenolod@sacredspiral.co.uk>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice is present in all copies.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __DSYSLOG_FILTER_INCLUDE_RECURSION_GUARD
#define __DSYSLOG_FILTER_INCLUDE_RECURSION_GUARD

#include "dsyslog_event.h"

/* A syslog filter. */
typedef struct dsyslog_filter_ dsyslog_filter_t;
typedef gboolean (*dsyslog_filter_handler_t)(dsyslog_event_t *event, dsyslog_filter_t *filter);
typedef void (*dsyslog_filter_destructor_t)(dsyslog_filter_t *filter);

struct dsyslog_filter_ {
	gchar *type;
	gchar *search;
	gchar *replace;
	gchar *program;
	gchar *message;
	gint logcode;
	gpointer opaque;
	dsyslog_filter_handler_t handler;
	dsyslog_filter_destructor_t destructor;
	GList *conditions;
};

extern void dsyslog_filter_type_register(gchar *type, dsyslog_filter_handler_t hdl);
extern void dsyslog_filter_type_unregister(gchar *type);
extern void dsyslog_filter_add(dsyslog_filter_t *filter);
extern void dsyslog_filter_remove(dsyslog_filter_t *filter);
extern gboolean dsyslog_filter_process(dsyslog_event_t *event);
extern void dsyslog_filter_clear(void);

#endif
