// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.
// ------------------------------------------------------------------------------
// Changes to this file must follow the http://aka.ms/api-review process.
// ------------------------------------------------------------------------------
[assembly: System.Runtime.CompilerServices.CompilationRelaxations(8)]
[assembly: System.Runtime.CompilerServices.RuntimeCompatibility(WrapNonExceptionThrows = true)]
[assembly: System.Diagnostics.Debuggable(System.Diagnostics.DebuggableAttribute.DebuggingModes.IgnoreSymbolStoreSequencePoints)]
[assembly: System.Runtime.Versioning.TargetFramework(".NETStandard,Version=v2.0", FrameworkDisplayName = ".NET Standard 2.0")]
[assembly: System.Reflection.AssemblyCompany("Microsoft Corporation")]
[assembly: System.Reflection.AssemblyConfiguration("release")]
[assembly: System.Reflection.AssemblyCopyright("© Microsoft Corporation. All rights reserved.")]
[assembly: System.Reflection.AssemblyDescription("Complete commands common to command-line and GUI NuGet clients.")]
[assembly: System.Reflection.AssemblyFileVersion("6.13.2.1")]
[assembly: System.Reflection.AssemblyInformationalVersion("6.13.2+5d81cb8da82eda8a6b47aae92d1e6f888de982ce.5d81cb8da82eda8a6b47aae92d1e6f888de982ce")]
[assembly: System.Reflection.AssemblyProduct("NuGet")]
[assembly: System.Reflection.AssemblyTitle("NuGet.Commands")]
[assembly: System.Reflection.AssemblyMetadata("RepositoryUrl", "https://github.com/NuGet/NuGet.Client")]
[assembly: System.Resources.NeutralResourcesLanguage("en-US")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("DynamicProxyGenAssembly2, PublicKey=0024000004800000940000000602000000240000525341310004000001000100C547CAC37ABD99C8DB225EF2F6C8A3602F3B3606CC9891605D02BAA56104F4CFC0734AA39B93BF7852F7D9266654753CC297E7D2EDFE0BAC1CDCF9F717241550E0A7B191195B7667BB4F64BCB8E2121380FD1D9D46AD2D92D2D15605093924CCEAF74C4861EFF62ABF69B9291ED0A340E113BE11E6A7D3113E92484CF7045CC7")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.Commands.Test, PublicKey=0024000004800000940000000602000000240000525341310004000001000100A5276DF8650A58CB43396DC7B3D395F30A82D0D1FA98FBCFE3ABEAD5DE0B1DB6764347A0F6BF0B060A27C202CCD122DB5DED8F596CEBE2ECC3A6629015EEB96C94F6B9E8185D4ACC84C376FF6B1C3147431A4D55CB5736DB97A9E88FCC47D9193F4DB5896DC5817E5D0CBD2641726E7431990BCD2DD7FA1D28493D0CFD9DCFA4")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.PackageManagement.VisualStudio.Test, PublicKey=0024000004800000940000000602000000240000525341310004000001000100A5276DF8650A58CB43396DC7B3D395F30A82D0D1FA98FBCFE3ABEAD5DE0B1DB6764347A0F6BF0B060A27C202CCD122DB5DED8F596CEBE2ECC3A6629015EEB96C94F6B9E8185D4ACC84C376FF6B1C3147431A4D55CB5736DB97A9E88FCC47D9193F4DB5896DC5817E5D0CBD2641726E7431990BCD2DD7FA1D28493D0CFD9DCFA4")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.ProjectModel.Test, PublicKey=0024000004800000940000000602000000240000525341310004000001000100A5276DF8650A58CB43396DC7B3D395F30A82D0D1FA98FBCFE3ABEAD5DE0B1DB6764347A0F6BF0B060A27C202CCD122DB5DED8F596CEBE2ECC3A6629015EEB96C94F6B9E8185D4ACC84C376FF6B1C3147431A4D55CB5736DB97A9E88FCC47D9193F4DB5896DC5817E5D0CBD2641726E7431990BCD2DD7FA1D28493D0CFD9DCFA4")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.SolutionRestoreManager.Test, PublicKey=0024000004800000940000000602000000240000525341310004000001000100A5276DF8650A58CB43396DC7B3D395F30A82D0D1FA98FBCFE3ABEAD5DE0B1DB6764347A0F6BF0B060A27C202CCD122DB5DED8F596CEBE2ECC3A6629015EEB96C94F6B9E8185D4ACC84C376FF6B1C3147431A4D55CB5736DB97A9E88FCC47D9193F4DB5896DC5817E5D0CBD2641726E7431990BCD2DD7FA1D28493D0CFD9DCFA4")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Test.Utility, PublicKey=0024000004800000940000000602000000240000525341310004000001000100A5276DF8650A58CB43396DC7B3D395F30A82D0D1FA98FBCFE3ABEAD5DE0B1DB6764347A0F6BF0B060A27C202CCD122DB5DED8F596CEBE2ECC3A6629015EEB96C94F6B9E8185D4ACC84C376FF6B1C3147431A4D55CB5736DB97A9E88FCC47D9193F4DB5896DC5817E5D0CBD2641726E7431990BCD2DD7FA1D28493D0CFD9DCFA4")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.Commands.FuncTest, PublicKey=0024000004800000940000000602000000240000525341310004000001000100A5276DF8650A58CB43396DC7B3D395F30A82D0D1FA98FBCFE3ABEAD5DE0B1DB6764347A0F6BF0B060A27C202CCD122DB5DED8F596CEBE2ECC3A6629015EEB96C94F6B9E8185D4ACC84C376FF6B1C3147431A4D55CB5736DB97A9E88FCC47D9193F4DB5896DC5817E5D0CBD2641726E7431990BCD2DD7FA1D28493D0CFD9DCFA4")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Dotnet.Integration.Test, PublicKey=0024000004800000940000000602000000240000525341310004000001000100A5276DF8650A58CB43396DC7B3D395F30A82D0D1FA98FBCFE3ABEAD5DE0B1DB6764347A0F6BF0B060A27C202CCD122DB5DED8F596CEBE2ECC3A6629015EEB96C94F6B9E8185D4ACC84C376FF6B1C3147431A4D55CB5736DB97A9E88FCC47D9193F4DB5896DC5817E5D0CBD2641726E7431990BCD2DD7FA1D28493D0CFD9DCFA4")]
[assembly: System.Reflection.AssemblyVersionAttribute("6.13.2.1")]
[assembly: System.Runtime.CompilerServices.ReferenceAssembly]
[assembly: System.Reflection.AssemblyFlagsAttribute((System.Reflection.AssemblyNameFlags)0x70)]
namespace NuGet.Commands
{
    public partial class AddClientCertArgs : IClientCertArgsWithPackageSource, IClientCertArgsWithConfigFile, IClientCertArgsWithFileData, IClientCertArgsWithStoreData, IClientCertArgsWithForce
    {
        public string Configfile { get { throw null; } set { } }
        public string FindBy { get { throw null; } set { } }
        public string FindValue { get { throw null; } set { } }
        public bool Force { get { throw null; } set { } }
        public string PackageSource { get { throw null; } set { } }
        public string Password { get { throw null; } set { } }
        public string Path { get { throw null; } set { } }
        public string StoreLocation { get { throw null; } set { } }
        public string StoreName { get { throw null; } set { } }
        public bool StorePasswordInClearText { get { throw null; } set { } }
    }

    public static partial class AddClientCertRunner
    {
        public static void Run(AddClientCertArgs args, System.Func<Common.ILogger> getLogger) { }
    }
    public partial class AddSourceArgs
    {
        public bool AllowInsecureConnections { get { throw null; } set { } }
        public string Configfile { get { throw null; } set { } }
        public string Name { get { throw null; } set { } }
        public string Password { get { throw null; } set { } }
        public string ProtocolVersion { get { throw null; } set { } }
        public string Source { get { throw null; } set { } }
        public bool StorePasswordInClearText { get { throw null; } set { } }
        public string Username { get { throw null; } set { } }
        public string ValidAuthenticationTypes { get { throw null; } set { } }
    }
    public static partial class AddSourceRunner
    {
        public static void Run(AddSourceArgs args, System.Func<Common.ILogger> getLogger) { }
    }
    public static partial class AssetTargetFallbackUtility
    {
        public static readonly string AssetTargetFallback;
        public static void EnsureValidFallback(System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework> packageTargetFallback, System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework> assetTargetFallback, string filePath) { }
        public static Frameworks.NuGetFramework GetFallbackFramework(Frameworks.NuGetFramework projectFramework, System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework> packageTargetFallback, System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework> assetTargetFallback) { throw null; }
        public static (Frameworks.NuGetFramework frameworkName, System.Collections.Immutable.ImmutableArray<Frameworks.NuGetFramework> imports, bool assetTargetFallback, bool warn) GetFallbackFrameworkInformation(Frameworks.NuGetFramework originalFrameworkName, System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework> packageTargetFallback, System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework> assetTargetFallbackEnum) { throw null; }
        public static Common.RestoreLogMessage GetInvalidFallbackCombinationMessage(string path) { throw null; }
    }
    public static partial class BuildAssetsUtils
    {
        public static readonly string[] MacroCandidates;
        public const string PropsExtension = ".props";
        public const string TargetsExtension = ".targets";
        public static void AddNuGetProperties(System.Xml.Linq.XDocument doc, System.Collections.Generic.IEnumerable<string> packageFolders, string repositoryRoot, ProjectModel.ProjectStyle projectStyle, string assetsFilePath, bool success) { }
        public static void AddNuGetPropertiesToFirstImport(System.Collections.Generic.IEnumerable<MSBuildOutputFile> files, System.Collections.Generic.IEnumerable<string> packageFolders, string repositoryRoot, ProjectModel.ProjectStyle projectStyle, string assetsFilePath, bool success) { }
        public static System.Xml.Linq.XElement GenerateContentFilesItem(string path, ProjectModel.LockFileContentFile item, string packageId, string packageVersion) { throw null; }
        public static System.Xml.Linq.XDocument GenerateEmptyImportsFile() { throw null; }
        public static System.Xml.Linq.XElement GenerateImport(string path) { throw null; }
        public static System.Xml.Linq.XDocument GenerateMSBuildFile(System.Collections.Generic.List<MSBuildRestoreItemGroup> groups, ProjectModel.ProjectStyle outputType) { throw null; }
        public static System.Collections.Generic.List<MSBuildOutputFile> GenerateMultiTargetFailureFiles(string targetsPath, string propsPath, ProjectModel.ProjectStyle restoreType) { throw null; }
        public static System.Xml.Linq.XDocument GenerateMultiTargetFrameworkWarning() { throw null; }
        public static System.Xml.Linq.XElement GenerateProperty(string propertyName, string content) { throw null; }
        public static string GetLanguage(string nugetLanguage) { throw null; }
        public static string GetMSBuildFilePath(ProjectModel.PackageSpec project, string extension) { throw null; }
        public static string GetMSBuildFilePathForPackageReferenceStyleProject(ProjectModel.PackageSpec project, string extension) { throw null; }
        public static System.Collections.Generic.List<MSBuildOutputFile> GetMSBuildOutputFiles(ProjectModel.PackageSpec project, ProjectModel.LockFile assetsFile, System.Collections.Generic.IEnumerable<RestoreTargetGraph> targetGraphs, System.Collections.Generic.IReadOnlyList<Repositories.NuGetv3LocalRepository> repositories, RestoreRequest request, string assetsFilePath, bool restoreSuccess, Common.ILogger log) { throw null; }
        public static string GetPathWithMacros(string absolutePath, string repositoryRoot) { throw null; }
        public static bool HasChanges(System.Xml.Linq.XDocument newFile, string path, Common.ILogger log) { throw null; }
        public static System.Xml.Linq.XDocument ReadExisting(string path, Common.ILogger log) { throw null; }
        public static void WriteFiles(System.Collections.Generic.IEnumerable<MSBuildOutputFile> files, Common.ILogger log) { }
        public static void WriteXML(string path, System.Xml.Linq.XDocument doc) { }
    }
    public static partial class ClientCertArgsExtensions
    {
        public static System.Security.Cryptography.X509Certificates.X509FindType? GetFindBy(this IClientCertArgsWithStoreData args) { throw null; }
        public static System.Security.Cryptography.X509Certificates.StoreLocation? GetStoreLocation(this IClientCertArgsWithStoreData args) { throw null; }
        public static System.Security.Cryptography.X509Certificates.StoreName? GetStoreName(this IClientCertArgsWithStoreData args) { throw null; }
        public static bool IsFileCertSettingsProvided(this IClientCertArgsWithFileData args) { throw null; }
        public static bool IsPackageSourceSettingProvided(this IClientCertArgsWithPackageSource args) { throw null; }
        public static bool IsStoreCertSettingsProvided(this IClientCertArgsWithStoreData args) { throw null; }
        public static void Validate(this AddClientCertArgs args) { }
        public static void Validate(this RemoveClientCertArgs args) { }
        public static void Validate(this UpdateClientCertArgs args) { }
    }
    public partial class CommandException : System.Exception
    {
        public CommandException() { }
        protected CommandException(System.Runtime.Serialization.SerializationInfo info, System.Runtime.Serialization.StreamingContext context) { }
        public CommandException(string message, System.Exception exception) { }
        public CommandException(string format, params object[] args) { }
        public CommandException(string message) { }
    }

    public partial class CompatibilityCheckResult
    {
        public CompatibilityCheckResult(RestoreTargetGraph graph, System.Collections.Generic.IEnumerable<CompatibilityIssue> issues) { }
        public RestoreTargetGraph Graph { get { throw null; } }
        public System.Collections.Generic.IReadOnlyList<CompatibilityIssue> Issues { get { throw null; } }
        public bool Success { get { throw null; } }
    }
    public partial class CompatibilityIssue : System.IEquatable<CompatibilityIssue>
    {
        internal CompatibilityIssue() { }
        public string AssemblyName { get { throw null; } }
        public System.Collections.Generic.List<Frameworks.FrameworkRuntimePair> AvailableFrameworkRuntimePairs { get { throw null; } }
        public System.Collections.Generic.List<Frameworks.NuGetFramework> AvailableFrameworks { get { throw null; } }
        public Frameworks.NuGetFramework Framework { get { throw null; } }
        public Packaging.Core.PackageIdentity Package { get { throw null; } }
        public string RuntimeIdentifier { get { throw null; } }
        public CompatibilityIssueType Type { get { throw null; } }

        public bool Equals(CompatibilityIssue other) { throw null; }
        public string Format() { throw null; }
        public static CompatibilityIssue IncompatiblePackage(Packaging.Core.PackageIdentity referenceAssemblyPackage, Frameworks.NuGetFramework framework, string runtimeIdentifier, System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework> packageFrameworks) { throw null; }
        public static CompatibilityIssue IncompatiblePackageWithDotnetTool(Packaging.Core.PackageIdentity referenceAssemblyPackage) { throw null; }
        public static CompatibilityIssue IncompatibleProject(Packaging.Core.PackageIdentity project, Frameworks.NuGetFramework framework, string runtimeIdentifier, System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework> projectFrameworks) { throw null; }
        public static CompatibilityIssue IncompatibleProjectType(Packaging.Core.PackageIdentity project) { throw null; }
        public static CompatibilityIssue IncompatibleToolsPackage(Packaging.Core.PackageIdentity packageIdentity, Frameworks.NuGetFramework framework, string runtimeIdentifier, System.Collections.Generic.HashSet<Frameworks.FrameworkRuntimePair> available) { throw null; }
        public static CompatibilityIssue ReferenceAssemblyNotImplemented(string assemblyName, Packaging.Core.PackageIdentity referenceAssemblyPackage, Frameworks.NuGetFramework framework, string runtimeIdentifier) { throw null; }
        public static CompatibilityIssue ToolsPackageWithExtraPackageTypes(Packaging.Core.PackageIdentity referenceAssemblyPackage) { throw null; }
        public override string ToString() { throw null; }
    }

    public enum CompatibilityIssueType
    {
        ReferenceAssemblyNotImplemented = 0,
        PackageIncompatible = 1,
        ProjectIncompatible = 2,
        PackageToolsAssetsIncompatible = 3,
        ProjectWithIncorrectDependencyCount = 4,
        IncompatiblePackageWithDotnetTool = 5,
        ToolsPackageWithExtraPackageTypes = 6,
        PackageTypeIncompatible = 7
    }

    public partial struct ContentMetadata
    {
        private object _dummy;
        private int _dummyPrimitive;
        public string BuildAction { get { throw null; } set { } }
        public string CopyToOutput { get { throw null; } set { } }
        public string Flatten { get { throw null; } set { } }
        public string Source { get { throw null; } set { } }
        public string Target { get { throw null; } set { } }
    }

    public static partial class DeleteRunner
    {
        public static System.Threading.Tasks.Task Run(Configuration.ISettings settings, Configuration.IPackageSourceProvider sourceProvider, string packageId, string packageVersion, string source, string apiKey, bool nonInteractive, bool noServiceEndpoint, System.Func<string, bool> confirmFunc, Common.ILogger logger) { throw null; }
    }
    public partial class DependencyGraphFileRequestProvider : IRestoreRequestProvider
    {
        public DependencyGraphFileRequestProvider(RestoreCommandProvidersCache providerCache) { }
        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<RestoreSummaryRequest>> CreateRequests(string inputPath, RestoreArgs restoreContext) { throw null; }
        public virtual System.Threading.Tasks.Task<bool> Supports(string path) { throw null; }
    }

    public partial class DependencyGraphSpecRequestProvider : IPreLoadedRestoreRequestProvider
    {
        public DependencyGraphSpecRequestProvider(RestoreCommandProvidersCache providerCache, ProjectModel.DependencyGraphSpec dgFile, Configuration.ISettings settings) { }
        public DependencyGraphSpecRequestProvider(RestoreCommandProvidersCache providerCache, ProjectModel.DependencyGraphSpec dgFile) { }
        public System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<RestoreSummaryRequest>> CreateRequests(RestoreArgs restoreContext) { throw null; }
        public static System.Collections.Generic.IEnumerable<ProjectModel.ExternalProjectReference> GetExternalClosure(ProjectModel.DependencyGraphSpec dgFile, string projectNameToRestore) { throw null; }
    }

    public static partial class DiagnosticUtility
    {
        public static string FormatDependency(string id, Versioning.VersionRange range) { throw null; }
        public static string FormatExpectedIdentity(string id, Versioning.VersionRange range) { throw null; }
        public static string FormatGraphName(RestoreTargetGraph graph) { throw null; }
        public static string FormatIdentity(LibraryModel.LibraryIdentity identity) { throw null; }
        public static string GetMultiLineMessage(System.Collections.Generic.IEnumerable<string> lines) { throw null; }
        public static System.Collections.Generic.IEnumerable<Common.RestoreLogMessage> MergeOnTargetGraph(System.Collections.Generic.IEnumerable<Common.RestoreLogMessage> messages) { throw null; }
    }
    public partial class DisableSourceArgs
    {
        public string Configfile { get { throw null; } set { } }
        public string Name { get { throw null; } set { } }
    }
    public static partial class DisableSourceRunner
    {
        public static void Run(DisableSourceArgs args, System.Func<Common.ILogger> getLogger) { }
    }
    public partial class DownloadDependencyResolutionResult
    {
        internal DownloadDependencyResolutionResult() { }
        public System.Collections.Generic.IList<System.Tuple<LibraryModel.LibraryRange, DependencyResolver.RemoteMatch>> Dependencies { get { throw null; } }
        public Frameworks.NuGetFramework Framework { get { throw null; } }
        public System.Collections.Generic.ISet<DependencyResolver.RemoteMatch> Install { get { throw null; } }
        public System.Collections.Generic.ISet<LibraryModel.LibraryRange> Unresolved { get { throw null; } }

        public static DownloadDependencyResolutionResult Create(Frameworks.NuGetFramework framework, System.Collections.Generic.IList<System.Tuple<LibraryModel.LibraryRange, DependencyResolver.RemoteMatch>> dependencies, System.Collections.Generic.IList<DependencyResolver.IRemoteDependencyProvider> remoteDependencyProviders) { throw null; }
    }
    public partial class EnableSourceArgs
    {
        public string Configfile { get { throw null; } set { } }
        public string Name { get { throw null; } set { } }
    }
    public static partial class EnableSourceRunner
    {
        public static void Run(EnableSourceArgs args, System.Func<Common.ILogger> getLogger) { }
    }
    public partial interface IClientCertArgsWithConfigFile
    {
        string Configfile { get; set; }
    }

    public partial interface IClientCertArgsWithFileData
    {
        string Password { get; set; }

        string Path { get; set; }

        bool StorePasswordInClearText { get; set; }
    }

    public partial interface IClientCertArgsWithForce
    {
        bool Force { get; set; }
    }

    public partial interface IClientCertArgsWithPackageSource
    {
        string PackageSource { get; set; }
    }

    public partial interface IClientCertArgsWithStoreData
    {
        string FindBy { get; set; }

        string FindValue { get; set; }

        string StoreLocation { get; set; }

        string StoreName { get; set; }
    }

    public partial interface IListCommandRunner
    {
        System.Threading.Tasks.Task ExecuteCommand(ListArgs listArgs);
    }

    public partial interface ILocalsCommandRunner
    {
        void ExecuteCommand(LocalsArgs localsArgs);
    }

    public partial interface IMSBuildItem
    {
        string Identity { get; }

        System.Collections.Generic.IReadOnlyList<string> Properties { get; }

        string GetProperty(string property, bool trim);
        string GetProperty(string property);
    }

    public partial class IndexedRestoreTargetGraph
    {
        internal IndexedRestoreTargetGraph() { }
        public IRestoreTargetGraph Graph { get { throw null; } }

        public static IndexedRestoreTargetGraph Create(IRestoreTargetGraph graph) { throw null; }
        public DependencyResolver.GraphItem<DependencyResolver.RemoteResolveResult> GetItemById(string id, LibraryModel.LibraryType libraryType) { throw null; }
        public DependencyResolver.GraphItem<DependencyResolver.RemoteResolveResult> GetItemById(string id) { throw null; }
        public bool HasErrors(string id) { throw null; }
    }
    public partial interface IPreLoadedRestoreRequestProvider
    {
        System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<RestoreSummaryRequest>> CreateRequests(RestoreArgs restoreContext);
    }

    public partial interface IProjectFactory
    {
        Common.ILogger Logger { get; set; }

        Packaging.PackageBuilder CreateBuilder(string basePath, Versioning.NuGetVersion version, string suffix, bool buildIfNeeded, Packaging.PackageBuilder builder = null);
        System.Collections.Generic.Dictionary<string, string> GetProjectProperties();
        ProjectModel.WarningProperties GetWarningPropertiesForProject();
        void SetIncludeSymbols(bool includeSymbols);
    }

    public partial interface IRestoreProgressReporter
    {
        void EndProjectUpdate(string projectPath, System.Collections.Generic.IReadOnlyList<string> updatedFiles);
        void StartProjectUpdate(string projectPath, System.Collections.Generic.IReadOnlyList<string> updatedFiles);
    }

    public partial interface IRestoreRequestProvider
    {
        System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<RestoreSummaryRequest>> CreateRequests(string inputPath, RestoreArgs restoreContext);
        System.Threading.Tasks.Task<bool> Supports(string path);
    }

    public partial interface IRestoreResult
    {
        ProjectModel.LockFile LockFile { get; }

        string LockFilePath { get; }

        System.Collections.Generic.IEnumerable<MSBuildOutputFile> MSBuildOutputFiles { get; }

        ProjectModel.LockFile PreviousLockFile { get; }

        bool Success { get; }
    }

    public partial interface IRestoreTargetGraph
    {
        DependencyResolver.AnalyzeResult<DependencyResolver.RemoteResolveResult> AnalyzeResult { get; }

        System.Collections.Generic.IEnumerable<ResolverConflict> Conflicts { get; }

        Client.ManagedCodeConventions Conventions { get; }

        System.Collections.Generic.ISet<DependencyResolver.GraphItem<DependencyResolver.RemoteResolveResult>> Flattened { get; }

        Frameworks.NuGetFramework Framework { get; }

        System.Collections.Generic.IEnumerable<DependencyResolver.GraphNode<DependencyResolver.RemoteResolveResult>> Graphs { get; }

        bool InConflict { get; }

        System.Collections.Generic.ISet<DependencyResolver.RemoteMatch> Install { get; }

        string Name { get; }

        System.Collections.Generic.ISet<ResolvedDependencyKey> ResolvedDependencies { get; }

        RuntimeModel.RuntimeGraph RuntimeGraph { get; }

        string RuntimeIdentifier { get; }

        string TargetGraphName { get; }

        System.Collections.Generic.ISet<LibraryModel.LibraryRange> Unresolved { get; }
    }

    public partial interface ISignCommandRunner
    {
        System.Threading.Tasks.Task<int> ExecuteCommandAsync(SignArgs signArgs);
    }

    public partial interface ITrustedSignersCommandRunner
    {
        System.Threading.Tasks.Task<int> ExecuteCommandAsync(TrustedSignersArgs trustedSignersArgs);
    }

    public partial interface IVerifyCommandRunner
    {
        System.Threading.Tasks.Task<int> ExecuteCommandAsync(VerifyArgs verifyArgs);
    }

    public partial class ListArgs
    {
        public ListArgs(System.Collections.Generic.IList<string> arguments, System.Collections.Generic.IList<Configuration.PackageSource> listEndpoints, Configuration.ISettings settings, Common.ILogger logger, Log printJustified, bool isDetailedl, string listCommandNoPackages, string listCommandLicenseUrl, string listCommandListNotSupported, bool allVersions, bool includeDelisted, bool prerelease, System.Threading.CancellationToken token) { }
        public bool AllVersions { get { throw null; } }
        public System.Collections.Generic.IList<string> Arguments { get { throw null; } }
        public System.Threading.CancellationToken CancellationToken { get { throw null; } }
        public bool IncludeDelisted { get { throw null; } }
        public bool IsDetailed { get { throw null; } }
        public string ListCommandLicenseUrl { get { throw null; } }
        public string ListCommandListNotSupported { get { throw null; } }
        public string ListCommandNoPackages { get { throw null; } }
        public System.Collections.Generic.IList<Configuration.PackageSource> ListEndpoints { get { throw null; } }
        public Common.ILogger Logger { get { throw null; } }
        public bool Prerelease { get { throw null; } }
        public Log PrintJustified { get { throw null; } }
        public Configuration.ISettings Settings { get { throw null; } }

        public delegate void Log(int startIndex, string message);
    }
    public partial class ListClientCertArgs : IClientCertArgsWithConfigFile
    {
        public string Configfile { get { throw null; } set { } }
    }

    public static partial class ListClientCertRunner
    {
        public static void Run(ListClientCertArgs args, System.Func<Common.ILogger> getLogger) { }
    }
    public partial class ListCommandRunner : IListCommandRunner
    {
        public System.Threading.Tasks.Task ExecuteCommand(ListArgs listArgs) { throw null; }
    }

    public partial class ListSourceArgs
    {
        public string Configfile { get { throw null; } set { } }
        public string Format { get { throw null; } set { } }
    }
    public static partial class ListSourceRunner
    {
        public static void Run(ListSourceArgs args, System.Func<Common.ILogger> getLogger) { }
    }
    public partial class LocalsArgs
    {
        public LocalsArgs(System.Collections.Generic.IList<string> arguments, Configuration.ISettings settings, Log logInformation, Log logError, bool clear, bool list) { }
        public System.Collections.Generic.IList<string> Arguments { get { throw null; } }
        public bool Clear { get { throw null; } }
        public bool List { get { throw null; } }
        public Log LogError { get { throw null; } }
        public Log LogInformation { get { throw null; } }
        public Configuration.ISettings Settings { get { throw null; } }

        public delegate void Log(string message);
    }
    public partial class LocalsCommandRunner : ILocalsCommandRunner
    {
        public void ExecuteCommand(LocalsArgs localsArgs) { }
    }

    public partial class LockFileBuilder
    {
        public LockFileBuilder(int lockFileVersion, Common.ILogger logger, System.Collections.Generic.Dictionary<RestoreTargetGraph, System.Collections.Generic.Dictionary<string, LibraryModel.LibraryIncludeFlags>> includeFlagGraphs) { }
        public ProjectModel.LockFile CreateLockFile(ProjectModel.LockFile previousLockFile, ProjectModel.PackageSpec project, System.Collections.Generic.IEnumerable<RestoreTargetGraph> targetGraphs, System.Collections.Generic.IReadOnlyList<Repositories.NuGetv3LocalRepository> localRepositories, DependencyResolver.RemoteWalkContext context, LockFileBuilderCache lockFileBuilderCache) { throw null; }
        [System.Obsolete("Use method with LockFileBuilderCache parameter")]
        public ProjectModel.LockFile CreateLockFile(ProjectModel.LockFile previousLockFile, ProjectModel.PackageSpec project, System.Collections.Generic.IEnumerable<RestoreTargetGraph> targetGraphs, System.Collections.Generic.IReadOnlyList<Repositories.NuGetv3LocalRepository> localRepositories, DependencyResolver.RemoteWalkContext context) { throw null; }
    }
    public partial class LockFileBuilderCache
    {
        public ContentModel.ContentItemCollection GetContentItems(ProjectModel.LockFileLibrary library, Repositories.LocalPackageInfo package) { throw null; }
        public System.Collections.Generic.List<System.Collections.Generic.List<ContentModel.SelectionCriteria>> GetSelectionCriteria(RestoreTargetGraph graph, Frameworks.NuGetFramework framework) { throw null; }
    }
    public static partial class LockFileUtils
    {
        public static readonly string LIBANY;
        public static ProjectModel.LockFileTargetLibrary CreateLockFileTargetLibrary(ProjectModel.LockFileLibrary library, Repositories.LocalPackageInfo package, RestoreTargetGraph targetGraph, LibraryModel.LibraryIncludeFlags dependencyType) { throw null; }
        public static ProjectModel.LockFileTargetLibrary CreateLockFileTargetProject(DependencyResolver.GraphItem<DependencyResolver.RemoteResolveResult> graphItem, LibraryModel.LibraryIdentity library, LibraryModel.LibraryIncludeFlags dependencyType, RestoreTargetGraph targetGraph, ProjectModel.ProjectStyle rootProjectStyle) { throw null; }
        public static void ExcludeItems(ProjectModel.LockFileTargetLibrary lockFileLib, LibraryModel.LibraryIncludeFlags dependencyType) { }
        public static string ToDirectorySeparator(string path) { throw null; }
    }
    public partial class MSBuildItem : IMSBuildItem
    {
        public MSBuildItem(string identity, System.Collections.Generic.IDictionary<string, string> metadata) { }
        public string Identity { get { throw null; } }
        public System.Collections.Generic.IReadOnlyList<string> Properties { get { throw null; } }

        public string GetProperty(string property, bool trim) { throw null; }
        public string GetProperty(string property) { throw null; }
        public override string ToString() { throw null; }
    }

    public partial class MSBuildOutputFile
    {
        public MSBuildOutputFile(string path, System.Xml.Linq.XDocument content) { }
        public System.Xml.Linq.XDocument Content { get { throw null; } }
        public string Path { get { throw null; } }
    }
    public partial class MSBuildPackTargetArgs
    {
        public System.Collections.Generic.HashSet<string> AllowedOutputExtensionsInPackageBuildOutputFolder { get { throw null; } set { } }
        public System.Collections.Generic.HashSet<string> AllowedOutputExtensionsInSymbolsPackageBuildOutputFolder { get { throw null; } set { } }
        public string AssemblyName { get { throw null; } set { } }
        public string[] BuildOutputFolder { get { throw null; } set { } }
        public System.Collections.Generic.Dictionary<string, System.Collections.Generic.IEnumerable<ContentMetadata>> ContentFiles { get { throw null; } set { } }
        public bool IncludeBuildOutput { get { throw null; } set { } }
        public string NuspecOutputPath { get { throw null; } set { } }
        public System.Collections.Generic.IDictionary<string, string> SourceFiles { get { throw null; } set { } }
        public System.Collections.Generic.ISet<Frameworks.NuGetFramework> TargetFrameworks { get { throw null; } set { } }
        public System.Collections.Generic.IEnumerable<OutputLibFile> TargetPathsToAssemblies { get { throw null; } set { } }
        public System.Collections.Generic.IEnumerable<OutputLibFile> TargetPathsToSymbols { get { throw null; } set { } }
    }
    public partial class MSBuildProjectFactory : IProjectFactory
    {
        public bool Build { get { throw null; } set { } }
        public System.Collections.Generic.ICollection<Packaging.ManifestFile> Files { get { throw null; } set { } }
        public bool IncludeSymbols { get { throw null; } set { } }
        public bool IsTool { get { throw null; } set { } }
        public Common.ILogger Logger { get { throw null; } set { } }
        public Configuration.IMachineWideSettings MachineWideSettings { get { throw null; } set { } }
        public System.Collections.Generic.Dictionary<string, string> ProjectProperties { get { throw null; } }

        public Packaging.PackageBuilder CreateBuilder(string basePath, Versioning.NuGetVersion version, string suffix, bool buildIfNeeded, Packaging.PackageBuilder builder) { throw null; }
        public System.Collections.Generic.Dictionary<string, string> GetProjectProperties() { throw null; }
        public static string GetTargetPathForSourceFile(string sourcePath, string projectDirectory) { throw null; }
        public ProjectModel.WarningProperties GetWarningPropertiesForProject() { throw null; }
        public static IProjectFactory ProjectCreator(PackArgs packArgs, string path) { throw null; }
        public void SetIncludeSymbols(bool includeSymbols) { }
    }

    public static partial class MSBuildProjectFrameworkUtility
    {
        public static Frameworks.NuGetFramework GetProjectFramework(string projectFilePath, string targetFrameworkMoniker, string targetPlatformMoniker, string targetPlatformMinVersion, string clrSupport, string windowsTargetPlatformMinVersion) { throw null; }
        [System.Obsolete("If you need ClrSupport support parameter to be accounted for in the calculation, the method with the windowsTargetPlatformMinVersion is the only correct one.")]
        public static Frameworks.NuGetFramework GetProjectFramework(string projectFilePath, string targetFrameworkMoniker, string targetPlatformMoniker, string targetPlatformMinVersion, string clrSupport) { throw null; }
        public static Frameworks.NuGetFramework GetProjectFramework(string projectFilePath, string targetFrameworkMoniker, string targetPlatformMoniker, string targetPlatformMinVersion) { throw null; }
        public static Frameworks.NuGetFramework GetProjectFrameworkReplacement(Frameworks.NuGetFramework framework) { throw null; }
        public static System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework> GetProjectFrameworks(System.Collections.Generic.IEnumerable<string> frameworkStrings) { throw null; }
        public static System.Collections.Generic.IEnumerable<string> GetProjectFrameworkStrings(string projectFilePath, string targetFrameworks, string targetFramework, string targetFrameworkMoniker, string targetPlatformIdentifier, string targetPlatformVersion, string targetPlatformMinVersion, bool isXnaWindowsPhoneProject, bool isManagementPackProject) { throw null; }
        public static System.Collections.Generic.IEnumerable<string> GetProjectFrameworkStrings(string projectFilePath, string targetFrameworks, string targetFramework, string targetFrameworkMoniker, string targetPlatformIdentifier, string targetPlatformVersion, string targetPlatformMinVersion) { throw null; }
    }
    public partial class MSBuildRestoreItemGroup
    {
        public static readonly string ImportGroup;
        public static readonly string ItemGroup;
        public string Condition { get { throw null; } }
        public System.Collections.Generic.List<string> Conditions { get { throw null; } set { } }
        public System.Collections.Generic.List<System.Xml.Linq.XElement> Items { get { throw null; } set { } }
        public int Position { get { throw null; } set { } }
        public string RootName { get { throw null; } set { } }

        public static MSBuildRestoreItemGroup Create(string rootName, System.Collections.Generic.IEnumerable<System.Xml.Linq.XElement> items, int position, System.Collections.Generic.IEnumerable<string> conditions) { throw null; }
    }
    public static partial class MSBuildRestoreUtility
    {
        public static readonly string Clear;
        public static System.Collections.Generic.IEnumerable<string> AggregateSources(System.Collections.Generic.IEnumerable<string> values, System.Collections.Generic.IEnumerable<string> excludeValues) { throw null; }
        public static void ApplyIncludeFlags(ProjectModel.ProjectRestoreReference dependency, string includeAssets, string excludeAssets, string privateAssets) { }
        public static bool ContainsClearKeyword(System.Collections.Generic.IEnumerable<string> values) { throw null; }
        public static void Dump(System.Collections.Generic.IEnumerable<IMSBuildItem> items, Common.ILogger log) { }
        public static string FixSourcePath(string s) { throw null; }
        public static (bool IsEnabled, bool IsVersionOverrideDisabled, bool IsCentralPackageTransitivePinningEnabled, bool isCentralPackageFloatingVersionsEnabled) GetCentralPackageManagementSettings(IMSBuildItem projectSpecItem, ProjectModel.ProjectStyle projectStyle) { throw null; }
        public static ProjectModel.DependencyGraphSpec GetDependencySpec(System.Collections.Generic.IEnumerable<IMSBuildItem> items, bool readOnly) { throw null; }
        public static ProjectModel.DependencyGraphSpec GetDependencySpec(System.Collections.Generic.IEnumerable<IMSBuildItem> items) { throw null; }
        public static (LibraryModel.LibraryIncludeFlags includeType, LibraryModel.LibraryIncludeFlags suppressParent) GetLibraryDependencyIncludeFlags(string includeAssets, string excludeAssets, string privateAssets) { throw null; }
        public static Common.RestoreLogMessage GetMessageForUnsupportedProject(string path) { throw null; }
        public static ProjectModel.PackageSpec GetPackageSpec(System.Collections.Generic.IEnumerable<IMSBuildItem> items) { throw null; }
        public static ProjectModel.RestoreAuditProperties GetRestoreAuditProperties(IMSBuildItem specItem, System.Collections.Generic.HashSet<string> suppressionItems) { throw null; }
        public static Versioning.NuGetVersion GetSdkAnalysisLevel(string sdkAnalysisLevel) { throw null; }
        public static bool GetUsingMicrosoftNETSdk(string usingMicrosoftNETSdk) { throw null; }
        public static Common.RestoreLogMessage GetWarningForUnsupportedProject(string path) { throw null; }
        public static bool HasInvalidClear(System.Collections.Generic.IEnumerable<string> values) { throw null; }
        public static bool LogErrorForClearIfInvalid(System.Collections.Generic.IEnumerable<string> values, string projectPath, Common.ILogger logger) { throw null; }
        public static void NormalizePathCasings(System.Collections.Generic.Dictionary<string, string> paths, ProjectModel.DependencyGraphSpec graphSpec) { }
        public static void NormalizePathCasings(System.Collections.Generic.IDictionary<string, string> paths, ProjectModel.DependencyGraphSpec graphSpec) { }
        public static void RemoveMissingProjects(ProjectModel.DependencyGraphSpec graphSpec) { }
        public static System.Threading.Tasks.Task ReplayWarningsAndErrorsAsync(System.Collections.Generic.IEnumerable<ProjectModel.IAssetsLogMessage> messages, Common.ILogger logger) { throw null; }
    }
    public partial class NoOpRestoreResult : RestoreResult
    {
        public NoOpRestoreResult(bool success, string lockFilePath, System.Lazy<ProjectModel.LockFile> lockFileLazy, ProjectModel.CacheFile cacheFile, string cacheFilePath, ProjectModel.ProjectStyle projectStyle, System.TimeSpan elapsedTime) : base(default, default!, default!, default!, default!, default!, default!, default!, default!, default!, default!, default!, default!, default, default) { }
        public override ProjectModel.LockFile LockFile { get { throw null; } }
        public override ProjectModel.LockFile PreviousLockFile { get { throw null; } }

        public override System.Threading.Tasks.Task CommitAsync(Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
        public override System.Collections.Generic.ISet<LibraryModel.LibraryIdentity> GetAllInstalled() { throw null; }
    }

    public static partial class NoOpRestoreUtilities
    {
        public static string GetProjectCacheFilePath(string cacheRoot, string projectPath) { throw null; }
        public static string GetProjectCacheFilePath(string cacheRoot) { throw null; }
    }
    public partial class OriginalCaseGlobalPackageFolder
    {
        public OriginalCaseGlobalPackageFolder(RestoreRequest request, System.Guid parentId) { }
        public OriginalCaseGlobalPackageFolder(RestoreRequest request) { }
        public System.Guid ParentId { get { throw null; } }

        public void ConvertLockFileToOriginalCase(ProjectModel.LockFile lockFile) { }
        public System.Threading.Tasks.Task CopyPackagesToOriginalCaseAsync(System.Collections.Generic.IEnumerable<RestoreTargetGraph> graphs, System.Threading.CancellationToken token) { throw null; }
    }
    public partial struct OutputLibFile
    {
        private object _dummy;
        private int _dummyPrimitive;
        public string FinalOutputPath { get { throw null; } set { } }
        public string TargetFramework { get { throw null; } set { } }
        public string TargetPath { get { throw null; } set { } }
    }

    public partial class PackagesLockFileBuilder
    {
        public ProjectModel.PackagesLockFile CreateNuGetLockFile(ProjectModel.LockFile assetsFile) { throw null; }
    }
    public static partial class PackageSourceProviderExtensions
    {
        public static string ResolveAndValidateSource(this Configuration.IPackageSourceProvider sourceProvider, string source) { throw null; }
        public static Configuration.PackageSource ResolveSource(System.Collections.Generic.IEnumerable<Configuration.PackageSource> availableSources, string source) { throw null; }
    }
    public partial class PackageSpecificWarningProperties : System.IEquatable<PackageSpecificWarningProperties>
    {
        public System.Collections.Generic.IDictionary<Common.NuGetLogCode, System.Collections.Generic.IDictionary<string, System.Collections.Generic.ISet<Frameworks.NuGetFramework>>> Properties { get { throw null; } }

        public void Add(Common.NuGetLogCode code, string libraryId, Frameworks.NuGetFramework framework) { }
        public void AddRangeOfCodes(System.Collections.Generic.IEnumerable<Common.NuGetLogCode> codes, string libraryId, Frameworks.NuGetFramework framework) { }
        public void AddRangeOfFrameworks(Common.NuGetLogCode code, string libraryId, System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework> frameworks) { }
        public bool Contains(Common.NuGetLogCode code, string libraryId, Frameworks.NuGetFramework framework) { throw null; }
        public static PackageSpecificWarningProperties CreatePackageSpecificWarningProperties(ProjectModel.PackageSpec packageSpec, Frameworks.NuGetFramework framework) { throw null; }
        public static PackageSpecificWarningProperties CreatePackageSpecificWarningProperties(ProjectModel.PackageSpec packageSpec) { throw null; }
        public bool Equals(PackageSpecificWarningProperties other) { throw null; }
        public override bool Equals(object obj) { throw null; }
        public override int GetHashCode() { throw null; }
    }

    public partial class PackArgs
    {
        public System.Collections.Generic.IEnumerable<string> Arguments { get { throw null; } set { } }
        public string BasePath { get { throw null; } set { } }
        public bool Build { get { throw null; } set { } }
        public string CurrentDirectory { get { throw null; } set { } }
        public bool Deterministic { get { throw null; } set { } }
        public System.Collections.Generic.IEnumerable<string> Exclude { get { throw null; } set { } }
        public bool ExcludeEmptyDirectories { get { throw null; } set { } }
        public bool IncludeReferencedProjects { get { throw null; } set { } }
        public bool InstallPackageToOutputPath { get { throw null; } set { } }
        public Common.ILogger Logger { get { throw null; } set { } }
        public Common.LogLevel LogLevel { get { throw null; } set { } }
        public Configuration.IMachineWideSettings MachineWideSettings { get { throw null; } set { } }
        public System.Version MinClientVersion { get { throw null; } set { } }
        public System.Lazy<string> MsBuildDirectory { get { throw null; } set { } }
        public bool NoDefaultExcludes { get { throw null; } set { } }
        public bool NoPackageAnalysis { get { throw null; } set { } }
        public string OutputDirectory { get { throw null; } set { } }
        public bool OutputFileNamesWithoutVersion { get { throw null; } set { } }
        public string PackagesDirectory { get { throw null; } set { } }
        public MSBuildPackTargetArgs PackTargetArgs { get { throw null; } set { } }
        public string Path { get { throw null; } set { } }
        public System.Collections.Generic.Dictionary<string, string> Properties { get { throw null; } }
        public bool Serviceable { get { throw null; } set { } }
        public string SolutionDirectory { get { throw null; } set { } }
        public string Suffix { get { throw null; } set { } }
        public SymbolPackageFormat SymbolPackageFormat { get { throw null; } set { } }
        public bool Symbols { get { throw null; } set { } }
        public bool Tool { get { throw null; } set { } }
        public string Version { get { throw null; } set { } }
        public ProjectModel.WarningProperties WarningProperties { get { throw null; } set { } }

        public string GetPropertyValue(string propertyName) { throw null; }
        public static SymbolPackageFormat GetSymbolPackageFormat(string symbolPackageFormat) { throw null; }
    }
    public partial class PackCollectorLogger : Common.LoggerBase
    {
        public PackCollectorLogger(Common.ILogger innerLogger, ProjectModel.WarningProperties warningProperties, PackCommand.PackageSpecificWarningProperties packageSpecificWarningProperties) { }
        public PackCollectorLogger(Common.ILogger innerLogger, ProjectModel.WarningProperties warningProperties) { }
        public System.Collections.Generic.IEnumerable<Common.ILogMessage> Errors { get { throw null; } }
        public ProjectModel.WarningProperties WarningProperties { get { throw null; } set { } }

        public override void Log(Common.ILogMessage message) { }
        public override System.Threading.Tasks.Task LogAsync(Common.ILogMessage message) { throw null; }
    }

    public partial class PackCommandRunner
    {
        public PackCommandRunner(PackArgs packArgs, CreateProjectFactory createProjectFactory, Packaging.PackageBuilder packageBuilder) { }
        public PackCommandRunner(PackArgs packArgs, CreateProjectFactory createProjectFactory) { }
        public bool GenerateNugetPackage { get { throw null; } set { } }
        public System.Collections.Generic.IEnumerable<Packaging.Rules.IPackageRule> Rules { get { throw null; } set { } }

        public static void AddDependencyGroups(System.Collections.Generic.IEnumerable<LibraryModel.LibraryDependency> dependencies, Frameworks.NuGetFramework framework, Packaging.PackageBuilder builder) { }
        public static void AddLibraryDependency(LibraryModel.LibraryDependency dependency, System.Collections.Generic.ISet<LibraryModel.LibraryDependency> list) { }
        public static void AddPackageDependency(Packaging.Core.PackageDependency dependency, System.Collections.Generic.ISet<Packaging.Core.PackageDependency> set) { }
        [System.Obsolete("Do not use this. Use RunPackageBuild() instead as it accounts for the effects of package analysis to the complete operation status.")]
        public void BuildPackage() { }
        [System.Obsolete("Do not use this. Use RunPackageBuild() instead as it accounts for the effects of package analysis to the complete operation status.")]
        public Packaging.PackageArchiveReader BuildPackage(Packaging.PackageBuilder builder, string outputPath = null) { throw null; }
        public static string GetInputFile(PackArgs packArgs) { throw null; }
        public static string GetOutputFileName(string packageId, Versioning.NuGetVersion version, bool isNupkg, bool symbols, SymbolPackageFormat symbolPackageFormat, bool excludeVersion = false) { throw null; }
        public static string GetOutputPath(Packaging.PackageBuilder builder, PackArgs packArgs, bool symbols = false, Versioning.NuGetVersion nugetVersion = null, string outputDirectory = null, bool isNupkg = true) { throw null; }
        [System.Obsolete]
        public static bool ProcessProjectJsonFile(Packaging.PackageBuilder builder, string basePath, string id, Versioning.NuGetVersion version, string suffix, System.Func<string, string> propertyProvider) { throw null; }
        public bool RunPackageBuild() { throw null; }
        public static void SetupCurrentDirectory(PackArgs packArgs) { }
        public delegate IProjectFactory CreateProjectFactory(PackArgs packArgs, string path);
    }
    public static partial class PushRunner
    {
        public static System.Threading.Tasks.Task Run(Configuration.ISettings settings, Configuration.IPackageSourceProvider sourceProvider, System.Collections.Generic.IList<string> packagePaths, string source, string apiKey, string symbolSource, string symbolApiKey, int timeoutSeconds, bool disableBuffering, bool noSymbols, bool noServiceEndpoint, bool skipDuplicate, Common.ILogger logger) { throw null; }
        [System.Obsolete("Use Run method which takes multiple package paths.")]
        public static System.Threading.Tasks.Task Run(Configuration.ISettings settings, Configuration.IPackageSourceProvider sourceProvider, string packagePath, string source, string apiKey, string symbolSource, string symbolApiKey, int timeoutSeconds, bool disableBuffering, bool noSymbols, bool noServiceEndpoint, bool skipDuplicate, Common.ILogger logger) { throw null; }
    }
    public partial class RemoveClientCertArgs : IClientCertArgsWithConfigFile, IClientCertArgsWithPackageSource
    {
        public string Configfile { get { throw null; } set { } }
        public string PackageSource { get { throw null; } set { } }
    }

    public static partial class RemoveClientCertRunner
    {
        public static void Run(RemoveClientCertArgs args, System.Func<Common.ILogger> getLogger) { }
    }
    public partial class RemoveSourceArgs
    {
        public string Configfile { get { throw null; } set { } }
        public string Name { get { throw null; } set { } }
    }
    public static partial class RemoveSourceRunner
    {
        public static void Run(RemoveSourceArgs args, System.Func<Common.ILogger> getLogger) { }
    }
    public static partial class RequestRuntimeUtility
    {
        public static System.Collections.Generic.IEnumerable<string> GetDefaultRestoreRuntimes(string os, string runtimeOsName) { throw null; }
    }
    public readonly partial struct ResolvedDependencyKey : System.IEquatable<ResolvedDependencyKey>
    {
        private readonly object _dummy;
        private readonly int _dummyPrimitive;
        public ResolvedDependencyKey(LibraryModel.LibraryIdentity parent, Versioning.VersionRange range, LibraryModel.LibraryIdentity child) { }
        public LibraryModel.LibraryIdentity Child { get { throw null; } }
        public LibraryModel.LibraryIdentity Parent { get { throw null; } }
        public Versioning.VersionRange Range { get { throw null; } }

        public readonly bool Equals(ResolvedDependencyKey other) { throw null; }
        public override readonly bool Equals(object obj) { throw null; }
        public override readonly int GetHashCode() { throw null; }
        public static bool operator ==(ResolvedDependencyKey left, ResolvedDependencyKey right) { throw null; }
        public static bool operator !=(ResolvedDependencyKey left, ResolvedDependencyKey right) { throw null; }
    }

    public partial class ResolverConflict
    {
        public ResolverConflict(string name, System.Collections.Generic.IEnumerable<ResolverRequest> requests) { }
        public string Name { get { throw null; } }
        public System.Collections.Generic.IList<ResolverRequest> Requests { get { throw null; } }
    }
    public partial class ResolverRequest
    {
        public ResolverRequest(LibraryModel.LibraryIdentity requestor, LibraryModel.LibraryRange request) { }
        public LibraryModel.LibraryRange Request { get { throw null; } }
        public LibraryModel.LibraryIdentity Requestor { get { throw null; } }

        public override string ToString() { throw null; }
    }
    public partial class RestoreArgs
    {
        public System.Collections.Generic.IReadOnlyList<ProjectModel.IAssetsLogMessage> AdditionalMessages { get { throw null; } set { } }
        public bool AllowNoOp { get { throw null; } set { } }
        public Protocol.Core.Types.SourceCacheContext CacheContext { get { throw null; } set { } }
        public Protocol.CachingSourceProvider CachingSourceProvider { get { throw null; } set { } }
        public string ConfigFile { get { throw null; } set { } }
        public bool DisableParallel { get { throw null; } set { } }
        public System.Collections.Generic.HashSet<string> FallbackRuntimes { get { throw null; } set { } }
        public string GlobalPackagesFolder { get { throw null; } set { } }
        public bool HideWarningsAndErrors { get { throw null; } set { } }
        public System.Collections.Generic.List<string> Inputs { get { throw null; } set { } }
        public bool? IsLowercaseGlobalPackagesFolder { get { throw null; } set { } }
        public bool IsRestoreOriginalAction { get { throw null; } set { } }
        public int? LockFileVersion { get { throw null; } set { } }
        public Common.ILogger Log { get { throw null; } set { } }
        public Configuration.IMachineWideSettings MachineWideSettings { get { throw null; } set { } }
        public Packaging.PackageSaveMode PackageSaveMode { get { throw null; } set { } }
        public System.Guid ParentId { get { throw null; } set { } }
        public System.Collections.Generic.List<IPreLoadedRestoreRequestProvider> PreLoadedRequestProviders { get { throw null; } set { } }
        public IRestoreProgressReporter ProgressReporter { get { throw null; } set { } }
        public System.Collections.Generic.List<IRestoreRequestProvider> RequestProviders { get { throw null; } set { } }
        public bool RestoreForceEvaluate { get { throw null; } set { } }
        public System.Collections.Generic.HashSet<string> Runtimes { get { throw null; } set { } }
        public System.Collections.Generic.List<string> Sources { get { throw null; } set { } }
        public bool? ValidateRuntimeAssets { get { throw null; } set { } }

        public void ApplyStandardProperties(RestoreRequest request) { }
        public System.Collections.Generic.IReadOnlyList<string> GetEffectiveFallbackPackageFolders(Configuration.ISettings settings) { throw null; }
        public string GetEffectiveGlobalPackagesFolder(string rootDirectory, Configuration.ISettings settings) { throw null; }
        public Configuration.ISettings GetSettings(string projectDirectory) { throw null; }
    }
    public partial class RestoreCollectorLogger : Common.LoggerBase, Common.ICollectorLogger, Common.ILogger
    {
        public RestoreCollectorLogger(Common.ILogger innerLogger, Common.LogLevel verbosity, bool hideWarningsAndErrors) { }
        public RestoreCollectorLogger(Common.ILogger innerLogger, Common.LogLevel verbosity) { }
        public RestoreCollectorLogger(Common.ILogger innerLogger, bool hideWarningsAndErrors) { }
        public RestoreCollectorLogger(Common.ILogger innerLogger) { }
        public System.Collections.Generic.IEnumerable<Common.IRestoreLogMessage> Errors { get { throw null; } }
        public string ProjectPath { get { throw null; } }
        public WarningPropertiesCollection ProjectWarningPropertiesCollection { get { throw null; } set { } }
        public WarningPropertiesCollection TransitiveWarningPropertiesCollection { get { throw null; } set { } }

        public void ApplyRestoreInputs(ProjectModel.PackageSpec projectSpec) { }
        public void ApplyRestoreOutput(System.Collections.Generic.IEnumerable<RestoreTargetGraph> restoreTargetGraphs) { }
        protected bool DisplayMessage(Common.IRestoreLogMessage message) { throw null; }
        public override void Log(Common.ILogMessage message) { }
        public void Log(Common.IRestoreLogMessage message) { }
        public override System.Threading.Tasks.Task LogAsync(Common.ILogMessage message) { throw null; }
        public System.Threading.Tasks.Task LogAsync(Common.IRestoreLogMessage message) { throw null; }
    }

    public partial class RestoreCommand
    {
        public RestoreCommand(RestoreRequest request) { }
        public System.Guid ParentId { get { throw null; } }

        public System.Threading.Tasks.Task<RestoreResult> ExecuteAsync() { throw null; }
        public System.Threading.Tasks.Task<RestoreResult> ExecuteAsync(System.Threading.CancellationToken token) { throw null; }
    }
    public partial class RestoreCommandException : System.Exception, Common.ILogMessageException
    {
        public RestoreCommandException(Common.IRestoreLogMessage logMessage) { }
        public Common.ILogMessage AsLogMessage() { throw null; }
    }

    public partial class RestoreCommandProviders
    {
        [System.Obsolete("Create via RestoreCommandProvidersCache")]
        public RestoreCommandProviders(Repositories.NuGetv3LocalRepository globalPackages, System.Collections.Generic.IReadOnlyList<Repositories.NuGetv3LocalRepository> fallbackPackageFolders, System.Collections.Generic.IReadOnlyList<DependencyResolver.IRemoteDependencyProvider> localProviders, System.Collections.Generic.IReadOnlyList<DependencyResolver.IRemoteDependencyProvider> remoteProviders, Protocol.LocalPackageFileCache packageFileCache) { }
        public System.Collections.Generic.IReadOnlyList<Repositories.NuGetv3LocalRepository> FallbackPackageFolders { get { throw null; } }
        public Repositories.NuGetv3LocalRepository GlobalPackages { get { throw null; } }
        public System.Collections.Generic.IReadOnlyList<DependencyResolver.IRemoteDependencyProvider> LocalProviders { get { throw null; } }
        public Protocol.LocalPackageFileCache PackageFileCache { get { throw null; } }
        public System.Collections.Generic.IReadOnlyList<DependencyResolver.IRemoteDependencyProvider> RemoteProviders { get { throw null; } }

        [System.Obsolete("Create via RestoreCommandProvidersCache")]
        public static RestoreCommandProviders Create(string globalFolderPath, System.Collections.Generic.IEnumerable<string> fallbackPackageFolderPaths, System.Collections.Generic.IEnumerable<Protocol.Core.Types.SourceRepository> sources, Protocol.Core.Types.SourceCacheContext cacheContext, Protocol.LocalPackageFileCache packageFileCache, Common.ILogger log) { throw null; }
    }
    public partial class RestoreCommandProvidersCache
    {
        public RestoreCommandProviders GetOrCreate(string globalPackagesPath, System.Collections.Generic.IReadOnlyList<string> fallbackPackagesPaths, System.Collections.Generic.IReadOnlyList<Protocol.Core.Types.SourceRepository> sources, Protocol.Core.Types.SourceCacheContext cacheContext, Common.ILogger log, bool updateLastAccess) { throw null; }
        public RestoreCommandProviders GetOrCreate(string globalPackagesPath, System.Collections.Generic.IReadOnlyList<string> fallbackPackagesPaths, System.Collections.Generic.IReadOnlyList<Protocol.Core.Types.SourceRepository> sources, Protocol.Core.Types.SourceCacheContext cacheContext, Common.ILogger log) { throw null; }
        public RestoreCommandProviders GetOrCreate(string globalPackagesPath, System.Collections.Generic.IReadOnlyList<string> fallbackPackagesPaths, System.Collections.Generic.IReadOnlyList<Protocol.Core.Types.SourceRepository> packageSources, System.Collections.Generic.IReadOnlyList<Protocol.Core.Types.SourceRepository> auditSources, Protocol.Core.Types.SourceCacheContext cacheContext, Common.ILogger log, bool updateLastAccess) { throw null; }
    }
    public partial class RestoreRequest
    {
        public static readonly int DefaultDegreeOfConcurrency;
        [System.Obsolete("Use constructor with LockFileBuilderCache parameter")]
        public RestoreRequest(ProjectModel.PackageSpec project, RestoreCommandProviders dependencyProviders, Protocol.Core.Types.SourceCacheContext cacheContext, Packaging.Signing.ClientPolicyContext clientPolicyContext, Common.ILogger log) { }
        public RestoreRequest(ProjectModel.PackageSpec project, RestoreCommandProviders dependencyProviders, Protocol.Core.Types.SourceCacheContext cacheContext, Packaging.Signing.ClientPolicyContext clientPolicyContext, Configuration.PackageSourceMapping packageSourceMapping, Common.ILogger log, LockFileBuilderCache lockFileBuilderCache) { }
        public System.Collections.Generic.IReadOnlyList<ProjectModel.IAssetsLogMessage> AdditionalMessages { get { throw null; } set { } }
        public bool AllowNoOp { get { throw null; } set { } }
        public Protocol.Core.Types.SourceCacheContext CacheContext { get { throw null; } set { } }
        public Packaging.Signing.ClientPolicyContext ClientPolicyContext { get { throw null; } }
        public System.Collections.Generic.ISet<Frameworks.FrameworkRuntimePair> CompatibilityProfiles { get { throw null; } }
        public ProjectModel.DependencyGraphSpec DependencyGraphSpec { get { throw null; } set { } }
        public RestoreCommandProviders DependencyProviders { get { throw null; } set { } }
        public ProjectModel.LockFile ExistingLockFile { get { throw null; } set { } }
        public System.Collections.Generic.IList<ProjectModel.ExternalProjectReference> ExternalProjects { get { throw null; } set { } }
        public System.Collections.Generic.ISet<string> FallbackRuntimes { get { throw null; } }
        public bool HideWarningsAndErrors { get { throw null; } set { } }
        public bool IsLowercasePackagesDirectory { get { throw null; } set { } }
        public bool IsRestoreOriginalAction { get { throw null; } set { } }
        public string LockFilePath { get { throw null; } set { } }
        public int LockFileVersion { get { throw null; } set { } }
        public Common.ILogger Log { get { throw null; } set { } }
        public int MaxDegreeOfConcurrency { get { throw null; } set { } }
        public string MSBuildProjectExtensionsPath { get { throw null; } set { } }
        public Packaging.PackageSaveMode PackageSaveMode { get { throw null; } set { } }
        public string PackagesDirectory { get { throw null; } }
        public Configuration.PackageSourceMapping PackageSourceMapping { get { throw null; } }
        public System.Guid ParentId { get { throw null; } set { } }
        public ProjectModel.PackageSpec Project { get { throw null; } }
        public ProjectModel.ProjectStyle ProjectStyle { get { throw null; } set { } }
        public System.Collections.Generic.ISet<string> RequestedRuntimes { get { throw null; } }
        public bool RestoreForceEvaluate { get { throw null; } set { } }
        public string RestoreOutputPath { get { throw null; } set { } }
        public bool UpdatePackageLastAccessTime { get { throw null; } set { } }
        public bool ValidateRuntimeAssets { get { throw null; } set { } }
        public Packaging.XmlDocFileSaveMode XmlDocFileSaveMode { get { throw null; } set { } }
    }
    public partial class RestoreResult : IRestoreResult
    {
        public RestoreResult(bool success, System.Collections.Generic.IEnumerable<RestoreTargetGraph> restoreGraphs, System.Collections.Generic.IEnumerable<CompatibilityCheckResult> compatibilityCheckResults, System.Collections.Generic.IEnumerable<MSBuildOutputFile> msbuildFiles, ProjectModel.LockFile lockFile, ProjectModel.LockFile previousLockFile, string lockFilePath, ProjectModel.CacheFile cacheFile, string cacheFilePath, string packagesLockFilePath, ProjectModel.PackagesLockFile packagesLockFile, string dependencyGraphSpecFilePath, ProjectModel.DependencyGraphSpec dependencyGraphSpec, ProjectModel.ProjectStyle projectStyle, System.TimeSpan elapsedTime) { }
        protected string CacheFilePath { get { throw null; } }
        public System.Collections.Generic.IEnumerable<CompatibilityCheckResult> CompatibilityCheckResults { get { throw null; } }
        public System.TimeSpan ElapsedTime { get { throw null; } }
        public virtual ProjectModel.LockFile LockFile { get { throw null; } }
        public string LockFilePath { get { throw null; } set { } }
        public virtual System.Collections.Generic.IList<ProjectModel.IAssetsLogMessage> LogMessages { get { throw null; } internal set { } }
        public System.Collections.Generic.IEnumerable<MSBuildOutputFile> MSBuildOutputFiles { get { throw null; } }
        public virtual ProjectModel.LockFile PreviousLockFile { get { throw null; } }
        public ProjectModel.ProjectStyle ProjectStyle { get { throw null; } }
        public System.Collections.Generic.IEnumerable<RestoreTargetGraph> RestoreGraphs { get { throw null; } }
        public bool Success { get { throw null; } }

        public virtual System.Threading.Tasks.Task CommitAsync(Common.ILogger log, System.Threading.CancellationToken token) { throw null; }
        public virtual System.Collections.Generic.ISet<LibraryModel.LibraryIdentity> GetAllInstalled() { throw null; }
        public System.Collections.Generic.ISet<LibraryModel.LibraryRange> GetAllUnresolved() { throw null; }
    }

    public partial class RestoreResultPair
    {
        public RestoreResultPair(RestoreSummaryRequest request, RestoreResult result) { }
        public RestoreResult Result { get { throw null; } }
        public RestoreSummaryRequest SummaryRequest { get { throw null; } }
    }
    public static partial class RestoreRunner
    {
        public static System.Threading.Tasks.Task<RestoreSummary> CommitAsync(RestoreResultPair restoreResult, System.Threading.CancellationToken token) { throw null; }
        public static string GetInvalidInputErrorMessage(string input) { throw null; }
        public static System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<RestoreSummaryRequest>> GetRequests(RestoreArgs restoreContext) { throw null; }
        public static System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<RestoreSummary>> RunAsync(RestoreArgs restoreContext, System.Threading.CancellationToken token) { throw null; }
        public static System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<RestoreSummary>> RunAsync(RestoreArgs restoreContext) { throw null; }
        public static System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<RestoreResultPair>> RunWithoutCommit(System.Collections.Generic.IEnumerable<RestoreSummaryRequest> restoreRequests, RestoreArgs restoreContext) { throw null; }
    }
    public partial class RestoreSpecException : System.Exception
    {
        internal RestoreSpecException() { }
        public System.Collections.Generic.IEnumerable<string> Files { get { throw null; } }

        public static RestoreSpecException Create(string message, System.Collections.Generic.IEnumerable<string> files, System.Exception innerException) { throw null; }
        public static RestoreSpecException Create(string message, System.Collections.Generic.IEnumerable<string> files) { throw null; }
    }

    public partial class RestoreSummary
    {
        public RestoreSummary(RestoreResult result, string inputPath, System.Collections.Generic.IEnumerable<string> configFiles, System.Collections.Generic.IEnumerable<Protocol.Core.Types.SourceRepository> sourceRepositories, System.Collections.Generic.IEnumerable<Common.RestoreLogMessage> errors) { }
        public RestoreSummary(bool success, string inputPath, System.Collections.Generic.IReadOnlyList<string> configFiles, System.Collections.Generic.IReadOnlyList<string> feedsUsed, int installCount, System.Collections.Generic.IReadOnlyList<Common.IRestoreLogMessage> errors) { }
        public RestoreSummary(bool success) { }
        public bool AuditRan { get { throw null; } }
        public System.Collections.Generic.IReadOnlyList<string> ConfigFiles { get { throw null; } }
        public System.Collections.Generic.IReadOnlyList<Common.IRestoreLogMessage> Errors { get { throw null; } }
        public System.Collections.Generic.IReadOnlyList<string> FeedsUsed { get { throw null; } }
        public string InputPath { get { throw null; } }
        public int InstallCount { get { throw null; } }
        public bool NoOpRestore { get { throw null; } }
        public bool Success { get { throw null; } }

        public static void Log(Common.ILogger logger, System.Collections.Generic.IReadOnlyList<RestoreSummary> restoreSummaries, bool logErrors = false) { }
    }
    public partial class RestoreSummaryRequest
    {
        public RestoreSummaryRequest(RestoreRequest request, string inputPath, System.Collections.Generic.IEnumerable<string> configFiles, System.Collections.Generic.IReadOnlyList<Protocol.Core.Types.SourceRepository> sources) { }
        public System.Collections.Generic.IEnumerable<string> ConfigFiles { get { throw null; } }
        public string InputPath { get { throw null; } }
        public RestoreRequest Request { get { throw null; } }
        public System.Collections.Generic.IReadOnlyList<Protocol.Core.Types.SourceRepository> Sources { get { throw null; } }
    }
    public partial class RestoreTargetGraph : IRestoreTargetGraph
    {
        internal RestoreTargetGraph() { }
        public DependencyResolver.AnalyzeResult<DependencyResolver.RemoteResolveResult> AnalyzeResult { get { throw null; } }
        public System.Collections.Generic.IEnumerable<ResolverConflict> Conflicts { get { throw null; } }
        public Client.ManagedCodeConventions Conventions { get { throw null; } }
        public System.Collections.Generic.ISet<DependencyResolver.GraphItem<DependencyResolver.RemoteResolveResult>> Flattened { get { throw null; } }
        public Frameworks.NuGetFramework Framework { get { throw null; } }
        public System.Collections.Generic.IEnumerable<DependencyResolver.GraphNode<DependencyResolver.RemoteResolveResult>> Graphs { get { throw null; } }
        public bool InConflict { get { throw null; } }
        public System.Collections.Generic.ISet<DependencyResolver.RemoteMatch> Install { get { throw null; } }
        public string Name { get { throw null; } }
        public System.Collections.Generic.ISet<ResolvedDependencyKey> ResolvedDependencies { get { throw null; } }
        public RuntimeModel.RuntimeGraph RuntimeGraph { get { throw null; } }
        public string RuntimeIdentifier { get { throw null; } }
        public string TargetGraphName { get { throw null; } }
        public System.Collections.Generic.ISet<LibraryModel.LibraryRange> Unresolved { get { throw null; } }

        public static RestoreTargetGraph Create(RuntimeModel.RuntimeGraph runtimeGraph, System.Collections.Generic.IEnumerable<DependencyResolver.GraphNode<DependencyResolver.RemoteResolveResult>> graphs, DependencyResolver.RemoteWalkContext context, Common.ILogger log, Frameworks.NuGetFramework framework, string runtimeIdentifier) { throw null; }
        public static RestoreTargetGraph Create(System.Collections.Generic.IEnumerable<DependencyResolver.GraphNode<DependencyResolver.RemoteResolveResult>> graphs, DependencyResolver.RemoteWalkContext context, Common.ILogger logger, Frameworks.NuGetFramework framework) { throw null; }
    }

    public partial class SignArgs
    {
        public string CertificateFingerprint { get { throw null; } set { } }
        public string CertificatePassword { get { throw null; } set { } }
        public string CertificatePath { get { throw null; } set { } }
        public System.Security.Cryptography.X509Certificates.StoreLocation CertificateStoreLocation { get { throw null; } set { } }
        public System.Security.Cryptography.X509Certificates.StoreName CertificateStoreName { get { throw null; } set { } }
        public string CertificateSubjectName { get { throw null; } set { } }
        public Common.ILogger Logger { get { throw null; } set { } }
        public bool NonInteractive { get { throw null; } set { } }
        public string OutputDirectory { get { throw null; } set { } }
        public bool Overwrite { get { throw null; } set { } }

        [System.Obsolete("Use PackagePaths instead")]
        public string PackagePath { get { throw null; } set { } }
        public System.Collections.Generic.IReadOnlyList<string> PackagePaths { get { throw null; } set { } }
        public SignCommand.IPasswordProvider PasswordProvider { get { throw null; } set { } }
        public Common.HashAlgorithmName SignatureHashAlgorithm { get { throw null; } set { } }
        public string Timestamper { get { throw null; } set { } }
        public Common.HashAlgorithmName TimestampHashAlgorithm { get { throw null; } set { } }
        public System.Threading.CancellationToken Token { get { throw null; } set { } }
    }
    public sealed partial class SignCommandException : System.Exception, Common.ILogMessageException
    {
        public SignCommandException(Common.ILogMessage logMessage) { }
        public Common.ILogMessage AsLogMessage() { throw null; }
    }

    public partial class SignCommandRunner : ISignCommandRunner
    {
        public System.Threading.Tasks.Task<int> ExecuteCommandAsync(SignArgs signArgs) { throw null; }
        public System.Threading.Tasks.Task<int> ExecuteCommandAsync(System.Collections.Generic.IEnumerable<string> packagesToSign, Packaging.Signing.SignPackageRequest signPackageRequest, string timestamper, Common.ILogger logger, string outputDirectory, bool overwrite, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class SourceRepositoryDependencyProvider : DependencyResolver.IRemoteDependencyProvider
    {
        public SourceRepositoryDependencyProvider(Protocol.Core.Types.SourceRepository sourceRepository, Common.ILogger logger, Protocol.Core.Types.SourceCacheContext cacheContext, bool ignoreFailedSources, bool ignoreWarning, Protocol.LocalPackageFileCache fileCache, bool isFallbackFolderSource) { }
        public SourceRepositoryDependencyProvider(Protocol.Core.Types.SourceRepository sourceRepository, Common.ILogger logger, Protocol.Core.Types.SourceCacheContext cacheContext, bool ignoreFailedSources, bool ignoreWarning) { }
        public bool IsHttp { get { throw null; } }
        public Configuration.PackageSource Source { get { throw null; } }
        public Protocol.Core.Types.SourceRepository SourceRepository { get { throw null; } }

        public System.Threading.Tasks.Task<LibraryModel.LibraryIdentity> FindLibraryAsync(LibraryModel.LibraryRange libraryRange, Frameworks.NuGetFramework targetFramework, Protocol.Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Versioning.NuGetVersion>> GetAllVersionsAsync(string id, Protocol.Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<LibraryModel.LibraryDependencyInfo> GetDependenciesAsync(LibraryModel.LibraryIdentity libraryIdentity, Frameworks.NuGetFramework targetFramework, Protocol.Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }
        public System.Threading.Tasks.Task<Packaging.IPackageDownloader> GetPackageDownloaderAsync(Packaging.Core.PackageIdentity packageIdentity, Protocol.Core.Types.SourceCacheContext cacheContext, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public enum SourcesAction
    {
        None = 0,
        List = 1,
        Add = 2,
        Remove = 3,
        Enable = 4,
        Disable = 5,
        Update = 6
    }

    public enum SourcesListFormat
    {
        None = 0,
        Detailed = 1,
        Short = 2
    }

    public static partial class SpecValidationUtility
    {
        public static void ValidateDependencySpec(ProjectModel.DependencyGraphSpec spec, System.Collections.Generic.HashSet<string> projectsToSkip) { }
        public static void ValidateDependencySpec(ProjectModel.DependencyGraphSpec spec) { }
        public static void ValidateProjectSpec(ProjectModel.PackageSpec spec) { }
    }
    public enum SymbolPackageFormat
    {
        Snupkg = 0,
        SymbolsNupkg = 1
    }

    public static partial class ToolRestoreUtility
    {
        public static ProjectModel.PackageSpec GetSpec(string projectFilePath, string id, Versioning.VersionRange versionRange, Frameworks.NuGetFramework framework, string packagesPath, System.Collections.Generic.IList<string> fallbackFolders, System.Collections.Generic.IList<Configuration.PackageSource> sources, ProjectModel.WarningProperties projectWideWarningProperties) { throw null; }
        public static System.Collections.Generic.IReadOnlyList<RestoreSummaryRequest> GetSubSetRequests(System.Collections.Generic.IEnumerable<RestoreSummaryRequest> requestSummaries) { throw null; }
        public static System.Collections.Generic.IReadOnlyList<RestoreSummaryRequest> GetSubSetRequestsForSingleId(System.Collections.Generic.IEnumerable<RestoreSummaryRequest> requests) { throw null; }
        public static LibraryModel.LibraryDependency GetToolDependencyOrNullFromSpec(ProjectModel.PackageSpec spec) { throw null; }
        public static string GetToolIdOrNullFromSpec(ProjectModel.PackageSpec spec) { throw null; }
        public static ProjectModel.LockFileTargetLibrary GetToolTargetLibrary(ProjectModel.LockFile toolLockFile, string toolId) { throw null; }
        public static string GetUniqueName(string id, string framework, Versioning.VersionRange versionRange) { throw null; }
    }
    public static partial class TransitiveNoWarnUtils
    {
        public static WarningPropertiesCollection CreateTransitiveWarningPropertiesCollection(System.Collections.Generic.IEnumerable<RestoreTargetGraph> targetGraphs, ProjectModel.PackageSpec parentProjectSpec) { throw null; }
        public static System.Collections.Generic.Dictionary<string, System.Collections.Generic.HashSet<Common.NuGetLogCode>> ExtractPackageSpecificNoWarnForFramework(PackageSpecificWarningProperties packageSpecificWarningProperties, Frameworks.NuGetFramework framework) { throw null; }
        public static System.Collections.Generic.Dictionary<Frameworks.NuGetFramework, System.Collections.Generic.Dictionary<string, System.Collections.Generic.HashSet<Common.NuGetLogCode>>> ExtractPackageSpecificNoWarnPerFramework(PackageSpecificWarningProperties packageSpecificWarningProperties) { throw null; }
        public static System.Collections.Generic.HashSet<Common.NuGetLogCode> ExtractPathNoWarnProperties(NodeWarningProperties nodeWarningProperties, string libraryId) { throw null; }
        public static System.Collections.Generic.HashSet<Common.NuGetLogCode> MergeCodes(System.Collections.Generic.HashSet<Common.NuGetLogCode> first, System.Collections.Generic.HashSet<Common.NuGetLogCode> second) { throw null; }
        public static System.Collections.Generic.Dictionary<string, System.Collections.Generic.HashSet<Common.NuGetLogCode>> MergePackageSpecificNoWarn(System.Collections.Generic.Dictionary<string, System.Collections.Generic.HashSet<Common.NuGetLogCode>> first, System.Collections.Generic.Dictionary<string, System.Collections.Generic.HashSet<Common.NuGetLogCode>> second) { throw null; }
        public static PackageSpecificWarningProperties MergePackageSpecificWarningProperties(PackageSpecificWarningProperties first, PackageSpecificWarningProperties second) { throw null; }
        public static bool TryMergeNullObjects<T>(T first, T second, out T merged) where T : class { throw null; }
        public partial class DependencyNode : System.IEquatable<DependencyNode>
        {
            public DependencyNode(string id, bool isProject, NodeWarningProperties nodeWarningProperties) { }
            public DependencyNode(string id, bool isProject, System.Collections.Generic.HashSet<Common.NuGetLogCode> projectWideNoWarn, System.Collections.Generic.Dictionary<string, System.Collections.Generic.HashSet<Common.NuGetLogCode>> packageSpecificNoWarn) { }
            public string Id { get { throw null; } }
            public bool IsProject { get { throw null; } }
            public NodeWarningProperties NodeWarningProperties { get { throw null; } }

            public bool Equals(DependencyNode other) { throw null; }
            public override bool Equals(object obj) { throw null; }
            public override int GetHashCode() { throw null; }
            public override string ToString() { throw null; }
        }

        public partial class NodeWarningProperties : System.IEquatable<NodeWarningProperties>
        {
            public NodeWarningProperties(System.Collections.Generic.HashSet<Common.NuGetLogCode> projectWide, System.Collections.Generic.Dictionary<string, System.Collections.Generic.HashSet<Common.NuGetLogCode>> packageSpecific) { }
            public System.Collections.Generic.Dictionary<string, System.Collections.Generic.HashSet<Common.NuGetLogCode>> PackageSpecific { get { throw null; } }
            public System.Collections.Generic.HashSet<Common.NuGetLogCode> ProjectWide { get { throw null; } }

            public bool Equals(NodeWarningProperties other) { throw null; }
            public override bool Equals(object obj) { throw null; }
            public override int GetHashCode() { throw null; }
            public NodeWarningProperties GetIntersect(NodeWarningProperties other) { throw null; }
            public bool IsSubSetOf(NodeWarningProperties other) { throw null; }
        }
    }
    public sealed partial class TrustedSignerActionsProvider
    {
        public TrustedSignerActionsProvider(Packaging.Signing.ITrustedSignersProvider trustedSignersProvider, Common.ILogger logger) { }
        public void AddOrUpdateTrustedSigner(string name, string fingerprint, Common.HashAlgorithmName hashAlgorithm, bool allowUntrustedRoot) { }
        public System.Threading.Tasks.Task AddTrustedRepositoryAsync(string name, System.Uri serviceIndex, System.Collections.Generic.IEnumerable<string> owners, System.Threading.CancellationToken token) { throw null; }
        public System.Threading.Tasks.Task SyncTrustedRepositoryAsync(string name, System.Threading.CancellationToken token) { throw null; }
    }
    public partial class TrustedSignersArgs
    {
        public TrustedSignersAction Action { get { throw null; } set { } }
        public bool AllowUntrustedRoot { get { throw null; } set { } }
        public bool Author { get { throw null; } set { } }
        public string CertificateFingerprint { get { throw null; } set { } }
        public string FingerprintAlgorithm { get { throw null; } set { } }
        public Common.ILogger Logger { get { throw null; } set { } }
        public string Name { get { throw null; } set { } }
        public System.Collections.Generic.IEnumerable<string> Owners { get { throw null; } set { } }
        public string PackagePath { get { throw null; } set { } }
        public bool Repository { get { throw null; } set { } }
        public string ServiceIndex { get { throw null; } set { } }

        public enum TrustedSignersAction
        {
            Add = 0,
            List = 1,
            Remove = 2,
            Sync = 3
        }
    }
    public partial class TrustedSignersCommandRunner : ITrustedSignersCommandRunner
    {
        public TrustedSignersCommandRunner(Packaging.Signing.ITrustedSignersProvider trustedSignersProvider, Configuration.IPackageSourceProvider packageSourceProvider) { }
        public System.Threading.Tasks.Task<int> ExecuteCommandAsync(TrustedSignersArgs trustedSignersArgs) { throw null; }
    }

    public partial class UpdateClientCertArgs : IClientCertArgsWithPackageSource, IClientCertArgsWithConfigFile, IClientCertArgsWithFileData, IClientCertArgsWithStoreData, IClientCertArgsWithForce
    {
        public string Configfile { get { throw null; } set { } }
        public string FindBy { get { throw null; } set { } }
        public string FindValue { get { throw null; } set { } }
        public bool Force { get { throw null; } set { } }
        public string PackageSource { get { throw null; } set { } }
        public string Password { get { throw null; } set { } }
        public string Path { get { throw null; } set { } }
        public string StoreLocation { get { throw null; } set { } }
        public string StoreName { get { throw null; } set { } }
        public bool StorePasswordInClearText { get { throw null; } set { } }
    }

    public static partial class UpdateClientCertRunner
    {
        public static void Run(UpdateClientCertArgs args, System.Func<Common.ILogger> getLogger) { }
    }
    public partial class UpdateSourceArgs
    {
        public bool AllowInsecureConnections { get { throw null; } set { } }
        public string Configfile { get { throw null; } set { } }
        public string Name { get { throw null; } set { } }
        public string Password { get { throw null; } set { } }
        public string ProtocolVersion { get { throw null; } set { } }
        public string Source { get { throw null; } set { } }
        public bool StorePasswordInClearText { get { throw null; } set { } }
        public string Username { get { throw null; } set { } }
        public string ValidAuthenticationTypes { get { throw null; } set { } }
    }
    public static partial class UpdateSourceRunner
    {
        public static void Run(UpdateSourceArgs args, System.Func<Common.ILogger> getLogger) { }
    }
    public partial class VerifyArgs
    {
        public System.Collections.Generic.IEnumerable<string> CertificateFingerprint { get { throw null; } set { } }
        public Common.ILogger Logger { get { throw null; } set { } }
        public Common.LogLevel LogLevel { get { throw null; } set { } }

        [System.Obsolete("Use PackagePaths instead")]
        public string PackagePath { get { throw null; } set { } }
        public System.Collections.Generic.IReadOnlyList<string> PackagePaths { get { throw null; } set { } }
        public Configuration.ISettings Settings { get { throw null; } set { } }
        public System.Collections.Generic.IList<Verification> Verifications { get { throw null; } set { } }

        public enum Verification
        {
            Unknown = 0,
            All = 1,
            Signatures = 2
        }
    }
    public partial class VerifyCommandRunner : IVerifyCommandRunner
    {
        public System.Threading.Tasks.Task<int> ExecuteCommandAsync(VerifyArgs verifyArgs) { throw null; }
    }

    public partial class WarningPropertiesCollection : System.IEquatable<WarningPropertiesCollection>
    {
        public WarningPropertiesCollection(ProjectModel.WarningProperties projectWideWarningProperties, PackageSpecificWarningProperties packageSpecificWarningProperties, System.Collections.Generic.IReadOnlyList<Frameworks.NuGetFramework> projectFrameworks) { }
        public PackageSpecificWarningProperties PackageSpecificWarningProperties { get { throw null; } }
        public System.Collections.Generic.IReadOnlyList<Frameworks.NuGetFramework> ProjectFrameworks { get { throw null; } }
        public ProjectModel.WarningProperties ProjectWideWarningProperties { get { throw null; } }

        public bool ApplyNoWarnProperties(Common.IRestoreLogMessage message) { throw null; }
        public static bool ApplyProjectWideNoWarnProperties(Common.ILogMessage message, ProjectModel.WarningProperties warningProperties) { throw null; }
        public static void ApplyProjectWideWarningsAsErrorProperties(Common.ILogMessage message, ProjectModel.WarningProperties warningProperties) { }
        public void ApplyWarningAsErrorProperties(Common.IRestoreLogMessage message) { }
        public bool ApplyWarningProperties(Common.IRestoreLogMessage message) { throw null; }
        public bool Equals(WarningPropertiesCollection other) { throw null; }
        public override bool Equals(object obj) { throw null; }
        public override int GetHashCode() { throw null; }
    }
}

namespace NuGet.Commands.PackCommand
{
    public partial class PackageSpecificWarningProperties
    {
        public static PackageSpecificWarningProperties CreatePackageSpecificWarningProperties(System.Collections.Generic.IDictionary<string, System.Collections.Generic.HashSet<(Common.NuGetLogCode, Frameworks.NuGetFramework)>> noWarnProperties) { throw null; }
    }
}

namespace NuGet.Commands.SignCommand
{
    public partial interface IPasswordProvider
    {
    }
}