/*
 * Decompiled with CFR 0.152.
 */
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyPair;
import java.security.spec.AlgorithmParameterSpec;
import netscape.security.x509.X500Name;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.IVParameterSpec;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.KeyGenAlgorithm;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.KeyWrapAlgorithm;
import org.mozilla.jss.crypto.KeyWrapper;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SymmetricKey;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkix.crmf.CertReqMsg;
import org.mozilla.jss.pkix.crmf.CertRequest;
import org.mozilla.jss.pkix.crmf.CertTemplate;
import org.mozilla.jss.pkix.crmf.EncryptedKey;
import org.mozilla.jss.pkix.crmf.EncryptedValue;
import org.mozilla.jss.pkix.crmf.PKIArchiveOptions;
import org.mozilla.jss.pkix.crmf.POPOPrivKey;
import org.mozilla.jss.pkix.crmf.ProofOfPossession;
import org.mozilla.jss.pkix.primitive.AVA;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class ComCrypto {
    private String cdir;
    private String certnickname;
    private String keysize;
    private String keytype;
    private String tokenname;
    private String tokenpwd;
    private String certpackage;
    private String pkcs10request;
    private boolean debug = true;
    private boolean DBlogin = false;
    private boolean generaterequest = false;
    private String transportcert = null;
    private boolean dualkey = false;
    public String CRMF_REQUEST = null;
    int START = 1;
    int END = this.START + 1;
    Password password = null;
    public static CryptoManager manager = null;
    public static CryptoToken token = null;
    public static final String PR_INTERNAL_TOKEN_NAME = "internal";
    private CryptoStore store = null;
    private Password pass1 = null;
    private Password pass2 = null;
    private String bstr = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    private String blob;
    private String Blob1 = null;
    private String Blob2 = null;
    private String estr = "-----END NEW CERTIFICATE REQUEST-----";
    private String certprefix = null;

    public ComCrypto() {
    }

    public ComCrypto(String string, String string2, String string3, String string4, String string5) {
        this.cdir = string;
        this.tokenname = PR_INTERNAL_TOKEN_NAME;
        this.tokenpwd = string2;
        this.certnickname = string3;
        this.keysize = string4;
        this.keytype = string5;
    }

    public ComCrypto(String string, String string2, String string3, String string4, String string5, String string6) {
        this.cdir = string;
        this.tokenname = string2 == null || string2.equals("") ? PR_INTERNAL_TOKEN_NAME : string2;
        this.tokenpwd = string3;
        this.certnickname = string4;
        this.keysize = string5;
        this.keytype = string6;
    }

    public void setCertDir(String string) {
        this.cdir = string;
    }

    public void setCertnickname(String string) {
        this.certnickname = string;
    }

    public void setKeySize(String string) {
        this.keysize = string;
    }

    public void setKeyType(String string) {
        this.keytype = string;
    }

    public void setTokenName(String string) {
        this.tokenname = string;
    }

    public void setTokenPWD(String string) {
        this.tokenpwd = string;
    }

    public void setCertPackage(String string) {
        this.certpackage = string;
    }

    public void setGenerateRequest(boolean bl) {
        this.generaterequest = bl;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public void setCertPrefix(String string) {
        this.certprefix = string;
    }

    public void setTransportCert(String string) {
        this.transportcert = string;
    }

    public void setDualKey(boolean bl) {
        this.dualkey = bl;
    }

    public String getPkcs10Request() {
        return this.pkcs10request;
    }

    public String getCertificateString(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        return x509Certificate.getVersion() + ";" + x509Certificate.getSerialNumber().toString() + ";" + x509Certificate.getIssuerDN() + ";" + x509Certificate.getSubjectDN();
    }

    public X509Certificate findCert(String string) {
        try {
            X509Certificate x509Certificate = manager.findCertByNickname(string);
            return x509Certificate;
        }
        catch (Exception exception) {
            System.out.println("exception importing cert " + exception.getMessage());
            return null;
        }
    }

    public boolean importCert(X509Certificate x509Certificate, String string) {
        try {
            System.out.println("importCert x509 : importing with nickname: " + string);
            InternalCertificate internalCertificate = manager.importCertToPerm(x509Certificate, string);
            internalCertificate.setSSLTrust(2);
            return true;
        }
        catch (Exception exception) {
            System.out.println("exception importing cert " + exception.getMessage());
            return false;
        }
    }

    public boolean importCert(String string, String string2) {
        System.out.println("importCert string: importing with nickname: " + string2);
        try {
            X509Certificate x509Certificate;
            String string3 = this.normalize(string);
            if (this.DBlogin) {
                System.out.println("Already logged into to DB");
            }
            if (manager == null) {
                System.out.println("Manager object is null");
            }
            if ((x509Certificate = manager.importCertPackage(string3.getBytes(), string2)) != null) {
                System.out.println("importCert string: importCertPackage() succeeded");
            } else {
                System.out.println("importCert string: importCertPackage() failed");
            }
            System.out.println("importCert string: set CA trust bits");
            X509Certificate[] x509CertificateArray = manager.getCACerts();
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                if (!x509CertificateArray[i].getSubjectDN().toString().equals(x509Certificate.getIssuerDN().toString())) continue;
                InternalCertificate internalCertificate = (InternalCertificate)x509CertificateArray[i];
                internalCertificate.setSSLTrust(152);
                System.out.println("importCert string: CA trust bits set");
                break;
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: exception importing cert: " + exception.getMessage());
            exception.printStackTrace();
        }
        return true;
    }

    public boolean importCACert(String string) {
        try {
            String string2 = this.normalize(string);
            if (this.DBlogin) {
                System.out.println("Already logged into to DB");
            }
            if (manager == null) {
                System.out.println("Manager object is null");
            }
            X509Certificate x509Certificate = manager.importCACertPackage(string2.getBytes());
            InternalCertificate internalCertificate = (InternalCertificate)x509Certificate;
            internalCertificate.setSSLTrust(152);
            return true;
        }
        catch (Exception exception) {
            System.out.println("ERROR:exception importing cert " + exception.getMessage());
            return false;
        }
    }

    public String normalize(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\' && string.charAt(i + 1) == 'n') {
                string2 = string2 + '\n';
                ++i;
                continue;
            }
            if (string.charAt(i) == '\\' && string.charAt(i + 1) == 'r') {
                ++i;
                continue;
            }
            if (string.charAt(i) == '\"') continue;
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }

    String normalizeForLDAP(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\' && string.charAt(i + 1) == 'n') {
                string2 = string2 + "\n ";
                ++i;
                continue;
            }
            if (string.charAt(i) == '\\' && string.charAt(i + 1) == 'r') {
                ++i;
                continue;
            }
            if (string.charAt(i) == '\"') continue;
            string2 = string2 + string.charAt(i);
        }
        return string2;
    }

    public String pkcs7Convertcert(String string) {
        String string2 = "";
        int n = string.length();
        for (int i = 0; i < n; i += 64) {
            string2 = i + 64 < n ? string2 + string.substring(i, i + 64) + "\n" : string2 + string.substring(i, n);
        }
        return string2;
    }

    public void deleteKeys() {
        try {
            int n = 0;
            this.store = token.getCryptoStore();
            PrivateKey[] privateKeyArray = this.store.getPrivateKeys();
            if (this.debug) {
                System.out.println("Now we shall delete all the keys!");
            }
            privateKeyArray = this.store.getPrivateKeys();
            for (n = 0; n < privateKeyArray.length; ++n) {
                PrivateKey privateKey = privateKeyArray[n];
                this.store.deletePrivateKey(privateKey);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean CreateCertDB() {
        return this.loginDB();
    }

    public boolean loginDB() {
        Password password = null;
        try {
            if (this.debug) {
                System.out.println("CRYPTO INIT WITH CERTDB:" + this.cdir);
            }
            if (this.certprefix != null) {
                CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(this.cdir, this.certprefix, this.certprefix, "secmod.db");
                CryptoManager.initialize((CryptoManager.InitializationValues)initializationValues);
            } else {
                CryptoManager.initialize((String)this.cdir);
            }
            manager = CryptoManager.getInstance();
            if (this.debug) {
                System.out.println("tokenname:" + this.tokenname);
            }
            if ((token = this.tokenname.equals(PR_INTERNAL_TOKEN_NAME) ? manager.getInternalKeyStorageToken() : manager.getTokenByName(this.tokenname)) == null) {
                System.out.println("loginDB: token null ");
                return false;
            }
            password = new Password(this.tokenpwd.toCharArray());
            if (token.isLoggedIn() && this.debug) {
                System.out.println("Already Logged in ");
            }
            if (this.debug) {
                System.out.println("tokenpwd:" + this.tokenpwd);
            }
            token.login((PasswordCallback)password);
            password.clear();
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
            if (this.debug) {
                System.out.println("Crypto manager already initialized");
            }
        }
        catch (NoSuchTokenException noSuchTokenException) {
            System.err.println("lolginDB:" + (Object)((Object)noSuchTokenException));
            return false;
        }
        catch (Exception exception) {
            try {
                if (!token.isLoggedIn()) {
                    token.initPassword(password, password);
                }
                return true;
            }
            catch (Exception exception2) {
                System.err.println("some exception:" + exception);
                return false;
            }
        }
        this.DBlogin = true;
        return true;
    }

    public synchronized boolean generateRequest() {
        System.out.println("generating pkcs10 Request");
        this.loginDB();
        try {
            this.debug = true;
            System.out.println("Generating request : keysize :" + this.keysize);
            System.out.println("Generating request : subject :" + this.certnickname);
            System.out.println("Generating request : keytype :" + this.keytype);
            Integer n = new Integer(this.keysize);
            if (this.generaterequest) {
                this.blob = token.generateCertRequest(this.certnickname, n.intValue(), this.keytype, (byte[])null, (byte[])null, (byte[])null);
                System.out.println("Cert Request Generated.");
                this.bstr = "-----BEGIN NEW CERTIFICATE REQUEST-----";
                this.Blob1 = this.blob.substring(this.bstr.length() + 1);
                this.Blob2 = this.Blob1.substring(0, this.Blob1.indexOf(this.estr));
                System.out.println(this.Blob2);
                this.pkcs10request = this.Blob2;
            }
            return true;
        }
        catch (Exception exception) {
            System.out.println("Exception: Unable to generate request: " + exception);
            return false;
        }
    }

    public String generateCRMFrequest() {
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        boolean bl = false;
        boolean bl2 = true;
        long l = 0L;
        KeyPair keyPair = null;
        System.out.println("Debug : initialize crypto Manager");
        try {
            String string;
            BASE64Encoder bASE64Encoder;
            Object object;
            Object object2;
            Integer n;
            KeyPairGeneratorSpi.Usage[] usageArray;
            block13: {
                try {
                    CryptoManager.initialize((String)this.cdir);
                }
                catch (Exception exception) {
                    System.out.println("INITIALIZATION ERROR: " + exception.toString());
                    System.out.println("cdir = " + this.cdir);
                }
                try {
                    System.out.println("Debug : before getInstance");
                    manager = CryptoManager.getInstance();
                    usageArray = this.tokenpwd;
                    System.out.println("Debug : before get token");
                    token = this.tokenname.equals(PR_INTERNAL_TOKEN_NAME) ? manager.getInternalKeyStorageToken() : manager.getTokenByName(this.tokenname);
                    if (token == null) {
                        System.err.println("generateCRMFrequest: token null ");
                        return null;
                    }
                    this.password = new Password(usageArray.toCharArray());
                    System.out.println("Debug : before login password");
                    token.login((PasswordCallback)this.password);
                    System.out.println("Debug : after login password");
                }
                catch (NoSuchTokenException noSuchTokenException) {
                    System.err.println("generateCRMFrequest:" + noSuchTokenException.toString());
                    return null;
                }
                catch (Exception exception) {
                    System.out.println("INITIALIZATION ERROR: " + exception.toString());
                    if (token.isLoggedIn()) break block13;
                    token.initPassword((PasswordCallback)this.password, (PasswordCallback)this.password);
                }
            }
            if (this.keytype.equalsIgnoreCase("rsa")) {
                usageArray = token.getKeyPairGenerator(KeyPairAlgorithm.RSA);
                n = new Integer(this.keysize);
                int n2 = n;
                usageArray.initialize(n2);
                keyPair = usageArray.genKeyPair();
            } else if (this.keytype.equalsIgnoreCase("ecc")) {
                usageArray = new KeyPairGeneratorSpi.Usage[]{KeyPairGeneratorSpi.Usage.DERIVE};
                keyPair = CryptoUtil.generateECCKeyPair((String)this.tokenname, (String)this.keysize, null, (KeyPairGeneratorSpi.Usage[])usageArray, (boolean)false, (int)-1, (int)-1);
            }
            usageArray = new CertTemplate();
            usageArray.setVersion(new INTEGER(2L));
            if (this.certnickname != null) {
                n = new X500Name(this.certnickname);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(n.getEncoded());
                object2 = (Name)Name.getTemplate().decode((InputStream)byteArrayInputStream);
                usageArray.setSubject(object2);
            }
            usageArray.setPublicKey(new SubjectPublicKeyInfo(keyPair.getPublic()));
            n = new SEQUENCE();
            CertRequest certRequest = new CertRequest(new INTEGER(1L), (CertTemplate)usageArray, (SEQUENCE)n);
            object2 = new byte[]{0, 3, 0};
            ProofOfPossession proofOfPossession = ProofOfPossession.createKeyEncipherment((POPOPrivKey)POPOPrivKey.createThisMessage((BIT_STRING)new BIT_STRING((byte[])object2, 3)));
            CertReqMsg certReqMsg = new CertReqMsg(certRequest, proofOfPossession, null);
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addElement((ASN1Value)certReqMsg);
            if (this.dualkey) {
                System.out.println("dualkey = true");
                object = new SEQUENCE();
                bASE64Encoder = new CertRequest(new INTEGER(1L), (CertTemplate)usageArray, (SEQUENCE)object);
                string = new CertReqMsg((CertRequest)bASE64Encoder, proofOfPossession, null);
                sEQUENCE.addElement((ASN1Value)string);
            }
            object = ASN1Util.encode((ASN1Value)sEQUENCE);
            bASE64Encoder = new BASE64Encoder();
            this.CRMF_REQUEST = string = bASE64Encoder.encodeBuffer(object);
            System.out.println("CRMF_REQUEST = " + this.CRMF_REQUEST);
        }
        catch (Exception exception) {
            System.out.println("ERROR: " + exception.toString());
            exception.printStackTrace();
            return null;
        }
        return this.CRMF_REQUEST;
    }

    public String generateCRMFtransport() {
        boolean bl = false;
        boolean bl2 = true;
        long l = 0L;
        KeyPair keyPair = null;
        try {
            BASE64Encoder bASE64Encoder;
            Object object;
            Name name;
            ByteArrayInputStream byteArrayInputStream;
            X500Name x500Name;
            String string;
            block13: {
                try {
                    CryptoManager.initialize((String)this.cdir);
                }
                catch (Exception exception) {
                    System.out.println("INITIALIZATION ERROR: " + exception.toString());
                    System.out.println("cdir = " + this.cdir);
                }
                try {
                    System.out.println("Debug : before getInstance");
                    manager = CryptoManager.getInstance();
                    string = this.tokenpwd;
                    System.out.println("Debug : before get token");
                    token = this.tokenname.equals(PR_INTERNAL_TOKEN_NAME) ? manager.getInternalKeyStorageToken() : manager.getTokenByName(this.tokenname);
                    if (token == null) {
                        System.err.println("generateCRMFtransport: token null ");
                        return null;
                    }
                    this.password = new Password(string.toCharArray());
                    System.out.println("Debug : before login password");
                    token.login((PasswordCallback)this.password);
                    System.out.println("Debug : after login password");
                }
                catch (NoSuchTokenException noSuchTokenException) {
                    System.err.println("generateCRMFtransport:" + noSuchTokenException.toString());
                    return null;
                }
                catch (Exception exception) {
                    System.out.println("INITIALIZATION ERROR: " + exception.toString());
                    if (token.isLoggedIn()) break block13;
                    token.initPassword((PasswordCallback)this.password, (PasswordCallback)this.password);
                }
            }
            string = token.getKeyPairGenerator(KeyPairAlgorithm.RSA);
            Integer n = new Integer(this.keysize);
            int n2 = n;
            string.initialize(n2);
            keyPair = string.genKeyPair();
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            byte[] byArray = bASE64Decoder.decodeBuffer(this.transportcert);
            X509Certificate x509Certificate = manager.importCACertPackage(byArray);
            byte[] byArray2 = new byte[]{1, 1, 1, 1, 1, 1, 1, 1};
            KeyGenerator keyGenerator = token.getKeyGenerator(KeyGenAlgorithm.DES3);
            SymmetricKey symmetricKey = keyGenerator.generate();
            KeyWrapper keyWrapper = token.getKeyWrapper(KeyWrapAlgorithm.DES3_CBC_PAD);
            keyWrapper.initWrap(symmetricKey, (AlgorithmParameterSpec)new IVParameterSpec(byArray2));
            byte[] byArray3 = keyWrapper.wrap((PrivateKey)keyPair.getPrivate());
            KeyWrapper keyWrapper2 = token.getKeyWrapper(KeyWrapAlgorithm.RSA);
            keyWrapper2.initWrap(x509Certificate.getPublicKey(), null);
            byte[] byArray4 = keyWrapper2.wrap(symmetricKey);
            CertTemplate certTemplate = new CertTemplate();
            certTemplate.setVersion(new INTEGER(2L));
            if (this.certnickname != null) {
                x500Name = new X500Name(this.certnickname);
                byteArrayInputStream = new ByteArrayInputStream(x500Name.getEncoded());
                name = (Name)Name.getTemplate().decode((InputStream)byteArrayInputStream);
                certTemplate.setSubject(name);
            }
            certTemplate.setPublicKey(new SubjectPublicKeyInfo(keyPair.getPublic()));
            x500Name = null;
            if (this.keytype.equalsIgnoreCase("rsa")) {
                x500Name = new AlgorithmIdentifier(new OBJECT_IDENTIFIER("1.2.840.113549.3.7"), (ASN1Value)new OCTET_STRING(byArray2));
            } else if (this.keytype.equalsIgnoreCase("ecc")) {
                x500Name = new AlgorithmIdentifier(new OBJECT_IDENTIFIER("1.2.840.10045.2.1"), (ASN1Value)new OCTET_STRING(byArray2));
            }
            byteArrayInputStream = new EncryptedValue(null, (AlgorithmIdentifier)x500Name, new BIT_STRING(byArray4, 0), null, null, new BIT_STRING(byArray3, 0));
            name = new EncryptedKey((EncryptedValue)byteArrayInputStream);
            PKIArchiveOptions pKIArchiveOptions = new PKIArchiveOptions((EncryptedKey)name);
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addElement((ASN1Value)new AVA(new OBJECT_IDENTIFIER("1.3.6.1.5.5.7.5.1.4"), (ASN1Value)pKIArchiveOptions));
            CertRequest certRequest = new CertRequest(new INTEGER(1L), certTemplate, sEQUENCE);
            byte[] byArray5 = new byte[]{0, 3, 0};
            ProofOfPossession proofOfPossession = ProofOfPossession.createKeyEncipherment((POPOPrivKey)POPOPrivKey.createThisMessage((BIT_STRING)new BIT_STRING(byArray5, 3)));
            CertReqMsg certReqMsg = new CertReqMsg(certRequest, proofOfPossession, null);
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addElement((ASN1Value)certReqMsg);
            if (this.dualkey) {
                System.out.println("dualkey = true");
                object = new SEQUENCE();
                bASE64Encoder = new CertRequest(new INTEGER(1L), certTemplate, (SEQUENCE)object);
                CertReqMsg certReqMsg2 = new CertReqMsg((CertRequest)bASE64Encoder, proofOfPossession, null);
                sEQUENCE2.addElement((ASN1Value)certReqMsg2);
            }
            object = ASN1Util.encode((ASN1Value)sEQUENCE2);
            bASE64Encoder = new BASE64Encoder();
            this.CRMF_REQUEST = bASE64Encoder.encodeBuffer(object);
            System.out.println("Generated crmf request: ...... ");
            System.out.println("");
            System.out.println(this.CRMF_REQUEST);
            System.out.println("");
            System.out.println("End crmf Request:");
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
        }
        return this.CRMF_REQUEST;
    }
}

