# Docker Engine's use of nftables

> [!WARNING]
> This is intended for development use - the structure of docker's nftables
> rules will change between releases, it is not a stable interface.

> [!NOTE]
> This document is generated by `TestBridgeNftablesDoc` by running a
> daemon, creating networks and containers, and capturing nftables.
> The nftables are then merged with a text/template for each section.
> The resulting document is diffed against one in the repo, so the
> test will fail if there are differences in the generated rules (but
> changes in the templates may go unnoticed).

IPv6 nftables rules follow the same pattern as IPv4 rules, they're in
different tables (`ip docker-bridges`, and `ip6 docker-bridges`). So,
only the IPv4 rules are shown here.

The tables are re-created each time Docker starts.

The filter-INPUT hook is not used by Docker. Packets arriving from the host's
physical network or the host itself hit the filter-FORWARD chain, as they are
routed into the bridge network. Similarly, filter-OUTPUT is not used.

Scenarios:

  - [New daemon](generated/new-daemon.md)
  - [Container on a user-defined network, with a published port](generated/usernet-portmap.md)
  - [Container on a user-defined network, with a port published on a loopback address](generated/usernet-portmap-lo.md)
  - [Container on a user-defined network, with a published port, no userland proxy](generated/usernet-portmap-noproxy.md)
  - [Container on a user-defined network with inter-container communication disabled, with a published port](generated/usernet-portmap-noicc.md)
  - [Container on a user-defined --internal network](generated/usernet-internal.md)
  - [Container on a routed-mode network, with a published port](generated/usernet-portmap-routed.md)
  - [Container on a nat-unprotected network, with a published port](generated/usernet-portmap-natunprot.md)
  - [Swarm service, with a published port](generated/swarm-portmap.md)
