/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2016 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef PLANE_WIDGET_H
#define PLANE_WIDGET_H

#include <Action.h>

// VTK stuff
#include <vtkSmartPointer.h>
#include <vtkImplicitPlaneWidget.h>
#include <vtkCommand.h>

/** This class implements a VTK implicit plane in the CamiTK application.
 *  It uses the vtkImplicitPlaneWidget to display a 3D plane with handy interactors
 *  to modify the plane 3D position (orientation and displacement in a given bounding box)
 *
 *  The plane widget is linked with an action.
 *  When the user displaces the plane in 3D, the linked action apply() method
 *  is automatically called.
 */
class PlaneWidget : public vtkCommand {

public:

    /// the constructor
    PlaneWidget();

    /// the constructor
    PlaneWidget(camitk::Action *a);

    /// the destructor
    virtual ~PlaneWidget();

    /// The widget to see the real information
    vtkSmartPointer<vtkImplicitPlaneWidget> planeWidget;

    /** Allows one to get the current 3D widget configuration.
     *  This is a VTK "callback" (inherited from vtkCommand).
     */
    virtual void Execute(vtkObject *caller, unsigned long, void *);

private:
    camitk::Action *action;
};

#endif // PLANE_WIDGET_H
