# Copyright (C) 2012 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA

# The sad news about QFileSystemWatcher: on Windows using it heavily lead
# to many many many bug reports about Permission Errors.
# So as a short-time workaround we disable watcher at all for Windows.

import sys
from PyQt4 import QtCore


class _FakeSignal(object):

    def __init__(self):
        pass

    def connect(self, *args, **kwargs):
        pass


class _FakeFileSystemWatcher(object):
    """We just provide all methods that supported by real object
    but do nothing instead."""

    def __init__(self, *args, **kwargs):
        pass

    def addPath(self, file):
        pass

    def addPaths(self, files):
        pass

    def directories(self):
        return []

    def files(self):
        return []

    def removePath(self, file):
        pass

    def removePaths(self, files):
        pass

    directoryChanged = _FakeSignal()
    fileChanged = _FakeSignal()


QFileSystemWatcher = QtCore.QFileSystemWatcher

if sys.platform == 'win32':
    QFileSystemWatcher = _FakeFileSystemWatcher
