/***************************************************************************
 *   Copyright (C) 2005-2006 Gao Xianchao                                  *
 *                 2007 Gao Xianchao gnap_an linux_lyb ahlongxp            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/*
 * Author:	gxc
 * Create data:	2005-10-16 17:09
 */
 
#ifndef STORAGE_H_
#define STORAGE_H_

#include <string>
#include <list>
#include <set>
#include <stdio.h>
//#include <ext/hash_map>
#include <map>
#include "BitStorm.h"
#include "BitSet.h"

typedef struct
{
	TFileInfo fileInfo;
	int handle; 
	time_t mtime;
	bool baned;
} TStorageFileInfo;

typedef struct
{
	std::string data;
	unsigned int lastAccessTick;
} TPieceCahce;

typedef struct 
{
	unsigned int begin;
	unsigned int end;
}TIntPair;

typedef std::list<TIntPair> TRangeList;

typedef std::list<TStorageFileInfo> TFileHandleList;
typedef std::list<unsigned int> TIntList;
//typedef __gnu_cxx::hash_map<unsigned int, std::string> TPieceMap;	
//typedef __gnu_cxx::hash_map<unsigned int, TPieceCahce> TReadPieceMap;	
typedef std::map<unsigned int, std::string> TPieceMap;	
typedef std::map<unsigned int, TPieceCahce> TReadPieceMap;	

class CStorage : public IStorage
{
public:
	CStorage();
	virtual ~CStorage();
private:
	IBTTask* _task;
	std::string _destDir;
	std::string _psfPath;
	bool _newTask;
	TFileHandleList _fileHandleList;
	CBitSet _bitSet;
	CBitSet _banedBitSet;
	TRangeList _rangeList;
	TIntList _downloadingPieces;
	unsigned int _finishedPiece;
	
	TReadPieceMap _readCache;
	TPieceMap _writeCache;
	
	TBanedFileList _bandFileList;
	int64_t _banedSize;
private:	
	bool openFiles();
	bool needCheckFiles();
	void checkFiles();
	void makeRequestRange();
	void saveBitset();
	bool openFile(unsigned int index, TFileInfo fileInfo);
	TStorageFileInfo getFileInfoByOffset(int64_t offset);
	unsigned int getReadCacheSizeMax();
	unsigned int getWriteCacheSizeMax();
	
	void writePieceD(unsigned int pieceIndex,std::string& data);
	void saveWriteCacheToDisk();
	std::string readDataD(unsigned int pieceIndex, off64_t offset, unsigned int len);
	
	unsigned int getPieceTaskInRange(IBitSet* bitSet, unsigned int beginIndex, unsigned int endIndex);
	void removeDownloadingPiece(unsigned int index);
	
	void genBanedBitSet();
	unsigned int getPieceIndexByOffset(off64_t offset);
public:	
 	void setBTTask(IBTTask* task);
	IBTTask* getBTTask();	
	
	bool start();
	void stop();
	void setBanedFileList(TBanedFileList bandFileList);
	bool finished();
	std::string getBitfield();
	IBitSet* getBitSet();
	IBitSet* getBanedBitSet();
	unsigned int getPieceLength(unsigned int pieceIndex);
	unsigned int getPieceTask(IBitSet* bitSet);
	void abandonPieceTask(unsigned int pieceIndex);
	void writePiece(unsigned int pieceIndex,std::string& data);
	std::string readData(unsigned int pieceIndex, unsigned int offset, unsigned int len);	
	std::string readPiece(unsigned int pieceIndex);
	float getFinishedPercent();
	int64_t getLeftCount();
	int64_t getSelectedCount();
	int64_t getBanedCount();
};

#endif /*STORAGE_H_*/
