/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"

extern int start_jack (int argc, char *argv[]);
extern int run_jack (void *pointer);
extern int stop_jack ();

static GtkImage *signbit, *mantissa[23], *integer[40];
static GdkPixbuf *pixbufs[12];

static GtkLabel *freq_label, *max_label, *min_label;
static GtkLabel *nan_label, *inf_label, *denormal_label;

guint timeout_tag;

void
update_oops(unsigned int nan, unsigned int inf, unsigned int denormal)
{
  char text[] = "        0";

  snprintf(text, sizeof(text), "%u", nan);
  gtk_label_set_text(nan_label, text);
  snprintf(text, sizeof(text), "%u", inf);
  gtk_label_set_text(inf_label, text);
  snprintf(text, sizeof(text), "%u", denormal);
  gtk_label_set_text(denormal_label, text);
}

void
update_freq(unsigned int freq)
{
  char text[] = "xxx000 Hz";

  snprintf(text, sizeof(text), "%u Hz", freq);
  gtk_label_set_text(freq_label, text);
}

void
update_range(float min, float max)
{
  char text[] = "-000.0 dB";

  if (min <= max) {
    snprintf(text, sizeof(text), "%3.1f dB", min);
    gtk_label_set_text(min_label, text);
    snprintf(text, sizeof(text), "%3.1f dB", max);
    gtk_label_set_text(max_label, text);
  } else {
    sprintf(text, "N/A");
    gtk_label_set_text(min_label, text);
    gtk_label_set_text(max_label, text);
  }
}

void
integer_bit(int bit, int color)
{
  gtk_image_set_from_pixbuf(integer[bit],pixbufs[color + 6]);
}

void
sign_bit(int color)
{
  gtk_image_set_from_pixbuf(signbit,pixbufs[color]);
}

void
mantissa_bit(int bit, int color)
{
  gtk_image_set_from_pixbuf(mantissa[bit],pixbufs[color]);
}

void
freeze(void)
{
  if (timeout_tag) {
    g_source_remove(timeout_tag);
    timeout_tag = 0;
  }
}

void
unfreeze(void)
{
  timeout_tag = g_timeout_add (200, run_jack, NULL);
}

int
main (int argc, char *argv[])
{
  GtkWidget *window;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

  window = create_bitmeter_main ();
  pixbufs[0] = create_pixbuf("0m.xpm");
  pixbufs[1] = create_pixbuf("1m.xpm");
  pixbufs[2] = create_pixbuf("2m.xpm");
  pixbufs[3] = create_pixbuf("3m.xpm");
  pixbufs[4] = create_pixbuf("4m.xpm");
  pixbufs[5] = create_pixbuf("5m.xpm");
  pixbufs[6] = create_pixbuf("0i.xpm");
  pixbufs[7] = create_pixbuf("1i.xpm");
  pixbufs[8] = create_pixbuf("2i.xpm");
  pixbufs[9] = create_pixbuf("3i.xpm");
  pixbufs[10] = create_pixbuf("4i.xpm");
  pixbufs[11] = create_pixbuf("5i.xpm");

  int bit;
  for (bit = 0; bit < 23; ++bit) {
    char name[]= "mantissa00";
    sprintf(name, "mantissa%02d", bit);
    mantissa[bit] = GTK_IMAGE(lookup_widget(window, name));
    gtk_image_set_from_pixbuf(mantissa[bit], pixbufs[0]);
  }
  for (bit = 0; bit < 40; ++bit) {
    char name[]= "integer00";
    sprintf(name, "integer%02d", bit);
    integer[bit] = GTK_IMAGE(lookup_widget(window, name));
    gtk_image_set_from_pixbuf(integer[bit], pixbufs[6]);
  }
  signbit = GTK_IMAGE(lookup_widget(window, "signbit"));
  freq_label = GTK_LABEL(lookup_widget(window, "freq_label"));
  min_label = GTK_LABEL(lookup_widget(window, "min_label"));
  max_label = GTK_LABEL(lookup_widget(window, "max_label"));
  nan_label = GTK_LABEL(lookup_widget(window, "nan_label"));
  inf_label = GTK_LABEL(lookup_widget(window, "inf_label"));
  denormal_label = GTK_LABEL(lookup_widget(window, "denormal_label"));

  gtk_image_set_from_pixbuf(signbit, pixbufs[0]);

  gtk_widget_show (window);

  start_jack (argc, argv);
  timeout_tag = g_timeout_add (200, run_jack, NULL);
  gtk_main ();

  stop_jack ();
  return 0;
}
