/* $Id$ */

/* fwrite( const void *, size_t, size_t, FILE * )

   This file is part of the Public Domain C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <stdio.h>

#ifndef REGTEST

#include <_PDCLIB_glue.h>

#include <stdbool.h>
#include <string.h>

size_t fwrite( const void * _PDCLIB_restrict ptr, size_t size, size_t nmemb, struct _PDCLIB_file_t * _PDCLIB_restrict stream )
{
    size_t total = size * nmemb;
    size_t written = 0;
    char *data = ptr;

    while (total-- > 0)
    {
	char c = *data++;
	if (putc(c, stream) != c)
	    break;
	written++;
    }
    return written / size;
}

#endif

#ifdef TEST
#include <_PDCLIB_test.h>

int main( void )
{
    /* Testing covered by fread(). */
    return TEST_RESULTS;
}

#endif

