/*
 *  Copyright (c) 1994, Riley Rainey,  riley@netcon.com
 *
 *  Permission to use, copy, modify and distribute (without charge) this
 *  software, documentation, images, etc. is granted, provided that this 
 *  comment and the author's name is retained.
 *
 *  This software is provided by the author as is, and without any expressed
 *  or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose.  In no
 *  event shall the author be liable for any direct, indirect, incidental, or
 *  consequential damages arising in any way out of the use of this software.
 */

#ifndef gutil1_H
#define gutil1_H

#ifdef gutil1_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif


EXTERN void RescaleView (Widget w, double factor);

EXTERN void DrawWidget (Widget w, Boolean immediate);

EXTERN void DrawPolygon (Widget w, polygon_t *poly, Boolean immediate);

EXTERN void WorldToWidget (view_info_t *p, point_t *q, int *x, int *y);

EXTERN void DrawGrid (view_info_t *p, Display *dpy, Drawable d);

EXTERN void DrawSelectedPolygon (Widget w, polygon_t *poly, Boolean immediate, Boolean erase);

EXTERN void DrawRuler (view_info_t *p, Display *dpy, Drawable d, Pixel bg);

EXTERN void StringSize (char *s, int *xw, int *yw);

#undef EXTERN
#endif
