/*###############################################################################
# Linux Management Providers (LMP), DNS provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_DNSPROTOCOLENDPOINTACCESS_H_
#define OPENDRIM_DNSPROTOCOLENDPOINTACCESS_H_

#include "DNS_Common.h"

#include "OpenDRIM_DNSProtocolEndpoint.h"

int DNS_OpenDRIM_DNSProtocolEndpoint_load(const CMPIBroker* broker, string& errorMessage);

int DNS_OpenDRIM_DNSProtocolEndpoint_unload(string& errorMessage);

int DNS_OpenDRIM_DNSProtocolEndpoint_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_DNSProtocolEndpoint>& instances, const char** properties, string& errorMessage, const string& discriminant);

int DNS_OpenDRIM_DNSProtocolEndpoint_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_DNSProtocolEndpoint& instance, const char** properties, string& errorMessage);

int DNS_OpenDRIM_DNSProtocolEndpoint_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSProtocolEndpoint& newInstance, const OpenDRIM_DNSProtocolEndpoint& oldInstance, const char** properties, string& errorMessage);

int DNS_OpenDRIM_DNSProtocolEndpoint_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSProtocolEndpoint& instance, string& errorMessage);

int DNS_OpenDRIM_DNSProtocolEndpoint_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSProtocolEndpoint& instance, string& errorMessage);

int DNS_OpenDRIM_DNSProtocolEndpoint_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DNSProtocolEndpoint& instance, unsigned int& returnValue, const OpenDRIM_DNSProtocolEndpoint_RequestStateChange_In& in, OpenDRIM_DNSProtocolEndpoint_RequestStateChange_Out& out, string& errorMessage);

int DNS_OpenDRIM_DNSProtocolEndpoint_populate(OpenDRIM_DNSProtocolEndpoint& instance, string& errorMessage);

#endif /*OPENDRIM_DNSPROTOCOLENDPOINTACCESS_H_*/
