/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.module.html.Html4DocDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlAttributeDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlSpecialToken;
import edu.harvard.hul.ois.jhove.module.html.HtmlTagDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Html4StrictDocDesc
extends Html4DocDesc {
    protected static void classInit4(Map map) {
        HtmlTagDesc htmlTagDesc;
        String string;
        int n;
        Html4DocDesc.classInit4(map);
        fontMarkup = new String[]{"tt", "i", "b", "big", "small"};
        listMarkup = new String[]{"ul", "ol"};
        specialMarkup = new String[]{"a", "img", "object", "br", "script", "map", "q", "sub", "sup", "span", "bdo"};
        inlineContent = new ArrayList(35);
        Html4StrictDocDesc.addStringsToList(fontMarkup, inlineContent);
        Html4StrictDocDesc.addStringsToList(phraseMarkup, inlineContent);
        Html4StrictDocDesc.addStringsToList(specialMarkup, inlineContent);
        Html4StrictDocDesc.addStringsToList(formMarkup, inlineContent);
        inlineContent.add(HtmlSpecialToken.PCDATA);
        blockContent = new ArrayList(20);
        Html4StrictDocDesc.addStringsToList(headings, blockContent);
        Html4StrictDocDesc.addStringsToList(listMarkup, blockContent);
        String[] stringArray = new String[]{"p", "pre", "dl", "div", "noscript", "blockquote", "form", "hr", "table", "fieldset", "address"};
        Html4StrictDocDesc.addStringsToList(stringArray, blockContent);
        flowContent = new ArrayList(30);
        flowContent.addAll(blockContent);
        flowContent.addAll(inlineContent);
        bodyContent = new ArrayList(blockContent.size() + 3);
        bodyContent.addAll(blockContent);
        bodyContent.add("script");
        bodyContent.add("ins");
        bodyContent.add("del");
        listContent = new ArrayList(1);
        listContent.add("li");
        for (n = 0; n < fontMarkup.length; ++n) {
            string = fontMarkup[n];
            htmlTagDesc = new HtmlTagDesc(string, true, true, inlineContent, bigAttrs);
            map.put(string, htmlTagDesc);
        }
        for (n = 0; n < phraseMarkup.length; ++n) {
            string = phraseMarkup[n];
            htmlTagDesc = new HtmlTagDesc(string, true, true, inlineContent, bigAttrs);
            map.put(string, htmlTagDesc);
        }
        thtdAtts = new ArrayList(bigAttrs.size() + 7);
        thtdAtts.addAll(bigAttrs);
        Html4StrictDocDesc.addSimpleAttribute(thtdAtts, "abbr");
        Html4StrictDocDesc.addSimpleAttribute(thtdAtts, "axis");
        Html4StrictDocDesc.addSimpleAttribute(thtdAtts, "headers");
        Html4StrictDocDesc.addSimpleAttribute(thtdAtts, "scope");
        thtdAtts.add(halignAtt);
        thtdAtts.add(valignAtt);
        Html4StrictDocDesc.addSimpleAttribute(thtdAtts, "rowspan");
        Html4StrictDocDesc.addSimpleAttribute(thtdAtts, "colspan");
    }

    protected static void addAElement(Map map) {
        String string = "a";
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 14);
        arrayList.addAll(bigAttrs);
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "type");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "name");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "href");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "hreflang");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "rel");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "rev");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "accesskey");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "shape");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "rect");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "coords");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "tabindex");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "onfocus");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "onblur");
        ArrayList arrayList2 = new ArrayList(inlineContent.size());
        arrayList2.addAll(inlineContent);
        arrayList2.remove("a");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, arrayList2, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addAddressElement(Map map) {
        String string = "address";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, inlineContent, bigAttrs);
        map.put(string, htmlTagDesc);
    }

    protected static void addAreaElement(Map map, HtmlAttributeDesc htmlAttributeDesc) {
        String string = "area";
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(5);
        arrayList.add(htmlAttributeDesc);
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "coords");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "href");
        arrayList.add(new HtmlAttributeDesc("nohref", new String[]{"nohref"}, 4));
        arrayList.add(new HtmlAttributeDesc("alt", null, 1));
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "tabindex");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "accesskey");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "onfocus");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "onblur");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addBaseElement(Map map) {
        String string = "base";
        ArrayList arrayList = new ArrayList(1);
        Html4StrictDocDesc.addRequiredAttribute(arrayList, "href");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, arrayList);
        map.put(string, htmlTagDesc);
    }

    protected static void addBlockquoteElement(Map map) {
        String string = "blockquote";
        ArrayList<String> arrayList = new ArrayList<String>(blockContent.size() + 1);
        arrayList.addAll(blockContent);
        arrayList.add("script");
        ArrayList arrayList2 = new ArrayList(bigAttrs.size() + 1);
        arrayList2.addAll(bigAttrs);
        Html4StrictDocDesc.addSimpleAttribute(arrayList2, "cite");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, arrayList, arrayList2);
        map.put(string, htmlTagDesc);
    }

    protected static void addBrElement(Map map, List list) {
        String string = "br";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, false, null, list);
        map.put(string, htmlTagDesc);
    }

    protected static void addButtonElement(Map map) {
        String string = "button";
        ArrayList<String> arrayList = new ArrayList<String>(formMarkup.length + 3);
        Html4StrictDocDesc.addStringsToList(formMarkup, arrayList);
        arrayList.add("form");
        arrayList.add("fieldset");
        ArrayList<HtmlAttributeDesc> arrayList2 = new ArrayList<HtmlAttributeDesc>(biggerAttrs.size() + 8);
        arrayList2.addAll(biggerAttrs);
        Html4StrictDocDesc.addSimpleAttribute(arrayList2, "name");
        Html4StrictDocDesc.addSimpleAttribute(arrayList2, "value");
        arrayList2.add(new HtmlAttributeDesc("type", new String[]{"button", "submit", "reset"}, 5));
        Html4StrictDocDesc.addSelfAttribute(arrayList2, "disabled");
        Html4StrictDocDesc.addSimpleAttribute(arrayList2, "tabindex");
        Html4StrictDocDesc.addSimpleAttribute(arrayList2, "accesskey");
        Html4StrictDocDesc.addSimpleAttribute(arrayList2, "onfocus");
        Html4StrictDocDesc.addSimpleAttribute(arrayList2, "onblur");
    }

    protected static void addCaptionElement(Map map, List list, HtmlAttributeDesc htmlAttributeDesc) {
        String string = "caption";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, list, bigAttrs);
        map.put(string, htmlTagDesc);
    }

    protected static void addDivElement(Map map) {
        String string = "div";
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, flowContent, bigAttrs);
        map.put(string, htmlTagDesc);
    }

    protected static void addDlElement(Map map) {
        String string = "dl";
        ArrayList arrayList = new ArrayList(2);
        Html4StrictDocDesc.addStringsToList(new String[]{"dt", "dd"}, arrayList);
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, true, true, arrayList, bigAttrs);
        map.put(string, htmlTagDesc);
    }

    protected static void addHeadElement(Map map) {
        String string = "head";
        String[] stringArray = new String[]{"script", "style", "meta", "link"};
        ArrayList<String> arrayList = new ArrayList<String>(7);
        arrayList.add("title");
        arrayList.add("base");
        arrayList.add("script");
        arrayList.add("style");
        arrayList.add("meta");
        arrayList.add("link");
        arrayList.add("object");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc(string, false, false, arrayList, null);
        map.put(string, htmlTagDesc);
        Html4StrictDocDesc.addStringsToList(stringArray, arrayList);
    }

    protected static void addLegendElement(Map map) {
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 1);
        arrayList.addAll(bigAttrs);
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "accesskey");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("label", true, true, inlineContent, arrayList);
        map.put("label", htmlTagDesc);
    }

    protected static void addLiElement(Map map) {
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("li", true, false, flowContent, bigAttrs);
        map.put("li", htmlTagDesc);
    }

    protected static void addLinkElement(Map map) {
        ArrayList arrayList = new ArrayList(bigAttrs.size() + 8);
        arrayList.addAll(bigAttrs);
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "charset");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "href");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "hreflang");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "type");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "rel");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "rev");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "media");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("link", true, false, null, arrayList);
        map.put("link", htmlTagDesc);
    }

    protected static void addNoscriptElement(Map map) {
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("noscript", true, false, blockContent, bigAttrs);
        map.put("noscript", htmlTagDesc);
    }

    protected static void addObjectElement(Map map) {
        ArrayList arrayList = new ArrayList(biggerAttrs.size() + 13);
        arrayList.addAll(biggerAttrs);
        Html4StrictDocDesc.addSelfAttribute(arrayList, "declare");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "classid");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "codebase");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "data");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "type");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "codetype");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "archive");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "standby");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "height");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "width");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "usemap");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "name");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "tabindex");
    }

    protected static void addOlElement(Map map) {
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("ol", true, true, listContent, bigAttrs);
        map.put("ol", htmlTagDesc);
    }

    protected static void addPElement(Map map) {
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("p", true, false, inlineContent, bigAttrs);
        map.put("p", htmlTagDesc);
    }

    protected static void addPreElement(Map map) {
        ArrayList arrayList = new ArrayList(inlineContent.size());
        arrayList.addAll(inlineContent);
        Html4StrictDocDesc.removeStringsFromList(arrayList, new String[]{"img", "object", "big", "small", "sub", "sup"});
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("pre", true, true, arrayList, bigAttrs);
        map.put("pre", htmlTagDesc);
    }

    protected static void addScriptElement(Map map) {
        ArrayList<HtmlSpecialToken> arrayList = new ArrayList<HtmlSpecialToken>(1);
        arrayList.add(HtmlSpecialToken.PCDATA);
        ArrayList arrayList2 = new ArrayList(6);
        Html4StrictDocDesc.addSimpleAttribute(arrayList2, "charset");
        Html4StrictDocDesc.addSimpleAttribute(arrayList2, "type");
        Html4StrictDocDesc.addSimpleAttribute(arrayList2, "src");
        Html4StrictDocDesc.addSelfAttribute(arrayList2, "defer");
        Html4StrictDocDesc.addSimpleAttribute(arrayList2, "event");
        Html4StrictDocDesc.addSimpleAttribute(arrayList2, "for");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("script", true, true, arrayList, arrayList2);
        map.put("script", htmlTagDesc);
    }

    protected static void addTableElement(Map map) {
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(biggerAttrs.size() + 8);
        arrayList.addAll(biggerAttrs);
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "summary");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "width");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "border");
        arrayList.add(new HtmlAttributeDesc("frame", new String[]{"void", "above", "below", "hsides", "lhs", "rhs", "vsides", "box", "border"}, 4));
        arrayList.add(new HtmlAttributeDesc("rules", new String[]{"none", "groups", "rows", "cols", "all"}, 4));
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "rules");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "cellspacing");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "cellpadding");
        Html4StrictDocDesc.addSimpleAttribute(arrayList, "datapagesize");
        List[] listArray = new List[5];
        int[] nArray = new int[]{0, 3, 0, 0, 2};
        ArrayList<String> arrayList2 = new ArrayList<String>(1);
        arrayList2.add("caption");
        listArray[0] = arrayList2;
        arrayList2 = new ArrayList(2);
        arrayList2.add("col");
        arrayList2.add("colgroup");
        listArray[1] = arrayList2;
        arrayList2 = new ArrayList(1);
        arrayList2.add("thead");
        listArray[2] = arrayList2;
        arrayList2 = new ArrayList(1);
        arrayList2.add("tfoot");
        listArray[3] = arrayList2;
        arrayList2 = new ArrayList(1);
        arrayList2.add("tbody");
        listArray[4] = arrayList2;
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("table", true, true, nArray, listArray, arrayList);
        map.put("table", htmlTagDesc);
    }

    protected static void addTrElement(Map map) {
        ArrayList<HtmlAttributeDesc> arrayList = new ArrayList<HtmlAttributeDesc>(bigAttrs.size() + 3);
        arrayList.addAll(bigAttrs);
        arrayList.add(halignAtt);
        arrayList.add(valignAtt);
        ArrayList<String> arrayList2 = new ArrayList<String>(2);
        arrayList2.add("th");
        arrayList2.add("td");
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("tr", true, false, arrayList2, arrayList);
        htmlTagDesc.addImplicitContainer((HtmlTagDesc)map.get("tbody"));
        map.put("tr", htmlTagDesc);
    }

    protected static void addUlElement(Map map) {
        HtmlTagDesc htmlTagDesc = new HtmlTagDesc("ul", true, true, listContent, bigAttrs);
        map.put("ul", htmlTagDesc);
    }
}

