/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import org.fest.swing.core.MouseButton;
import org.fest.util.Strings;

public final class MouseClickInfo {
    private final MouseButton button;
    private int times;

    public static MouseClickInfo leftButton() {
        return MouseClickInfo.button(MouseButton.LEFT_BUTTON);
    }

    public static MouseClickInfo middleButton() {
        return MouseClickInfo.button(MouseButton.MIDDLE_BUTTON);
    }

    public static MouseClickInfo rightButton() {
        return MouseClickInfo.button(MouseButton.RIGHT_BUTTON);
    }

    public static MouseClickInfo button(MouseButton button) {
        return new MouseClickInfo(button, 1);
    }

    private MouseClickInfo(MouseButton button, int times) {
        if (button == null) {
            throw new NullPointerException("The MouseButton should not be null");
        }
        this.button = button;
        this.times = times;
    }

    public MouseButton button() {
        return this.button;
    }

    public int times() {
        return this.times;
    }

    public MouseClickInfo times(int newTimes) {
        this.times = newTimes;
        return this;
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{this.getClass().getSimpleName(), "[", "button=", this.button, ",", "times=", String.valueOf(this.times), "]"});
    }
}

