/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.encoding.ExternalCompressor;
import htsjdk.samtools.cram.encoding.NullEncoding;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.io.InputStreamUtils;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CompressionHeader {
    private static final String RN_readNamesIncluded = "RN";
    private static final String AP_alignmentPositionIsDelta = "AP";
    private static final String RR_referenceRequired = "RR";
    private static final String TD_tagIdsDictionary = "TD";
    private static final String SM_substitutionMatrix = "SM";
    private static final Log log = Log.getInstance(CompressionHeader.class);
    public boolean readNamesIncluded;
    public boolean APDelta = true;
    private boolean referenceRequired = true;
    public Map<EncodingKey, EncodingParams> encodingMap;
    public Map<Integer, EncodingParams> tMap;
    public final Map<Integer, ExternalCompressor> externalCompressors = new HashMap<Integer, ExternalCompressor>();
    public SubstitutionMatrix substitutionMatrix;
    public List<Integer> externalIds;
    public byte[][][] dictionary;

    public CompressionHeader() {
    }

    private CompressionHeader(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    /*
     * WARNING - void declaration
     */
    private byte[][][] parseDictionary(byte[] bytes) {
        void var5_7;
        ArrayList<Object> dictionary = new ArrayList<Object>();
        for (int i = 0; i < bytes.length; ++i) {
            ArrayList list = new ArrayList();
            while (bytes[i] != 0) {
                list.add(Arrays.copyOfRange(bytes, i, i + 3));
                i += 3;
            }
            dictionary.add(list);
        }
        int maxWidth = 0;
        for (List list : dictionary) {
            maxWidth = Math.max(maxWidth, list.size());
        }
        byte[][][] array = new byte[dictionary.size()][][];
        boolean bl = false;
        while (var5_7 < dictionary.size()) {
            List list = (List)dictionary.get((int)var5_7);
            array[var5_7] = (byte[][])list.toArray((T[])new byte[list.size()][]);
            ++var5_7;
        }
        return array;
    }

    private byte[] dictionaryToByteArray() {
        int size = 0;
        byte[][][] byArray = this.dictionary;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte[][] dictionaryArrayArray;
            for (byte[] dictionaryArray : dictionaryArrayArray = byArray[i]) {
                size += dictionaryArray.length;
            }
            ++size;
        }
        byte[] bytes = new byte[size];
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        byte[][][] byArray2 = this.dictionary;
        int n2 = byArray2.length;
        for (int i = 0; i < n2; ++i) {
            byte[][] dictionaryArrayArray;
            for (byte[] dictionaryArray : dictionaryArrayArray = byArray2[i]) {
                buffer.put(dictionaryArray);
            }
            buffer.put((byte)0);
        }
        return bytes;
    }

    public byte[][] getTagIds(int id) {
        return this.dictionary[id];
    }

    public void read(byte[] data) {
        try {
            this.read(new ByteArrayInputStream(data));
        }
        catch (IOException e) {
            throw new RuntimeException("This should have never happened.");
        }
    }

    void read(InputStream is) throws IOException {
        int i;
        int byteSize = ITF8.readUnsignedITF8(is);
        byte[] bytes = new byte[byteSize];
        InputStreamUtils.readFully(is, bytes, 0, bytes.length);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int mapSize = ITF8.readUnsignedITF8(buffer);
        for (int i2 = 0; i2 < mapSize; ++i2) {
            String key = new String(new byte[]{buffer.get(), buffer.get()});
            if (RN_readNamesIncluded.equals(key)) {
                this.readNamesIncluded = buffer.get() == 1;
                continue;
            }
            if (AP_alignmentPositionIsDelta.equals(key)) {
                this.APDelta = buffer.get() == 1;
                continue;
            }
            if (RR_referenceRequired.equals(key)) {
                this.referenceRequired = buffer.get() == 1;
                continue;
            }
            if (TD_tagIdsDictionary.equals(key)) {
                int size = ITF8.readUnsignedITF8(buffer);
                byte[] dictionaryBytes = new byte[size];
                buffer.get(dictionaryBytes);
                this.dictionary = this.parseDictionary(dictionaryBytes);
                continue;
            }
            if (SM_substitutionMatrix.equals(key)) {
                byte[] matrixBytes = new byte[5];
                buffer.get(matrixBytes);
                this.substitutionMatrix = new SubstitutionMatrix(matrixBytes);
                continue;
            }
            throw new RuntimeException("Unknown preservation map key: " + key);
        }
        byteSize = ITF8.readUnsignedITF8(is);
        bytes = new byte[byteSize];
        InputStreamUtils.readFully(is, bytes, 0, bytes.length);
        buffer = ByteBuffer.wrap(bytes);
        mapSize = ITF8.readUnsignedITF8(buffer);
        this.encodingMap = new TreeMap<EncodingKey, EncodingParams>();
        for (EncodingKey encodingKey : EncodingKey.values()) {
            this.encodingMap.put(encodingKey, NullEncoding.toParam());
        }
        for (i = 0; i < mapSize; ++i) {
            String key = new String(new byte[]{buffer.get(), buffer.get()});
            EncodingKey encodingKey = EncodingKey.byFirstTwoChars(key);
            if (encodingKey == null) {
                log.debug("Unknown encoding key: " + key);
                continue;
            }
            EncodingID id = EncodingID.values()[buffer.get()];
            int paramLen = ITF8.readUnsignedITF8(buffer);
            byte[] paramBytes = new byte[paramLen];
            buffer.get(paramBytes);
            this.encodingMap.put(encodingKey, new EncodingParams(id, paramBytes));
            log.debug(String.format("FOUND ENCODING: %s, %s, %s.", encodingKey.name(), id.name(), Arrays.toString(Arrays.copyOf(paramBytes, 20))));
        }
        byteSize = ITF8.readUnsignedITF8(is);
        bytes = new byte[byteSize];
        InputStreamUtils.readFully(is, bytes, 0, bytes.length);
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        mapSize = ITF8.readUnsignedITF8(buf);
        this.tMap = new TreeMap<Integer, EncodingParams>();
        for (i = 0; i < mapSize; ++i) {
            int key = ITF8.readUnsignedITF8(buf);
            EncodingID id = EncodingID.values()[buf.get()];
            int paramLen = ITF8.readUnsignedITF8(buf);
            byte[] paramBytes = new byte[paramLen];
            buf.get(paramBytes);
            this.tMap.put(key, new EncodingParams(id, paramBytes));
        }
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.write(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    void write(OutputStream outputStream) throws IOException {
        ByteBuffer mapBuffer = ByteBuffer.allocate(102400);
        ITF8.writeUnsignedITF8(5, mapBuffer);
        mapBuffer.put(RN_readNamesIncluded.getBytes());
        mapBuffer.put((byte)(this.readNamesIncluded ? 1 : 0));
        mapBuffer.put(AP_alignmentPositionIsDelta.getBytes());
        mapBuffer.put((byte)(this.APDelta ? 1 : 0));
        mapBuffer.put(RR_referenceRequired.getBytes());
        mapBuffer.put((byte)(this.referenceRequired ? 1 : 0));
        mapBuffer.put(SM_substitutionMatrix.getBytes());
        mapBuffer.put(this.substitutionMatrix.getEncodedMatrix());
        mapBuffer.put(TD_tagIdsDictionary.getBytes());
        byte[] dictionaryBytes = this.dictionaryToByteArray();
        ITF8.writeUnsignedITF8(dictionaryBytes.length, mapBuffer);
        mapBuffer.put(dictionaryBytes);
        mapBuffer.flip();
        Object mapBytes = new byte[mapBuffer.limit()];
        mapBuffer.get((byte[])mapBytes);
        ITF8.writeUnsignedITF8(((byte[])mapBytes).length, outputStream);
        outputStream.write((byte[])mapBytes);
        int size = 0;
        mapBytes = this.encodingMap.keySet().iterator();
        while (mapBytes.hasNext()) {
            EncodingKey encodingKey = (EncodingKey)((Object)mapBytes.next());
            if (this.encodingMap.get((Object)((Object)encodingKey)).id == EncodingID.NULL) continue;
            ++size;
        }
        ByteBuffer mapBuffer2 = ByteBuffer.allocate(102400);
        ITF8.writeUnsignedITF8(size, mapBuffer2);
        for (EncodingKey encodingKey : this.encodingMap.keySet()) {
            if (this.encodingMap.get((Object)((Object)encodingKey)).id == EncodingID.NULL) continue;
            mapBuffer2.put((byte)encodingKey.name().charAt(0));
            mapBuffer2.put((byte)encodingKey.name().charAt(1));
            EncodingParams params = this.encodingMap.get((Object)encodingKey);
            mapBuffer2.put((byte)(0xFF & params.id.ordinal()));
            ITF8.writeUnsignedITF8(params.params.length, mapBuffer2);
            mapBuffer2.put(params.params);
        }
        mapBuffer2.flip();
        byte[] byArray = new byte[mapBuffer2.limit()];
        mapBuffer2.get(byArray);
        ITF8.writeUnsignedITF8(byArray.length, outputStream);
        outputStream.write(byArray);
        mapBuffer = ByteBuffer.allocate(102400);
        ITF8.writeUnsignedITF8(this.tMap.size(), mapBuffer);
        for (Integer n : this.tMap.keySet()) {
            ITF8.writeUnsignedITF8((int)n, mapBuffer);
            EncodingParams params = this.tMap.get(n);
            mapBuffer.put((byte)(0xFF & params.id.ordinal()));
            ITF8.writeUnsignedITF8(params.params.length, mapBuffer);
            mapBuffer.put(params.params);
        }
        mapBuffer.flip();
        mapBytes = new byte[mapBuffer.limit()];
        mapBuffer.get((byte[])mapBytes);
        ITF8.writeUnsignedITF8(((byte[])mapBytes).length, outputStream);
        outputStream.write((byte[])mapBytes);
    }
}

