// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_PUBLIC_COMMON_REQUEST_CONTEXT_TYPE_H_
#define CONTENT_PUBLIC_COMMON_REQUEST_CONTEXT_TYPE_H_

namespace content {

enum RequestContextType {
  REQUEST_CONTEXT_TYPE_UNSPECIFIED = 0,
  REQUEST_CONTEXT_TYPE_AUDIO,
  REQUEST_CONTEXT_TYPE_BEACON,
  REQUEST_CONTEXT_TYPE_CSP_REPORT,
  REQUEST_CONTEXT_TYPE_DOWNLOAD,
  REQUEST_CONTEXT_TYPE_EMBED,
  REQUEST_CONTEXT_TYPE_EVENT_SOURCE,
  REQUEST_CONTEXT_TYPE_FAVICON,
  REQUEST_CONTEXT_TYPE_FETCH,
  REQUEST_CONTEXT_TYPE_FONT,
  REQUEST_CONTEXT_TYPE_FORM,
  REQUEST_CONTEXT_TYPE_FRAME,
  REQUEST_CONTEXT_TYPE_HYPERLINK,
  REQUEST_CONTEXT_TYPE_IFRAME,
  REQUEST_CONTEXT_TYPE_IMAGE,
  REQUEST_CONTEXT_TYPE_IMAGE_SET,
  REQUEST_CONTEXT_TYPE_IMPORT,
  REQUEST_CONTEXT_TYPE_INTERNAL,
  REQUEST_CONTEXT_TYPE_LOCATION,
  REQUEST_CONTEXT_TYPE_MANIFEST,
  REQUEST_CONTEXT_TYPE_OBJECT,
  REQUEST_CONTEXT_TYPE_PING,
  REQUEST_CONTEXT_TYPE_PLUGIN,
  REQUEST_CONTEXT_TYPE_PREFETCH,
  REQUEST_CONTEXT_TYPE_SCRIPT,
  REQUEST_CONTEXT_TYPE_SERVICE_WORKER,
  REQUEST_CONTEXT_TYPE_SHARED_WORKER,
  REQUEST_CONTEXT_TYPE_SUBRESOURCE,
  REQUEST_CONTEXT_TYPE_STYLE,
  REQUEST_CONTEXT_TYPE_TRACK,
  REQUEST_CONTEXT_TYPE_VIDEO,
  REQUEST_CONTEXT_TYPE_WORKER,
  REQUEST_CONTEXT_TYPE_XML_HTTP_REQUEST,
  REQUEST_CONTEXT_TYPE_XSLT,
  REQUEST_CONTEXT_TYPE_LAST = REQUEST_CONTEXT_TYPE_XSLT
};

}  // namespace content

#endif  // CONTENT_PUBLIC_COMMON_REQUEST_CONTEXT_TYPE_H_
