'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbGetNamedGeometry __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetNamedGeometry \- Loads a keyboard geometry description from this database 
by name
.SH SYNOPSIS
.HP
.B Status XkbGetNamedGeometry
.BI "(\^Display *" "dpy" "\^,"
.BI "XkbDescPtr " "xkb" "\^,"
.BI "Atom " "name" "\^);"
.SH ARGUMENTS
.TP
.I \- dpy
connection to the X server
.TP
.I \- xkb
keyboard description into which the geometry should be loaded
.TP
.I \- name
name of the geometry to be loaded
.SH DESCRIPTION
.LP
It is also possible to load a keyboard geometry by name. The X server maintains 
a database 
of keyboard components (see below).

.I XkbGetNamedGeometry 
can return BadName if the name cannot be found.

The X server maintains a database of keyboard components, identified by 
component type. 
The database contains all the information necessary to build a complete keyboard 
description for a particular device, as well as to assemble partial 
descriptions. Table 1 identifies the component types and the type of information 
they contain.

.TS
c s s
l l l
l l l
l lw(2i) lw(2i).
Table 1 Server Database Keyboard Components
_
Component	Component Primary Contents	May also contain
Type
_
Keymap	T{
Complete keyboard description
.br 
Normally assembled using a complete component from each of the other types
T}
.sp
Keycodes	T{
Symbolic name for each key
.br
Minimum and maximum legal keycodes
T}	T{
Aliases for some keys
.br
Symbolic names for indicators
.br
Description of indicators physically present
T}
.sp
Types	Key types	T{
Real modifier bindings and symbolic names for some virtual modifiers
T}
.sp
Compatibility	T{
Rules used to assign actions to keysyms
T}	T{
Maps for some indicators
.br
Real modifier bindings and symbolic names for some virtual modifiers
T}
.sp
Symbols	T{
Symbol mapping for keyboard keys
.br
Modifier mapping
.br
Symbolic names for groups
T}	T{
Explicit actions and behaviors for some keys
.br
Real modifier bindings and symbolic names for some virtual modifiers
T}
.sp
Geometry	Layout of the keyboard	T{
Aliases for some keys; overrides keycodes component aliases
.br
Symbolic names for some indicators
.br
Description of indicators physically present
T}
.TE

While a keymap is a database entry for a complete keyboard description, and 
therefore 
logically different from the individual component database entries, the rules 
for 
processing keymap entries are identical to those for the individual components. 
In the 
discussion that follows, the term component is used to refer to either 
individual 
components or a keymap.

There may be multiple entries for each of the component types. An entry may be 
either
.I complete 
or 
.I partial. 
Partial entries describe only a piece of the corresponding keyboard component 
and are 
designed to be combined with other entries of the same type to form a complete 
entry.

For example, a partial symbols map might describe the differences between a 
common ASCII 
keyboard and some national layout. Such a partial map is not useful on its own 
because it 
does not include those symbols that are the same on both the ASCII and national 
layouts 
(such as function keys). On the other hand, this partial map can be used to 
configure 
.I any 
ASCII keyboard to use a national layout.

When a keyboard description is built, the components are processed in the order 
in which 
they appear in Table 1; later definitions override earlier ones.
.SH DIAGNOSTICS
.TP 15
.B BadName
A font or color of the specified name does not exist.
