// Copyright 2014 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "xfa/fgas/font/fgas_fontutils.h"

#include "build/build_config.h"
#include "core/fxcrt/fx_codepage.h"
#include "core/fxcrt/fx_extension.h"
#include "xfa/fgas/font/cfgas_fontmgr.h"

namespace {

const FGAS_FONTUSB g_FXGdiFontUSBTable[] = {
    {0x0000, 0x007F, 0, FX_CODEPAGE_MSWin_WesternEuropean},
    {0x0080, 0x00FF, 1, FX_CODEPAGE_MSWin_WesternEuropean},
    {0x0100, 0x017F, 2, FX_CODEPAGE_MSWin_EasternEuropean},
    {0x0180, 0x024F, 3, FX_CODEPAGE_MSWin_EasternEuropean},
    {0x0250, 0x02AF, 4, 0xFFFF},
    {0x02B0, 0x02FF, 5, 0xFFFF},
    {0x0300, 0x036F, 6, 0xFFFF},
    {0x0370, 0x03FF, 7, FX_CODEPAGE_MSWin_Greek},
    {0x0400, 0x04FF, 9, FX_CODEPAGE_MSWin_Cyrillic},
    {0x0500, 0x052F, 9, 0xFFFF},
    {0x0530, 0x058F, 10, 0xFFFF},
    {0x0590, 0x05FF, 11, FX_CODEPAGE_MSWin_Hebrew},
    {0x0600, 0x06FF, 13, FX_CODEPAGE_MSWin_Arabic},
    {0x0700, 0x074F, 71, 0xFFFF},
    {0x0750, 0x077F, 13, 0xFFFF},
    {0x0780, 0x07BF, 72, 0xFFFF},
    {0x07C0, 0x07FF, 14, 0xFFFF},
    {0x0800, 0x08FF, 999, 0xFFFF},
    {0x0900, 0x097F, 15, 0xFFFF},
    {0x0980, 0x09FF, 16, 0xFFFF},
    {0x0A00, 0x0A7F, 17, 0xFFFF},
    {0x0A80, 0x0AFF, 18, 0xFFFF},
    {0x0B00, 0x0B7F, 19, 0xFFFF},
    {0x0B80, 0x0BFF, 20, 0xFFFF},
    {0x0C00, 0x0C7F, 21, 0xFFFF},
    {0x0C80, 0x0CFF, 22, 0xFFFF},
    {0x0D00, 0x0D7F, 23, 0xFFFF},
    {0x0D80, 0x0DFF, 73, 0xFFFF},
    {0x0E00, 0x0E7F, 24, FX_CODEPAGE_MSDOS_Thai},
    {0x0E80, 0x0EFF, 25, 0xFFFF},
    {0x0F00, 0x0FFF, 70, 0xFFFF},
    {0x1000, 0x109F, 74, 0xFFFF},
    {0x10A0, 0x10FF, 26, 0xFFFF},
    {0x1100, 0x11FF, 28, 0xFFFF},
    {0x1200, 0x137F, 75, 0xFFFF},
    {0x1380, 0x139F, 75, 0xFFFF},
    {0x13A0, 0x13FF, 76, 0xFFFF},
    {0x1400, 0x167F, 77, 0xFFFF},
    {0x1680, 0x169F, 78, 0xFFFF},
    {0x16A0, 0x16FF, 79, 0xFFFF},
    {0x1700, 0x171F, 84, 0xFFFF},
    {0x1720, 0x173F, 84, 0xFFFF},
    {0x1740, 0x175F, 84, 0xFFFF},
    {0x1760, 0x177F, 84, 0xFFFF},
    {0x1780, 0x17FF, 80, 0xFFFF},
    {0x1800, 0x18AF, 81, 0xFFFF},
    {0x18B0, 0x18FF, 999, 0xFFFF},
    {0x1900, 0x194F, 93, 0xFFFF},
    {0x1950, 0x197F, 94, 0xFFFF},
    {0x1980, 0x19DF, 95, 0xFFFF},
    {0x19E0, 0x19FF, 80, 0xFFFF},
    {0x1A00, 0x1A1F, 96, 0xFFFF},
    {0x1A20, 0x1AFF, 999, 0xFFFF},
    {0x1B00, 0x1B7F, 27, 0xFFFF},
    {0x1B80, 0x1BBF, 112, 0xFFFF},
    {0x1BC0, 0x1BFF, 999, 0xFFFF},
    {0x1C00, 0x1C4F, 113, 0xFFFF},
    {0x1C50, 0x1C7F, 114, 0xFFFF},
    {0x1C80, 0x1CFF, 999, 0xFFFF},
    {0x1D00, 0x1D7F, 4, 0xFFFF},
    {0x1D80, 0x1DBF, 4, 0xFFFF},
    {0x1DC0, 0x1DFF, 6, 0xFFFF},
    {0x1E00, 0x1EFF, 29, 0xFFFF},
    {0x1F00, 0x1FFF, 30, 0xFFFF},
    {0x2000, 0x206F, 31, 0xFFFF},
    {0x2070, 0x209F, 32, 0xFFFF},
    {0x20A0, 0x20CF, 33, 0xFFFF},
    {0x20D0, 0x20FF, 34, 0xFFFF},
    {0x2100, 0x214F, 35, 0xFFFF},
    {0x2150, 0x215F, 36, 0xFFFF},
    {0x2160, 0x216B, 36, FX_CODEPAGE_ChineseSimplified},
    {0x216C, 0x216F, 36, 0xFFFF},
    {0x2170, 0x2179, 36, FX_CODEPAGE_ChineseSimplified},
    {0x217A, 0x218F, 36, 0xFFFF},
    {0x2190, 0x2199, 37, FX_CODEPAGE_Hangul},
    {0x219A, 0x21FF, 37, 0xFFFF},
    {0x2200, 0x22FF, 38, 0xFFFF},
    {0x2300, 0x23FF, 39, 0xFFFF},
    {0x2400, 0x243F, 40, 0xFFFF},
    {0x2440, 0x245F, 41, 0xFFFF},
    {0x2460, 0x2473, 42, FX_CODEPAGE_ShiftJIS},
    {0x2474, 0x249B, 42, FX_CODEPAGE_ChineseSimplified},
    {0x249C, 0x24E9, 42, FX_CODEPAGE_Hangul},
    {0x24EA, 0x24FF, 42, 0xFFFF},
    {0x2500, 0x2573, 43, FX_CODEPAGE_ChineseSimplified},
    {0x2574, 0x257F, 43, 0xFFFF},
    {0x2580, 0x2580, 44, 0xFFFF},
    {0x2581, 0x258F, 44, FX_CODEPAGE_ChineseSimplified},
    {0x2590, 0x259F, 44, 0xFFFF},
    {0x25A0, 0x25FF, 45, 0xFFFF},
    {0x2600, 0x26FF, 46, 0xFFFF},
    {0x2700, 0x27BF, 47, 0xFFFF},
    {0x27C0, 0x27EF, 38, 0xFFFF},
    {0x27F0, 0x27FF, 37, 0xFFFF},
    {0x2800, 0x28FF, 82, 0xFFFF},
    {0x2900, 0x297F, 37, 0xFFFF},
    {0x2980, 0x29FF, 38, 0xFFFF},
    {0x2A00, 0x2AFF, 38, 0xFFFF},
    {0x2B00, 0x2BFF, 37, 0xFFFF},
    {0x2C00, 0x2C5F, 97, 0xFFFF},
    {0x2C60, 0x2C7F, 29, 0xFFFF},
    {0x2C80, 0x2CFF, 8, 0xFFFF},
    {0x2D00, 0x2D2F, 26, 0xFFFF},
    {0x2D30, 0x2D7F, 98, 0xFFFF},
    {0x2D80, 0x2DDF, 75, 0xFFFF},
    {0x2DE0, 0x2DFF, 9, 0xFFFF},
    {0x2E00, 0x2E7F, 31, 0xFFFF},
    {0x2E80, 0x2EFF, 59, 0xFFFF},
    {0x2F00, 0x2FDF, 59, 0xFFFF},
    {0x2FE0, 0x2FEF, 999, 0xFFFF},
    {0x2FF0, 0x2FFF, 59, 0xFFFF},
    {0x3000, 0x303F, 48, 0xFFFF},
    {0x3040, 0x309F, 49, FX_CODEPAGE_ShiftJIS},
    {0x30A0, 0x30FF, 50, FX_CODEPAGE_ShiftJIS},
    {0x3100, 0x3129, 51, FX_CODEPAGE_ChineseSimplified},
    {0x312A, 0x312F, 51, 0xFFFF},
    {0x3130, 0x318F, 52, FX_CODEPAGE_Hangul},
    {0x3190, 0x319F, 59, 0xFFFF},
    {0x31A0, 0x31BF, 51, 0xFFFF},
    {0x31C0, 0x31EF, 61, 0xFFFF},
    {0x31F0, 0x31FF, 50, 0xFFFF},
    {0x3200, 0x321C, 54, FX_CODEPAGE_Hangul},
    {0x321D, 0x325F, 54, 0xFFFF},
    {0x3260, 0x327F, 54, FX_CODEPAGE_Hangul},
    {0x3280, 0x32FF, 54, 0xFFFF},
    {0x3300, 0x3387, 55, 0xFFFF},
    {0x3388, 0x33D0, 55, FX_CODEPAGE_Hangul},
    {0x33D1, 0x33FF, 55, 0xFFFF},
    {0x3400, 0x4DBF, 59, 0xFFFF},
    {0x4DC0, 0x4DFF, 99, 0xFFFF},
    {0x4E00, 0x9FA5, 59, FX_CODEPAGE_ChineseSimplified},
    {0x9FA6, 0x9FFF, 59, 0xFFFF},
    {0xA000, 0xA48F, 83, 0xFFFF},
    {0xA490, 0xA4CF, 83, 0xFFFF},
    {0xA4D0, 0xA4FF, 999, 0xFFFF},
    {0xA500, 0xA63F, 12, 0xFFFF},
    {0xA640, 0xA69F, 9, 0xFFFF},
    {0xA6A0, 0xA6FF, 999, 0xFFFF},
    {0xA700, 0xA71F, 5, 0xFFFF},
    {0xA720, 0xA7FF, 29, 0xFFFF},
    {0xA800, 0xA82F, 100, 0xFFFF},
    {0xA830, 0xA8FF, 999, 0xFFFF},
    {0xA840, 0xA87F, 53, 0xFFFF},
    {0xA880, 0xA8DF, 115, 0xFFFF},
    {0xA8E0, 0xA8FF, 999, 0xFFFF},
    {0xA900, 0xA92F, 116, 0xFFFF},
    {0xA930, 0xA95F, 117, 0xFFFF},
    {0xA960, 0xA9FF, 999, 0xFFFF},
    {0xAA00, 0xAA5F, 118, 0xFFFF},
    {0xAA60, 0xABFF, 999, 0xFFFF},
    {0xAC00, 0xD7AF, 56, FX_CODEPAGE_Hangul},
    {0xD7B0, 0xD7FF, 999, 0xFFFF},
    {0xD800, 0xDB7F, 57, 0xFFFF},
    {0xDB80, 0xDBFF, 57, 0xFFFF},
    {0xDC00, 0xDFFF, 57, 0xFFFF},
    {0xE000, 0xE814, 60, 0xFFFF},
    {0xE815, 0xE864, 60, FX_CODEPAGE_ChineseSimplified},
    {0xE865, 0xF8FF, 60, 0xFFFF},
    {0xF900, 0xFA0B, 61, FX_CODEPAGE_Hangul},
    {0xFA0C, 0xFA0D, 61, FX_CODEPAGE_ChineseSimplified},
    {0xFA0E, 0xFA2D, 61, FX_CODEPAGE_ShiftJIS},
    {0xFA2E, 0xFAFF, 61, 0xFFFF},
    {0xFB00, 0xFB4F, 62, 0xFFFF},
    {0xFB50, 0xFDFF, 63, FX_CODEPAGE_MSWin_Arabic},
    {0xFE00, 0xFE0F, 91, 0xFFFF},
    {0xFE10, 0xFE1F, 65, 0xFFFF},
    {0xFE20, 0xFE2F, 64, 0xFFFF},
    {0xFE30, 0xFE4F, 65, 0xFFFF},
    {0xFE50, 0xFE6F, 66, 0xFFFF},
    {0xFE70, 0xFEFF, 67, FX_CODEPAGE_MSWin_Arabic},
    {0xFF00, 0xFF5F, 68, FX_CODEPAGE_ChineseSimplified},
    {0xFF60, 0xFF9F, 68, FX_CODEPAGE_ShiftJIS},
    {0xFFA0, 0xFFEF, 68, 0xFFFF},
};

#if defined(OS_WIN)
const FGAS_FontInfo g_XFAFontsMap[] = {
    {0x01d5d33e, "SimSun", "Arial", 0, 936},
    {0x01e4f102, "YouYuan", "Arial", 1, 936},
    {0x030549dc, "LiSu", "Arial", 1, 936},
    {0x032edd44, "Simhei", "Arial", 1, 936},
    {0x03eac6fc, "PoorRichard-Regular", "Arial", 2, 1252},
    {0x03ed90e6, "Nina", "Arial", 0, 1252},
    {0x077b56b3, "KingsoftPhoneticPlain", "Arial", 0, 1252},
    {0x078ed524, "MicrosoftSansSerif", "Arial", 0, 1252},
    {0x089b18a9, "Arial", "Arial", 0, 1252},
    {0x0b2cad72, "MonotypeCorsiva", "Arial", 8, 1252},
    {0x0bb003e7, "Kartika", "Arial", 2, 1252},
    {0x0bb469df, "VinerHandITC", "Arial", 8, 1252},
    {0x0bc1a851, "SegoeUI", "Arial", 0, 1252},
    {0x0c112ebd, "KozukaGothicPro-VIM", "Arial", 0, 1252},
    {0x0cfcb9c1, "AdobeThai", "Kokila,Arial Narrow", 0, 847},
    {0x0e7de0f9, "Playbill", "Arial", 0, 1252},
    {0x0eff47c3, "STHupo", "Arial", 0, 936},
    {0x107ad374, "Constantia", "Arial", 2, 1252},
    {0x12194c2d, "KunstlerScript", "Arial", 8, 1252},
    {0x135ef6a1, "MinionProSmBd",
     "Bell MT,Corbel,Times New Roman,Cambria,Berlin Sans FB", 0, 1252},
    {0x158c4049, "Garamond", "Arial", 2, 1252},
    {0x160ecb24, "STZhongsong", "Arial", 0, 936},
    {0x161ed07e, "MSGothic", "Arial", 1, 1252},
    {0x171d1ed1, "SnapITC-Regular", "Arial", 0, 1252},
    {0x18d1188f, "Cambria", "Arial", 2, 1252},
    {0x18eaf350, "ArialUnicodeMS", "Arial", 0, 936},
    {0x1a92d115, "MingLiU", "Arial", 1, 1252},
    {0x1cc217c6, "TrebuchetMS", "Arial", 0, 1252},
    {0x1d649596, "BasemicTimes", "Arial", 0, 1252},
    {0x1e34ee60, "BellMT", "Arial", 2, 1252},
    {0x1eb36945, "CooperBlack", "Arial", 2, 1252},
    {0x1ef7787d, "BatangChe", "Arial", 1, 1252},
    {0x20b3bd3a, "BrushScriptMT", "Arial", 8, 1252},
    {0x220877aa, "Candara", "Arial", 0, 1252},
    {0x22135007, "FreestyleScript-Regular", "Arial", 8, 1252},
    {0x251059c3, "Chiller", "Arial", 0, 1252},
    {0x25bed6dd, "MSReferenceSansSerif", "Arial", 0, 1252},
    {0x28154c81, "Parchment-Regular", "Arial", 8, 1252},
    {0x29711eb9, "STLiti", "Arial", 0, 936},
    {0x2b1993b4, "Basemic", "Arial", 0, 1252},
    {0x2b316339, "NiagaraSolid-Reg", "Arial", 0, 1252},
    {0x2c147529, "FootlightMTLight", "Arial", 0, 1252},
    {0x2c198928, "HarlowSolid", "Arial", 0, 1252},
    {0x2c6ac6b2, "LucidaBright", "Arial", 2, 1252},
    {0x2c9f38e2, "KozukaMinchoPro-VIR", "Arial", 0, 1252},
    {0x2d5a47b0, "STCaiyun", "Arial", 0, 936},
    {0x2def26bf, "BernardMT-Condensed", "Arial", 0, 1252},
    {0x2fd8930b, "KozukaMinchoPr6NR", "Arial", 0, 1252},
    {0x3115525a, "FangSong_GB2312", "Arial", 0, 1252},
    {0x31327817, "MyriadPro",
     "Calibri,Corbel,Candara,Cambria Math,Franklin Gothic Medium,Arial "
     "Narrow,Times New Roman",
     0, 1252},
    {0x32244975, "Helvetica", "Arial", 0, 1252},
    {0x32ac995c, "Terminal", "Arial", 0, 1252},
    {0x338d648a, "NiagaraEngraved-Reg", "Arial", 0, 1252},
    {0x33bb65f2, "Sylfaen", "Arial", 2, 1252},
    {0x3402c30e, "MSPMincho", "Arial", 2, 1252},
    {0x3412bf31, "SimSun-PUA", "Arial", 0, 936},
    {0x36eb39b9, "BerlinSansFB", "Arial", 0, 1252},
    {0x36f42055, "UniversATT", "Microsoft Sans Serif", 0, 1252},
    {0x3864c4f6, "HighTowerText", "Arial", 2, 1252},
    {0x3a257d03, "FangSong_GB2312", "Arial", 0, 1252},
    {0x3cdae668, "FreestyleScript", "Arial", 8, 1252},
    {0x3d55aed7, "Jokerman", "Arial", 0, 1252},
    {0x3d5b4385, "PMingLiU", "Arial", 2, 1252},
    {0x3d9b7669, "EstrangeloEdessa", "Arial", 0, 1252},
    {0x3e532d74, "FranklinGothicMedium", "Arial", 0, 1252},
    {0x3e6aa32d, "NSimSun", "Arial", 1, 936},
    {0x3f6c36a8, "Gautami", "Arial", 0, 1252},
    {0x3ff32662, "Chiller-Regular", "Arial", 0, 1252},
    {0x409de312, "ModernNo.20", "Arial", 2, 1252},
    {0x41443c5e, "Georgia", "Arial", 2, 1252},
    {0x4160ade5, "BellGothicStdBlack",
     "Arial,Arial Unicode MS,Book Antiqua,Dotum,Georgia", 0, 1252},
    {0x421976c4, "Modern-Regular", "Arial", 2, 1252},
    {0x422a7252, "Stencil", "Arial", 0, 1252},
    {0x42c8554f, "Fixedsys", "Arial", 0, 1252},
    {0x435cb41d, "Roman", "Arial", 0, 1252},
    {0x47882383, "CourierNew", "Arial", 1, 1252},
    {0x480a2338, "BerlinSansFBDemi", "Arial", 0, 1252},
    {0x480bf7a4, "CourierStd", "Courier New,Verdana", 0, 1252},
    {0x481ad6ed, "VladimirScript", "Arial", 8, 1252},
    {0x4911577a, "YouYuan", "Arial", 1, 936},
    {0x4a788d72, "STXingkai", "Arial", 0, 936},
    {0x4bf88566, "SegoeCondensed", "Arial", 0, 1252},
    {0x4ccf51a4, "BerlinSansFB-Reg", "Arial", 0, 1252},
    {0x4ea967ce, "GulimChe", "Arial", 1, 1252},
    {0x4f68bd79, "LetterGothicStd", "Courier New,Verdana", 0, 1252},
    {0x51a0d0e6, "KozukaGothicPr6NM", "Arial", 0, 1252},
    {0x531b3dea, "BasemicSymbol", "Arial", 0, 1252},
    {0x5333fd39, "CalifornianFB-Reg", "Arial", 2, 1252},
    {0x53561a54, "FZYTK--GBK1-0", "Arial", 0, 936},
    {0x55e0dde6, "LucidaSansTypewriter", "Arial", 0, 1252},
    {0x574d4d3d, "AdobeArabic", "Arial Narrow", 0, 1252},
    {0x5792e759, "STKaiti", "Arial", 0, 936},
    {0x5921978e, "LucidaSansUnicode", "Arial", 0, 1252},
    {0x594e2da4, "Vrinda", "Arial", 0, 1252},
    {0x59baa9a2, "KaiTi_GB2312", "Arial", 0, 1252},
    {0x5cfedf4f, "BaskOldFace", "Arial", 0, 1252},
    {0x5f97921c, "AdobeMyungjoStdM",
     "Batang,Bookman Old Style,Consolas,STZhongsong", 0, 936},
    {0x5fefbfad, "Batang", "Arial", 2, 1252},
    {0x605342b9, "DotumChe", "Arial", 1, 1252},
    {0x608c5f9a, "KaiTi_GB2312", "Arial", 0, 936},
    {0x61efd0d1, "MaturaMTScriptCapitals", "Arial", 0, 1252},
    {0x626608a9, "MVBoli", "Arial", 0, 1252},
    {0x630501a3, "SmallFonts", "Arial", 0, 1252},
    {0x65d0e2a9, "FZYTK--GBK1-0", "Arial", 0, 936},
    {0x669f29e1, "FZSTK--GBK1-0", "Arial", 0, 936},
    {0x673a9e5f, "Tunga", "Arial", 0, 1252},
    {0x691aa4ce, "NiagaraSolid", "Arial", 0, 1252},
    {0x696259b7, "Corbel", "Arial", 0, 1252},
    {0x696ee9be, "STXihei", "Arial", 0, 936},
    {0x6c59cf69, "Dotum", "Arial", 0, 1252},
    {0x707fa561, "Gungsuh", "Arial", 2, 1252},
    {0x71416bb2, "ZWAdobeF", "Arial", 0, 1252},
    {0x71b41801, "Verdana", "Arial", 0, 1252},
    {0x73f25e4c, "PalatinoLinotype", "Arial", 0, 1252},
    {0x73f4d19f, "NiagaraEngraved", "Arial", 0, 1252},
    {0x74001694, "MyriadProBlack", "Book Antiqua,Constantia,Dotum,Georgia", 0,
     1252},
    {0x74b14d8f, "Haettenschweiler", "Arial", 0, 1252},
    {0x74cb44ee, "NSimSun", "Arial", 1, 936},
    {0x76b4d7ff, "Shruti", "Arial", 0, 1252},
    {0x788b3533, "Webdings", "Arial", 6, 42},
    {0x797dde99, "MSSerif", "Arial", 0, 1252},
    {0x7a0f9e9e, "MSMincho", "Arial", 1, 1252},
    {0x7b439caf, "OldEnglishTextMT", "Arial", 0, 1252},
    {0x8213a433, "LucidaSans-Typewriter", "Arial", 0, 1252},
    {0x82fec929, "AdobeSongStd",
     "Centaur,Calibri,STSong,Bell MT,Garamond,Times New Roman", 0, 936},
    {0x83581825, "Modern", "Arial", 0, 1252},
    {0x835a2823, "Algerian", "Arial", 0, 1252},
    {0x83dab9f5, "Script", "Arial", 0, 1252},
    {0x847b56da, "Tahoma", "Arial", 0, 1252},
    {0x8a783cb2, "SimSun-PUA", "Arial", 0, 1252},
    {0x8b5cac0e, "Onyx", "Arial", 0, 1252},
    {0x8c6a499e, "Gulim", "Arial", 0, 1252},
    {0x8e0af790, "JuiceITC", "Arial", 0, 1252},
    {0x8e8d43b2, "Centaur", "Arial", 2, 1252},
    {0x8ee4dcca, "BookshelfSymbol7", "Arial", 0, 1252},
    {0x90794800, "BellGothicStdLight", "Bell MT,Calibri,Times New Roman", 0,
     1252},
    {0x909b516a, "Century", "Arial", 2, 1252},
    {0x92ae370d, "MSOutlook", "Arial", 4, 42},
    {0x93c9fbf1, "LucidaFax", "Arial", 2, 1252},
    {0x9565085e, "BookAntiqua", "Arial", 2, 1252},
    {0x9856d95d, "AdobeMingStd", "Arial,Arial Unicode MS,Cambria,BatangChe", 0,
     949},
    {0x9bbadd6b, "ColonnaMT", "Arial", 0, 1252},
    {0x9cbd16a4, "ShowcardGothic-Reg", "Arial", 0, 1252},
    {0x9d73008e, "MSSansSerif", "Arial", 0, 1252},
    {0xa0607db1, "GungsuhChe", "Arial", 1, 1252},
    {0xa0bcf6a1, "LatinWide", "Arial", 2, 1252},
    {0xa1429b36, "Symbol", "Arial", 6, 42},
    {0xa1fa5abc, "Wingdings2", "Arial", 6, 42},
    {0xa1fa5abd, "Wingdings3", "Arial", 6, 42},
    {0xa427bad4, "InformalRoman-Regular", "Arial", 8, 1252},
    {0xa8b92ece, "FZSTK--GBK1-0", "Arial", 0, 936},
    {0xa8d83ece, "CalifornianFB", "Arial", 2, 1252},
    {0xaa3e082c, "Kingsoft-Phonetic", "Arial", 0, 1252},
    {0xaa6bcabe, "HarlowSolidItalic", "Arial", 0, 1252},
    {0xade5337c, "MSUIGothic", "Arial", 0, 1252},
    {0xb08dd941, "WideLatin", "Arial", 2, 1252},
    {0xb207f05d, "PoorRichard", "Arial", 2, 1252},
    {0xb3bc492f, "JuiceITC-Regular", "Arial", 0, 1252},
    {0xb5545399, "Marlett", "Arial", 4, 42},
    {0xb5dd1ebb, "BritannicBold", "Arial", 0, 1252},
    {0xb699c1c5, "LucidaCalligraphy-Italic", "Arial", 0, 1252},
    {0xb725d629, "TimesNewRoman", "Arial", 2, 1252},
    {0xb7eaebeb, "AdobeHeitiStdR", "Batang,Century,Dotum", 0, 936},
    {0xbd29c486, "BerlinSansFBDemi-Bold", "Arial", 0, 1252},
    {0xbe8a8db4, "BookshelfSymbolSeven", "Arial", 0, 1252},
    {0xc16c0118, "AdobeHebrew", "Bell MT,Berlin Sans FB,Calibri", 0, 1252},
    {0xc318b0af, "MyriadProLight", "Calibri,STFangsong,Times New Roman", 0,
     1252},
    {0xc65e5659, "CambriaMath", "Arial", 2, 1252},
    {0xc75c8f05, "LucidaConsole", "Arial", 1, 1252},
    {0xca7c35d6, "Calibri", "Arial", 0, 1252},
    {0xcb053f53, "MicrosoftYaHei", "Arial", 0, 936},
    {0xcb7190f9, "Magneto-Bold", "Arial", 0, 1252},
    {0xcca00cc5, "System", "Arial", 0, 1252},
    {0xccad6f76, "Jokerman-Regular", "Arial", 0, 1252},
    {0xccc5818c, "EuroSign", "Arial", 0, 1252},
    {0xcf3d7234, "LucidaHandwriting-Italic", "Arial", 0, 1252},
    {0xcf7b8fdb, "MinionPro",
     "Bell MT,Corbel,Times New Roman,Cambria,Berlin Sans FB", 0, 1252},
    {0xcfe5755f, "Simhei", "Arial", 1, 936},
    {0xd011f4ee, "MSPGothic", "Arial", 0, 1252},
    {0xd060e7ef, "Vivaldi", "Arial", 8, 1252},
    {0xd07edec1, "FranklinGothic-Medium", "Arial", 0, 1252},
    {0xd107243f, "SimSun", "Arial", 0, 936},
    {0xd1881562, "ArialNarrow", "Arial Narrow", 0, 1252},
    {0xd22b7dce, "BodoniMTPosterCompressed", "Arial", 0, 1252},
    {0xd22bfa60, "ComicSansMS", "Arial", 8, 1252},
    {0xd3bd0e35, "Bauhaus93", "Arial", 0, 1252},
    {0xd429ee7a, "STFangsong", "Arial", 0, 936},
    {0xd6679c12, "BernardMTCondensed", "Arial", 0, 1252},
    {0xd8e8a027, "LucidaSans", "Arial", 0, 1252},
    {0xd9fe7761, "HighTowerText-Reg", "Arial", 2, 1252},
    {0xda7e551e, "STSong", "Arial", 0, 936},
    {0xdaa6842d, "STZhongsong", "Arial", 0, 936},
    {0xdaaab93f, "STFangsong", "Arial", 0, 936},
    {0xdaeb0713, "STSong", "Arial", 0, 936},
    {0xdafedbef, "STCaiyun", "Arial", 0, 936},
    {0xdb00a3d9, "Broadway", "Arial", 0, 1252},
    {0xdb1f5ad4, "STXinwei", "Arial", 0, 936},
    {0xdb326e7f, "STKaiti", "Arial", 0, 936},
    {0xdb69595a, "STHupo", "Arial", 0, 936},
    {0xdba0082c, "STXihei", "Arial", 0, 936},
    {0xdbd0ab18, "STXingkai", "Arial", 0, 936},
    {0xdc1a7db1, "STLiti", "Arial", 0, 936},
    {0xdc33075f, "KristenITC-Regular", "Arial", 8, 1252},
    {0xdcc7009c, "Harrington", "Arial", 0, 1252},
    {0xdd712466, "ArialBlack", "Arial", 0, 1252},
    {0xdde87b3e, "Impact", "Arial", 0, 1252},
    {0xdf69fb32, "SnapITC", "Arial", 0, 1252},
    {0xdf8b25e8, "CenturyGothic", "Arial", 0, 1252},
    {0xe0f705c0, "KristenITC", "Arial", 8, 1252},
    {0xe1427573, "Raavi", "Arial", 0, 1252},
    {0xe2cea0cb, "Magneto", "Arial", 0, 1252},
    {0xe36a9e17, "Ravie", "Arial", 0, 1252},
    {0xe433f8e2, "Parchment", "Arial", 8, 1252},
    {0xe43dff4a, "Wingdings", "Arial", 4, 42},
    {0xe4e2c405, "MTExtra", "Arial", 6, 42},
    {0xe618cc35, "InformalRoman", "Arial", 8, 1252},
    {0xe6c27ffc, "Mistral", "Arial", 8, 1252},
    {0xe7ebf4b9, "Courier", "Courier New", 0, 1252},
    {0xe8bc4a9d, "MSReferenceSpecialty", "Arial", 0, 1252},
    {0xe90fb013, "TempusSansITC", "Arial", 0, 1252},
    {0xec637b42, "Consolas", "Verdana", 1, 1252},
    {0xed3a683b, "STXinwei", "Arial", 0, 936},
    {0xef264cd1, "LucidaHandwriting", "Arial", 0, 1252},
    {0xf086bca2, "BaskervilleOldFace", "Arial", 0, 1252},
    {0xf1028030, "Mangal", "Arial", 2, 1252},
    {0xf1da7eb9, "ShowcardGothic", "Arial", 0, 1252},
    {0xf210f06a, "ArialMT", "Arial", 0, 1252},
    {0xf477f16a, "Latha", "Arial", 0, 1252},
    {0xf616f3dd, "LiSu", "Arial", 1, 936},
    {0xfa479aa6, "MicrosoftYaHei", "Arial", 0, 936},
    {0xfcd19697, "BookmanOldStyle", "Arial", 0, 1252},
    {0xfe209a82, "LucidaCalligraphy", "Arial", 0, 1252},
    {0xfef135f8, "AdobeHeitiStd-Regular", "Batang,Century,Dotum", 0, 936},
};
#elif _FX_PLATFORM_ == _FX_PLATFORM_LINUX_
const FGAS_FontInfo g_XFAFontsMap[] = {
    {0x01d5d33e, "SimSun",
     "WenQuanYi Zen Hei Mono,AR PL UMing CN,AR PL UMing HK,AR PL UMing TW,AR "
     "PL UMing TW MBE",
     0, 936},
    {0x01e4f102, "YouYuan",
     "WenQuanYi Zen Hei Mono,AR PL UMing CN,AR PL UMing HK,AR PL UMing TW,AR "
     "PL UMing TW MBE",
     1, 936},
    {0x030549dc, "LiSu",
     "WenQuanYi Zen Hei,WenQuanYi Zen Hei Sharp,WenQuanYi Zen Hei "
     "Mono,WenQuanYi Micro Hei",
     1, 936},
    {0x032edd44, "Simhei",
     "WenQuanYi Zen Hei,WenQuanYi Zen Hei Sharp,WenQuanYi Zen Hei "
     "Mono,WenQuanYi Micro Hei",
     1, 936},
    {0x03eac6fc, "PoorRichard-Regular", "Droid Sans Japanese,FreeSerif", 2,
     1252},
    {0x03ed90e6, "Nina", "FreeSerif", 0, 1252},
    {0x077b56b3, "KingsoftPhoneticPlain",
     "Tibetan Machine Uni,LKLUG,Samyak Gujarati,Droid Sans Thai,Droid Sans "
     "Armenian,Untitled1,utkal,Lohit Oriya",
     0, 1252},
    {0x078ed524, "MicrosoftSansSerif",
     "Droid Sans Japanese,FreeSerif,WenQuanYi Micro Hei", 0, 1252},
    {0x089b18a9, "Arial",
     "Droid Sans Japanese,DejaVu Sans Condensed,FreeSerif,WenQuanYi Micro Hei",
     0, 1252},
    {0x0b2cad72, "MonotypeCorsiva", "Droid Sans Japanese,FreeSerif", 8, 1252},
    {0x0bb003e7, "Kartika",
     "FreeSans,Liberation Sans,Liberation Sans Narrow,Nimbus Sans "
     "L,Garuda,FreeSerif,WenQuanYi Micro Hei",
     2, 1252},
    {0x0bb469df, "VinerHandITC",
     "Droid Sans Japanese,Ubuntu,Liberation Sans,Liberation Serif", 8, 1252},
    {0x0bc1a851, "SegoeUI", "Droid Sans Japanese,DejaVu Sans", 0, 1252},
    {0x0c112ebd, "KozukaGothicPro-VIM", "FreeSerif", 0, 1252},
    {0x0cfcb9c1, "AdobeThai", "Droid Sans Japanese,Waree", 0, 847},
    {0x0e7de0f9, "Playbill",
     "KacstQurn,Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,Droid "
     "Sans Ethiopic,Droid Sans Japanese,FreeSerif",
     0, 1252},
    {0x0eff47c3, "STHupo", "AR PL UKai HK,AR PL UMing HK,AR PL UKai CN", 0,
     936},
    {0x107ad374, "Constantia",
     "Droid Sans Japanese,FreeSerif,WenQuanYi Micro Hei,Ubuntu", 2, 1252},
    {0x12194c2d, "KunstlerScript", "Droid Sans Japanese,Liberation Serif", 8,
     1252},
    {0x135ef6a1, "MinionProSmBd", "Liberation Serif", 0, 1252},
    {0x158c4049, "Garamond",
     "Droid Sans Japanese,Liberation Serif,Ubuntu,FreeSerif", 2, 1252},
    {0x160ecb24, "STZhongsong",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 936},
    {0x161ed07e, "MSGothic",
     "WenQuanYi Micro Hei Mono,WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,AR PL "
     "UMing CN,AR PL UMing HK,AR PL UMing TW",
     1, 1252},
    {0x171d1ed1, "SnapITC-Regular",
     "Liberation Sans Narrow,Ubuntu Condensed,Nimbus Sans L,DejaVu Sans", 0,
     1252},
    {0x18d1188f, "Cambria", "Droid Sans Japanese,FreeSerif,FreeMono", 2, 1252},
    {0x18eaf350, "ArialUnicodeMS",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 936},
    {0x1a92d115, "MingLiU",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     1, 1252},
    {0x1cc217c6, "TrebuchetMS",
     "Droid Sans Japanese,Liberation Serif,FreeSerif,Ubuntu", 0, 1252},
    {0x1d649596, "BasemicTimes",
     "Liberation Serif,Times New Roman,Droid Sans Japanese,FreeSerif,Ubuntu", 0,
     1252},
    {0x1e34ee60, "BellMT",
     "KacstQurn,Droid Sans Japanese,Ubuntu,Liberation Serif", 2, 1252},
    {0x1eb36945, "CooperBlack",
     "KacstQurn,Droid Sans Japanese,FreeMono,Liberation Mono, WenQuanYi Micro "
     "Hei Mono",
     2, 1252},
    {0x1ef7787d, "BatangChe",
     "WenQuanYi Zen Hei Mono,AR PL UMing CN,AR PL UMing HK,AR PL UMing "
     "TW,WenQuanYi Zen Hei,WenQuanYi Micro Hei",
     1, 1252},
    {0x20b3bd3a, "BrushScriptMT",
     "KacstQurn,Droid Arabic Naskh,Droid Sans Ethiopic,Droid Sans "
     "Japanese,URW Chancery L,Liberation Sans",
     8, 1252},
    {0x220877aa, "Candara", "Droid Sans Japanese,DejaVu Sans", 0, 1252},
    {0x22135007, "FreestyleScript-Regular",
     "KacstQurn,Droid Sans Japanese,Liberation Sans", 8, 1252},
    {0x251059c3, "Chiller",
     "KacstQurn,Droid Arabic Naskh,Droid Sans Ethiopic,Droid Sans "
     "Japanese,Liberation Sans",
     0, 1252},
    {0x25bed6dd, "MSReferenceSansSerif",
     "DejaVu Sans Condensed,Ubuntu Condensed,Droid Sans Japanese,AR PL UKai "
     "HK",
     0, 1252},
    {0x28154c81, "Parchment-Regular", "Droid Sans Japanese,Liberation Sans", 8,
     1252},
    {0x29711eb9, "STLiti", "AR PL UKai HK", 0, 936},
    {0x2b1993b4, "Basemic",
     "Liberation Serif,Droid Sans Japanese,Liberation Sans", 0, 1252},
    {0x2b316339, "NiagaraSolid-Reg", "Droid Sans Japanese,Liberation Sans", 0,
     1252},
    {0x2c147529, "FootlightMTLight",
     "KacstQurn,Droid Sans Japanese,Liberation Sans", 0, 1252},
    {0x2c198928, "HarlowSolid", "KacstQurn,Droid Sans Japanese,Liberation Sans",
     0, 1252},
    {0x2c6ac6b2, "LucidaBright",
     "KacstQurn,Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,Droid "
     "Sans Japanese,Liberation Sans",
     2, 1252},
    {0x2c9f38e2, "KozukaMinchoPro-VIR", "DejaVu Sans", 0, 1252},
    {0x2d5a47b0, "STCaiyun", "AR PL UKai HK", 0, 936},
    {0x2def26bf, "BernardMT-Condensed",
     "KacstQurn,Droid Sans Japanese,DejaVu Serif", 0, 1252},
    {0x2fd8930b, "KozukaMinchoPr6NR", "DejaVu Serif", 0, 1252},
    {0x3115525a, "FangSong_GB2312",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 1252},
    {0x31327817, "MyriadPro", "Ubuntu Condensed,Droid Sans Japanese, FreeSerif",
     0, 1252},
    {0x32244975, "Helvetica",
     "Ubuntu,DejaVu Sans Condensed,Liberation Sans,Liberation Sans "
     "Narrow,Nimbus Sans ",
     0, 1252},
    {0x32ac995c, "Terminal", "DejaVu Serif", 0, 1252},
    {0x338d648a, "NiagaraEngraved-Reg", "Droid Sans Japanese,DejaVu Serif", 0,
     1252},
    {0x33bb65f2, "Sylfaen", "Droid Sans Japanese,DejaVu Sans", 2, 1252},
    {0x3402c30e, "MSPMincho",
     "WenQuanYi Zen Hei Mono,AR PL UMing CN,AR PL UMing HK,AR PL UMing TW", 2,
     1252},
    {0x3412bf31, "SimSun-PUA",
     "WenQuanYi Zen Hei Mono,AR PL UMing CN,AR PL UMing CN,AR PL UMing HK", 0,
     936},
    {0x36eb39b9, "BerlinSansFB",
     "Droid Sans Japanese,Liberation Serif,Ubuntu,FreeSerif", 0, 1252},
    {0x36f42055, "UniversATT", "Microsoft Sans Serif", 0, 1252},
    {0x3864c4f6, "HighTowerText", "Droid Sans Japanese,DejaVu Serif", 2, 1252},
    {0x3a257d03, "FangSong_GB2312", "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei",
     0, 1252},
    {0x3c7d1d07, "Garamond3LTStd",
     "Droid Sans Japanese,Ubuntu Condensed,DejaVu Sans Condensed,Liberation "
     "Serif,Ubuntu,FreeSerif",
     2, 1252},
    {0x3cdae668, "FreestyleScript", "KacstQurn,Droid Sans Japanese,DejaVu Sans",
     8, 1252},
    {0x3d55aed7, "Jokerman", "Droid Sans Japanese,DejaVu Sans", 0, 1252},
    {0x3d5b4385, "PMingLiU",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     2, 1252},
    {0x3d9b7669, "EstrangeloEdessa", "Droid Sans Japanese,DejaVu Sans", 0,
     1252},
    {0x3e532d74, "FranklinGothicMedium", "Droid Sans Japanese,Ubuntu", 0, 1252},
    {0x3e6aa32d, "NSimSun",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     1, 936},
    {0x3f6c36a8, "Gautami",
     "Droid Arabic Naskh,Droid Sans Ethiopic, mry_KacstQurn,Droid Sans "
     "Japanese,FreeSans",
     0, 1252},
    {0x3ff32662, "Chiller-Regular",
     "KacstQurn,Droid Arabic Naskh,Droid Sans Ethiopic,FreeSans", 0, 1252},
    {0x409de312, "ModernNo.20",
     "KacstQurn,Droid Sans Japanese,Nimbus Sans L,Nimbus Sans L,FreeSans", 2,
     1252},
    {0x41443c5e, "Georgia", "Droid Sans Japanese,FreeSans", 2, 1252},
    {0x4160ade5, "BellGothicStdBlack", "FreeSans", 0, 1252},
    {0x421976c4, "Modern-Regular", "FreeSans", 2, 1252},
    {0x422a7252, "Stencil", "Droid Sans Japanese,FreeSans,Liberation Sans", 0,
     1252},
    {0x42c8554f, "Fixedsys", "FreeSerif", 0, 1252},
    {0x435cb41d, "Roman", "FreeSerif", 0, 1252},
    {0x47882383, "CourierNew",
     "FreeMono,WenQuanYi Micro Hei Mono,AR PL UKai CN,AR PL UKai HK,AR PL "
     "UKai TW,AR PL UKai TW MBE,DejaVu Sans",
     1, 1252},
    {0x480a2338, "BerlinSansFBDemi", "Droid Sans Japanese,Liberation Serif", 0,
     1252},
    {0x480bf7a4, "CourierStd", "DejaVu Sans", 0, 1252},
    {0x481ad6ed, "VladimirScript", "Droid Sans Japanese,DejaVu Serif", 8, 1252},
    {0x4911577a, "YouYuan",
     "WenQuanYi Zen Hei Mono,AR PL UMing CN,AR PL UMing HK,AR PL UMing TW", 1,
     936},
    {0x4a788d72, "STXingkai", "AR PL UKai HK,AR PL UMing HK,AR PL UKai CN", 0,
     936},
    {0x4bf88566, "SegoeCondensed", "FreeSerif", 0, 1252},
    {0x4ccf51a4, "BerlinSansFB-Reg", "Droid Sans Japanese,Liberation Serif", 0,
     1252},
    {0x4ea967ce, "GulimChe",
     "WenQuanYi Zen Hei Mono,AR PL UKai CN,AR PL UKai HK,AR PL UKai TW,AR PL "
     "UKai TW MBE",
     1, 1252},
    {0x4f68bd79, "LetterGothicStd",
     "FreeMono,Liberation Mono,Andale Mono,WenQuanYi Micro Hei Mono", 0, 1252},
    {0x51a0d0e6, "KozukaGothicPr6NM", "FreeSerif", 0, 1252},
    {0x531b3dea, "BasemicSymbol", "FreeSerif", 0, 1252},
    {0x5333fd39, "CalifornianFB-Reg",
     "Droid Sans Japanese,URW Chancery L,FreeSerif", 2, 1252},
    {0x53561a54, "FZYTK--GBK1-0",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 936},
    {0x55e0dde6, "LucidaSansTypewriter",
     "Ubuntu Mono,DejaVu Sans Mono,Nimbus Mono L,Liberation Mono,Courier 10 "
     "Pitch,FreeMono",
     0, 1252},
    {0x574d4d3d, "AdobeArabic", "Droid Sans Japanese,DejaVu Sans", 0, 1252},
    {0x5792e759, "STKaiti", "WenQuanYi Micro Hei Mono", 0, 936},
    {0x5921978e, "LucidaSansUnicode", "Droid Sans Japanese,DejaVu Sans", 0,
     1252},
    {0x594e2da4, "Vrinda",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Arabic "
     "Naskh,mry_KacstQurn,Droid Sans Japanese,FreeSans,FreeSerif",
     0, 1252},
    {0x59baa9a2, "KaiTi_GB2312",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 1252},
    {0x5cfedf4f, "BaskOldFace",
     "KacstQurn,Droid Sans Japanese,Ubuntu,Liberation Serif", 0, 1252},
    {0x5e16ac91, "TrajanPro",
     "Nimbus Sans L,AR PL UMing HK,AR PL UKai HK,AR PL UMing TW,AR PL UMing "
     "TW MBE,DejaVu Sans,DejaVu Serif",
     0, 1252},
    {0x5f388196, "ITCLegacySansStdMedium",
     "Liberation Serif,FreeSerif,FreeSans,Ubuntu", 0, 1252},
    {0x5f97921c, "AdobeMyungjoStdM",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 936},
    {0x5fefbfad, "Batang",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     2, 1252},
    {0x605342b9, "DotumChe",
     "WenQuanYi Zen Hei Mono,AR PL UMing CN,AR PL UMing HK,AR PL UMing TW", 1,
     1252},
    {0x608c5f9a, "KaiTi_GB2312",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 936},
    {0x61efd0d1, "MaturaMTScriptCapitals",
     "KacstQurn,Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,Droid "
     "Sans Japanese,DejaVu Serif,DejaVu Sans",
     0, 1252},
    {0x626608a9, "MVBoli",
     "Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,Droid Sans "
     "Ethiopic,Droid Sans Japanese,DejaVu Sans",
     0, 1252},
    {0x630501a3, "SmallFonts", "DejaVu Serif", 0, 1252},
    {0x65d0e2a9, "FZYTK--GBK1-0",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 936},
    {0x669f29e1, "FZSTK--GBK1-0",
     "AR PL UMing CN,AR PL UKai CN, AR PL UMing HK", 0, 936},
    {0x673a9e5f, "Tunga",
     "Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,Droid Sans "
     "Japanese,DejaVu Serif",
     0, 1252},
    {0x691aa4ce, "NiagaraSolid", "Droid Sans Japanese,DejaVu Serif", 0, 1252},
    {0x696259b7, "Corbel", "Droid Sans Japanese,DejaVu Sans", 0, 1252},
    {0x696ee9be, "STXihei", "WenQuanYi Micro Hei Mono", 0, 936},
    {0x6c59cf69, "Dotum", "WenQuanYi Zen Hei Mono", 0, 1252},
    {0x707fa561, "Gungsuh", "WenQuanYi Zen Hei Mono", 2, 1252},
    {0x71416bb2, "ZWAdobeF",
     "KacstArt,KacstBookm,KacstDecorative,KacstDigital,KacstFarsi,KacstLetter,"
     "KacstOffice,Dingbats,FreeSerif",
     0, 1252},
    {0x71b41801, "Verdana",
     "DejaVu Sans Condensed,Ubuntu Condensed,Droid Sans Japanese,DejaVu Sans",
     0, 1252},
    {0x73f25e4c, "PalatinoLinotype", "Droid Sans Japanese,FreeSerif", 0, 1252},
    {0x73f4d19f, "NiagaraEngraved", "Droid Sans Japanese,FreeSerif", 0, 1252},
    {0x74001694, "MyriadProBlack", "Droid Sans Japanese,AR PL UKai HK", 0,
     1252},
    {0x74b14d8f, "Haettenschweiler", "Droid Sans Japanese,DejaVu Serif", 0,
     1252},
    {0x74cb44ee, "NSimSun", "WenQuanYi Zen Hei Mono", 1, 936},
    {0x76b4d7ff, "Shruti",
     "Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,Droid Sans "
     "Japanese,FreeSans",
     0, 1252},
    {0x788b3533, "Webdings", "FreeSans", 6, 42},
    {0x797dde99, "MSSerif", "FreeSans", 0, 1252},
    {0x7a0f9e9e, "MSMincho",
     "WenQuanYi Micro Hei Mono,AR PL UMing CN,AR PL UMing HK,AR PL UMing TW", 1,
     1252},
    {0x7b439caf, "OldEnglishTextMT",
     "Droid Sans Japanese,Liberation Sans,Ubuntu", 0, 1252},
    {0x8213a433, "LucidaSans-Typewriter",
     "Ubuntu Mono,Liberation Mono,DejaVu Sans Mono", 0, 1252},
    {0x82fec929, "AdobeSongStd",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 936},
    {0x83581825, "Modern", "FreeSans", 0, 1252},
    {0x835a2823, "Algerian",
     "KacstQurn,Droid Sans Japanese,FreeSans,Liberation Sans,Ubuntu", 0, 1252},
    {0x83dab9f5, "Script", "FreeSans", 0, 1252},
    {0x847b56da, "Tahoma",
     "Droid Sans Japanese,DejaVu Sans Condensed,FreeSerif", 0, 1252},
    {0x8a783cb2, "SimSun-PUA",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 1252},
    {0x8b5cac0e, "Onyx", "Droid Sans Japanese,Liberation Sans", 0, 1252},
    {0x8c6a499e, "Gulim",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 1252},
    {0x8e0af790, "JuiceITC", "Droid Sans Japanese,Liberation Sans", 0, 1252},
    {0x8e8d43b2, "Centaur",
     "KacstQurn,Droid Sans Japanese,Khmer OS,Khmer OS System", 2, 1252},
    {0x8ee4dcca, "BookshelfSymbol7", "Liberation Sans", 0, 1252},
    {0x90794800, "BellGothicStdLight", "Liberation Sans", 0, 1252},
    {0x909b516a, "Century",
     "Droid Sans Japanese,Liberation Sans,Liberation Mono,Liberation Serif", 2,
     1252},
    {0x92ae370d, "MSOutlook", "Liberation Sans", 4, 42},
    {0x93c9fbf1, "LucidaFax",
     "KacstQurn,Droid Arabic Naskh,Droid Sans "
     "Ethiopic,mry_KacstQurn,Liberation Sans",
     2, 1252},
    {0x9565085e, "BookAntiqua",
     "Droid Sans Japanese,Liberation Sans,Liberation Serif", 2, 1252},
    {0x9856d95d, "AdobeMingStd", "AR PL UMing HK", 0, 949},
    {0x9bbadd6b, "ColonnaMT",
     "KacstQurn,Droid Sans Japanese,Khmer OS,Khmer OS System", 0, 1252},
    {0x9cbd16a4, "ShowcardGothic-Reg",
     "Droid Sans Japanese,Liberation Sans,Ubuntu", 0, 1252},
    {0x9d73008e, "MSSansSerif", "FreeSerif", 0, 1252},
    {0xa0607db1, "GungsuhChe",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     1, 1252},
    {0xa0bcf6a1, "LatinWide", "FreeSerif", 2, 1252},
    {0xa1429b36, "Symbol", "FreeSerif", 6, 42},
    {0xa1fa5abc, "Wingdings2", "FreeSerif", 6, 42},
    {0xa1fa5abd, "Wingdings3", "FreeSerif", 6, 42},
    {0xa427bad4, "InformalRoman-Regular",
     "Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,Droid Sans "
     "Japanese,FreeSerif",
     8, 1252},
    {0xa8b92ece, "FZSTK--GBK1-0", "AR PL UMing CN", 0, 936},
    {0xa8d83ece, "CalifornianFB", "Droid Sans Japanese,FreeSerif", 2, 1252},
    {0xaa3e082c, "Kingsoft-Phonetic",
     "Tibetan Machine Uni,LKLUG,Samyak Gujarati,Droid Sans "
     "Thai,utkal,Kedage,Mallige,AR PL UKai CN",
     0, 1252},
    {0xaa6bcabe, "HarlowSolidItalic",
     "KacstQurn,Droid Sans Japanese,Liberation Serif", 0, 1252},
    {0xade5337c, "MSUIGothic",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 1252},
    {0xb08dd941, "WideLatin",
     "KacstQurn,Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,Droid "
     "Sans Japanese,Liberation Serif",
     2, 1252},
    {0xb12765e0, "ITCLegacySansStdBook",
     "AR PL UMing HK,AR PL UKai HK,FreeSerif,Ubuntu,FreeSans", 0, 1252},
    {0xb207f05d, "PoorRichard", "Droid Sans Japanese,Liberation Serif", 2,
     1252},
    {0xb3bc492f, "JuiceITC-Regular", "Droid Sans Japanese,Liberation Serif", 0,
     1252},
    {0xb5545399, "Marlett", "Liberation Serif", 4, 42},
    {0xb5dd1ebb, "BritannicBold",
     "KacstQurn,Droid Arabic Naskh,Droid Sans "
     "Ethiopic,mry_KacstQurn,Liberation Serif",
     0, 1252},
    {0xb699c1c5, "LucidaCalligraphy-Italic",
     "KacstQurn,Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,Droid "
     "Sans Japanese,DejaVu Serif",
     0, 1252},
    {0xb725d629, "TimesNewRoman", "Droid Sans Japanese,Liberation Sans", 2,
     1252},
    {0xb7eaebeb, "AdobeHeitiStdR",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 936},
    {0xbd29c486, "BerlinSansFBDemi-Bold", "Droid Sans Japanese,DejaVu Serif", 0,
     1252},
    {0xbe8a8db4, "BookshelfSymbolSeven", "DejaVu Sans", 0, 1252},
    {0xc16c0118, "AdobeHebrew", "Droid Sans Japanese,Ubuntu,Liberation Serif",
     0, 1252},
    {0xc318b0af, "MyriadProLight",
     "Droid Sans Japanese,AR PL UKai HK,AR PL UMing HK,AR PL UKai CN", 0, 1252},
    {0xc65e5659, "CambriaMath", "Droid Sans Japanese,FreeSerif,FreeMono", 2,
     1252},
    {0xc75c8f05, "LucidaConsole",
     "Liberation Mono,DejaVu Sans Mono,FreeMono,WenQuanYi Micro Hei Mono", 1,
     1252},
    {0xca7c35d6, "Calibri", "Droid Sans Japanese,DejaVu Sans", 0, 1252},
    {0xcb053f53, "MicrosoftYaHei",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 936},
    {0xcb7190f9, "Magneto-Bold",
     "Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,Droid Sans "
     "Japanese,DejaVu Serif",
     0, 1252},
    {0xcca00cc5, "System", "DejaVu Sans", 0, 1252},
    {0xccad6f76, "Jokerman-Regular", "Droid Sans Japanese,DejaVu Sans", 0,
     1252},
    {0xccc5818c, "EuroSign", "DejaVu Serif", 0, 1252},
    {0xcf3d7234, "LucidaHandwriting-Italic",
     "Liberation Sans Narrow,Ubuntu Condensed,Nimbus Sans L,DejaVu Serif", 0,
     1252},
    {0xcf7b8fdb, "MinionPro", "DejaVu Sans", 0, 1252},
    {0xcfe5755f, "Simhei",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     1, 936},
    {0xd011f4ee, "MSPGothic",
     "WenQuanYi Zen Hei Mono,AR PL UMing CN,AR PL UMing HK,AR PL UMing TW", 0,
     1252},
    {0xd060e7ef, "Vivaldi",
     "KacstQurn,Droid Sans Japanese,Liberation Sans,Ubuntu", 8, 1252},
    {0xd07edec1, "FranklinGothic-Medium", "Droid Sans Japanese,Ubuntu", 0,
     1252},
    {0xd107243f, "SimSun", "WenQuanYi Zen Hei Mono", 0, 936},
    {0xd1881562, "ArialNarrow",
     "Liberation Sans Narrow,Droid Sans Japanese,FreeSerif", 0, 1252},
    {0xd22b7dce, "BodoniMTPosterCompressed", "Droid Sans Japanese,DejaVu Serif",
     0, 1252},
    {0xd22bfa60, "ComicSansMS", "Droid Sans Japanese,FreeMono,Liberation Mono",
     8, 1252},
    {0xd3bd0e35, "Bauhaus93",
     "KacstQurn,Droid Sans Japanese,Liberation Sans,Ubuntu", 0, 1252},
    {0xd429ee7a, "STFangsong", "WenQuanYi Micro Hei Mono", 0, 936},
    {0xd6679c12, "BernardMTCondensed",
     "KacstQurn,Droid Sans Japanese,Nimbus Sans L,URW Chancery "
     "L,KacstOne,Liberation Sans",
     0, 1252},
    {0xd8e8a027, "LucidaSans",
     "Liberation Sans Narrow,Nimbus Sans L,KacstQurn,Droid Arabic Naskh,Droid "
     "Sans Ethiopic,DejaVu Serif Condensed,Liberation Mono,Ubuntu",
     0, 1252},
    {0xd9fe7761, "HighTowerText-Reg",
     "Droid Sans Japanese,Ubuntu,Liberation Serif", 2, 1252},
    {0xda7e551e, "STSong", "WenQuanYi Micro Hei Mono", 0, 936},
    {0xdaa6842d, "STZhongsong",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 936},
    {0xdaaab93f, "STFangsong",
     "WenQuanYi Micro Hei Mono,WenQuanYi Zen Hei Mono,WenQuanYi Zen "
     "Hei,WenQuanYi Zen Hei Sharp",
     0, 936},
    {0xdaeb0713, "STSong",
     "WenQuanYi Micro Hei Mono,WenQuanYi Zen Hei Mono,WenQuanYi Zen "
     "Hei,WenQuanYi Zen Hei Sharp",
     0, 936},
    {0xdafedbef, "STCaiyun", "AR PL UKai HK,AR PL UMing HK,AR PL UKai CN", 0,
     936},
    {0xdb00a3d9, "Broadway",
     "KacstQurn,Droid Sans Japanese,DejaVu Sans,FreeMono,Liberation Mono", 0,
     1252},
    {0xdb1f5ad4, "STXinwei", "AR PL UKai HK,AR PL UMing HK,AR PL UKai CN", 0,
     936},
    {0xdb326e7f, "STKaiti",
     "WenQuanYi Micro Hei Mono,WenQuanYi Zen Hei Mono,WenQuanYi Zen "
     "Hei,WenQuanYi Zen Hei Sharp",
     0, 936},
    {0xdb69595a, "STHupo",
     "WenQuanYi Micro Hei Mono,WenQuanYi Zen Hei Mono,WenQuanYi Zen "
     "Hei,WenQuanYi Zen Hei Sharp",
     0, 936},
    {0xdba0082c, "STXihei",
     " WenQuanYi Micro Hei Mono,WenQuanYi Zen Hei Mono,WenQuanYi Zen "
     "Hei,WenQuanYi Zen Hei Sharp",
     0, 936},
    {0xdbd0ab18, "STXingkai", "AR PL UKai HK,AR PL UMing HK,AR PL UKai CN", 0,
     936},
    {0xdc1a7db1, "STLiti", "AR PL UKai HK,AR PL UMing HK,AR PL UKai CN", 0,
     936},
    {0xdc33075f, "KristenITC-Regular",
     "Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,DejaVu Sans "
     "Condensed,Ubuntu,Liberation Sans",
     8, 1252},
    {0xdcc7009c, "Harrington",
     "KacstQurn,Droid Sans Japanese,Liberation Serif,FreeSerif,Ubuntu", 0,
     1252},
    {0xdd712466, "ArialBlack",
     "Droid Sans Japanese,DejaVu Sans,DejaVu Serif,FreeMono", 0, 1252},
    {0xdde87b3e, "Impact", "Droid Sans Japanese,DejaVu Serif", 0, 1252},
    {0xdf69fb32, "SnapITC",
     "Liberation Sans Narrow,Ubuntu Condensed,DejaVu Sans,DejaVu "
     "Serif,FreeMono",
     0, 1252},
    {0xdf8b25e8, "CenturyGothic",
     "Droid Sans Japanese,Liberation Mono,Liberation Sans,Liberation Serif", 0,
     1252},
    {0xe0f705c0, "KristenITC",
     "Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,DejaVu Sans "
     "Condensed,Ubuntu,Liberation Sans",
     8, 1252},
    {0xe1427573, "Raavi",
     "Droid Arabic Naskh,Droid Sans "
     "Ethiopic,mry_KacstQurn,FreeSerif,Liberation Serif,Khmer OS",
     0, 1252},
    {0xe2cea0cb, "Magneto",
     "Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,DejaVu "
     "Serif,DejaVu Serif Condensed,DejaVu Sans",
     0, 1252},
    {0xe36a9e17, "Ravie",
     "Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,DejaVu "
     "Serif,DejaVu Sans,FreeMono",
     0, 1252},
    {0xe433f8e2, "Parchment", "Droid Sans Japanese,DejaVu Serif", 8, 1252},
    {0xe43dff4a, "Wingdings", "DejaVu Serif", 4, 42},
    {0xe4e2c405, "MTExtra", "DejaVu Serif", 6, 42},
    {0xe618cc35, "InformalRoman",
     "Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,Droid Sans "
     "Japanese,Nimbus Sans L,DejaVu Sans Condensed,Ubuntu,Liberation Sans",
     8, 1252},
    {0xe6c27ffc, "Mistral", "Droid Sans Japanese,DejaVu Serif", 8, 1252},
    {0xe7ebf4b9, "Courier", "DejaVu Sans,DejaVu Sans Condensed,FreeSerif", 0,
     1252},
    {0xe8bc4a9d, "MSReferenceSpecialty", "DejaVu Serif", 0, 1252},
    {0xe90fb013, "TempusSansITC",
     "Droid Sans Japanese,Ubuntu,Liberation Serif,FreeSerif", 0, 1252},
    {0xec637b42, "Consolas",
     "DejaVu Sans Condensed,AR PL UKai CN,AR PL UKai HK,AR PL UKai "
     "TW,FreeSerif,FreeSans",
     1, 1252},
    {0xed3a683b, "STXinwei", "AR PL UKai HK,AR PL UMing HK,AR PL UKai CN", 0,
     936},
    {0xef264cd1, "LucidaHandwriting",
     "Liberation Sans Narrow,Ubuntu Condensed,Nimbus Sans "
     "L,KacstQurn,Liberation Mono",
     0, 1252},
    {0xf086bca2, "BaskervilleOldFace",
     "KacstQurn,Droid Sans Japanese,Liberation Serif,Ubuntu,FreeSerif", 0,
     1252},
    {0xf1028030, "Mangal",
     "FreeSans,TSCu_Paranar,Garuda,Liberation Sans,Liberation Sans "
     "Narrow,Nimbus Sans ",
     2, 1252},
    {0xf1da7eb9, "ShowcardGothic",
     "Droid Sans Japanese,DejaVu Serif Condensed,DejaVu Sans "
     "Condensed,Liberation Sans,Ubuntu",
     0, 1252},
    {0xf210f06a, "ArialMT",
     "Liberation Sans,Liberation Sans Narrow,FreeSans,Nimbus Sans L,Khmer OS "
     "System,Khmer OS",
     0, 1252},
    {0xf477f16a, "Latha",
     "Liberation Sans Narrow,Nimbus Sans L,Droid Arabic "
     "Naskh,mry_KacstQurn,FreeSerif,Nimbus Sans ",
     0, 1252},
    {0xf616f3dd, "LiSu",
     "WenQuanYi Zen Hei Mono,AR PL UMing CN,AR PL UMing HK,AR PL UMing TW,AR "
     "PL UMing TW MBE",
     1, 936},
    {0xfa479aa6, "MicrosoftYaHei",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 936},
    {0xfcd19697, "BookmanOldStyle",
     "Droid Sans Japanese,Liberation Mono,Liberation Sans,Liberation Serif", 0,
     1252},
    {0xfe209a82, "LucidaCalligraphy",
     "KacstQurn,Droid Arabic Naskh,Droid Sans Ethiopic,mry_KacstQurn,Droid "
     "Sans Japanese,DejaVu Serif,DejaVu Sans,FreeMono",
     0, 1252},
    {0xfef135f8, "AdobeHeitiStd-Regular",
     "WenQuanYi Zen Hei Mono,WenQuanYi Zen Hei,WenQuanYi Zen Hei "
     "Sharp,WenQuanYi Micro Hei",
     0, 936},
};
#elif defined(OS_MACOSX)
const FGAS_FontInfo g_XFAFontsMap[] = {
    {0x01d5d33e, "SimSun", "STHeiti,Heiti TC,STFangsong", 0, 936},
    {0x01e4f102, "YouYuan", "STHeiti,Heiti TC,STFangsong", 1, 936},
    {0x030549dc, "LiSu", "STHeiti,Heiti TC,STFangsong", 1, 936},
    {0x032edd44, "Simhei", "STHeiti,Heiti TC,STFangsong", 1, 936},
    {0x03eac6fc, "PoorRichard-Regular",
     "Noteworthy,Avenir Next Condensed,Impact", 2, 1252},
    {0x03ed90e6, "Nina", "Microsoft Sans Serif", 0, 1252},
    {0x077b56b3, "KingsoftPhoneticPlain",
     "LastResort,Apple "
     "Chancery,STIXVariants,STIXSizeOneSym,STIXSizeOneSym,Apple Braille",
     0, 1252},
    {0x078ed524, "MicrosoftSansSerif", "Songti SC,Apple Symbols", 0, 1252},
    {0x089b18a9, "Arial", "Arial Unicode MS,Microsoft Sans Serif,Apple Symbols",
     0, 1252},
    {0x0b2cad72, "MonotypeCorsiva", "Arial Narrow,Impact", 8, 1252},
    {0x0bb003e7, "Kartika",
     "Arial Unicode MS,Microsoft Sans Serif,Arial Narrow,Damascus", 2, 1252},
    {0x0bb469df, "VinerHandITC", "Comic Sans MS,Songti SC,STSong", 8, 1252},
    {0x0bc1a851, "SegoeUI", "Apple Symbols", 0, 1252},
    {0x0c112ebd, "KozukaGothicPro-VIM", "Microsoft Sans Serif,Apple Symbols", 0,
     1252},
    {0x0cfcb9c1, "AdobeThai", "Avenir Next Condensed Ultra Light", 0, 847},
    {0x0e7de0f9, "Playbill", "STIXNonUnicode", 0, 1252},
    {0x0eff47c3, "STHupo", "Kaiti SC,Songti SC,STHeiti", 0, 936},
    {0x107ad374, "Constantia", "Arial Unicode MS,Palatino,Baskerville", 2,
     1252},
    {0x12194c2d, "KunstlerScript",
     "Avenir Next Condensed Demi Bold,Arial Narrow", 8, 1252},
    {0x135ef6a1, "MinionProSmBd", "Microsoft Sans Serif,Apple Symbols", 0,
     1252},
    {0x158c4049, "Garamond", "Impact,Arial Narrow", 2, 1252},
    {0x160ecb24, "STZhongsong", "STFangsong,Songti SC", 0, 936},
    {0x161ed07e, "MSGothic",
     "WenQuanYi Zen Hei Mono,AR PL UMing CN,AR PL UMing HK,AR PL UMing "
     "TW,Microsoft Sans Serif,Apple Symbols",
     1, 1252},
    {0x171d1ed1, "SnapITC-Regular", "STHeiti,Arial Black", 0, 1252},
    {0x18d1188f, "Cambria", "Arial Unicode MS", 2, 1252},
    {0x18eaf350, "ArialUnicodeMS", "Microsoft Sans Serif,Apple Symbols", 0,
     936},
    {0x1a92d115, "MingLiU", "Heiti SC,STHeiti", 1, 1252},
    {0x1cc217c6, "TrebuchetMS", "Damascus,Impact,Arial Narrow", 0, 1252},
    {0x1d649596, "BasemicTimes", "Liberation Serif,Impact,Arial Narrow", 0,
     1252},
    {0x1e34ee60, "BellMT",
     "Papyrus,STIXNonUnicode,Microsoft Sans Serif,Avenir Light", 2, 1252},
    {0x1eb36945, "CooperBlack",
     "Marion,STIXNonUnicode,Arial Rounded MT Bold,Lucida Grande", 2, 1252},
    {0x1ef7787d, "BatangChe",
     "WenQuanYi Zen Hei Mono,AR PL UMing CN,,AR PL UMing HK,AR PL UMing TW,AR "
     "PL UMing TW MBE,Arial Unicode MS,Heiti TC",
     1, 1252},
    {0x20b3bd3a, "BrushScriptMT",
     "STIXNonUnicode,Damascus,Arial Narrow,Avenir Next Condensed,Cochin", 8,
     1252},
    {0x220877aa, "Candara", "Cochin,Baskerville,Marion", 0, 1252},
    {0x22135007, "FreestyleScript-Regular",
     "STIXNonUnicode,Nadeem,Zapf Dingbats", 8, 1252},
    {0x251059c3, "Chiller",
     "Zapf Dingbats,Damascus,STIXNonUnicode,Papyrus,KufiStandardGK,Baghdad", 0,
     1252},
    {0x25bed6dd, "MSReferenceSansSerif",
     "Tahoma,Apple Symbols,Apple LiGothic,Arial Unicode MS,Lucida "
     "Grande,Microsoft Sans Serif",
     0, 1252},
    {0x28154c81, "Parchment-Regular", "Microsoft Sans Serif,Apple Symbols", 8,
     1252},
    {0x29711eb9, "STLiti", "Kaiti SC,Songti SC", 0, 936},
    {0x2b1993b4, "Basemic", "Impact,Arial Narrow", 0, 1252},
    {0x2b316339, "NiagaraSolid-Reg", "Microsoft Sans Serif,Apple Symbols", 0,
     1252},
    {0x2c147529, "FootlightMTLight",
     "STIXNonUnicode,Avenir Next Condensed Heavy,PT Sans,Noteworthy", 0, 1252},
    {0x2c198928, "HarlowSolid",
     "Avenir Medium,Avenir Next Medium,Arial Unicode MS", 0, 1252},
    {0x2c6ac6b2, "LucidaBright",
     "PT Sans Narrow,Papyrus,Damascus,STIXNonUnicode,Arial Rounded MT "
     "Bold,Comic Sans MS,Avenir Next",
     2, 1252},
    {0x2c9f38e2, "KozukaMinchoPro-VIR", "Microsoft Sans Serif,Apple Symbols", 0,
     1252},
    {0x2d5a47b0, "STCaiyun", "Kaiti SC,Songti SC", 0, 936},
    {0x2def26bf, "BernardMT-Condensed",
     "Impact,Avenir Next Condensed Demi Bold,American Typewriter", 0, 1252},
    {0x2fd8930b, "KozukaMinchoPr6NR", "Microsoft Sans Serif,Apple Symbols", 0,
     1252},
    {0x3115525a, "FangSong_GB2312", "Hiragino Sans GB,STHeiti", 0, 1252},
    {0x31327817, "MyriadPro", "Microsoft Sans Serif,Apple Symbols", 0, 1252},
    {0x32244975, "Helvetica",
     "Arial Narrow,Arial Unicode MS,Damascus,STIXNonUnicode", 0, 1252},
    {0x32ac995c, "Terminal", "Microsoft Sans Serif,Apple Symbols", 0, 1252},
    {0x338d648a, "NiagaraEngraved-Reg", "Microsoft Sans Serif,Apple Symbols", 0,
     1252},
    {0x33bb65f2, "Sylfaen", "Arial Unicode MS,Marion", 2, 1252},
    {0x3402c30e, "MSPMincho", "Arial Unicode MS,Apple SD Gothic Neo", 2, 1252},
    {0x3412bf31, "SimSun-PUA", "STHeiti,Heiti TC,STFangsong", 0, 936},
    {0x36eb39b9, "BerlinSansFB", "American Typewriter,Impact", 0, 1252},
    {0x36f42055, "UniversATT", "Microsoft Sans Serif", 0, 1252},
    {0x3864c4f6, "HighTowerText", "STIXGeneral,.Helvetica Neue Desk UI", 2,
     1252},
    {0x3a257d03, "FangSong_GB2312", "Hiragino Sans GB,STHeiti", 0, 1252},
    {0x3cdae668, "FreestyleScript", "Nadeem,Zapf Dingbats,STIXNonUnicode", 8,
     1252},
    {0x3d55aed7, "Jokerman",
     "Papyrus,Lucida Grande,Heiti TC,American Typewriter", 0, 1252},
    {0x3d5b4385, "PMingLiU", "Heiti SC,STHeiti", 2, 1252},
    {0x3d9b7669, "EstrangeloEdessa", "American Typewriter,Marion", 0, 1252},
    {0x3e532d74, "FranklinGothicMedium", "Impact,Arial Narrow", 0, 1252},
    {0x3e6aa32d, "NSimSun", "STHeiti,STFangsong", 1, 936},
    {0x3f6c36a8, "Gautami",
     "Damascus,STIXNonUnicode,STIXGeneral,American Typewriter", 0, 1252},
    {0x3ff32662, "Chiller-Regular", "Papyrus,KufiStandardGK,Baghdad", 0, 1252},
    {0x409de312, "ModernNo.20", "Avenir Next Condensed,Impact", 2, 1252},
    {0x41443c5e, "Georgia", ".Helvetica Neue Desk UI,Arial Unicode MS", 2,
     1252},
    {0x4160ade5, "BellGothicStdBlack", "Microsoft Sans Serif,Apple Symbols", 0,
     1252},
    {0x421976c4, "Modern-Regular", "Impact", 2, 1252},
    {0x422a7252, "Stencil", "STIXNonUnicode,Songti SC,Georgia,Baskerville", 0,
     1252},
    {0x42c8554f, "Fixedsys", "Microsoft Sans Serif,Apple Symbols", 0, 1252},
    {0x435cb41d, "Roman", "Arial Narrow", 0, 1252},
    {0x47882383, "CourierNew", "PCMyungjo,Osaka,Arial Unicode MS,Songti SC", 1,
     1252},
    {0x480a2338, "BerlinSansFBDemi",
     "STIXNonUnicode,American Typewriter,Avenir Next Condensed Heavy", 0, 1252},
    {0x480bf7a4, "CourierStd", "Courier New", 0, 1252},
    {0x481ad6ed, "VladimirScript",
     "STIXNonUnicode,Avenir Next Condensed,Impact", 8, 1252},
    {0x4911577a, "YouYuan", "STHeiti,Heiti TC", 1, 936},
    {0x4a788d72, "STXingkai", "Kaiti SC,Songti SC", 0, 936},
    {0x4bf88566, "SegoeCondensed", "Microsoft Sans Serif,Apple Symbols", 0,
     1252},
    {0x4ccf51a4, "BerlinSansFB-Reg",
     "STIXNonUnicode,American Typewriter,Impact", 0, 1252},
    {0x4ea967ce, "GulimChe", "Arial Unicode MS,Heiti TC,STFangsong", 1, 1252},
    {0x4f68bd79, "LetterGothicStd",
     "Courier New,Andale Mono,Ayuthaya,PCMyungjo,Osaka", 0, 1252},
    {0x51a0d0e6, "KozukaGothicPr6NM", "Microsoft Sans Serif,Apple Symbols", 0,
     1252},
    {0x531b3dea, "BasemicSymbol", "Microsoft Sans Serif,Apple Symbols", 0,
     1252},
    {0x5333fd39, "CalifornianFB-Reg",
     "American Typewriter,Avenir Next Condensed,Impact", 2, 1252},
    {0x53561a54, "FZYTK--GBK1-0", "STFangsong,Songti SC,STSong", 0, 936},
    {0x55e0dde6, "LucidaSansTypewriter", "Menlo,Courier New,Andale Mono", 0,
     1252},
    {0x574d4d3d, "AdobeArabic", "Arial Narrow", 0, 1252},
    {0x5792e759, "STKaiti", "Songti SC,Arial Unicode MS", 0, 936},
    {0x5921978e, "LucidaSansUnicode", "Lucida Grande,Arial Unicode MS,Menlo", 0,
     1252},
    {0x594e2da4, "Vrinda", "Geeza Pro,Damascus,STIXGeneral,Gill Sans", 0, 1252},
    {0x59baa9a2, "KaiTi_GB2312", "Hiragino Sans GB,STHeiti", 0, 1252},
    {0x5cfedf4f, "BaskOldFace",
     "Avenir Next Condensed Heavy,PT Sans,Avenir Next Condensed", 0, 1252},
    {0x5e16ac91, "TrajanPro", "Arial Narrow,PT Sans Narrow,Damascus", 0, 1252},
    {0x5f97921c, "AdobeMyungjoStdM",
     "AppleMyungjo,AppleGothic,Arial Unicode MS", 0, 936},
    {0x5fefbfad, "Batang", "Arial Unicode MS,Songti SC", 2, 1252},
    {0x605342b9, "DotumChe", "Arial Unicode MS,Heiti TC", 1, 1252},
    {0x608c5f9a, "KaiTi_GB2312", "Hiragino Sans GB,STHeiti,Heiti TC", 0, 936},
    {0x61efd0d1, "MaturaMTScriptCapitals",
     "Kokonor,Damascus,STIXNonUnicode,STHeiti,Arial Black,Avenir Next Heavy", 0,
     1252},
    {0x626608a9, "MVBoli",
     "Apple Braille,Geeza Pro,Microsoft Sans Serif,Apple Symbols", 0, 1252},
    {0x630501a3, "SmallFonts", "Microsoft Sans Serif,Apple Symbols", 0, 1252},
    {0x65d0e2a9, "FZYTK--GBK1-0", "STFangsong,Songti SC,STSong", 0, 936},
    {0x669f29e1, "FZSTK--GBK1-0", "STHeiti,Heiti TC", 0, 936},
    {0x673a9e5f, "Tunga",
     "Damascus,STIXNonUnicode,Avenir Next Condensed,Avenir Next Condensed "
     "Ultra Light,Futura",
     0, 1252},
    {0x691aa4ce, "NiagaraSolid", "Microsoft Sans Serif,Apple Symbols", 0, 1252},
    {0x696259b7, "Corbel", "Cochin,Baskerville,Marion", 0, 1252},
    {0x696ee9be, "STXihei", "STHeiti,Heiti TC,Songti SC,Arial Unicode MS", 0,
     936},
    {0x6c59cf69, "Dotum", "Arial Unicode MS,Songti SC", 0, 1252},
    {0x707fa561, "Gungsuh", "Arial Unicode MS,Heiti TC", 2, 1252},
    {0x71416bb2, "ZWAdobeF",
     "STIXSizeFourSym,STIXSizeThreeSym,STIXSizeTwoSym,STIXSizeOneSym", 0, 1252},
    {0x71b41801, "Verdana",
     "Tahoma,Marion,Apple Symbols,.Helvetica Neue Desk UI,Lucida "
     "Grande,Courier New",
     0, 1252},
    {0x73f25e4c, "PalatinoLinotype", "Palatino,Arial Unicode MS", 0, 1252},
    {0x73f4d19f, "NiagaraEngraved", "Microsoft Sans Serif,Apple Symbols", 0,
     1252},
    {0x74001694, "MyriadProBlack", "Palatino,Baskerville,Marion,Cochin", 0,
     1252},
    {0x74b14d8f, "Haettenschweiler", "Microsoft Sans Serif,Apple Symbols", 0,
     1252},
    {0x74cb44ee, "NSimSun", "STHeiti,Heiti TC,STFangsong", 1, 936},
    {0x76b4d7ff, "Shruti",
     "Damascus,STIXNonUnicode,Arial Unicode MS,American Typewriter", 0, 1252},
    {0x788b3533, "Webdings", "Microsoft Sans Serif,Apple Symbols", 6, 42},
    {0x797dde99, "MSSerif", "Microsoft Sans Serif,Apple Symbols", 0, 1252},
    {0x7a0f9e9e, "MSMincho",
     "WenQuanYi Zen Hei Mono,AR PL UMing CN,AR PL UMing HK,AR PL UMing TW,AR "
     "PL UMing TW MBE,Arial Unicode MS,Apple SD Gothic Neo",
     1, 1252},
    {0x7b439caf, "OldEnglishTextMT",
     "STIXNonUnicode,Arial Unicode MS,Baskerville,Avenir Next Medium", 0, 1252},
    {0x8213a433, "LucidaSans-Typewriter",
     "Comic Sans MS,Avenir Next,Arial Rounded MT Bold", 0, 1252},
    {0x82fec929, "AdobeSongStd", "Heiti TC,STHeiti", 0, 936},
    {0x83581825, "Modern", "Avenir Next Condensed,Impact", 0, 1252},
    {0x835a2823, "Algerian",
     "STIXNonUnicode,Baskerville,Avenir Next Medium,American Typewriter", 0,
     1252},
    {0x83dab9f5, "Script", "Arial Narrow", 0, 1252},
    {0x847b56da, "Tahoma", "Songti SC,Apple Symbols", 0, 1252},
    {0x8a783cb2, "SimSun-PUA", "STHeiti,Heiti TC,STFangsong", 0, 1252},
    {0x8b5cac0e, "Onyx", "Microsoft Sans Serif,Apple Symbols", 0, 1252},
    {0x8c6a499e, "Gulim", "Arial Unicode MS,Songti SC", 0, 1252},
    {0x8e0af790, "JuiceITC", "Nadeem,Al Bayan", 0, 1252},
    {0x8e8d43b2, "Centaur", "Avenir Next Condensed,Noteworthy,Impact", 2, 1252},
    {0x8ee4dcca, "BookshelfSymbol7", "Microsoft Sans Serif,Apple Symbols", 0,
     1252},
    {0x90794800, "BellGothicStdLight", "Microsoft Sans Serif,Apple Symbols", 0,
     1252},
    {0x909b516a, "Century", "Damascus,Andale Mono,Songti SC,Arial Unicode MS",
     2, 1252},
    {0x92ae370d, "MSOutlook", "Microsoft Sans Serif,Apple Symbols", 4, 42},
    {0x93c9fbf1, "LucidaFax",
     "PT Sans Narrow,Papyrus,Kokonor,Geeza Pro,Arial Rounded MT Bold,Lucida "
     "Grande,Futura",
     2, 1252},
    {0x9565085e, "BookAntiqua", "Palatino,Microsoft Sans Serif,Apple Symbols",
     2, 1252},
    {0x9856d95d, "AdobeMingStd", "AHiragino Sans GB,Heiti TC,STHeiti", 0, 949},
    {0x9bbadd6b, "ColonnaMT", "Noteworthy,Avenir Next Condensed,Impact", 0,
     1252},
    {0x9cbd16a4, "ShowcardGothic-Reg",
     "Arial Unicode MS,Georgia,American Typewriter", 0, 1252},
    {0x9d73008e, "MSSansSerif", "Songti SC,Apple Symbols", 0, 1252},
    {0xa0607db1, "GungsuhChe",
     "WenQuanYi Zen Hei Mono,AR PL UMing CN,AR PL UMing HK,AR PL UMing TW,AR "
     "PL UMing TW MBE,Arial Unicode MS,Heiti TC,STFangsong",
     1, 1252},
    {0xa0bcf6a1, "LatinWide", "Zapfino,Arial Black,STHeiti", 2, 1252},
    {0xa1429b36, "Symbol", "Microsoft Sans Serif,Apple Symbols", 6, 42},
    {0xa1fa5abc, "Wingdings2", "Microsoft Sans Serif,Apple Symbols", 6, 42},
    {0xa1fa5abd, "Wingdings3", "Microsoft Sans Serif,Apple Symbols", 6, 42},
    {0xa427bad4, "InformalRoman-Regular",
     "STIXNonUnicode,Arial Narrow,Avenir Next Condensed Demi Bold", 8, 1252},
    {0xa8b92ece, "FZSTK--GBK1-0", "STHeiti,Heiti TC,STFangsong", 0, 936},
    {0xa8d83ece, "CalifornianFB",
     "American Typewriter,Avenir Next Condensed,Impact", 2, 1252},
    {0xaa3e082c, "Kingsoft-Phonetic",
     "STIXVariants,STIXSizeOneSym,Apple Braille", 0, 1252},
    {0xaa6bcabe, "HarlowSolidItalic",
     "STIXNonUnicode,Avenir Medium,Avenir Next Medium,Arial Unicode MS", 0,
     1252},
    {0xade5337c, "MSUIGothic", "Arial Unicode MS,Apple SD Gothic Neo", 0, 1252},
    {0xb08dd941, "WideLatin",
     "Marion,Papyrus,Nanum Pen Script,Zapf Dingbats,Damascus,Zapfino,Arial "
     "Black,STHeiti",
     2, 1252},
    {0xb12765e0, "ITCLegacySansStdBook",
     "LastResort,.Helvetica Neue Desk UI,Arial Unicode MS,Palatino", 0, 1252},
    {0xb207f05d, "PoorRichard", "Noteworthy,Avenir Next Condensed,Impact", 2,
     1252},
    {0xb3bc492f, "JuiceITC-Regular", "Nadeem,Al Bayan,STIXNonUnicode", 0, 1252},
    {0xb5545399, "Marlett", "Microsoft Sans Serif,Apple Symbols", 4, 42},
    {0xb5dd1ebb, "BritannicBold",
     "Damascus,STIXNonUnicode,Avenir Next Condensed Heavy,PT Sans", 0, 1252},
    {0xb699c1c5, "LucidaCalligraphy-Italic", "STHeiti,Arial Black", 0, 1252},
    {0xb725d629, "TimesNewRoman", "Microsoft Sans Serif,Apple Symbols", 2,
     1252},
    {0xb7eaebeb, "AdobeHeitiStdR", "Heiti TC,STHeiti", 0, 936},
    {0xbd29c486, "BerlinSansFBDemi-Bold",
     "American Typewriter,Avenir Next Condensed Heavy", 0, 1252},
    {0xbe8a8db4, "BookshelfSymbolSeven", "Microsoft Sans Serif,Apple Symbols",
     0, 1252},
    {0xc16c0118, "AdobeHebrew",
     ".Helvetica Neue Desk UI,Palatino,American Typewriter", 0, 1252},
    {0xc318b0af, "MyriadProLight", "Palatino,Baskerville,Marion", 0, 1252},
    {0xc65e5659, "CambriaMath", "Arial Unicode MS", 2, 1252},
    {0xc75c8f05, "LucidaConsole", "Courier New,Menlo,Andale Mono", 1, 1252},
    {0xca7c35d6, "Calibri", "Apple Symbols,HeadLineA", 0, 1252},
    {0xcb053f53, "MicrosoftYaHei", "Arial Unicode MS", 0, 936},
    {0xcb7190f9, "Magneto-Bold", "Lucida Grande", 0, 1252},
    {0xcca00cc5, "System", "Microsoft Sans Serif,Apple Symbols", 0, 1252},
    {0xccad6f76, "Jokerman-Regular", "Lucida Grande", 0, 1252},
    {0xccc5818c, "EuroSign", "Microsoft Sans Serif,Apple Symbols", 0, 1252},
    {0xcf3d7234, "LucidaHandwriting-Italic",
     "Microsoft Sans Serif,Apple Symbols", 0, 1252},
    {0xcf7b8fdb, "MinionPro",
     "Bell MT,Corbel,Times New Roman,Cambria,Berlin Sans FB", 0, 1252},
    {0xcfe5755f, "Simhei", "STHeiti,Heiti TC,STFangsong", 1, 936},
    {0xd011f4ee, "MSPGothic", "Arial Unicode MS,Apple SD Gothic Neo", 0, 1252},
    {0xd060e7ef, "Vivaldi",
     "STIXNonUnicode,Arial Unicode MS,Avenir Medium,Avenir Next Medium", 8,
     1252},
    {0xd07edec1, "FranklinGothic-Medium", "Impact,Arial Narrow", 0, 1252},
    {0xd107243f, "SimSun", "STHeiti,Heiti TC,STFangsong", 0, 936},
    {0xd1881562, "ArialNarrow", "PT Sans Narrow,Apple Symbols", 0, 1252},
    {0xd22b7dce, "BodoniMTPosterCompressed",
     "Microsoft Sans Serif,Apple Symbols", 0, 1252},
    {0xd22bfa60, "ComicSansMS",
     "Damascus,Georgia,.Helvetica Neue Desk UI,Lucida Grande,Arial Unicode MS",
     8, 1252},
    {0xd3bd0e35, "Bauhaus93",
     "STIXNonUnicode,Arial Unicode MS,Avenir Next,Avenir", 0, 1252},
    {0xd429ee7a, "STFangsong", "Songti SC,Arial Unicode MS", 0, 936},
    {0xd6679c12, "BernardMTCondensed", "Impact,Avenir Next Condensed Demi Bold",
     0, 1252},
    {0xd8e8a027, "LucidaSans",
     "Arial Narrow,Khmer MN,Kokonor,Damascus,Microsoft Sans Serif,Apple "
     "Symbols",
     0, 1252},
    {0xd9fe7761, "HighTowerText-Reg",
     "STIXGeneral,.Helvetica Neue Desk UI,Trebuchet MS", 2, 1252},
    {0xda7e551e, "STSong", "Arial Unicode MS", 0, 936},
    {0xdaa6842d, "STZhongsong", "STFangsong,Songti SC,STSong", 0, 936},
    {0xdaaab93f, "STFangsong", "Songti SC,Arial Unicode MS", 0, 936},
    {0xdaeb0713, "STSong", "Songti SC,Arial Unicode MS", 0, 936},
    {0xdafedbef, "STCaiyun", "Kaiti SC,Songti SC,STHeiti", 0, 936},
    {0xdb00a3d9, "Broadway",
     "Papyrus,STIXNonUnicode,Arial Black,Avenir Next Heavy,Heiti TC", 0, 1252},
    {0xdb1f5ad4, "STXinwei", "Kaiti SC,Songti SC,STHeiti", 0, 936},
    {0xdb326e7f, "STKaiti", "Songti SC,Arial Unicode MS", 0, 936},
    {0xdb69595a, "STHupo", "Kaiti SC,Songti SC,STHeiti", 0, 936},
    {0xdba0082c, "STXihei", "Songti SC,Arial Unicode MS", 0, 936},
    {0xdbd0ab18, "STXingkai", "Kaiti SC,Songti SC", 0, 936},
    {0xdc1a7db1, "STLiti", "Kaiti SC,Songti SC", 0, 936},
    {0xdc33075f, "KristenITC-Regular",
     "STIXNonUnicode,Damascus,Songti SC,STSong", 8, 1252},
    {0xdcc7009c, "Harrington",
     "STIXNonUnicode,Avenir Next Condensed Heavy,Noteworthy", 0, 1252},
    {0xdd712466, "ArialBlack", "Geeza Pro,Damascus,Songti SC,STSong", 0, 1252},
    {0xdde87b3e, "Impact", "Arial Narrow,Marion", 0, 1252},
    {0xdf69fb32, "SnapITC",
     "Arial Narrow,PT Sans Narrow,Marion,STHeiti,Arial Black", 0, 1252},
    {0xdf8b25e8, "CenturyGothic",
     "Damascus,Andale Mono,Songti SC,Arial Unicode MS", 0, 1252},
    {0xe0f705c0, "KristenITC", "Songti SC,STSong", 8, 1252},
    {0xe1427573, "Raavi",
     "Damascus,STIXNonUnicode,Marion,Papyrus,Avenir Next Condensed "
     "Heavy,American Typewriter",
     0, 1252},
    {0xe2cea0cb, "Magneto",
     "STIXNonUnicode,Damascus,Geeza Pro,Lucida Grande,Georgia,Heiti TC", 0,
     1252},
    {0xe36a9e17, "Ravie", "STHeiti,Arial Black", 0, 1252},
    {0xe433f8e2, "Parchment", "Microsoft Sans Serif,Apple Symbols", 8, 1252},
    {0xe43dff4a, "Wingdings", "Microsoft Sans Serif,Apple Symbols", 4, 42},
    {0xe4e2c405, "MTExtra", "Microsoft Sans Serif,Apple Symbols", 6, 42},
    {0xe618cc35, "InformalRoman", "Arial Narrow", 8, 1252},
    {0xe6c27ffc, "Mistral", "Apple Symbols", 8, 1252},
    {0xe7ebf4b9, "Courier", "Courier New", 0, 1252},
    {0xe8bc4a9d, "MSReferenceSpecialty", "Microsoft Sans Serif,Apple Symbols",
     0, 1252},
    {0xe90fb013, "TempusSansITC",
     "STIXNonUnicode,Microsoft Sans Serif,Avenir Light", 0, 1252},
    {0xec637b42, "Consolas",
     "AR PL UKai CN,AR PL UKai HK,AR PL UKai TW,AR PL UKai TW MBE,AR PL UMing "
     "CN,AR PL UMing HK,Microsoft Sans Serif,Tahoma",
     1, 1252},
    {0xed3a683b, "STXinwei", "Kaiti SC,Songti SC,", 0, 936},
    {0xef264cd1, "LucidaHandwriting",
     "Arial Narrow,Avenir Next Condensed Demi Bold,Avenir Next "
     "Condensed,Avenir Next Condensed Medium,STHeiti,Arial Black",
     0, 1252},
    {0xf086bca2, "BaskervilleOldFace",
     "STIXNonUnicode,Avenir Next Condensed Heavy,PT Sans", 0, 1252},
    {0xf1028030, "Mangal",
     "Arial Unicode MS,Microsoft Sans Serif,Arial Narrow,Tahoma", 2, 1252},
    {0xf1da7eb9, "ShowcardGothic",
     "Papyrus,Arial Unicode MS,Georgia,American Typewriter", 0, 1252},
    {0xf210f06a, "ArialMT",
     "Arial Unicode MS,Arial Narrow,STIXNonUnicode,Damascus,Avenir Next "
     "Condensed Demi Bold,Avenir Next Condensed Medium,Avenir Next Condensed",
     0, 1252},
    {0xf477f16a, "Latha",
     "Arial Narrow,Damascus,STIXNonUnicode,American Typewriter", 0, 1252},
    {0xf616f3dd, "LiSu", "STHeiti,Heiti TC,STFangsong", 1, 936},
    {0xfa479aa6, "MicrosoftYaHei", "Arial Unicode MS", 0, 936},
    {0xfcd19697, "BookmanOldStyle",
     "Geeza Pro,Damascus,Andale Mono,Songti SC,Arial Unicode MS", 0, 1252},
    {0xfe209a82, "LucidaCalligraphy",
     "Kokonor,Damascus,STIXNonUnicode,STHeiti,Arial Black", 0, 1252},
    {0xfef135f8, "AdobeHeitiStd-Regular", "Heiti TC,STHeiti", 0, 936},
};
#elif defined(OS_ANDROID)
const FGAS_FontInfo g_XFAFontsMap[] = {
    {0x01d5d33e, "SimSun", "Droid Sans Fallback", 0, 936},
    {0x01e4f102, "YouYuan", "Droid Sans Fallback", 1, 936},
    {0x030549dc, "LiSu", "Droid Sans Fallback", 1, 936},
    {0x032edd44, "Simhei", "Droid Sans Fallback", 1, 936},
    {0x03eac6fc, "PoorRichard-Regular",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback,Droid Arabic "
     "Naskh,Droid Sans Ethiopic",
     2, 1252},
    {0x03ed90e6, "Nina",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x077b56b3, "KingsoftPhoneticPlain",
     "Droid Sans Thai,Droid Sans Armenian,Droid Arabic Naskh,Droid Sans "
     "Ethiopic,Droid Sans Fallback",
     0, 1252},
    {0x078ed524, "MicrosoftSansSerif", "Droid Sans Fallback", 0, 1252},
    {0x089b18a9, "Arial", "Droid Sans Fallback", 0, 1252},
    {0x0b2cad72, "MonotypeCorsiva",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 8, 1252},
    {0x0bb003e7, "Kartika",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Roboto,Droid Serif,Droid Sans "
     "Mono",
     2, 1252},
    {0x0bb469df, "VinerHandITC",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 8, 1252},
    {0x0bc1a851, "SegoeUI", "Droid Sans Fallback", 0, 1252},
    {0x0c112ebd, "KozukaGothicPro-VIM",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x0cfcb9c1, "AdobeThai",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 847},
    {0x0e7de0f9, "Playbill",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Roboto,Droid Serif,Droid Sans "
     "Mono",
     0, 1252},
    {0x0eff47c3, "STHupo", "Droid Sans Fallback", 0, 936},
    {0x107ad374, "Constantia",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0x12194c2d, "KunstlerScript",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 8, 1252},
    {0x135ef6a1, "MinionProSmBd",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x158c4049, "Garamond",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0x160ecb24, "STZhongsong", "Droid Sans Fallback", 0, 936},
    {0x161ed07e, "MSGothic", "Droid Sans Fallback", 1, 1252},
    {0x171d1ed1, "SnapITC-Regular",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x18d1188f, "Cambria", "Droid Sans Fallback", 2, 1252},
    {0x18eaf350, "ArialUnicodeMS", "Droid Sans Fallback", 0, 936},
    {0x1a92d115, "MingLiU", "Droid Sans Fallback", 1, 1252},
    {0x1cc217c6, "TrebuchetMS",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x1d649596, "BasemicTimes",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x1e34ee60, "BellMT",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0x1eb36945, "CooperBlack",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0x1ef7787d, "BatangChe", "Droid Sans Fallback", 1, 1252},
    {0x20b3bd3a, "BrushScriptMT", "Droid Arabic Naskh,Droid Sans Ethiopic", 8,
     1252},
    {0x220877aa, "Candara",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x22135007, "FreestyleScript-Regular",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 8, 1252},
    {0x251059c3, "Chiller",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Roboto,Droid Serif", 0, 1252},
    {0x25bed6dd, "MSReferenceSansSerif", "Droid Sans Fallback", 0, 1252},
    {0x28154c81, "Parchment-Regular",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 8, 1252},
    {0x29711eb9, "STLiti", "Droid Sans Fallback", 0, 936},
    {0x2b1993b4, "Basemic",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x2b316339, "NiagaraSolid-Reg",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x2c147529, "FootlightMTLight",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x2c198928, "HarlowSolid",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x2c6ac6b2, "LucidaBright",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Serif,Roboto", 2, 1252},
    {0x2c9f38e2, "KozukaMinchoPro-VIR",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x2d5a47b0, "STCaiyun", "Droid Sans Fallback", 0, 936},
    {0x2def26bf, "BernardMT-Condensed",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x2fd8930b, "KozukaMinchoPr6NR",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x3115525a, "FangSong_GB2312", "Droid Sans Fallback", 0, 1252},
    {0x31327817, "MyriadPro",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x32244975, "Helvetica",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Serif,Roboto", 0, 1252},
    {0x32ac995c, "Terminal",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x338d648a, "NiagaraEngraved-Reg",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x33bb65f2, "Sylfaen",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0x3402c30e, "MSPMincho", "Droid Sans Fallback", 2, 1252},
    {0x3412bf31, "SimSun-PUA", "Droid Sans Fallback", 0, 936},
    {0x36eb39b9, "BerlinSansFB",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x36f42055, "UniversATT", "Microsoft Sans Serif", 0, 1252},
    {0x3864c4f6, "HighTowerText",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0x3a257d03, "FangSong_GB2312", "Droid Sans Fallback", 0, 1252},
    {0x3cdae668, "FreestyleScript",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 8, 1252},
    {0x3d55aed7, "Jokerman",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x3d5b4385, "PMingLiU", "Droid Sans Fallback", 2, 1252},
    {0x3d9b7669, "EstrangeloEdessa",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x3e532d74, "FranklinGothicMedium",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x3e6aa32d, "NSimSun", "Droid Sans Fallback", 1, 936},
    {0x3f6c36a8, "Gautami",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Roboto,Droid Serif,Droid Sans "
     "Mono,Droid Sans Fallback",
     0, 1252},
    {0x3ff32662, "Chiller-Regular",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x409de312, "ModernNo.20",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0x41443c5e, "Georgia",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0x4160ade5, "BellGothicStdBlack",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x421976c4, "Modern-Regular",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0x422a7252, "Stencil",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x42c8554f, "Fixedsys",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x435cb41d, "Roman",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x47882383, "CourierNew", "Droid Sans Fallback", 1, 1252},
    {0x480a2338, "BerlinSansFBDemi",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x480bf7a4, "CourierStd", "Droid Sans Fallback", 0, 1252},
    {0x481ad6ed, "VladimirScript",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 8, 1252},
    {0x4911577a, "YouYuan", "Droid Sans Fallback", 1, 936},
    {0x4a788d72, "STXingkai", "Droid Sans Fallback", 0, 936},
    {0x4bf88566, "SegoeCondensed",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x4ccf51a4, "BerlinSansFB-Reg",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x4ea967ce, "GulimChe", "Droid Sans Fallback", 1, 1252},
    {0x4f68bd79, "LetterGothicStd",
     "Droid Sans Mono,Droid Arabic Naskh,Droid Sans Ethiopic,Droid Sans "
     "Mono,Droid Serif,Droid Sans Fallback",
     0, 1252},
    {0x51a0d0e6, "KozukaGothicPr6NM",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x531b3dea, "BasemicSymbol",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x5333fd39, "CalifornianFB-Reg",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0x53561a54, "FZYTK--GBK1-0", "Droid Sans Fallback", 0, 936},
    {0x55e0dde6, "LucidaSansTypewriter",
     "Droid Sans Mono,Droid Arabic Naskh,Droid Sans Ethiopic", 0, 1252},
    {0x574d4d3d, "AdobeArabic",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x5792e759, "STKaiti", "Droid Sans Fallback", 0, 936},
    {0x5921978e, "LucidaSansUnicode", "Droid Sans Fallback", 0, 1252},
    {0x594e2da4, "Vrinda",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Roboto,Droid Serif,Droid Sans "
     "Mono",
     0, 1252},
    {0x59baa9a2, "KaiTi_GB2312", "Droid Sans Fallback", 0, 1252},
    {0x5cfedf4f, "BaskOldFace",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x5f97921c, "AdobeMyungjoStdM", "Droid Sans Fallback", 0, 936},
    {0x5fefbfad, "Batang", "Droid Sans Fallback", 2, 1252},
    {0x605342b9, "DotumChe", "Droid Sans Fallback", 1, 1252},
    {0x608c5f9a, "KaiTi_GB2312", "Droid Sans Fallback", 0, 936},
    {0x61efd0d1, "MaturaMTScriptCapitals",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Serif,Roboto,Droid Sans "
     "Mono",
     0, 1252},
    {0x626608a9, "MVBoli",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Serif,Roboto,Droid Sans "
     "Mono",
     0, 1252},
    {0x630501a3, "SmallFonts",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x65d0e2a9, "FZYTK--GBK1-0", "Droid Sans Fallback", 0, 936},
    {0x669f29e1, "FZSTK--GBK1-0", "Droid Sans Fallback", 0, 936},
    {0x673a9e5f, "Tunga",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Roboto,Droid Serif,Droid Sans "
     "Mono,Droid Sans Fallback",
     0, 1252},
    {0x691aa4ce, "NiagaraSolid",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x696259b7, "Corbel",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x696ee9be, "STXihei", "Droid Sans Fallback", 0, 936},
    {0x6c59cf69, "Dotum", "Droid Sans Fallback", 0, 1252},
    {0x707fa561, "Gungsuh", "Droid Sans Fallback", 2, 1252},
    {0x71416bb2, "ZWAdobeF",
     "Droid Arabic Naskh,Droid Sans Armenian,Droid Sans Ethiopic,Droid Sans "
     "Georgian,Droid Sans Hebrew,Droid Sans Thai",
     0, 1252},
    {0x71b41801, "Verdana",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x73f25e4c, "PalatinoLinotype", "Droid Sans Fallback", 0, 1252},
    {0x73f4d19f, "NiagaraEngraved",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x74001694, "MyriadProBlack", "Book Antiqua,Constantia,Dotum,Georgia", 0,
     1252},
    {0x74b14d8f, "Haettenschweiler",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x74cb44ee, "NSimSun", "Droid Sans Fallback", 1, 936},
    {0x76b4d7ff, "Shruti",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Roboto,Droid Serif,Droid Sans "
     "Mono",
     0, 1252},
    {0x788b3533, "Webdings",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 6, 42},
    {0x797dde99, "MSSerif",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x7a0f9e9e, "MSMincho", "Droid Sans Fallback", 1, 1252},
    {0x7b439caf, "OldEnglishTextMT",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x8213a433, "LucidaSans-Typewriter",
     "Droid Sans Mono,Droid Serif,Roboto,Droid Sans Fallback", 0, 1252},
    {0x82fec929, "AdobeSongStd", "Droid Sans Fallback", 0, 936},
    {0x83581825, "Modern",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x835a2823, "Algerian",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x83dab9f5, "Script",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x847b56da, "Tahoma", "Droid Sans Fallback", 0, 1252},
    {0x8a783cb2, "SimSun-PUA", "Droid Sans Fallback", 0, 1252},
    {0x8b5cac0e, "Onyx",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x8c6a499e, "Gulim", "Droid Sans Fallback", 0, 1252},
    {0x8e0af790, "JuiceITC",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x8e8d43b2, "Centaur",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0x8ee4dcca, "BookshelfSymbol7",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x90794800, "BellGothicStdLight",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x909b516a, "Century",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0x92ae370d, "MSOutlook",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 4, 42},
    {0x93c9fbf1, "LucidaFax",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Serif,Roboto,Droid Sans "
     "Mono",
     2, 1252},
    {0x9565085e, "BookAntiqua",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0x9856d95d, "AdobeMingStd", "Droid Sans Fallback", 0, 949},
    {0x9bbadd6b, "ColonnaMT",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0x9cbd16a4, "ShowcardGothic-Reg",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallbac", 0, 1252},
    {0x9d73008e, "MSSansSerif",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xa0607db1, "GungsuhChe", "Droid Sans Fallback", 1, 1252},
    {0xa0bcf6a1, "LatinWide",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0xa1429b36, "Symbol",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 6, 42},
    {0xa1fa5abc, "Wingdings2",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 6, 42},
    {0xa1fa5abd, "Wingdings3",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 6, 42},
    {0xa427bad4, "InformalRoman-Regular",
     "Droid Arabic Naskh,Droid Sans Ethiopic", 8, 1252},
    {0xa8b92ece, "FZSTK--GBK1-0", "Droid Sans Fallback", 0, 936},
    {0xa8d83ece, "CalifornianFB",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0xaa3e082c, "Kingsoft-Phonetic",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xaa6bcabe, "HarlowSolidItalic",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xade5337c, "MSUIGothic",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xb08dd941, "WideLatin",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Serif,Roboto,Droid Sans "
     "Mono",
     2, 1252},
    {0xb207f05d, "PoorRichard",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0xb3bc492f, "JuiceITC-Regular",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xb5545399, "Marlett",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 4, 42},
    {0xb5dd1ebb, "BritannicBold", "Droid Arabic Naskh,Droid Sans Ethiopic", 0,
     1252},
    {0xb699c1c5, "LucidaCalligraphy-Italic",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xb725d629, "TimesNewRoman", "Droid Sans Fallback", 2, 1252},
    {0xb7eaebeb, "AdobeHeitiStdR", "Droid Sans Fallback", 0, 936},
    {0xbd29c486, "BerlinSansFBDemi-Bold",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xbe8a8db4, "BookshelfSymbolSeven",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xc16c0118, "AdobeHebrew",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback,Droid Arabic "
     "Naskh,Droid Sans Ethiopic",
     0, 1252},
    {0xc318b0af, "MyriadProLight",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xc65e5659, "CambriaMath", "Droid Sans Fallback", 2, 1252},
    {0xc75c8f05, "LucidaConsole",
     "Droid Sans Mono,Droid Serif,Roboto,Droid Sans Fallback", 1, 1252},
    {0xca7c35d6, "Calibri", "Droid Sans Fallback", 0, 1252},
    {0xcb053f53, "MicrosoftYaHei", "Droid Sans Fallback", 0, 936},
    {0xcb7190f9, "Magneto-Bold",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xcca00cc5, "System",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xccad6f76, "Jokerman-Regular",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xccc5818c, "EuroSign",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xcf3d7234, "LucidaHandwriting-Italic",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xcf7b8fdb, "MinionPro",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xcfe5755f, "Simhei", "Droid Sans Fallback", 1, 936},
    {0xd011f4ee, "MSPGothic", "Droid Sans Fallback", 0, 1252},
    {0xd060e7ef, "Vivaldi",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 8, 1252},
    {0xd07edec1, "FranklinGothic-Medium",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xd107243f, "SimSun", "Droid Sans Fallback", 0, 936},
    {0xd1881562, "ArialNarrow",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xd22b7dce, "BodoniMTPosterCompressed",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xd22bfa60, "ComicSansMS", "Droid Serif,Roboto,Droid Sans Fallback", 8,
     1252},
    {0xd3bd0e35, "Bauhaus93",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xd429ee7a, "STFangsong", "Droid Sans Fallback", 0, 936},
    {0xd6679c12, "BernardMTCondensed",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xd8e8a027, "LucidaSans",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Serif,Roboto", 0, 1252},
    {0xd9fe7761, "HighTowerText-Reg",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 2, 1252},
    {0xda7e551e, "STSong", "Droid Sans Fallback", 0, 936},
    {0xdaa6842d, "STZhongsong", "Droid Sans Fallback", 0, 936},
    {0xdaaab93f, "STFangsong", "Droid Sans Fallback", 0, 936},
    {0xdaeb0713, "STSong",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 936},
    {0xdafedbef, "STCaiyun", "Droid Sans Fallback", 0, 936},
    {0xdb00a3d9, "Broadway",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xdb1f5ad4, "STXinwei", "Droid Sans Fallback", 0, 936},
    {0xdb326e7f, "STKaiti", "Droid Sans Fallback", 0, 936},
    {0xdb69595a, "STHupo", "Droid Sans Fallback", 0, 936},
    {0xdba0082c, "STXihei", "Droid Sans Fallback", 0, 936},
    {0xdbd0ab18, "STXingkai", "Droid Sans Fallback", 0, 936},
    {0xdc1a7db1, "STLiti", "Droid Sans Fallback", 0, 936},
    {0xdc33075f, "KristenITC-Regular",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Serif,Roboto", 8, 1252},
    {0xdcc7009c, "Harrington",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xdd712466, "ArialBlack",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xdde87b3e, "Impact",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xdf69fb32, "SnapITC",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Serif,Roboto,Droid Sans "
     "Mono",
     0, 1252},
    {0xdf8b25e8, "CenturyGothic",
     "Droid Serif,Roboto,Droid Serif,Droid Sans Mono", 0, 1252},
    {0xe0f705c0, "KristenITC",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Serif,Roboto", 8, 1252},
    {0xe1427573, "Raavi",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Roboto,Droid Serif,Droid Sans "
     "Mono",
     0, 1252},
    {0xe2cea0cb, "Magneto",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Serif,Roboto,Droid Sans "
     "Mono",
     0, 1252},
    {0xe36a9e17, "Ravie",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Roboto,Droid Serif,Droid Sans "
     "Mono",
     0, 1252},
    {0xe433f8e2, "Parchment",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 8, 1252},
    {0xe43dff4a, "Wingdings",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 4, 42},
    {0xe4e2c405, "MTExtra",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 6, 42},
    {0xe618cc35, "InformalRoman",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Roboto,Droid Serif", 8, 1252},
    {0xe6c27ffc, "Mistral",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 8, 1252},
    {0xe7ebf4b9, "Courier", "Droid Sans Fallback", 0, 1252},
    {0xe8bc4a9d, "MSReferenceSpecialty",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xe90fb013, "TempusSansITC",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xec637b42, "Consolas", "Droid Sans Fallback", 1, 1252},
    {0xed3a683b, "STXinwei", "Droid Sans Fallback", 0, 936},
    {0xef264cd1, "LucidaHandwriting",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Serif,Roboto,Droid Sans "
     "Mono",
     0, 1252},
    {0xf086bca2, "BaskervilleOldFace",
     "Roboto,Droid Serif,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xf1028030, "Mangal",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Serif,Roboto,Droid Sans "
     "Mono",
     2, 1252},
    {0xf1da7eb9, "ShowcardGothic",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallbac", 0, 1252},
    {0xf210f06a, "ArialMT",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Roboto,Droid Serif", 0, 1252},
    {0xf477f16a, "Latha",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Roboto,Droid Serif,Droid Sans "
     "Mono",
     0, 1252},
    {0xf616f3dd, "LiSu", "Droid Sans Fallback", 1, 936},
    {0xfa479aa6, "MicrosoftYaHei", "Droid Sans Fallback", 0, 936},
    {0xfcd19697, "BookmanOldStyle",
     "Droid Serif,Roboto,Droid Sans Mono,Droid Sans Fallback", 0, 1252},
    {0xfe209a82, "LucidaCalligraphy",
     "Droid Arabic Naskh,Droid Sans Ethiopic,Droid Serif,Roboto,Droid Sans "
     "Mono",
     0, 1252},
    {0xfef135f8, "AdobeHeitiStd-Regular", "Droid Sans Fallback", 0, 936},
};
#endif

}  // namespace

const FGAS_FONTUSB* FGAS_GetUnicodeBitField(wchar_t unicode) {
  // This search is trying to find the entry where the unicode character falls
  // bewtween start and end. std::upper_bound needs to be used here instead of
  // lower_bound, because they return the first value that meets the
  // requirement, as though they are linearly searching. For lower_bound this
  // means the first element less then the value, and for upper_bound this means
  // the first element greater then the value. Since the entries are sorted in
  // ascending order, the correct entry is the first one with an end greater,
  // aka after, the value.
  auto* result = std::upper_bound(
      std::begin(g_FXGdiFontUSBTable), std::end(g_FXGdiFontUSBTable), unicode,
      [](const wchar_t unicode, const FGAS_FONTUSB& iter) {
        return iter.wEndUnicode > unicode;
      });
  if (result != std::end(g_FXGdiFontUSBTable) &&
      result->wStartUnicode <= unicode && result->wEndUnicode >= unicode)
    return result;
  return nullptr;
}

WideString FGAS_FontNameToEnglishName(WideStringView wsLocalName) {
  uint32_t dwLocalNameHash = FX_HashCode_GetW(wsLocalName, true);
  const FGAS_FontInfo* pEnd = g_XFAFontsMap + FX_ArraySize(g_XFAFontsMap);
  const FGAS_FontInfo* pFontInfo =
      std::lower_bound(g_XFAFontsMap, pEnd, dwLocalNameHash,
                       [](const FGAS_FontInfo& entry, uint32_t hash) {
                         return entry.dwFontNameHash < hash;
                       });
  if (pFontInfo < pEnd && pFontInfo->dwFontNameHash == dwLocalNameHash)
    return WideString::FromASCII(ByteStringView(pFontInfo->pPsName));
  return WideString(wsLocalName);
}

const FGAS_FontInfo* FGAS_FontInfoByFontName(WideStringView wsFontName) {
  WideString wsFontNameTemp(wsFontName);
  wsFontNameTemp.Remove(L' ');
  uint32_t dwCurFontNameHash =
      FX_HashCode_GetW(wsFontNameTemp.AsStringView(), true);
  const FGAS_FontInfo* pEnd = g_XFAFontsMap + FX_ArraySize(g_XFAFontsMap);
  const FGAS_FontInfo* pFontInfo =
      std::lower_bound(g_XFAFontsMap, pEnd, dwCurFontNameHash,
                       [](const FGAS_FontInfo& entry, uint32_t hash) {
                         return entry.dwFontNameHash < hash;
                       });
  if (pFontInfo < pEnd && pFontInfo->dwFontNameHash == dwCurFontNameHash)
    return pFontInfo;
  return nullptr;
}
