// Note: the code below was backported from the 3.x master branch, and it's
//       mostly cut and paste from there to avoid re-inventing that logic.

package db

// The code below was generated by lxd-generate - DO NOT EDIT!

import (
	"github.com/lxc/lxd/lxd/db/cluster"
	"github.com/lxc/lxd/lxd/db/query"
	"github.com/lxc/lxd/shared/api"
	"github.com/pkg/errors"
)

var _ = api.ServerEnvironment{}

var containerObjects = cluster.RegisterStmt(`
SELECT containers.id, containers.name, nodes.name AS node, containers.type, containers.architecture, containers.ephemeral, containers.creation_date, containers.stateful, containers.last_use_date, coalesce(containers.description, '')
  FROM containers JOIN nodes ON node_id = nodes.id
  ORDER BY containers.name
`)

var containerProfilesRef = cluster.RegisterStmt(`
SELECT containers.name,
       profiles.name
FROM containers_profiles
JOIN containers ON containers.id=containers_profiles.container_id
JOIN profiles ON profiles.id=containers_profiles.profile_id
ORDER BY containers_profiles.apply_order;
`)

var containerConfigRef = cluster.RegisterStmt(`
SELECT containers.name,
       containers_config.key,
       containers_config.value
FROM containers_config
JOIN containers ON containers.id=containers_config.container_id
`)

var containerDevicesRef = cluster.RegisterStmt(`
SELECT containers.name,
       containers_devices.name,
       containers_devices.type,
       coalesce(containers_devices_config.key, ''),
       coalesce(containers_devices_config.value, '')
FROM containers_devices
LEFT OUTER JOIN containers_devices_config
  ON containers_devices_config.container_device_id=containers_devices.id
JOIN containers ON containers.id=containers_devices.container_id
`)

// ContainerList returns all available containers.
func (c *ClusterTx) ContainerList() ([]Container, error) {
	// Result slice.
	objects := make([]Container, 0)

	stmt := c.stmt(containerObjects)
	args := []interface{}{}

	// Dest function for scanning a row.
	dest := func(i int) []interface{} {
		objects = append(objects, Container{})
		return []interface{}{
			&objects[i].ID,
			&objects[i].Name,
			&objects[i].Node,
			&objects[i].Type,
			&objects[i].Architecture,
			&objects[i].Ephemeral,
			&objects[i].CreationDate,
			&objects[i].Stateful,
			&objects[i].LastUseDate,
			&objects[i].Description,
		}
	}

	// Select.
	err := query.SelectObjects(stmt, dest, args...)
	if err != nil {
		return nil, errors.Wrap(err, "Failed to fetch containers")
	}

	// Fill field Config.
	configObjects, err := c.ContainerConfigRef()
	if err != nil {
		return nil, errors.Wrap(err, "Failed to fetch field Config")
	}

	for i := range objects {
		_, ok := configObjects[objects[i].Name]
		if !ok {
			configObjects[objects[i].Name] = map[string]string{}
		}

		value := configObjects[objects[i].Name]
		if value == nil {
			value = map[string]string{}
		}
		objects[i].Config = value
	}

	// Fill field Devices.
	devicesObjects, err := c.ContainerDevicesRef()
	if err != nil {
		return nil, errors.Wrap(err, "Failed to fetch field Devices")
	}

	for i := range objects {
		value := devicesObjects[objects[i].Name]
		if value == nil {
			value = map[string]map[string]string{}
		}
		objects[i].Devices = value
	}

	// Fill field Profiles.
	profilesObjects, err := c.ContainerProfilesRef()
	if err != nil {
		return nil, errors.Wrap(err, "Failed to fetch field Profiles")
	}

	for i := range objects {
		value := profilesObjects[objects[i].Name]
		if value == nil {
			value = []string{}
		}
		objects[i].Profiles = value
	}

	return objects, nil
}

// ContainerProfilesRef returns entities used by containers.
func (c *ClusterTx) ContainerProfilesRef() (map[string][]string, error) {
	// Result slice.
	objects := make([]struct {
		Name  string
		Value string
	}, 0)

	stmt := c.stmt(containerProfilesRef)
	args := []interface{}{}

	// Dest function for scanning a row.
	dest := func(i int) []interface{} {
		objects = append(objects, struct {
			Name  string
			Value string
		}{})
		return []interface{}{
			&objects[i].Name,
			&objects[i].Value,
		}
	}

	// Select.
	err := query.SelectObjects(stmt, dest, args...)
	if err != nil {
		return nil, errors.Wrap(err, "Failed to fetch string ref for containers")
	}

	// Build index by primary name.
	index := map[string][]string{}

	for _, object := range objects {
		item, ok := index[object.Name]
		if !ok {
			item = []string{}
		}

		index[object.Name] = append(item, object.Value)
	}

	return index, nil
}

// ContainerConfigRef returns entities used by containers.
func (c *ClusterTx) ContainerConfigRef() (map[string]map[string]string, error) {
	// Result slice.
	objects := make([]struct {
		Name  string
		Key   string
		Value string
	}, 0)

	stmt := c.stmt(containerConfigRef)
	args := []interface{}{}

	// Dest function for scanning a row.
	dest := func(i int) []interface{} {
		objects = append(objects, struct {
			Name  string
			Key   string
			Value string
		}{})
		return []interface{}{
			&objects[i].Name,
			&objects[i].Key,
			&objects[i].Value,
		}
	}

	// Select.
	err := query.SelectObjects(stmt, dest, args...)
	if err != nil {
		return nil, errors.Wrap(err, "Failed to fetch  ref for containers")
	}

	// Build index by primary name.
	index := map[string]map[string]string{}

	for _, object := range objects {
		item, ok := index[object.Name]
		if !ok {
			item = map[string]string{}
		}

		index[object.Name] = item
		item[object.Key] = object.Value
	}

	return index, nil
}

// ContainerDevicesRef returns entities used by containers.
func (c *ClusterTx) ContainerDevicesRef() (map[string]map[string]map[string]string, error) {
	// Result slice.
	objects := make([]struct {
		Name   string
		Device string
		Type   int
		Key    string
		Value  string
	}, 0)

	stmt := c.stmt(containerDevicesRef)
	args := []interface{}{}

	// Dest function for scanning a row.
	dest := func(i int) []interface{} {
		objects = append(objects, struct {
			Name   string
			Device string
			Type   int
			Key    string
			Value  string
		}{})
		return []interface{}{
			&objects[i].Name,
			&objects[i].Device,
			&objects[i].Type,
			&objects[i].Key,
			&objects[i].Value,
		}
	}

	// Select.
	err := query.SelectObjects(stmt, dest, args...)
	if err != nil {
		return nil, errors.Wrap(err, "Failed to fetch  ref for containers")
	}

	// Build index by primary name.
	index := map[string]map[string]map[string]string{}

	for _, object := range objects {
		item, ok := index[object.Name]
		if !ok {
			item = map[string]map[string]string{}
		}

		index[object.Name] = item
		config, ok := item[object.Device]
		if !ok {
			// First time we see this device, let's int the config
			// and add the type.
			deviceType, err := dbDeviceTypeToString(object.Type)
			if err != nil {
				return nil, errors.Wrapf(
					err, "unexpected device type code '%d'", object.Type)
			}
			config = map[string]string{}
			config["type"] = deviceType
			item[object.Device] = config
		}
		if object.Key != "" {
			config[object.Key] = object.Value
		}
	}

	return index, nil
}
