/* test-serializer.c generated by valac 0.40.6, the Vala compiler
 * generated from test-serializer.vala, do not modify */

/*
 * Copyright (C) 2012 Arth Patel
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "libcalculator.h"
#include <locale.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))


extern gint fail_count;
gint fail_count = 0;
extern gint pass_count;
gint pass_count = 0;

#define thousand_separator ","
#define radix_string "."
void pass (const gchar* text);
void fail (const gchar* text);
void test_number (Serializer* s,
                  const gchar* number,
                  gint base_value,
                  gint representation_base,
                  const gchar* expected_string);
void test_fixed (Serializer* s);
void test_automatic (Serializer* s);
void test_scientific (Serializer* s);
void test_engineering (Serializer* s);
void test_base_conversion (Serializer* s);
gint _vala_main (gchar** args,
                 int args_length1);


void
pass (const gchar* text)
{
	gint _tmp0_;
	_tmp0_ = pass_count;
	pass_count = _tmp0_ + 1;
}


void
fail (const gchar* text)
{
	FILE* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (text != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "*FAIL: %s\n", text);
	_tmp1_ = fail_count;
	fail_count = _tmp1_ + 1;
}


void
test_number (Serializer* s,
             const gchar* number,
             gint base_value,
             gint representation_base,
             const gchar* expected_string)
{
	Number* n = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (number != NULL);
	g_return_if_fail (expected_string != NULL);
	_tmp0_ = mp_set_from_string (number, base_value);
	n = _tmp0_;
	serializer_set_base (s, base_value);
	serializer_set_representation_base (s, (guint) representation_base);
	_tmp1_ = n;
	_tmp2_ = serializer_to_string (s, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, expected_string) == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		pass (NULL);
	} else {
		Number* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = n;
		_tmp6_ = serializer_to_string (s, _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("Serializer returned (%s) => expected value (%s)", _tmp7_, expected_string);
		_tmp9_ = _tmp8_;
		fail (_tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
	}
	_g_object_unref0 (n);
}


void
test_fixed (Serializer* s)
{
	g_return_if_fail (s != NULL);
	serializer_set_number_format (s, DISPLAY_FORMAT_FIXED);
	test_number (s, "123456789012345678901234", 10, 10, "123,456,789,012,345,678,901,234");
	test_number (s, "0.1234567890123456789012", 10, 10, "0.123456789");
	test_number (s, "101010101010101010101010", 2, 2, "101010101010101010101010");
	test_number (s, "0.1010101010101010101010", 2, 2, "0.101010101");
	test_number (s, "123456701234567012345670", 8, 8, "123456701234567012345670");
	test_number (s, "0.1234567012345670123456", 8, 8, "0.123456701");
	test_number (s, "123456789ABCDEF012345678", 16, 16, "123456789ABCDEF012345678");
	test_number (s, "0.ABCDEF0123456789ABCDEF", 16, 16, "0.ABCDEF012");
}


void
test_automatic (Serializer* s)
{
	g_return_if_fail (s != NULL);
	serializer_set_number_format (s, DISPLAY_FORMAT_AUTOMATIC);
	test_number (s, "0.10", 10, 10, "0.1");
	test_number (s, "0.12345678901234567890", 10, 10, "0.123456789");
	test_number (s, "123456789012", 10, 10, "123,456,789,012");
	test_number (s, "12345678901234567890", 10, 10, "1.23456789×10¹⁹");
	test_number (s, ".10", 2, 2, "0.1");
	test_number (s, "0.10101010101010101010", 2, 2, "0.101010101");
	test_number (s, "1010101010101010101010101010101010101010101010101010101010101010", 2, 2, "1010101010101010101010101010101010101010101010101010101010101010");
	test_number (s, "10101010101010101010101010101010101010101010101010101010101010101", 2, 2, "1.010101011×10⁶⁴");
	test_number (s, "0.10", 8, 8, "0.1");
	test_number (s, "0.12345670123456701234", 8, 8, "0.123456701");
	test_number (s, "1234567012345670123456", 8, 8, "1234567012345670123456");
	test_number (s, "12345670123456701234567", 8, 8, "1.234567012×10²²");
	test_number (s, "0.10", 16, 16, "0.1");
	test_number (s, "0.123456789ABCDEF01234", 16, 16, "0.12345678A");
	test_number (s, "123456789ABCDEF0", 16, 16, "123456789ABCDEF0");
	test_number (s, "123456789ABCEDF01", 16, 16, "1.23456789B×10¹⁶");
}


void
test_scientific (Serializer* s)
{
	g_return_if_fail (s != NULL);
	serializer_set_number_format (s, DISPLAY_FORMAT_SCIENTIFIC);
	test_number (s, "1", 10, 10, "1");
	test_number (s, "10", 10, 10, "1×10¹");
	test_number (s, "1234567890", 10, 10, "1.23456789×10⁹");
	test_number (s, "0.1", 10, 10, "1×10⁻¹");
	test_number (s, "0.1234567890", 10, 10, "1.23456789×10⁻¹");
	test_number (s, "101010", 2, 2, "101010");
	test_number (s, "12345670", 8, 8, "12345670");
	test_number (s, "123456789ABCDEF0", 16, 16, "123456789ABCDEF0");
	test_number (s, "0.010101", 2, 2, "0.010101");
	test_number (s, "0.1234567", 8, 8, "0.1234567");
	test_number (s, "0.123ABCDEF", 16, 16, "0.123ABCDEF");
}


void
test_engineering (Serializer* s)
{
	g_return_if_fail (s != NULL);
	serializer_set_number_format (s, DISPLAY_FORMAT_ENGINEERING);
	test_number (s, "1", 10, 10, "1");
	test_number (s, "10", 10, 10, "10");
	test_number (s, "1234567890", 10, 10, "1.23456789×10⁹");
	test_number (s, "0.1", 10, 10, "100×10⁻³");
	test_number (s, "0.1234567890", 10, 10, "123.456789×10⁻³");
	test_number (s, "101010", 2, 2, "101010");
	test_number (s, "12345670", 8, 8, "12345670");
	test_number (s, "123456789ABCDEF0", 16, 16, "123456789ABCDEF0");
	test_number (s, "0.10101", 2, 2, "0.10101");
	test_number (s, "0.1234567", 8, 8, "0.1234567");
	test_number (s, "0.123ABCDEF", 16, 16, "0.123ABCDEF");
}


void
test_base_conversion (Serializer* s)
{
	g_return_if_fail (s != NULL);
	test_number (s, "12₈", 10, 2, "1010₂");
	test_number (s, "10", 10, 2, "1010₂");
	test_number (s, "A₁₆", 10, 2, "1010₂");
	test_number (s, "1234567890123456789012345678901234567890", 10, 2, "1110100000110010010010000001110101110000001101101111110011101110001010" \
"110010111100010111111001011011001110001111110000101011010010₂");
	test_number (s, "1010₂", 10, 8, "12₈");
	test_number (s, "10", 10, 8, "12₈");
	test_number (s, "A₁₆", 10, 8, "12₈");
	test_number (s, "1234567890123456789012345678901234567890", 10, 8, "16406222016560155763561262742771331617605322₈");
	test_number (s, "1010₂", 10, 10, "10");
	test_number (s, "12₈", 10, 10, "10");
	test_number (s, "A₁₆", 10, 10, "10");
	test_number (s, "1010₂", 10, 16, "A₁₆");
	test_number (s, "12₈", 10, 16, "A₁₆");
	test_number (s, "10", 10, 16, "A₁₆");
	test_number (s, "1234567890123456789012345678901234567890", 10, 16, "3A0C92075C0DBF3B8ACBC5F96CE3F0AD2₁₆");
}


static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


gint
_vala_main (gchar** args,
            int args_length1)
{
	gint result = 0;
	Serializer* serializer = NULL;
	Serializer* _tmp0_;
	Serializer* _tmp1_;
	Serializer* _tmp2_;
	Serializer* _tmp3_;
	Serializer* _tmp4_;
	Serializer* _tmp5_;
	Serializer* _tmp6_;
	Serializer* _tmp7_;
	Serializer* _tmp8_;
	Serializer* _tmp9_;
	gint _tmp10_;
	gint _tmp17_;
	setlocale (LC_ALL, "C");
	_tmp0_ = serializer_new (DISPLAY_FORMAT_AUTOMATIC, 10, 9);
	serializer = _tmp0_;
	_tmp1_ = serializer;
	serializer_set_thousands_separator (_tmp1_, string_get_char (thousand_separator, (glong) 0));
	_tmp2_ = serializer;
	serializer_set_radix (_tmp2_, string_get_char (radix_string, (glong) 0));
	_tmp3_ = serializer;
	serializer_set_show_thousands_separators (_tmp3_, TRUE);
	_tmp4_ = serializer;
	serializer_set_thousands_separator_count (_tmp4_, 3);
	_tmp5_ = serializer;
	test_fixed (_tmp5_);
	_tmp6_ = serializer;
	test_automatic (_tmp6_);
	_tmp7_ = serializer;
	test_scientific (_tmp7_);
	_tmp8_ = serializer;
	test_engineering (_tmp8_);
	_tmp9_ = serializer;
	test_base_conversion (_tmp9_);
	_tmp10_ = fail_count;
	if (_tmp10_ == 0) {
		FILE* _tmp11_;
		gint _tmp12_;
		_tmp11_ = stdout;
		_tmp12_ = pass_count;
		fprintf (_tmp11_, "Passed all %i tests\n", _tmp12_);
	} else {
		FILE* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp13_ = stdout;
		_tmp14_ = fail_count;
		_tmp15_ = pass_count;
		_tmp16_ = fail_count;
		fprintf (_tmp13_, "Failed %i/%d tests\n", _tmp14_, _tmp15_ + _tmp16_);
	}
	_tmp17_ = fail_count;
	result = _tmp17_;
	_g_object_unref0 (serializer);
	return result;
}


int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}



