/*
 * New login encryption scheme for YMSG-15, activated by Yahoo as of Messenger 8
 *
 * * Copyright (C) 2008 Gregory D Hosler
 * (ghosler ['at'] users.sourceforge.net)
 *
 * This file is part of GYachI
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * In addition, as a special exception, the copyright holders of this file
 * give permission to link the code of its release of GyachI with the
 * OpenSSL project's "OpenSSL" library (or with modified versions of it
 * that use the same license as the "OpenSSL" library), and distribute
 * the linked executables.  You must obey the GNU General Public License
 * in all respects for all of the code used other than "OpenSSL".  If you
 * modify this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to do
 * so, delete this exception statement from your version.
 */

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <openssl/ssl.h>
#include <stdio.h>

#include <gtk/gtk.h>

#include "config.h"

#include "interface.h"
#include "gyach_int.h"
#include "util.h"
#include "yahoo_ymsg15.h"
#include "gyachi_ssl.h"
#include "gyach.h"
#include "yahoo_sha.h"
#include "gyachi_md5.h"

#include "gy_config.h"


typedef struct {
  char *s1;
  char *opt;
} REPLY_ENTRY;

/* forward declarations */
void build_response(char *dst, REPLY_ENTRY *template, char *crlf);
int template_size(REPLY_ENTRY *template, char *crlf);

/* local to this module */
REPLY_ENTRY response1_template[] = {
	{ "src=ymsgr&ts=&login=", 0 },
	{ "&passwd=", 0},
	{ "&chal=", 0},
	{ 0, 0 }
};

REPLY_ENTRY response2_template[] = {
	{ "src=ymsgr&ts=&token=", 0 },
	{ 0, 0 }
};

typedef struct {
	char *token_start;
	char *token_end;
	char *token_value;
} TOKEN;

char *post_template_get   = "POST /config/pwtoken_get HTTP/1.1";
char *post_template_login = "POST /config/pwtoken_login HTTP/1.1";
REPLY_ENTRY post_template[] = {
	{ 0, 0},
	{ "Referer: https://", 0},
	{ "Accept-Language: en-us", 0},
	{ "Content-Type: application/x-www-form-urlencoded", 0},
	{ "User-Agent: " GYACH_USER_AGENT, 0},
	{ "Host: ", 0 },
	{ "Content-Length: ", 0},
	{ "Connection: Close", 0}, 
	{ "Cache-Control: no-cache", 0},
	{ 0, 0 }
};

void fetch_ssl_token(char *login_host, REPLY_ENTRY *response_template, REPLY_ENTRY *post_template, TOKEN *tokens) {
	char *response;
	int  response_size;
	char *post_reply;
	int  post_reply_size;
	char *error;
	int  rv;
	char response_size_string[5];
	char *header = NULL;
	int  header_size;
	char header_1st_char;
	TOKEN *p_token;
	char *tkn;
	char *tkn_end;
	char c_temp;
	int  fd = 0;
	SSL  *ctx = NULL;

	response_size = template_size(response_template, 0);
	response = malloc(response_size + 1);
	build_response(response, response_template, 0);

#if 0
	if (capture_fp) {
		fprintf(capture_fp, "response size: %d, response:\n%s\n", response_size, response);
	}
#endif

	sprintf(response_size_string, "%d", response_size);
	post_template[6].opt = response_size_string;

	post_reply_size = template_size(post_template, "\r\n") + 2 + response_size ;
	post_reply = malloc(post_reply_size + 1);
	build_response(post_reply, post_template, "\r\n");
	strcpy(&post_reply[post_reply_size - response_size - 2], "\r\n");
	strcpy(&post_reply[post_reply_size - response_size], response);

#if 0
	if (capture_fp) {
		fprintf(capture_fp, "post reply size: %d, post reply:\n%s\n", post_reply_size, post_reply);
	}
#endif

	rv = ssl_init();
	if (rv == 0) {
		show_ok_dialog_p(login_window, "Failed to create a SSL context");
		goto error;
	}

	fd = connect_to_host(login_host, 443, &error);
	if (fd < 0) {
		show_ok_dialog_p(login_window, error);
		free(error);
		goto error;
	}

	ctx = ssl_connect(fd);
	if (ctx == 0) {
		show_ok_dialog_p(login_window, "SSL handshake failed");
		goto error;
	}

	rv = openssl_write(fd, post_reply, post_reply_size, ctx);
	if (rv <= 0) {
		show_ok_dialog_p(login_window, "SSL write failed");
		goto error;
	}

	rv = openssl_read(fd, &header_1st_char, 1, ctx);
	while ( (header_size = openssl_pending(fd, ctx)) == 0) {
		sleep(1);
	}
	if (header_size > 0) header_size++;
	if (capture_fp) {
		fprintf(capture_fp, "ssl_pending (ssl read size): %d\n", header_size);
	}
	if (header_size <= 0) {
		show_ok_dialog_p(login_window, "SSL header_size < 0");
		goto error;
	}

	header = malloc(header_size + 1);
	*header=header_1st_char;
	rv = openssl_read(fd, header+1, header_size-1, ctx);
	if (rv <= 0) {
		show_ok_dialog_p(login_window, "SSL read failed");
		goto error;
	}
	header[header_size] = 0;

	if (capture_fp) {
		fprintf(capture_fp, "ssl read returned: %d, post reply:\n%s\n", rv, header);
	}

	for (p_token=tokens; p_token->token_start; p_token++) {
		tkn = strstr(header, p_token->token_start);
		if (tkn == 0) {
			if (capture_fp) {
				fprintf(capture_fp, "failed to find token \"%s\"", p_token->token_start);
			}
			goto error;
		}

		tkn += strlen(p_token->token_start);
	
		tkn_end = strstr(tkn, p_token->token_end);
		if (tkn_end == 0) {
			if (capture_fp) {
				fprintf(capture_fp, "failed to find token \"%s\" terminator", p_token->token_start);
			}
			tkn=NULL;
			goto error;
		}

		c_temp = *tkn_end;
		*tkn_end=0;
		if (p_token->token_value) free(p_token->token_value);
		p_token->token_value = strdup(tkn);
		*tkn_end=c_temp;
	}

 error:
	if (capture_fp) {
		fflush(capture_fp);
	}
	if (response) {
		free(response);
		response=NULL;
	}
	if (header) {
		free(header);
		header=NULL;
	}
	if (post_reply) {
		free(post_reply);
		post_reply=NULL;
	}
	if (ctx) {
		openssl_close(fd, ctx);
		ctx=NULL;
	}

	if (fd) {
		close(fd);
	}

	return;
}

Y15_AUTH_INFO *yahoo_process_auth_0x0f(char *myusername, char *mypasswd, char *challenge, char *host)
{
	char *login_host = host;
	unsigned char *crumb_challenge;
	unsigned char  md5_result[16];
	md5_ctx_t md5_ctx;	
	char *mac64;
	Y15_AUTH_INFO *y15_auth_info;
	TOKEN tokens[5];

	if (login_host == 0) {
		login_host = "login.yahoo.com";
	}

	response1_template[0].opt = myusername;
	response1_template[1].opt = mypasswd;
	response1_template[2].opt = challenge;

	post_template[0].s1  = post_template_get;
	post_template[1].opt = login_host;
	post_template[5].opt = login_host;

	if (!ymsgr_token) {
		tokens[0].token_start = "ymsgr=";
		tokens[0].token_end   = "\r";
		tokens[0].token_value = NULL;
		tokens[1].token_start = NULL;
		tokens[1].token_end   = NULL;
		tokens[1].token_value = NULL;
		fetch_ssl_token(login_host, response1_template, post_template, tokens);

		if (tokens[0].token_value == 0) return NULL;

		ymsgr_token = tokens[0].token_value;
		write_config();
	}

	post_template[0].s1  = post_template_login;
	response2_template[0].opt = strdup(ymsgr_token);
	tokens[0].token_start = "crumb=";
	tokens[0].token_end   = "\r";
	tokens[0].token_value = NULL;
	tokens[1].token_start = "Set-Cookie: Y=";
	tokens[1].token_end   = ";";
	tokens[1].token_value = NULL;
	tokens[2].token_start = "Set-Cookie: T=";
	tokens[2].token_end   = ";";
	tokens[2].token_value = NULL;
	tokens[3].token_start = "Set-Cookie: B=";
	tokens[3].token_end   = ";";
	tokens[3].token_value = NULL;
	tokens[4].token_start = NULL;
	tokens[4].token_end   = NULL;
	tokens[4].token_value = NULL;
	fetch_ssl_token(login_host, response2_template, post_template, tokens);

	free(response2_template[0].opt);

	if (tokens[0].token_value == 0) {
		if (tokens[1].token_value) free(tokens[1].token_value);
		if (tokens[2].token_value) free(tokens[2].token_value);
		return NULL;
	}

	crumb_challenge = malloc(strlen(tokens[0].token_value) + strlen(challenge) + 1);
	strcpy(crumb_challenge, tokens[0].token_value);
	strcat(crumb_challenge, challenge);
	free(tokens[0].token_value);

	md5_init(&md5_ctx);
	md5_append(&md5_ctx, crumb_challenge, strlen(crumb_challenge));
	md5_finish(&md5_ctx, md5_result);

	mac64=malloc(25);
	to_y64(mac64, md5_result, 16);

	if (capture_fp) {
		fprintf(capture_fp, "mac64: %s\n", mac64);
		fflush(capture_fp);
	}

	y15_auth_info = malloc(sizeof(Y15_AUTH_INFO));
	y15_auth_info->y_cookie = tokens[1].token_value;
	y15_auth_info->t_cookie = tokens[2].token_value;
	y15_auth_info->b_cookie = tokens[3].token_value;
	y15_auth_info->resp_307 = mac64;

	return(y15_auth_info);
}





int template_size(REPLY_ENTRY *template, char *crlf) {
	int len;
	REPLY_ENTRY *entry;

	for (len=0, entry=template; entry->s1; entry++) {
		len += strlen(entry->s1);
		if (entry->opt) {
			len += strlen(entry->opt);
		}
		if (crlf) len += strlen(crlf);
	}

	return len;
}

void build_response(char *dst, REPLY_ENTRY *template, char *crlf) {
	int len;
	REPLY_ENTRY *entry;
	char *ptr;

	for (len=0, entry=template, ptr=dst; entry->s1; entry++) {
		strcpy(ptr, entry->s1);
		ptr += strlen(entry->s1);
		if (entry->opt) {
			strcpy(ptr, entry->opt);
			ptr += strlen(entry->opt);
		}
		if (crlf) {
			strcpy(ptr, crlf);
			ptr += strlen(crlf);
		}
	}

	return;
}
